#include "StdAfx.h"
#include "JniorRegistry.h"

CJniorRegistry::CJniorRegistry(void)
{
	root = NULL;

	char key[32];
	for (int index = 0; index < 8; index++) {
		sprintf(key, "%s%d%s", "IO/Inputs/din", index + 1, "/State");
		GetKey(key)->RESERVED = true;

		sprintf(key, "%s%d%s", "IO/Inputs/din", index + 1, "/Alarm");
		GetKey(key)->RESERVED = true;

		sprintf(key, "%s%d%s", "IO/Inputs/din", index + 1, "/Count");
		GetKey(key)->RESERVED = true;

		sprintf(key, "%s%d%s", "IO/Inputs/din", index + 1, "/CountAlarm1");
		GetKey(key)->RESERVED = true;

		sprintf(key, "%s%d%s", "IO/Inputs/din", index + 1, "/CountAlarm2");
		GetKey(key)->RESERVED = true;

		sprintf(key, "%s%d%s", "IO/Outputs/rout", index + 1, "/State");
		GetKey(key)->RESERVED = true;
	}
}

CJniorRegistry::~CJniorRegistry(void)
{
}

/// <summary>returns the registrykey object represented by the given registry key</summary>
RegistryKey* CJniorRegistry::GetKey(char* key)
{
	// validate the key passed in
	if (key == NULL) {
		return NULL;
	}

	REGISTRY_NODE* node;

	if (root != NULL) {
		node = root;

		do {
			if (strcmp(node->regKey->key, key) == 0) {
				return node->regKey;
			}
		} while ((node = node->next) != NULL);
	}

	// if we didnt find it, create it;
	node = new REGISTRY_NODE;
	node->prev = node->next = NULL;
	node->regKey = new RegistryKey();
	int size = sizeof(*(node->regKey));
	node->regKey->uniqueId = GetHash(key);
	node->regKey->SetKey(key);

	AddNode(node);

	return node->regKey;
}


RegistryKey* CJniorRegistry::GetKey(int uniqueId)
{
	if (root == NULL) return NULL;

	REGISTRY_NODE* node = root;

	do {
		if (node->regKey->uniqueId == uniqueId)
			return node->regKey;
	} while ((node = node->next) != NULL);

	return NULL;
}


REGISTRY_NODE* CJniorRegistry::AddNode(REGISTRY_NODE* newNode)
{
	if (root == NULL) {
		return root = newNode;
	}

	REGISTRY_NODE* node = root;

	do {
		// if the unique id matches another key then we will increment the 
		// unique id by 1 and try again.
		if (node->regKey->uniqueId == newNode->regKey->uniqueId) {
			printf("Registry Collision %d - %s\n", newNode->regKey->uniqueId, newNode->regKey->key);

			newNode->regKey->uniqueId++;

			// if this causes the unique id to roll to be the smallest short 
			// possible then we need to call and return the AddNode mehtod 
			// again.
			if (newNode->regKey->uniqueId == 0x8000) {
				return AddNode(newNode);
			}
		}

		if (node->regKey->uniqueId > newNode->regKey->uniqueId) {
			newNode->prev = node->prev;
			if (node->prev != NULL) 
				node->prev->next = newNode;
			newNode->next = node;
			node->prev = newNode;

			if (node == root) {
				root = newNode;
			}

			return node;
		}

		if (node->next == NULL) {
			node->next = newNode;
			newNode->prev = node;
			return newNode;
		}
	} while ((node = node->next) != NULL);	

	return NULL;
}


void CJniorRegistry::PrintRegistry() 
{
	REGISTRY_NODE* node;

	if (root != NULL) {
		node = root;

		do {
			printf("Registry Key %s\n", node->regKey->toString());
		} while ((node = node->next) != NULL);
	}
}


int CJniorRegistry::GetHash(char* s)
{
	short hash = 5381;
	size_t strLen = strlen(s);
	for (int i = 0; i < strLen; i++) {
		hash = ((hash << 5) + hash) + (char)s[i];
	}
        
	hash = (short)hash;
	return hash;
}


REGISTRY_KEY* CJniorRegistry::ToStructure(RegistryKey* regKey) {
	REGISTRY_KEY* structure = new REGISTRY_KEY();
	structure->uniqueId = regKey->uniqueId;

	size_t keyLen = strlen(regKey->key);
	structure->key = new char[keyLen + 1];
	strncpy(structure->key, regKey->key, keyLen);
	structure->key[keyLen] = '\0';

	size_t valueLen = strlen(regKey->value);
	structure->value = new char[valueLen + 1];
	strncpy_s(structure->value, valueLen + 1, regKey->value, valueLen);
	structure->value[valueLen] = '\0';

	return structure;
}

RegistryKey* CJniorRegistry::FromStructure(REGISTRY_KEY* structure) {
	RegistryKey* regKey = GetKey(structure->key);
	regKey->uniqueId = structure->uniqueId;
	regKey->SetValue(structure->value);

	return regKey;
}
