//#include "JniorRegistry.h"


#ifndef __STRUCTURES
#define __STRUCTURES


// make sure this structure is byte aligned on every byte boundry
#pragma pack(1)
__declspec(align(1)) 
struct CONNECT_PARAMS {
	char* host;
	int port;
	int retryCount;
	int retryInterval;
	int retriesRemaining;
	int webPort;
	int secondsRemaining;
	int status;
	char* message;
};


// make sure this structure is byte aligned on every byte boundry
#pragma pack(1)
__declspec(align(1)) 
struct CREDENTIALS {
	char* username;
	char* password;
	bool encode;
};



// make sure this structure is byte aligned on every byte boundry
#pragma pack(1)
__declspec(align(1)) 
struct JNIOR_INPUT {
	char state;
	char alarm;
	int count;
	char countAlarm1;
	char countAlarm2;
	long long usage;
	char usageAlarm;

	JNIOR_INPUT::JNIOR_INPUT() {
		state = -1;
		alarm = -1;
		count = -1;
		countAlarm1 = 0;
		countAlarm2 = 0;
		usage = -1;
		usageAlarm = 0;
	}
};

// make sure this structure is byte aligned on every byte boundry
#pragma pack(1)
__declspec(align(1)) 
struct JNIOR_OUTPUT {
	char state;
	long long usage;
	char usageAlarm;

	JNIOR_OUTPUT::JNIOR_OUTPUT() {
		state = -1;
		usage = -1;
		usageAlarm = 0;
	}
};

// make sure this structure is byte aligned on every byte boundry
#pragma pack(1)
__declspec(align(1)) 
struct JNIOR_MONITOR {
	JNIOR_INPUT inputs[16];
	JNIOR_OUTPUT outputs[16];
	long long jniorTime;
};



#pragma pack(1)
struct REGISTRY_KEY {
	short uniqueId;
	char* key;
	char* value;
};


#pragma pack(1)
struct STATUS_CALLBACK_ARGS {
	int handle;
	int status;
	char* message;
};

#pragma pack(1)
struct MONITOR_CALLBACK_ARGS {
	int handle;
	JNIOR_MONITOR* monitor;
};

#pragma pack(1)
struct REGISTRY_CALLBACK_ARGS {
	int handle;
	short count;
	REGISTRY_KEY** keys;
};

#pragma pack(1)
struct REGISTRY_LISTING_CALLBACK_ARGS {
	int handle;
	short count;
	char* path;
	char** keyNames;
};

#pragma pack(1)
struct COMMUNICATIONS_CALLBACK_ARGS {
	int handle;
	char direction; // -1 = IN, 1 = OUT
	short count;
	char* bytes;
};

#pragma pack(1)
struct CUSTOM_COMMAND_CALLBACK_ARGS {
	int handle;
	char returnStatus;
	short size;
	char* payload;
};



enum REQUEST_ENUM {
	DATE_TIME_REQUEST = 0,
	MONITOR_REQUEST,
	USAGE_METER_REQUEST,
	REBOOT_REQUEST,
	DISABLE_MONITOR_REQUEST,
	ENABLE_MONITOR_REQUEST
};

enum COMMAND_ENUM {
	CLOSE_RELAY = 1,
	OPEN_RELAY,
	TOGGLE_RELAY,
	RESET_INPUT_LATCH,
	CLEAR_INPUT_COUNTER,
	PULSE_OUTPUT,
	BLOCK_PULSE_RELAYS,
	CLEAR_INPUT_USAGE_METER,
	CLEAR_OUTPUT_USAGE_METER,
	BLOCK_SET_RELAYS
};

enum DEVICE_TYPE_ENUM {
	FOUR_RELAY_OUT			= 0xFB,
	RTD						= 0xFC,
	TEN_VOLT				= 0xFD,
	FOUR_TWENTY_MILLIAMP	= 0xFE,
	INTERNAL				= 0xFF,
	EIGHT_BIT_TEMPERATURE	= 0x10,
	TWELVE_BIT_TEMPERATURE	= 0x28
};

#endif