#pragma once

#include "JniorConstants.h"
#include "JniorStructures.h"

#include "Monitor.h"
#include "JniorRegistry.h"
#include "device.h"
#include "typefb.h"
#include <map>
#include <stdlib.h>
#include <vector>

#include "Logger.h"

using namespace std;


static DWORD m_dwStatusWrapperThreadId = -1;
static DWORD m_dwRegistryWrapperThreadId = -1;
static DWORD m_dwCommunicationsWrapperThreadId = -1;

static int NEXT_HANDLE = 10000;




#ifndef CALLBACK
#define CALLBACK __stdcall // __declspec //__stdcall
#endif

typedef void (CALLBACK* CALLBACKNOTIFY)(void* args);


//typedef void (CALLBACK* STATUSNOTIFY)(int status);
//typedef void (CALLBACK* REGISTRYNOTIFY)(RegistryKey**, short);
//
//typedef void (CALLBACK* COMMUNICATIONSNOTIFY)(char*, short, char);
//
//typedef void (CALLBACK* DEBUGNOTIFY)(char* debug);
//
//typedef void (CALLBACK* CUSTOMCOMMANDNOTIFY)(int responseCode, int payloadLength, char* payload);



//const int MONITOR_PACKET				= 1;
//const int EXT_MONITOR_PACKET			= 2;
//
//const int REQUEST_PACKET				= 5;
//enum REQUEST_ENUM {
//	DATE_TIME_REQUEST = 0,
//	MONITOR_REQUEST,
//	USAGE_METER_REQUEST,
//	REBOOT_REQUEST,
//	DISABLE_MONITOR_REQUEST,
//	ENABLE_MONITOR_REQUEST
//};
//
//const int SET_CLOCK_PACKET				= 7;
//const int USAGE_METER_PACKET			= 8;
//
//const int COMMAND_PACKET				= 10;
//enum COMMAND_ENUM {
//	CLOSE_RELAY = 1,
//	OPEN_RELAY,
//	TOGGLE_RELAY,
//	RESET_INPUT_LATCH,
//	CLEAR_INPUT_COUNTER,
//	PULSE_OUTPUT,
//	BLOCK_PULSE_RELAYS,
//	CLEAR_INPUT_USAGE_METER,
//	CLEAR_OUTPUT_USAGE_METER,
//	BLOCK_SET_RELAYS
//};
//
//const int READ_REG_KEYS					= 11;
//const int READ_REG_KEYS_RESPONSE		= 12;
//
//const int WRITE_REG_KEYS				= 13;
//const int WRITE_REG_KEYS_RESPONSE		= 14;
//
//const int SUBSCRIBE_REG_KEYS			= 15;
//
//const int LIST_REG_KEYS					= 16;
//const int LIST_REG_KEYS_RESPONSE		= 17;
//
//
//enum DEVICE_TYPE_ENUM {
//	FOUR_RELAY_OUT			= 0xFB,
//	RTD						= 0xFC,
//	TEN_VOLT				= 0xFD,
//	FOUR_TWENTY_MILLIAMP	= 0xFE,
//	INTERNAL				= 0xFF,
//	EIGHT_BIT_TEMPERATURE	= 0x10,
//	TWELVE_BIT_TEMPERATURE	= 0x28
//};
//
//const int READ_DEVICES					= 21;
//const int READ_DEVICE_RESPONSE			= 22;
//const int SUBSCRIBE_DEVICES				= 25;
//
//const int GET_EXTERNAL_VALUE			= 29;
//const int GET_EXTERNAL_VALUE_RESPONSE	= 30;
//
//const int LOGIN_REQUEST					= 126;
//const int LOGIN_ACK						= 125;
//
//const int CUSTOM_COMMAND_RESPONSE		= 254;
//const int CUSTOM_COMMAND				= 255;



//struct CONNECT_PARAMS {
//	char* host;
//	int port;
//	int retryCount;
//	int retryInterval;
//	int retriesRemaining;
//	int webPort;
//	int secondsRemaining;
//	int status;
//	char* message;
//};

struct HEADER {
	short OFFSET;
	char SYNC_BYTE;
	time_t SYNC_RECV_TIME;
	short LENGTH_HI;
	short LENGTH_LO;
	short CRC_HI;
	short CRC_LO;
	char PAYLOAD[0xffff];
	int PAYLOAD_LENGTH;
};

enum {
	WAIT_SYNC_BYTE,
	WAIT_LENGTH_HI,
	WAIT_LENGTH_LO,
	WAIT_CRC_HI,
	WAIT_CRC_LO,
	WAIT_PAYLOAD,
	PAYLOAD_READY
};


/// <summary>
/// Provides the credentials to login to the jnior server
/// </summary>
//struct CREDENTIALS {
//	char* username;
//	char* password;
//	bool encode;
//};


struct REQUEST {
	short request;
	int interval;
};


struct COMMAND {
	char action;
	short channel;
	short channelMask;
	short stateMask;
	int duration;
};


static const int SEND_RECV_TIMEOUT = 10000;


//// make sure this structure is byte aligned on every byte boundry
//#pragma pack(1)
//__declspec(align(1)) 
//struct JNIOR_INPUT {
//	char state;
//	char alarm;
//	int count;
//	char countAlarm1;
//	char countAlarm2;
//	long long usage;
//	char usageAlarm;
//
//	JNIOR_INPUT::JNIOR_INPUT() {
//		state = -1;
//		alarm = -1;
//		count = -1;
//		countAlarm1 = 0;
//		countAlarm2 = 0;
//		usage = -1;
//		usageAlarm = 0;
//	}
//};
//
//// make sure this structure is byte aligned on every byte boundry
//#pragma pack(1)
//__declspec(align(1)) 
//struct JNIOR_OUTPUT {
//	char state;
//	long long usage;
//	char usageAlarm;
//
//	JNIOR_OUTPUT::JNIOR_OUTPUT() {
//		state = -1;
//		usage = -1;
//		usageAlarm = 0;
//	}
//};
//
//// make sure this structure is byte aligned on every byte boundry
//#pragma pack(1)
//__declspec(align(1)) 
//struct JNIOR_MONITOR {
//	JNIOR_INPUT inputs[8];
//	JNIOR_OUTPUT outputs[8];
//	time_t jniorTime;
//};


struct JNIOR_EXT_OUTPUT {
	char state;

	JNIOR_EXT_OUTPUT::JNIOR_EXT_OUTPUT() {
		state = -1;
	}
};



class CJnior {
public:
	//static const int STATUS_COMMAND_TIMEOUT			= -2;
	//static const int STATUS_FAILED					= -1;
	//static const int STATUS_OK						= 0;

	//static const int STATUS_REBOOTING					= 1;
	//static const int STATUS_NOT_CONNECTED				= 2;
	//static const int STATUS_DISCONNECTED				= 3;
	//static const int STATUS_CONNECTING					= 4;
	//static const int STATUS_RECONNECTING				= 5;
	//static const int STATUS_CONNECTED					= 6;
	//static const int STATUS_CONNECTION_FAILED			= 7;
	//static const int STATUS_CANCELLED					= 8;
	//static const int STATUS_ACCEPTED_CONNECTION			= 9;
	//static const int STATUS_WAIT_FOR_RECV_THREAD		= 10;
	//static const int STATUS_RECV_THREAD_DONE			= 11;
	//static const int STATUS_QUERY_JNIOR_PORT			= 18;
	//static const int STATUS_QUERY_JNIOR_PORT_SUCCESS	= 19;


	//static const int STATUS_NOT_LOGGED_IN			= 100;
	//static const int STATUS_LOGGED_OUT				= 101;
	//static const int STATUS_LOGGING_IN				= 102;
	//static const int STATUS_LOGGED_IN_GUEST			= 103;
	//static const int STATUS_LOGGED_IN_USER			= 104;
	//static const int STATUS_LOGGED_IN_ADMIN			= 105;
	//static const int STATUS_LOGIN_FAILED			= 106;
	//static const int STATUS_LOGIN_INCORRECT_LEVEL	= 107;

	//static const int STATUS_REQUESTING_MONITOR		= 200;
	//static const int STATUS_REQUESTING_USAGE_METERS = 201;
	//static const int STATUS_REQUESTING_TIME			= 202;

	//static const int STATUS_DISABLE_MONITOR_PACKETS	= 205;
	//static const int STATUS_ENABLE_MONITOR_PACKETS	= 206;

	//static const int STATUS_CLOSE_OUTPUT			= 301;
	//static const int STATUS_OPEN_OUTPUT				= 302;
	//static const int STATUS_TOGGLE_OUTPUT			= 303;
	//static const int STATUS_PULSE_OUTPUT			= 306;
	//static const int STATUS_BLOCK_PULSE_RELAYS		= 307;
	//static const int STATUS_BLOCK_SET_RELAYS		= 400;

	//static const int PACKET_RECEIVED_START						= 1000;
	//static const int STATUS_MONITOR_PACKET_RECEIVED				= PACKET_RECEIVED_START + MONITOR_PACKET;
	//static const int STATUS_EXTERNAL_MONITOR_PACKET_RECEIVED	= PACKET_RECEIVED_START + EXT_MONITOR_PACKET;
	//static const int STATUS_USAGE_METERS_RECEIVED				= PACKET_RECEIVED_START + USAGE_METER_PACKET;

	//static const int STATUS_REGISTRY_READING		= PACKET_RECEIVED_START + READ_REG_KEYS;
	//static const int STATUS_REGISTRY_READ_RECEIVED	= PACKET_RECEIVED_START + READ_REG_KEYS_RESPONSE;

	//static const int STATUS_REGISTRY_WRITING		= PACKET_RECEIVED_START + WRITE_REG_KEYS;
	//static const int STATUS_REGISTRY_WRITE_RECEIVED	= PACKET_RECEIVED_START + WRITE_REG_KEYS_RESPONSE;

	//static const int STATUS_READING_DEVICES			= PACKET_RECEIVED_START + READ_DEVICES;
	//static const int STATUS_READ_DEVICES_RESPONSE	= PACKET_RECEIVED_START + READ_DEVICE_RESPONSE;

	//static const int STATUS_LOGIN_REQUEST			= PACKET_RECEIVED_START + LOGIN_REQUEST;
	//static const int STATUS_LOGIN_ACK				= PACKET_RECEIVED_START + LOGIN_ACK;


	//static const int SOCKET_NOT_WRITABLE			= -1000;
	//static const int SOCKET_NOT_READABLE			= -1001;
	//static const int ACK_FAILED						= -1002;


	CJnior(CONNECT_PARAMS*);
	~CJnior();

	int Cancel();


	int m_handle;

	char* m_Model;
	char* m_SoftwareVersion;

	int SetSocket(SOCKET sckt);
	CONNECT_PARAMS* GetConnectionProperties();
	static DWORD WINAPI ConnectThd( LPVOID lparam );
	int ConnectAsync(CONNECT_PARAMS* connectParams);
	int Connect(CONNECT_PARAMS* connectParams, bool);
	int Reconnect();
	int Disconnect();
	int Disconnect(bool reconnect);
	bool IsConnected();
	int SetRetryParams();

	int DisableMonitorPackets();
	int EnableMonitorPackets();

	int Reboot();

	int Login(CREDENTIALS* creds, bool waitForResponse);
	int LoginStatus(int status);
	bool IsLoggedIn();
	int GetLoginStatus();

	int RequestMonitorPacket(int monitorInterval);
	int RequestUsageMeterPacket();
	int Request(REQUEST* request);
	
	long long RequestClock();
	int SetClock(long long milliseconds);


	int Command(char* commandString, char* returnString);
	int Command(COMMAND* command);
	int SetOutput(int channel, char state);
	int CloseOutput(int channel);
	int OpenOutput(int channel);
	int ToggleOutput(int channel);
	int ResetInputLatch(int channel);
	int ClearInputCounter(int channel);
	int ClearInputUsage(int channel);
	int ClearOutputUsage(int channel);
	int PulseOutput(int channel, int duration);
	int BlockPulseRelays(int channelMask, int stateMask, int duration);
	int BlockSetRelays(int channelMask, int stateMask);
	JNIOR_MONITOR* GetMonitor();
	double GetExternalValue(char deviceType, char ioSelection, char channelNumber);

	clock_t GetMonitorFreshness();
	long long GetKnownJniorTime();


	/******************* REGISTRY ***********************************************/
	CJniorRegistry* m_registry;
	int ReadRegistryKeys(RegistryKey** keys, short size, char* defaultValue, bool waitForResponse);
	int WriteRegistryKeys(RegistryKey** keys, short size, bool waitForResponse);
	int SubscribeRegistryKeys(RegistryKey** keys, short size, char* defaultValue, bool waitForResponse);
	int ListRegistryAsync(char* path);
	int AddRegistryKeyCallback(RegistryKey** keys, int count, CALLBACKNOTIFY lProcAddress);
	/******************* REGISTRY ***********************************************/

	std::map<int, CDevice*> m_devices;
	int ReadDevices(long long[], int, bool);
	int SubscribeDevices(long long[], int);


	int ConnectionStatus(int status);
	int Status(int status);


	/******************* CALLBACKS *******************************************/
	void AddStatusCallback(CALLBACKNOTIFY lProcAddress);
	void RemoveStatusCallback(CALLBACKNOTIFY lProcAddress);

	void AddMonitorCallback(CALLBACKNOTIFY lProcAddress);

	void AddConnectionCallback(CALLBACKNOTIFY lProcAddress);

	void AddLoginCallback(CALLBACKNOTIFY lProcAddress);

	void AddRegistryCallback(CALLBACKNOTIFY lProcAddress);
	void AddRegistryListingCallback(CALLBACKNOTIFY lProcAddress);

	void AddCustomCommandCallback(CALLBACKNOTIFY lProcAddress);

	int CustomCommand(char* commandName, char commandType, short payloadSize, char* payload);


	void AddCommunicationsCallback(CALLBACKNOTIFY lProcAddress);

	//void AddDebugCallback(CALLBACKNOTIFY lProcAddress);
	/******************* CALLBACKS *******************************************/



	int Error(char* source, int err);

	int SetDumpFile(char* filename);

	void DataReady();
	void PacketReceived(int messageType, HEADER recvHeader);

	bool m_cancel;
	bool m_connectCancel;

	time_t m_lastSentTime;



private:

	JNIOR_MONITOR m_monitor;
	JNIOR_EXT_OUTPUT m_externalOutputs[8];

	map<short, double> m_externalModuleValues;


	CMonitor m_mutex;

	bool m_quit;

	int m_connectionStatus;
	int m_loginStatus;
	int m_loginLevel;
	bool m_rebooting;
	bool m_shouldReconnect;
	int m_recvState;

	// this is the buffer that is used to receive the packets.  0xffff + 5 is 
	// the largets packet possible since the length feild can be 0xffff and 
	// the header is 5 bytes long
	char m_recvbuf[0xffff + 5];
	int m_nextReadPos;
	int m_pos;
	HEADER m_recvHeader;

	clock_t m_monitorPacketRecvTime;
	clock_t m_timePacketRecvTime;

	// our socket object
	SOCKET m_sckt;

	CONNECT_PARAMS* m_connectParams;

	HANDLE m_hPrintfThread;
	DWORD m_dwPrintfThreadId;
	static DWORD WINAPI PrintfRedirectThd ( LPVOID *lparam );

	//HANDLE m_hThread;
	//DWORD m_dwThreadId;
	static bool SendHeartbeat(CJnior*);
	//static DWORD WINAPI ReceiverThd ( LPVOID lparam );


	class ReceiverThread;
	ReceiverThread* m_thd;


	//time_t m_jniorTime;

	int m_writtenKeys;

	// is the string that is currently being queried for a registry listing
	char* m_currentListingRequest;

	int Send(char* bytes, int size);

	int LoginReceived(char* bytes);

	char* m_dumpFileName;
	void hexdump(void *pAddressIn, long lSize, char direction);

	//void Log(char* text);

	
	void ProcessMonitorPacket();
	void ProcessExternalMonitorPacket();
	void ProcessUsageMeterPacket();
	void ProcessReadRegistryKeysResponse();
	void ProcessLoginResponse();


	/******************* CALLBACK LISTENERS *************************************/
	vector<CALLBACKNOTIFY> m_statusListeners;
	vector<CALLBACKNOTIFY> m_monitorListeners;
	vector<CALLBACKNOTIFY> m_connectionListeners;
	vector<CALLBACKNOTIFY> m_loginListeners;
	vector<CALLBACKNOTIFY> m_communicationListeners;
	vector<CALLBACKNOTIFY> m_registryListeners;
	vector<CALLBACKNOTIFY> m_registryListingListeners;
	vector<CALLBACKNOTIFY> m_debugListeners;
	vector<CALLBACKNOTIFY> m_customCommandListeners;
	/******************* CALLBACK LISTENERS *************************************/




	class ReceiverThread
	{
	private:
		CJnior* m_jnior;
		HANDLE m_hThread;
		DWORD m_dwThreadId;

	public:
		bool m_quit;

	public:
		ReceiverThread(CJnior* jnior) {
			m_jnior = jnior;

			m_quit = false;

			//if we havent created a thread to handle incoming bytes, do so now
			m_hThread = CreateThread(
				NULL,										// default security attributes 
				0,											// use default stack size  
				(LPTHREAD_START_ROUTINE) this->Run,	// thread function 
				this,										// argument to thread function 
				0,											// use default creation flags 
				&m_dwThreadId);								// returns the thread identifier 
		}

		static DWORD WINAPI Run ( LPVOID lparam )
		{
			// This is the owned of the thread
			ReceiverThread* parent = (ReceiverThread*) lparam;

			try {
			Logger(parent->m_jnior->m_dumpFileName, "Receiver Listening");

			//parent->m_jnior;

			// we want to be notified when either a socket is ready for reading or it 
			// has closed.  We use WSAEventSelect and WSAWaitForMultipleEvents to 
			// accompish this

			// loop until quit is true
			while (!parent->m_quit && parent->m_jnior->IsConnected()) {

				// A successful delivery of data will return a zero so we start 
				// with a non zero value.
				WSASetLastError (0);
				int bytesRecv = SOCKET_ERROR;
				while(!parent->m_quit && parent->m_jnior->IsConnected() && bytesRecv == SOCKET_ERROR)  // waiting for communications
				{
					//cout << "WAIT FOR SOCKET EVENT" << endl;
					WSAEVENT readOrCloseEvent = WSA_INVALID_EVENT;
					readOrCloseEvent = WSACreateEvent();
					WSAEventSelect(parent->m_jnior->m_sckt, readOrCloseEvent, FD_READ | FD_CLOSE);

					WSAEVENT EventArray[1];
					EventArray[0] = readOrCloseEvent;

					// wait for some event to occur
					int waitResult = WSAWaitForMultipleEvents(1, &readOrCloseEvent, FALSE, SEND_RECV_TIMEOUT, FALSE);
					//cout << "WSAWaitForMultipleEvents: " << waitResult << endl;

					if (parent->m_jnior->IsConnected() && waitResult == WSA_WAIT_TIMEOUT)
					{
						//parent->m_jnior->Status(STATUS_FAILED);

						Logger(parent->m_jnior->m_dumpFileName, "WSA_WAIT_TIMEOUT");

						WSANETWORKEVENTS* NetworkEvents = new WSANETWORKEVENTS;
						
						int enumResult = WSAEnumNetworkEvents(parent->m_jnior->m_sckt, EventArray[0], NetworkEvents);
						//cout << "WSAEnumNetworkEvents: " << enumResult << endl;

						if (enumResult == SOCKET_ERROR) {
							Logger(parent->m_jnior->m_dumpFileName, "Socket error");
							// try to reconnect
							if (!parent->m_jnior->m_rebooting) {
									parent->m_quit = true;
								if (parent->m_jnior->Reconnect() != STATUS_CONNECTED) {
									parent->m_jnior->Disconnect();
								}
							}
							break;
						}

						SendHeartbeat(parent->m_jnior);
						continue;
					} 

					else if ((waitResult != WSA_WAIT_FAILED) && (waitResult != WSA_WAIT_TIMEOUT)) {
						WSANETWORKEVENTS* NetworkEvents = new WSANETWORKEVENTS;
						
						int enumResult = WSAEnumNetworkEvents(parent->m_jnior->m_sckt, EventArray[0], NetworkEvents);
						//cout << "WSAEnumNetworkEvents: " << enumResult << endl;

						if (enumResult == SOCKET_ERROR) {
							break;
						} else if (enumResult == 0) {
							if ((NetworkEvents->lNetworkEvents & FD_READ) == FD_READ) {
								//printf("Read Event\n");
								Logger(parent->m_jnior->m_dumpFileName, "Read Event");
							}

							if ((NetworkEvents->lNetworkEvents & FD_CLOSE) == FD_CLOSE) {
								//parent->m_jnior->Status(STATUS_FAILED);

								//printf("Close Event\n");
								Logger(parent->m_jnior->m_dumpFileName, "Close Event");
								// try to reconnect
								if (!parent->m_jnior->m_rebooting) {
									parent->m_quit = true;
									if (parent->m_jnior->Reconnect() != STATUS_CONNECTED) {
										parent->m_jnior->Disconnect();
									}
								}

								break;
							}
						} else {
						//cout << "WSAEnumNetworkEvents Error: " << enumResult << " " << WSAGetLastError() << endl;
						}
					}

					else if (waitResult != 0) {
						//cout << "WSAEnumNetworkEvents Error: " << waitResult << " " << WSAGetLastError() << endl;
					}

					// reset the event
					WSAResetEvent(&readOrCloseEvent);

					// initialize a socket set.
					fd_set fds;
					FD_ZERO(&fds);
					FD_SET(parent->m_jnior->m_sckt, &fds);

					timeval timeout;
					timeout.tv_sec = 3;
					timeout.tv_usec = 0;

					int isReadable = select(0, &fds, NULL, NULL, &timeout);
					//if (isReadable != 1) {
					//	cout << "read select: Error: " << isReadable << endl;
					//}

					if (isReadable == SOCKET_ERROR || isReadable == 0) {
						if (parent->m_quit) {
							break;
						}

						parent->m_jnior->Error("CJnior::Run", SOCKET_NOT_READABLE);

						Logger(parent->m_jnior->m_dumpFileName, "Socket error");
						// try to reconnect
						if (!parent->m_jnior->m_rebooting) {
									parent->m_quit = true;
							if (parent->m_jnior->Reconnect() != STATUS_CONNECTED) {
								parent->m_jnior->Disconnect();
							}
						}

						// continute reading
						continue;
					}
					
					// data is ready to be read from the socket
					else if (isReadable > 0) {
						parent->m_jnior->DataReady();
					}

						// now we can check to see if we need to send a keep alive to the 
						// JNIOR.  The JNIOR will time out the connection after 15 
						// minutes of inactivity.  We will send atleast once every 10 
						// minutes.
								
						// To be alerted that the SOCKET connection has died we must try 
						// to send to the SOCKET.  The keep alive helps with that as well.  
						// If we are receiving data within the past 10 or so seconds the 
						// SOCKET must be ok.  The 10 second wait is deterined by the 
						// timeout on the select call for the reader set.
						SendHeartbeat(parent->m_jnior);
					//}

				}

			} // while not quit and connected
			Logger(parent->m_jnior->m_dumpFileName, "Receiver thread done");
			parent->m_jnior->Status(STATUS_RECV_THREAD_DONE);

			parent->m_hThread = NULL;
		
			} catch( ... ) {
			  cout << "Exception raised: " << '\n';
			  Logger(parent->m_jnior->m_dumpFileName, "Exception raised");
			}

			return 0;
		}

	};

};