#pragma once

class CMonitor
{
    HANDLE d_mutex;

public:
    CMonitor()
	{
#if defined( _WIN32 ) && defined( _MT )
		// This mutex will help the two threads share their toys.
		d_mutex = CreateMutex( NULL, false, NULL );
		if( d_mutex == NULL )
			printf ("Mutex Creation Failed!!!"); 
#endif
	}

	virtual ~CMonitor()
	{
#if defined( _WIN32 ) && defined( _MT )
		if( d_mutex != NULL )
		{
			CloseHandle( d_mutex );
			d_mutex = NULL;
		}
#endif
	}

	void MutexOn() const
	{
#if defined( _WIN32 ) && defined( _MT )
	WaitForSingleObject( d_mutex, INFINITE );  // To be safe...
#endif  
	}

  void MutexOff() const
  {
#if defined( _WIN32 ) && defined( _MT )
	  ReleaseMutex( d_mutex );  // To be safe...
#endif
  }
};
