#pragma once

#include <iostream>

void die_with_error(char *errorMessage)
{
    cout << errorMessage << endl;
    //exit(1);
}

void die_with_wserror(char *errorMessage)
{
    cout << errorMessage << ": " << WSAGetLastError() << endl;
    //exit(1);
}

	const int BUFFERSIZE = 1024;


string httpRequest(string url, string host, int webPort)
{
    string request;
    string response;
    int resp_leng;

    char buffer[BUFFERSIZE];
    struct sockaddr_in serveraddr;
    int sock;

    WSADATA wsaData;
	char *ipaddress = (char *)host.c_str();
	int port = webPort;

    request+="GET ";
	request+= url;
	request+=" HTTP/1.0\r\n";
    request+="\r\n";

    //init winsock
	if (WSAStartup(MAKEWORD(2, 0), &wsaData) != 0) {
        die_with_wserror("WSAStartup() failed");
		return "";
	}

    //open socket
	if ((sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
        die_with_wserror("socket() failed");
		return "";
	}

    //connect
    memset(&serveraddr, 0, sizeof(serveraddr));
    serveraddr.sin_family      = AF_INET;
    serveraddr.sin_addr.s_addr = inet_addr(ipaddress);
    serveraddr.sin_port        = htons((unsigned short) port);
	if (connect(sock, (struct sockaddr *) &serveraddr, sizeof(serveraddr)) < 0) {
        die_with_wserror("connect() failed");
		return "";
	}

    //send request
	if (send(sock, request.c_str(), request.length(), 0) != request.length()) {
        die_with_wserror("send() sent a different number of bytes than expected");
		return "";
	}

    //get response
    response = "";
    resp_leng= BUFFERSIZE;
    while (resp_leng == BUFFERSIZE)
    {
		while ((resp_leng= recv(sock, (char*)&buffer, BUFFERSIZE, 0)) > 0) {
			if (resp_leng>0) {
				response += string(buffer).substr(0,resp_leng);
			}
		}
    }

    //disconnect
    closesocket(sock);
    //cleanup
    WSACleanup();

    return response;
}

string queryCgi(string host, int webPort) {
	return httpRequest("/query.cgi?access", host, webPort);
}

string getConfigure(string host, int webPort) {
	return httpRequest("/configure.htm", host, webPort);
}

