#pragma once

//#include "JniorDll.h"

#include "JniorStructures.h"

#include <iostream>
#include <vector>

using namespace std;


typedef void (CALLBACK* CALLBACKNOTIFY)(void* args);


class RegistryKey {
public:
	short uniqueId;
	char* key;
	char* value;
	char* tostring;
	bool subscribed;
	bool readReceived;
	bool writeReceived;
	bool RESERVED;

	vector<CALLBACKNOTIFY> m_registryKeyListeners;


	RegistryKey() 
	{
		subscribed = false;
		readReceived = false;
		writeReceived = false;
		RESERVED = false;

		key = "\0";
		value = "\0";
		tostring = new char[250];
		tostring[0] = '\0';
	}

	void SetKey(char* key)
	{
		this->key = new char[strlen(key) + 1];
		strcpy(this->key, key);
		this->key[strlen(key)] = '\0';
	}

	bool SetValue(char* value)
	{
		// if the new value is null then create an empty string
		if (value == NULL) {
			value = new char[1];
			value[0] = '\0';
		}

		//cout << "Is value the same as " << this->value << " ?= " << value << endl;
		if (this->value == value || strcmp(this->value, value) == 0) {
			return false;
		}

		//cout << "Set value for " << this->key << " to " << value << endl;

		// delete the old value if it exists
		if (this->value != NULL)
		{
			//delete [] this->value;
		}

		//allocate space for the new value
		size_t length = strlen(value);
		this->value = new char[length+1];

		// copy the new value
		strcpy(this->value, value);
		this->value[length] = '\0';

		//cout << this << endl;

		return true;
	}

	bool AddRegistryKeyCallback(CALLBACKNOTIFY lProcAddress) {
		m_registryKeyListeners.push_back(lProcAddress);

		return true;
	}

	char* toString() {
		//printf("(%d) %s = %s\n", this->uniqueId, this->key, this->value);
		sprintf(tostring, "(%d) %s = %s\0", this->uniqueId, this->key, this->value);
		return tostring;
	}
};


struct REGISTRY_NODE {
	REGISTRY_NODE* prev;
	REGISTRY_NODE* next;
	RegistryKey* regKey;
};

class CJniorRegistry
{
public:
	CJniorRegistry(void);
	~CJniorRegistry(void);

	RegistryKey* GetKey(char* key);
	RegistryKey* GetKey(int uniqueId);

	REGISTRY_NODE* AddNode(REGISTRY_NODE* newNode);

	static int GetHash(char* s);

	REGISTRY_KEY* ToStructure(RegistryKey* key);
	RegistryKey* FromStructure(REGISTRY_KEY* key);

private:
	REGISTRY_NODE* root;

	void PrintRegistry() ;

};
