#include "StdAfx.h"
#include "Jnior.h"
#include "JniorDll.h"
#include "CommandTimeout.h"
#include "HTTP.h"
#include <stdlib.h>
#include <iostream>
#include "CRC16.h"
#include "base64.h"
#include "Lock.h"

using namespace std;


DWORD WINAPI CallbackWrapper ( LPVOID *lparam );

bool USE_CRC = TRUE;

// This is the constructor of a class that has been exported.
// see JniorDll.h for the class definition
CJnior::CJnior(CONNECT_PARAMS* cp)
{
	m_dwStatusWrapperThreadId = -1;
	m_dwRegistryWrapperThreadId = -1;

	m_dumpFileName = NULL;

	m_Model = NULL;
	m_SoftwareVersion = NULL;

	// set the handle then increment the next handle
	m_handle = NEXT_HANDLE++;

	m_quit = false;
	m_cancel = false;
	m_rebooting = false;
	m_shouldReconnect = true;
	m_rebooting = false;

	m_connectParams = NULL;

	m_nextReadPos = 0;
	m_pos = 0;
	m_recvState = WAIT_SYNC_BYTE;

	m_sckt = INVALID_SOCKET;
	//m_hThread = NULL;

	m_registry = new CJniorRegistry();
	m_writtenKeys = 0;

	ConnectionStatus(STATUS_NOT_CONNECTED);
	LoginStatus(STATUS_NOT_LOGGED_IN);
	m_loginLevel = -1;

	m_lastSentTime = 0;
	m_monitorPacketRecvTime = 0;
	m_timePacketRecvTime = 0;

	m_connectParams = cp; 

	return;
}

CJnior::~CJnior() {
	Cancel();
}

int CJnior::Cancel() {
	m_cancel = true;
	m_connectCancel = true;

	return Status(STATUS_CANCELLED);
}


int CJnior::SetSocket(SOCKET sckt) {
	// assign the socket
	m_sckt = sckt;

	// we are connected
	this->m_connectionStatus = STATUS_CONNECTED;

	//set receive timeout
	if(setsockopt(m_sckt
	          ,SOL_SOCKET
			  ,SO_RCVTIMEO
			  ,(const char *)&SEND_RECV_TIMEOUT
			  ,sizeof(SEND_RECV_TIMEOUT))!=0)
	{
		if (!m_cancel) {
			return Error("CJnior::SetSocket", STATUS_CONNECTION_FAILED);
		} else {
			return Error("CJnior::SetSocket", STATUS_CANCELLED);
		}
	}

	//set send timeout
	if(setsockopt(m_sckt
	          ,SOL_SOCKET
			  ,SO_SNDTIMEO
			  ,(const char *)&SEND_RECV_TIMEOUT
			  ,sizeof(SEND_RECV_TIMEOUT))!=0)
	{
		if (!m_cancel) {
			return Error("CJnior::SetSocket", STATUS_CONNECTION_FAILED);
		} else {
			return Error("CJnior::SetSocket", STATUS_CANCELLED);
		}
	}


	m_thd = new ReceiverThread(this);

	////if we havent created a thread to handle incoming bytes, do so now
	//if (m_hThread == NULL) {
	//	m_quit = false;
	//	m_hThread = CreateThread(
	//		NULL,										// default security attributes 
	//		0,											// use default stack size  
	//		(LPTHREAD_START_ROUTINE) this->ReceiverThd,	// thread function 
	//		this,										// argument to thread function 
	//		0,											// use default creation flags 
	//		&m_dwThreadId);								// returns the thread identifier 
	//}

	m_shouldReconnect = true;

	Status(STATUS_ACCEPTED_CONNECTION);
	
	return Status(STATUS_CONNECTED);
}



CONNECT_PARAMS* CJnior::GetConnectionProperties() {
	return this->m_connectParams;
}

struct CONNECT_THREAD_OBJS {
public:
	CJnior* jnior;
	CONNECT_PARAMS* connectParams;
};

int CJnior::ConnectAsync(CONNECT_PARAMS* connectParams) {
	// validate the connect params
	if (connectParams->port < 0) {
		return 1001;
	} else if (connectParams->retryCount < 0) {
		return 1002;
	} else if (connectParams->retryInterval < 0) {
		return 1003;
	} else if (connectParams->webPort < 0) {
		return 1004;
	}

	HANDLE hConnectThread = NULL;
	DWORD dwConnectThreadId;
	
	CONNECT_THREAD_OBJS* obj = new CONNECT_THREAD_OBJS();
	obj->jnior = this;
	obj->connectParams = connectParams;

	//if we havent created a thread to handle incoming bytes, do so now
	if (hConnectThread == NULL) {
		hConnectThread = CreateThread(
			NULL,										// default security attributes 
			0,											// use default stack size  
			(LPTHREAD_START_ROUTINE) this->ConnectThd,	// thread function 
			obj,										// argument to thread function 
			0,											// use default creation flags 
			&dwConnectThreadId);						// returns the thread identifier 
	}

	return STATUS_OK;
}

DWORD WINAPI CJnior::ConnectThd( LPVOID lparam ) {
	CONNECT_THREAD_OBJS* obj = (CONNECT_THREAD_OBJS*) lparam;

	return obj->jnior->Connect(obj->connectParams, false);
}


std::map<int, HANDLE> m_hConnectMutexes;

int CJnior::Connect(CONNECT_PARAMS* connectParams, bool reconnecting)
{
	if(WaitForSingleObject(m_hConnectMutexes[this->m_handle], 30000)==WAIT_TIMEOUT) {
		return STATUS_FAILED;
	}
	
	char log[128];

	if (this->IsConnected()) {
		Logger(this->m_dumpFileName, "Already Connected");
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return STATUS_CONNECTED;
	}

	/*if (!this->m_connectCancel) {
		Log("Connect - Already Connecting");
		return STATUS_CONNECTING;
	}*/

	long result = 0;
	sockaddr_in sck_add;
	bool couldNotConnect = false;
	m_connectCancel = false;
	m_quit = false;

	// validate the connect params
	if (connectParams->port < 0) {
		Logger(this->m_dumpFileName, "Connect - Invalid Port");
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return 1001;
	} else if (connectParams->retryCount < 0) {
		Logger(this->m_dumpFileName, "Connect - Invalid Retry Count");
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return 1002;
	} else if (connectParams->retryInterval < 0) {
		Logger(this->m_dumpFileName, "Connect - Invalid Retry Interval");
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return 1003;
	} else if (connectParams->webPort < 0) {
		Logger(this->m_dumpFileName, "Connect - Invalid Web Port");
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return 1004;
	}

	// get our connection parameters
	m_connectParams = connectParams;
	m_connectParams->retriesRemaining = m_connectParams->retryCount;
	m_connectParams->message = new char[1];
	m_connectParams->message[0] = '\0';

	sprintf(log, "Connect - Retry count: %d\0", m_connectParams->retryCount);
	Logger(this->m_dumpFileName, log);

	// check to see if the web port is in the ipaddress
	int nWebPort = 0;
	// make sure we have a valid web port
	if (m_connectParams->host != NULL) {
		string sWebPort = string(m_connectParams->host);
		int pos = sWebPort.find(":");
		if (pos > 0) {
			m_connectParams->host = new char[pos + 1];
			m_connectParams->host[pos] = '\0';
			strncpy(m_connectParams->host, sWebPort.c_str(), pos);
			sWebPort = sWebPort.substr(sWebPort.find(":") + 1);
			nWebPort = atoi(sWebPort.c_str());
			sprintf(log, "Connect - Got Web Port from address: %d", nWebPort);
			Logger(this->m_dumpFileName, log);
		}
	}

	// if we are already connected and this connect method is called again then 
	// we will close the current connection and connect again.  Maybe the 
	// programmer is smarter than we are?
	if (m_sckt != INVALID_SOCKET)
	{
		shutdown(m_sckt, SD_BOTH);
		closesocket(m_sckt);
	}

	// new socket
	m_sckt = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	// if we return INVALID_SOCKET then something went wrong.  call cleanup 
	// and raise the Error callback method
	if ( m_sckt == INVALID_SOCKET ) {
		WSACleanup();
		Error("CJnior::Connect", INVALID_SOCKET);
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return ConnectionStatus(STATUS_CONNECTION_FAILED);
	}

	// make sure our host is valid
	if (m_connectParams->host == NULL) {
		Logger(this->m_dumpFileName, "Connect - Invalid Host");
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return (STATUS_CONNECTION_FAILED);
	}

	u_long nRemoteAddr = inet_addr(m_connectParams->host);
	if (nRemoteAddr == INADDR_NONE) {
		// pcHost isn't dotted IP, so resolve it through DNS
		hostent* pHE = gethostbyname(m_connectParams->host);
		if (pHE == 0) {
			Error("CJnior::Connect", INADDR_NONE);
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return ConnectionStatus(STATUS_CONNECTION_FAILED);
		}
		if (pHE->h_addr_list != NULL) {
			in_addr* inaddress = (in_addr*)pHE->h_addr_list[0];
			m_connectParams->host = inet_ntoa(*inaddress);
			nRemoteAddr = inet_addr(m_connectParams->host);
		}
	}	
	if ( nRemoteAddr == INADDR_NONE ) {
		Logger(this->m_dumpFileName, "Connect - Address Invalid");
		Error("CJnior::Connect", INADDR_NONE);
		m_connectCancel = true;
		ReleaseMutex(m_hConnectMutexes[this->m_handle]);
		return ConnectionStatus(STATUS_CONNECTION_FAILED);
	}

	do {
		ConnectionStatus(STATUS_CONNECTING);

		// if the jnior server port is 0 then we need to query the web port for 
		// the jnior server port
		if (m_connectParams->port == 0 || couldNotConnect) {
			ConnectionStatus(STATUS_QUERY_JNIOR_PORT);

			string host = this->m_connectParams->host;
			int port = this->m_connectParams->webPort;
			if (nWebPort > 0) {
				port = nWebPort;
			}

			string response = queryCgi(host, port);
			#if DEBUG
				char* repsponseLog = new char[response.length()+3];
				sprintf(repsponseLog, "\r\n%s", (char*)response.c_str());
				Logger(this->m_dumpFileName, repsponseLog);
				delete [] repsponseLog;
			#endif

			string jniorServer = "<JniorServer>";
			int jniorServerLen = jniorServer.length();
			int startPos = response.find(jniorServer);

			Logger(this->m_dumpFileName, "Connect - Query CGI");

			if (startPos > 0) {
				int endPos = response.find("</JniorServer>");
				if (endPos > 0) {
					startPos += jniorServerLen;
					m_connectParams->port = atoi(response.substr(startPos, endPos - startPos).c_str());
					ConnectionStatus(STATUS_QUERY_JNIOR_PORT_SUCCESS);
				}
					sprintf(log, "Query CGI returned port %d", m_connectParams->port);
					Logger(this->m_dumpFileName, log);
			} else {
				string response = getConfigure(host, port);
				#if DEBUG
					char* repsponseLog = new char[response.length()+3];
					sprintf(repsponseLog, "\r\n%s", (char*)response.c_str());
					Logger(this->m_dumpFileName, repsponseLog);
					delete [] repsponseLog;
				#endif

				jniorServer = "<param name=\"port\" value=\"";
				jniorServerLen = jniorServer.length();
				startPos = response.find(jniorServer);

				Logger(this->m_dumpFileName, "Connect - Configure.htm");

				if (startPos > 0) {
					int endPos = response.find("\">");
					if (endPos > 0) {
						startPos += jniorServerLen;
						m_connectParams->port = atoi(response.substr(startPos, endPos - startPos).c_str());
						ConnectionStatus(STATUS_QUERY_JNIOR_PORT_SUCCESS);
						sprintf(log, "Configure.htm returned port %d", m_connectParams->port);
						Logger(this->m_dumpFileName, log);
					}
				}
			}
		}

		// everything looks good, continue to connect
		sck_add.sin_family = AF_INET;
		sck_add.sin_addr.s_addr = nRemoteAddr;
		sck_add.sin_port = htons( m_connectParams->port );
		
		// try to connect
		sprintf(log, "Connect - Attempting  %s:%d\0", m_connectParams->host, m_connectParams->port);
		Logger(this->m_dumpFileName, log);

		result = connect(m_sckt, (sockaddr *)&sck_add, sizeof(sockaddr_in));
		if (result == 0 || this->m_connectCancel) break;

		//cout << "Could not connect " << couldNotConnect << endl;

		int error = WSAGetLastError();
		sprintf(log, "Connect - Could not connect, WAS Error: %d\0", error);
		Logger(this->m_dumpFileName, log);

		// Resource temporarily unavailable.
		//  This error is returned from operations on nonblocking sockets that 
		//  cannot be completed immediately, for example recv when no data is 
		//  queued to be read from the socket. It is a nonfatal error, and the 
		//  operation should be retried later. It is normal for WSAEWOULDBLOCK 
		//  to be reported as the result from calling connect on a nonblocking 
		//  SOCK_STREAM socket, since some time must elapse for the connection 
		//  to be established.
		if (error == WSAEWOULDBLOCK) {
			// sleep for a little then try to connect again.  we are going to 
			// hope that we get a WSAEISCONN error
			Sleep(5000);
			result = connect(m_sckt, (sockaddr *)&sck_add, sizeof(sockaddr_in));
			if (result == 0 || this->m_connectCancel) break;
			error = WSAGetLastError();
		}
		// we are connected so GO
		if (error == WSAEISCONN) {
			result = 0;
			break;
		}

		// decrement the remaining retry count
		m_connectParams->retriesRemaining--;
		ConnectionStatus(STATUS_RECONNECTING);

		sprintf(log, "Connect - Retries remaining: %d\0", m_connectParams->retriesRemaining);
		Logger(this->m_dumpFileName, log);

		time_t sleepExpiration = time(0) + (m_connectParams->retryInterval / 1000);
		time_t t = time(0);
		m_connectParams->secondsRemaining = m_connectParams->retryInterval / 1000;
		do {
			Sleep(250);
			t = time(0);
			m_connectParams->secondsRemaining = sleepExpiration - t;
		} while (t < sleepExpiration && !this->m_connectCancel);
		couldNotConnect = true;
	} while (m_connectParams->retriesRemaining > 0 && !this->m_connectCancel && !this->m_quit);

	if (result < 0) {
		if (!m_connectCancel) {
			Error("CJnior::Connect", WSAGetLastError ());
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return ConnectionStatus(STATUS_CONNECTION_FAILED);
		} else {
			Logger(this->m_dumpFileName, "Connect - User Canceled");
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return ConnectionStatus(STATUS_CANCELLED);
		}
	}


	//set receive timeout
	if(setsockopt(m_sckt
	          ,SOL_SOCKET
			  ,SO_RCVTIMEO
			  ,(const char *)&SEND_RECV_TIMEOUT
			  ,sizeof(SEND_RECV_TIMEOUT))!=0)
	{
		if (!m_connectCancel) {
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return Error("CJnior::Connect", STATUS_CONNECTION_FAILED);
		} else {
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return Error("CJnior::Connect", STATUS_CANCELLED);
		}
	}

	//set send timeout
	if(setsockopt(m_sckt
	          ,SOL_SOCKET
			  ,SO_SNDTIMEO
			  ,(const char *)&SEND_RECV_TIMEOUT
			  ,sizeof(SEND_RECV_TIMEOUT))!=0)
	{
		if (!m_connectCancel) {
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return Error("CJnior::Connect", STATUS_CONNECTION_FAILED);
		} else {
			m_connectCancel = true;
			ReleaseMutex(m_hConnectMutexes[this->m_handle]);
			return Error("CJnior::Connect", STATUS_CANCELLED);
		}
	}

	m_nextReadPos = 0;
	m_pos = 0;
	m_recvState = WAIT_SYNC_BYTE;

	int connectionStatus = ConnectionStatus(STATUS_CONNECTED);

	//if (!reconnecting) {
		m_thd = new ReceiverThread(this);
	//}

	////if we havent created a thread to handle incoming bytes, do so now
	//if (m_hThread == NULL) {
	//	m_quit = false;
	//	m_hThread = CreateThread(
	//		NULL,										// default security attributes 
	//		0,											// use default stack size  
	//		(LPTHREAD_START_ROUTINE) this->ReceiverThd,	// thread function 
	//		this,										// argument to thread function 
	//		0,											// use default creation flags 
	//		&m_dwThreadId);								// returns the thread identifier 
	//}

	m_rebooting = false;
	m_shouldReconnect = true;
	m_connectCancel = true;

   	Logger(this->m_dumpFileName, "Connect - Connected");

	ReleaseMutex(m_hConnectMutexes[this->m_handle]);

	return connectionStatus;
}


int CJnior::Reconnect()
{
	if (!m_shouldReconnect) {
		return STATUS_DISCONNECTED;
	}

	Logger( this->m_dumpFileName, "Reconnecting..." );

	// make sure we are disconnected on our end
	Disconnect(true);

	m_cancel = false;
	//do {
		if (m_rebooting) {
			Sleep(90000);
		} else {
			Sleep(30000);
		}
		int result = Connect(m_connectParams, true);
	//} while (Connect(m_connectParams) != STATUS_CONNECTED && !this->m_cancel);

	if (!m_cancel) {
		Logger(this->m_dumpFileName, GetStatusDescription(result));
		return result;
	} else {
		return Status(STATUS_CANCELLED);
	}
}

int CJnior::Disconnect()
{
	Logger(this->m_dumpFileName, "Disconnect() called");

	return Disconnect(false);
}

int CJnior::Disconnect(bool reconnect)
{
	Logger(this->m_dumpFileName, "Disconnect(b) called");

	Sleep(100);

	m_recvState = WAIT_SYNC_BYTE;

	int result = shutdown(m_sckt, SD_SEND);
	if (result != 0) {
		result = WSAGetLastError();
		if (result != WSAENOTSOCK && result != WSAENOTCONN) {
			return Error("CJnior::Disonnect", result);
		}
	}

	if (result != WSAENOTSOCK && result != WSAENOTCONN) {
		// consume any remaining bytes in the buffer
		char buf[100];
		while (recv(m_sckt, buf, 100, 0) > 0) {
			Sleep(100);
		}

		result = closesocket(m_sckt);
		if (result != 0)
		{
			return Error("CJnior::Disconnect", result);
		}
	}

	//	// wait for the previous receiver thread to close
	//if (m_hThread != NULL) {
	//	ConnectionStatus(STATUS_WAIT_FOR_RECV_THREAD);
	//	while (m_hThread != NULL) {
	//		Sleep(100);
	//	}
	//}

	LoginStatus(STATUS_LOGGED_OUT);
	ConnectionStatus(STATUS_DISCONNECTED);

	m_shouldReconnect = reconnect;
	if (!m_rebooting && !reconnect) {
		m_quit = true;
		m_thd->m_quit = true;
		m_connectCancel = true;
		//m_hThread = NULL;
	}

	return STATUS_OK;
}

bool CJnior::IsConnected() {
	//Log(GetStatusDescription(this->m_connectionStatus));

	bool isConnected = (this->m_connectionStatus == STATUS_CONNECTED);

	if (!isConnected) {
		Logger(this->m_dumpFileName, "IsConnected false");
	//} else {
	//	Logger(this->m_dumpFileName, "IsConnected true");
	}

	return isConnected;
}

int CJnior::DisableMonitorPackets() {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST* request = new REQUEST;
	request->request = (short)REQUEST_ENUM::DISABLE_MONITOR_REQUEST;

	Request(request);

	Status(STATUS_DISABLE_MONITOR_PACKETS);

	delete [] request;

	return 0;
}

int CJnior::EnableMonitorPackets() {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST* request = new REQUEST;
	request->request = (short)REQUEST_ENUM::ENABLE_MONITOR_REQUEST;

	Request(request);

	Status(STATUS_ENABLE_MONITOR_PACKETS);

	delete [] request;

	return 0;
}

int CJnior::Reboot()
{
	m_cancel = false;
	while (m_SoftwareVersion == NULL && !this->m_cancel) {
		Sleep(1000);
	}

	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST* request = new REQUEST;
	request->request = (short)REQUEST_ENUM::REBOOT_REQUEST;

	Request(request);

	Status(STATUS_REBOOTING);

	m_rebooting = true;

	delete [] request;

	//// we had a reboot issue where if there was an active connection durring 
	//// the reboot then the JNIOR would hang (sometimes).  This fix will only 
	//// work if this is the only connection.  This fix will disconnect itself 
	//// after the reboot has been sent.
	//int result = strcmp(SoftwareVersion, "2.14.57");
	//if (result == 0) {
	//	Status(1003);
	//	Reconnect();
	//}

	return 0;
}



/******************************************************************************
************************ LOGIN ************************************************
******************************************************************************/
int CJnior::Login(CREDENTIALS* creds, bool waitForResponse)
{
	LoginStatus(STATUS_LOGGING_IN);

	size_t userSize = strlen(creds->username);
	size_t passSize = strlen(creds->password);
	size_t size = userSize + passSize + 3;
	char* bytes = new char[64];
	int pos = 0;

	bytes[pos++] = LOGIN_REQUEST;

	// should we use encoding or send the login in cleartext
	if (creds->encode) {
		// set a blank username
		bytes[pos++] = 0x00;

		// build the string that we want to encode
		string preencode = string(creds->username);
		preencode += ":";
		preencode += string(creds->password);

		// encode it
		string encoded = base64_encode(reinterpret_cast<const unsigned char*>(preencode.c_str()), preencode.length());
		passSize = encoded.length();

		// transfer the encoded password
		bytes[pos++] = passSize;
		strncpy((char*)&bytes[pos], encoded.c_str(), passSize);
		pos += passSize;

	} else {
		// transfer the username
		bytes[pos++] = userSize;
		strncpy((char*)&bytes[pos], creds->username, userSize);
		pos += userSize;

		// transfer the password
		bytes[pos++] = passSize;
		strncpy((char*)&bytes[pos], creds->password, passSize);
		pos += passSize;
	}

	m_loginStatus = STATUS_NOT_LOGGED_IN;

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_LOGIN_FAILED;

	CommandTimeout* timeout = new CommandTimeout(45000);
	while (waitForResponse && m_loginStatus == STATUS_NOT_LOGGED_IN && !timeout->isExpired() && !this->m_cancel) {
		Sleep(100);
	}
	if (timeout->expired) {
		delete timeout;
		return Status(STATUS_COMMAND_TIMEOUT);
	}
	delete timeout;

	if (bytes != NULL) delete [] bytes;

	return m_loginStatus;
}

int CJnior::LoginStatus(int status) {
	this->m_loginStatus = Status(status);

	char log[128];
	sprintf(log, "Login Status - message: %03d %s\0", status, GetStatusDescription(status));
	Logger(this->m_dumpFileName, log);

	if (m_loginListeners.size() > 0) {
		STATUS_CALLBACK_ARGS* args = new STATUS_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->status = status;
		args->message = GetStatusDescription(args->status);

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_loginListeners.begin(), this->m_loginListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper, //StatusCallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwStatusWrapperThreadId);								// returns the thread identifier 
	}

	return this->m_loginStatus;
}

bool CJnior::IsLoggedIn() {
	return ((this->m_loginStatus == STATUS_LOGGED_IN_GUEST)
		|| (this->m_loginStatus == STATUS_LOGGED_IN_USER)
		|| (this->m_loginStatus == STATUS_LOGGED_IN_ADMIN));
}

int CJnior::GetLoginStatus() {
	return this->m_loginLevel;
}
/*********************** LOGIN ***********************************************/



int CJnior::RequestMonitorPacket(int monitorInterval) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST request;
	request.request = (short)REQUEST_ENUM::MONITOR_REQUEST;
	request.interval = monitorInterval;

	Request(&request);

	Status(STATUS_REQUESTING_MONITOR);

	return 0;
}

long long CJnior::RequestClock() {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST request;
	request.request = (short)REQUEST_ENUM::DATE_TIME_REQUEST;

	m_timePacketRecvTime = 0;
	int result = Request(&request);
	if (result != 0) return result;

	Status(STATUS_REQUESTING_TIME);

	CommandTimeout* timeout = new CommandTimeout(45000);
	while (m_timePacketRecvTime == 0 && !timeout->isExpired() && !this->m_cancel) {
		if (m_cancel) {
			return Status(STATUS_CANCELLED);
		} else if (timeout->isExpired()) {
			return Status(STATUS_COMMAND_TIMEOUT);
		} else {
			Sleep(100);
		}
	}

	return this->m_monitor.jniorTime;
}

int CJnior::RequestUsageMeterPacket() {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	REQUEST request;
	request.request = (short)REQUEST_ENUM::USAGE_METER_REQUEST;

	Request(&request);

	Status(STATUS_REQUESTING_USAGE_METERS);

	return 0;
}

int CJnior::Request(REQUEST* request)
{
	if (!IsConnected()) return STATUS_NOT_CONNECTED;

	char* bytes = new char[7];
	int pos = 0;

	bytes[pos++] = REQUEST_PACKET;

	setshort(bytes, pos, request->request);

	if (request->request == REQUEST_ENUM::MONITOR_REQUEST) {
		setint(bytes, pos, request->interval);
	}

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;

	//while (block && loginStatus == STATUS_NOT_LOGGED_IN) {
	//	Sleep(100);
	//}

	//delete [] bytes;

	return STATUS_OK;
}


// ***** SET CLOCK *****
int CJnior::SetClock(long long milliseconds) {
	char bytes[9];
	int pos = 0;

	bytes[pos++] = SET_CLOCK_PACKET;

	setlong(bytes, pos, milliseconds);

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;

	return STATUS_OK;
}


// ***** COMMAND FUNCTIONS *****
int CJnior::Command(char* commandString, char* returnString) {
	int defaultpulse = 100;
        int i, n;
        int state = 0;
        int mask = 0;
        int res = 0;
        int setmask = 0;
        int parameter = defaultpulse;
        bool close = false;
        bool open = false;
        bool reset = false;
        bool setcounters = false;
        bool dosetcounters = false;
        bool doreset = false;
        bool pulse = false;
        bool value = false;
        bool counterdump = false;
        bool usagedump = false;
		bool stop = false;
        int shift = 0;
        
		int commandLength = strlen(commandString);

        for (i=0; i<commandLength && !stop; i++) { /* each character in the comand */
            switch (commandString[i]) {
                case 'q':   // [Q]uit - exits command
                    stop = true;   // ends command interpretation
                    break;  // will exit
                    
                case 't':   // [T]est mode cycles the relays for verification
                    // this must be a command by itself
					if (commandLength != 1) return STATUS_FAILED;
                    return true;
                    
                case 'c':   // [C]lose sets relay state to 1
                    close = true;
                    open = false;
                    reset = false;
                    setcounters = false;
                    break;  // next character
                    
                case 'o':   // [O]pen sets relay state to 0
                    open = true;
                    close = false;
                    reset = false;
                    setcounters = false;
                    break;  // next character
                    
                case 'p':   // [P]ulse indicates that changes are pulsed
                    pulse = true;
                    break;  // next character
                    
                case '=':   // acquire parameter
					{
						// extract just the content after the '='
						char* cmd = &commandString[i + 1]; 
						// check that only digits are here
						for (n=0; n<strlen(cmd); n++) {
							if (!(cmd[n] >= '0' && cmd[n] <= '9')) return STATUS_FAILED;
						}
						// obtain the integer value
						parameter = atoi(cmd);
						value = true;
						stop = true;   // ends command interpretation
					}
					break;
                    
                case 'r':
                    doreset = true;
                    reset = true;
                    open = false;
                    close = false;
                    setcounters = false;
                    break;  // next character
                    
                case 's':   // sets selected counters
                    dosetcounters = true;
                    setcounters = true;
                    open = false;
                    close = false;
                    reset = false;
                    break;
                    
                case '1':   // digit sets up state and mask
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                    if (!open && !close && !reset && !setcounters) return false;
                    n = (int) (commandString[i] - '1');
                    if (shift == 0) {
                        mask |= (1 << n);
                        if (close) {
                            state |= (1 << n);
                        } else if (open) {
                            state &= ~(1 << n);
                        } else if (reset) res |= (1 << n);
                        else if (setcounters) setmask |= (1 << n);
                    } else {
                        mask |= (1 << (n + 8 * shift));
                        if (close) {
                            state |= (1 << n << (8 * shift));
                        } else if (open) {
                            state &= ~(1 << n << (8 * shift));
                        }
                    }
                    shift = 0;
                    break;  // next character
                    
                case '*':    // means all - 12345678
                    if (!open && !close && !reset && !setcounters) return false;
                    if (close) {
                        state = 0xffff;
                        mask = 0xffff;
                    } else if (open) {
                        state = 0;
                        mask = 0xffff;
                    } else if (reset) res = 0xffff;
                    else if (setcounters) setmask = 0xffff;
                    break;  // next character
                    
                case '+':
                    shift++;
                    break;
                    
                case 'l':   // list counters after command
                    counterdump = true;
                    break;
                    
                case 'u':   // list usage after command
                    usagedump = true;
                    break;
                    
                case ' ':   // white space ignored
                    break;  // next character
                    
                default:    // error in command
                    return false;
            }
        } /* each character in the command */
        
        // extra parameter is an error
        if (value && !pulse && !dosetcounters) return false;
        
        // parameter conflict - can't use both [S]et and [P]ulse in the same command line.
        if (value && pulse && dosetcounters) return false;
        
        // [S]et Counters command requires a parameter
        if (dosetcounters && !value) return false;
        
        // if mask is nonzero then we have changes to make on the way out
        if (mask != 0) {
            if (pulse) { /* this action is pulsed */
				this->BlockPulseRelays( mask, state, parameter );
            } /* this action is pulsed */
            else this->BlockSetRelays( mask, state );
        }
        
        /* if there are no relays selected and the pulse command has been
         *  issued then we establish a new default pulse duration.
         */
        else { /* define new defaults */
            if (pulse) { /* new default pulse specified */
                if (!value) return false;   // pulse w/o selection or value is error
                defaultpulse = parameter;
                //////printHeader(out);
            } /* new default pulse specified */
        } /* define new defaults */
        
        // If reset is to be performed it is now
        if (doreset) {
            if (res == 0) { /* no inputs specified then outputs reset */
                this->BlockSetRelays( 0xFF, 0x00 );
                // This also resets the pulse queue and cancels any ongoing pulse
                //////digital.resetQueue();
            } /* no inputs specified then outputs reset */
            
            //////// resets input latches if selected
            //////else { /* reset selected inputs */
            //////    for (n=0; n<8; n++) {
            //////        if ((res & (1 << n)) != 0) digital.setInputLatched(n, false);
            //////    }
            //////} /* reset selected inputs */
            
        }
        
        //////// [S]et Counters as appropriate
        //////if (dosetcounters) { /* counters can be set */
        //////    if (setmask == 0) return false; // command requires the counters to be specified
        //////    for (n=0; n<8; n++) {
        //////        if ((setmask & (1 << n)) != 0) digital.setCounter(n, parameter);
        //////    }
        //////    counterdump = true; // and list the counters now
        //////} /* counters can be set */
        //////
        //////// Now if a [L]ist Counters command has been included we do that.
        //////if (counterdump) {
        //////    out.println("\r\n     din1     din2     din3     din4     din5     din6     din7     din8");
        //////    StringBuffer str = new StringBuffer();
        //////    for (n=0; n<8; n++) {
        //////        String cnt = "         " + digital.getCounter(n);
        //////        str.append(cnt.substring(cnt.length()-9));
        //////    }
        //////    out.println(str);
        //////    printHeader(out);
        //////}
        //////
        //////// Now if the [U]sage command has been included we display those statistics
        //////if (usagedump) {
        //////    out.println();
        //////    try {
        //////        long millis[] = new long[16];
        //////        for (n=0; n<16; n++) { /* each channel */
        //////            millis[n] = digital.getUsage(n);
        //////        } /* each channel */
        //////        
        //////        for (n=0; n<16; n++) { /* each channel */
        //////            if (n<8) out.print( "din" + (n+1) + "  " );
        //////            else out.print( "rout" + (n-7) + " ");
        //////            out.print( Long.toString(millis[n]) + " msec (");
        //////            StringBuffer format = new StringBuffer(Long.toString(millis[n]/36000L));
        //////            while (format.length() < 3) format.insert(0, '0');
        //////            format.insert(format.length()-2, '.');
        //////            out.println( format.toString() + " hrs)" );
        //////        } /* each channel */
        //////        out.println();
        //////    } catch (IOException ioe) {}
        //////}
        
		return STATUS_OK;
}

int CJnior::Command(COMMAND* command)
{
	char* bytes = NULL;
	int pos = 0;

	if (command->action == 6) {
		bytes = new char[8];

		bytes[pos++] = COMMAND_PACKET;

		bytes[pos++] = command->action;
		setshort(bytes, pos, command->channel);
		setint(bytes, pos, command->duration);
	}

	else if (command->action == 7) {
		int maskBytes = 1;
		if (command->channelMask > 0xff || command->stateMask > 0xff) {
			maskBytes = 2;
		}

		bytes = new char[6 + maskBytes * 2];

		bytes[pos++] = COMMAND_PACKET;

		bytes[pos++] = command->action;
		if (maskBytes == 1) {
			bytes[pos++] = command->channelMask;
		} else {
			setshort(bytes, pos, command->channelMask);
		}
		if (maskBytes == 1) {
			bytes[pos++] = command->stateMask;
		} else {
			setshort(bytes, pos, command->stateMask);
		}
		setint(bytes, pos, command->duration);
	}

	else if (command->action == 10) {
		int maskBytes = 1;
		if (command->channelMask > 0xff || command->stateMask > 0xff) {
			maskBytes = 2;
		}

		bytes = new char[2 + maskBytes * 2];

		bytes[pos++] = COMMAND_PACKET;

		bytes[pos++] = command->action;
		if (maskBytes == 1) {
			bytes[pos++] = command->channelMask;
		} else {
			setshort(bytes, pos, command->channelMask);
		}
		if (maskBytes == 1) {
			bytes[pos++] = command->stateMask;
		} else {
			setshort(bytes, pos, command->stateMask);
		}
	}

	else {
		bytes = new char[4];

		bytes[pos++] = COMMAND_PACKET;

		bytes[pos++] = command->action;
		setshort(bytes, pos, command->channel);
	}


	if (Send(bytes, pos) == STATUS_FAILED) {
		Status(STATUS_FAILED);
		return STATUS_FAILED;
	}

	//while (block && loginStatus == STATUS_NOT_LOGGED_IN) {
	//	Sleep(100);
	//}

	//delete [] bytes;

	return STATUS_OK;
}

int CJnior::SetOutput(int channel, char state) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Set Output %d - %d", channel, state);
	Logger( this->m_dumpFileName, log );

	if (state == 0x00) {
		return OpenOutput(channel);
	} else if (state == 0x01) {
		return CloseOutput(channel);
	}

	return STATUS_FAILED;
}
	
int CJnior::CloseOutput(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Close Output %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::CLOSE_RELAY;
	command.channel = channel;

	Command(&command);

	Status(STATUS_CLOSE_OUTPUT);

	return 0;
}

int CJnior::OpenOutput(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Open Output %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::OPEN_RELAY;
	command.channel = channel;

	Command(&command);

	Status(STATUS_OPEN_OUTPUT);

	return 0;
}

int CJnior::ToggleOutput(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Toggle Output %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::TOGGLE_RELAY;
	command.channel = channel;

	Command(&command);

	Status(STATUS_TOGGLE_OUTPUT);

	return 0;
}

int CJnior::ResetInputLatch(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Reset Input Latch %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::RESET_INPUT_LATCH;
	command.channel = channel;

	Command(&command);

	Status(STATUS_TOGGLE_OUTPUT);

	return 0;
}

int CJnior::ClearInputCounter(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Clear Input Counter %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::CLEAR_INPUT_COUNTER;
	command.channel = channel;

	Command(&command);

	Status(STATUS_TOGGLE_OUTPUT);

	return 0;
}

int CJnior::ClearInputUsage(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Clear Input Usage %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::CLEAR_INPUT_USAGE_METER;
	command.channel = channel;

	Command(&command);

	Status(STATUS_TOGGLE_OUTPUT);

	return 0;
}

int CJnior::ClearOutputUsage(int channel) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Clear Output Usage %d", channel);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::CLEAR_OUTPUT_USAGE_METER;
	command.channel = channel;

	Command(&command);

	Status(STATUS_TOGGLE_OUTPUT);

	return 0;
}

int CJnior::PulseOutput(int channel, int duration) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Pulse Output %d for %d", channel, duration);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::PULSE_OUTPUT;
	command.channel = channel;
	command.duration = duration;

	Command(&command);

	Status(STATUS_PULSE_OUTPUT);

	return 0;
}

int CJnior::BlockPulseRelays(int channelMask, int stateMask, int duration) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Block Pulse Relays - Channels:%d States:%d Duration:%d", channelMask, stateMask, duration);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::BLOCK_PULSE_RELAYS;
	command.channelMask = channelMask;
	command.stateMask = stateMask;
	command.duration = duration;

	Command(&command);

	Status(STATUS_BLOCK_PULSE_RELAYS);

	return 0;
}

int CJnior::BlockSetRelays(int channelMask, int stateMask) {
	if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	char log[128];
	sprintf(log, "Block Set Relays - Channels:%d States:%d", channelMask, stateMask);
	Logger( this->m_dumpFileName, log );

	COMMAND command;
	command.action = COMMAND_ENUM::BLOCK_SET_RELAYS;
	command.channelMask = channelMask;
	command.stateMask = stateMask;

	Command(&command);

	Status(STATUS_BLOCK_SET_RELAYS);

	return 0;

}

JNIOR_MONITOR* CJnior::GetMonitor() {
	// wait for the monitor packet to come in
	while (this->m_monitorPacketRecvTime == 0) {
		Sleep(100);
	}

	return &m_monitor;
}

double CJnior::GetExternalValue(char deviceType, char ioSelection, char channelNumber) {
	if (!IsConnected()) return STATUS_NOT_CONNECTED;

	char bytes[4];
	int pos = 0;

	bytes[pos++] = GET_EXTERNAL_VALUE;
	bytes[pos++] = deviceType;
	bytes[pos++] = ioSelection;
	bytes[pos++] = channelNumber;

	short externalModuleValueKey = (deviceType << 8) + (ioSelection << 4) + channelNumber;
	m_externalModuleValues[externalModuleValueKey] = 0xffffffff;

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;

	CommandTimeout* timeout = new CommandTimeout(45000);
	while (m_externalModuleValues[externalModuleValueKey] == 0xffffffff 
		&& !timeout->isExpired() && !m_cancel && !m_quit) {
			Sleep(10);
	}
	
	return m_externalModuleValues[externalModuleValueKey];
}


// ***** COMMAND FUNCTIONS *****


clock_t CJnior::GetMonitorFreshness() {
	if (this->m_monitorPacketRecvTime == 0) return -1;
	return clock() - this->m_monitorPacketRecvTime;
}

long long CJnior::GetKnownJniorTime() {
	// wait for the monitor packet to come in
	while (this->m_monitorPacketRecvTime == 0) {
		Sleep(100);
	}

	return this->m_monitor.jniorTime;
}


/******************************************************************************
************************ REGISTRY FUNCTIONS ***********************************
******************************************************************************/
int CJnior::ReadRegistryKeys(RegistryKey** keys, short size, char* defaultValue, bool waitForResponse)
{
	char* bytes = new char[500];
	int pos = 0;
	bool validKey = false;

	//try {
		bytes[pos++] = READ_REG_KEYS;

		short keyCount = 0;
		pos += 2;

		// for each key we assign a unique id and send the key string
		for (int i = 0; i < size; i++) {
			if (keys[i] == NULL || keys[i]->key == NULL) {
				continue;
			}

			validKey = true;

			RegistryKey* regKey = m_registry->GetKey(keys[i]->key);

			if (regKey->RESERVED) continue;

			// set the value of the key to be the default value supplied
			if (defaultValue != NULL) {
				regKey->SetValue(defaultValue);
			}

			keyCount++;
			regKey->readReceived = false;

			//char s[250];
			//sprintf(s, "ReadRegistryKeys   %s ?= %s\n", regKey->toString(), keys[i]->toString());
			//Log(s);

			int registryKeySize = strlen(keys[i]->key);
			int size = registryKeySize + 6;

			setshort(bytes, pos, regKey->uniqueId);
			
			//try {
				bytes[pos++] = registryKeySize;
				strcpy((char*)&bytes[pos], regKey->key);
				pos += registryKeySize;
			/*}
			catch (...) {
				char ex[250];
				sprintf(ex, "Exception in copying key in Read Keys Method\r\n"
					"RegKey=%s, pos=%d"
					"\r\n", regKey->key, pos);
				Log(ex);

				return STATUS_FAILED;
			}*/

			//cout << "Requesting Key (" << regKey->uniqueId << ") " << regKey->key << endl;
		}
		
		if (keyCount == 0) return STATUS_OK;

		// number of keys
		hton(bytes[1], keyCount);

		if (validKey) {
			if (Send(bytes, pos) == STATUS_FAILED) 
				return STATUS_FAILED;

			//delete [] bytes;

			bool stillWaiting = false;
			m_cancel = false;
			do {
				stillWaiting = false;
				for (int i = 0; i < size; i++) {
					if (keys[i] == NULL || keys[i]->key == NULL) {
						continue;
					}

					RegistryKey* regKey = m_registry->GetKey(keys[i]->key);
					if (waitForResponse && regKey->readReceived == false) {
						stillWaiting = true;
						//printf("still waiting...\n");
						break;
					}
				}

				Sleep(100);
			} while (stillWaiting && !this->m_cancel);
		}

	/*}
	catch (...) {
		char ex[100];
		sprintf(ex, "Exception in Read Keys Method\r\n"
			"NumberOfKeys=%d, pos=%d"
			"\r\n", size, pos);
		Log(ex);

		return STATUS_FAILED;
	}*/

		if (m_cancel) {
		return Status(STATUS_CANCELLED);
	}

	return STATUS_OK;
}

int CJnior::WriteRegistryKeys(RegistryKey** keys, short count, bool waitForResponse)
{
	cout << "Login Status: " << m_loginStatus << endl;

	if (m_loginStatus == STATUS_NOT_LOGGED_IN) {
		Status(STATUS_NOT_LOGGED_IN);
		return -1;
	} else if (m_loginStatus != STATUS_LOGGED_IN_ADMIN) {
		Status(STATUS_LOGIN_INCORRECT_LEVEL);
		return -1;
	}

	char* bytes = new char[500];
	int pos = 0;

	//try {
		bytes[pos++] = WRITE_REG_KEYS;

		short keyCount = 0;
		pos += 2;

		// for each key we assign a unique id and send the key string
		for (int i = 0; i < count; i++) {
			RegistryKey* regKey = m_registry->GetKey(keys[i]->key);
			
			regKey->SetValue(keys[i]->value);


			if (regKey->RESERVED) {
				char* lastSlash = strrchr(regKey->key, '/');
				int pos = lastSlash - regKey->key;
				//printf ("Last occurence of '/' found at %d \n", pos);

				int channel = regKey->key[pos - 1] - '0';

				if (strcmp((const char*)(&lastSlash[1]), "State") == 0) {
					this->SetOutput(channel, atoi (regKey->value));
				}

				continue;
			}

			keyCount++;
			regKey->writeReceived = false;

			//printf("WriteRegistryKeys   %s ?= %s\n", regKey->toString(), keys[i]->toString());

			int registryKeySize = strlen(keys[i]->key);
			int registryValueSize = strlen(keys[i]->value);
			int size = registryKeySize + registryValueSize + 7;

			bytes[pos++] = registryKeySize;
			strcpy((char*)&bytes[pos], regKey->key);
			pos += registryKeySize;

			bytes[pos++] = registryValueSize;
			strcpy((char*)&bytes[pos], regKey->value);
			pos += registryValueSize;

			//printf("Writing Key %s\n", regKey->toString());


			// perform the callback on the individual registry keys if there are 
			// callbacks assigned
			if (regKey->m_registryKeyListeners.size() > 0) {
				REGISTRY_KEY** regKeys = new REGISTRY_KEY*[1];
				regKeys[0] = m_registry->ToStructure(regKey);

				REGISTRY_CALLBACK_ARGS* args = new REGISTRY_CALLBACK_ARGS;
				args->handle = this->m_handle;
				args->keys = regKeys;
				args->count = 1;

				CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
				wrapper->listeners.assign(regKey->m_registryKeyListeners.begin(), regKey->m_registryKeyListeners.end());
				wrapper->args = args;

				HANDLE hThread = CreateThread(
							NULL,										// default security attributes 
							0,											// use default stack size  
							(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
							wrapper,									// argument to thread function 
							0,											// use default creation flags 
							&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
			}
		}
		
		if (keyCount == 0) return STATUS_OK;

		// number of keys
		hton(bytes[1], keyCount);

		Status(STATUS_REGISTRY_WRITING);

		if (Send(bytes, pos) == STATUS_FAILED) 
			return STATUS_FAILED;

		m_writtenKeys += count;
		m_cancel = false;
		do {
			Sleep(100);
		} while (waitForResponse && m_writtenKeys > 0 && !this->m_cancel);

		if (m_cancel) {
			return Status(STATUS_CANCELLED);
		}

		if (m_writtenKeys == 0) {
			Status(STATUS_REGISTRY_WRITE_RECEIVED);
		}
	/*}
	catch (...) {
		char ex[100];
		sprintf(ex, "Exception in Write Keys Method\r\n"
			"NumberOfKeys=%d, pos=%d"
			"\r\n", size, pos);
		Log(ex);

		return Error(STATUS_FAILED);
	}*/

	return STATUS_OK;
}

int CJnior::SubscribeRegistryKeys(RegistryKey** keys, short count, char* defaultValue, bool waitForResponse)
{
	char* bytes = new char[500];
	int pos = 0;

	//try {
		bytes[pos++] = SUBSCRIBE_REG_KEYS;

		short keyCount = 0;
		pos += 2;

		// for each key we assign a unique id and send the key string
		for (int i = 0; i < count; i++) {
			RegistryKey* regKey = m_registry->GetKey(keys[i]->key);
			regKey->subscribed = true;

			if (regKey->RESERVED) continue;

			// set the value of the key to be the default value supplied
			regKey->SetValue(defaultValue);

			keyCount++;
			regKey->readReceived = false;

			int registryKeySize = strlen(keys[i]->key);
			int size = registryKeySize + 6;

			setshort(bytes, pos, regKey->uniqueId);
			
			bytes[pos++] = registryKeySize;
			strcpy((char*)&bytes[pos], regKey->key);
			pos += registryKeySize;

			//printf("Requesting Key (%d) %s\n", regKey->uniqueId, regKey->key);
		}
		
		if (keyCount == 0) return STATUS_OK;

		// number of keys
		hton(bytes[1], keyCount);

		if (Send(bytes, pos) == STATUS_FAILED) 
			return STATUS_FAILED;

		bool stillWaiting = false;
		do {
			stillWaiting = false;
			for (int i = 0; i < count; i++) {
				RegistryKey* regKey = m_registry->GetKey(keys[i]->key);
				if (waitForResponse && regKey->readReceived == false) {
					stillWaiting = true;
					//printf("still waiting...");
					break;
				}
			}

			Sleep(100);
		} while (stillWaiting && !this->m_cancel);
	/*}
	catch (...) {
		char ex[100];
		sprintf(ex, "Exception in Write Keys Method\r\n"
			"NumberOfKeys=%d, pos=%d"
			"\r\n", size, pos);
		Log(ex);

		return Error(STATUS_FAILED);
	}*/

	return STATUS_OK;
}

int CJnior::ListRegistryAsync (char* path) {
	// set the current listing request se we know what string to return in 
	// the callback
	int pathLen = strlen(path);
	m_currentListingRequest = new char[pathLen + 1];
	strncpy(this->m_currentListingRequest, path, pathLen);
	this->m_currentListingRequest[pathLen] = '\0';
	
	char* bytes = new char[500];
	int pos = 0;

	bytes[pos++] = LIST_REG_KEYS;

	bytes[pos++] = strlen(path);
	strcpy((char*)&bytes[pos], path);
	pos += strlen(path);

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;

	return STATUS_OK;
}

int CJnior::AddRegistryKeyCallback(RegistryKey** keys, int count, CALLBACKNOTIFY lProcAddress) {
	for (int i = 0; i < count; i++) {
		RegistryKey* regKey = m_registry->GetKey(keys[i]->key);
		regKey->AddRegistryKeyCallback(lProcAddress);
	}

	return STATUS_OK;
}
/*********************** REGISTRY FUNCTIONS **********************************/



int CJnior::ReadDevices(long long deviceIds[], int size, bool subscribe) {
	char* bytes = new char[3 + 8 * size];
	int pos = 0;

	if (!subscribe) {
		bytes[pos++] = READ_DEVICES;
	} else {
		bytes[pos++] = SUBSCRIBE_DEVICES;
	}

	setshort(bytes, pos, size);

	for (int i = 0; i < size; i++) {
		setlong(bytes, pos, deviceIds[i]);
	}

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;

	//while (block && loginStatus == STATUS_NOT_LOGGED_IN) {
	//	Sleep(100);
	//}

	delete [] bytes;

	return STATUS_OK;
}

int CJnior::SubscribeDevices(long long deviceIds[], int size) {
	return ReadDevices(deviceIds, size, true);
}



int CJnior::CustomCommand(char* commandName, char commandType, short payloadSize, char* payload)
{
	char* bytes = new char[2 + strlen(commandName) + 1 + 2 + payloadSize];
	int pos = 0;

	bytes[pos++] = CUSTOM_COMMAND;
	bytes[pos++] = strlen(commandName);
	memcpy((char*)&bytes[pos], commandName, strlen(commandName));
	pos += strlen(commandName);
	bytes[pos++] = commandType;
	setshort(bytes, pos, payloadSize);

	//for (int i = 0; i < payloadSize; i++) {
	//	bytes[pos++] = payload[i];
	//}
	memcpy((char*)&bytes[pos], payload, payloadSize);
	pos += payloadSize;

	if (Send(bytes, pos) == STATUS_FAILED) 
		return STATUS_FAILED;


	delete [] bytes;

	return STATUS_OK;
}



//void CJnior::Log(char* text) {
//	m_mutex.MutexOn();
//	if (m_dumpFileName != NULL) {
//		FILE* file = NULL;
//		int tries = 100;
//		while (file == NULL) {
//			file = fopen(m_dumpFileName, "a");
//			if (--tries == 0) {
//				return;
//			}
//		}
//
//		// create the timestamp
//		char timestamp[32];
//		SYSTEMTIME lt;
//		GetLocalTime(&lt);
//		sprintf(timestamp, "%02d:%02d:%02d.%03d", lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);
//		fprintf(file, "%s   %s\r\n", timestamp, text);
//		fclose(file);
//	}
//#if DEBUG
//	cout << text << endl;
//#endif
//	m_mutex.MutexOff();
//}

Mutex hexDumpMutex;

void CJnior::hexdump(void *pAddressIn, long lSize, char direction)
{
	synchronized(hexDumpMutex)
	{
		 char szBuf[100];
		 long lIndent = 12;
		 long lOutLen, lIndex, lIndex2, lOutLen2;
		 long lRelPos;
		 struct { char *pData; unsigned long lSize; } buf;
		 unsigned char *pTmp,ucTmp;
		 unsigned char *pAddress = (unsigned char *)pAddressIn;

		   buf.pData   = (char *)pAddress;
		   buf.lSize   = lSize;

   			//mutex.MutexOn();

			  //FILE* file = fopen(dumpFileName, "a");
		//	  char timeStr [9];
		//			_strtime( timeStr );
		   //   fprintf(file, "%s\n", timeStr);
			  //fclose(file);
		//	Log(timeStr);

			while (buf.lSize > 0)
		   {
			  pTmp     = (unsigned char *)buf.pData;
			  lOutLen  = (int)buf.lSize;
			  if (lOutLen > 16)
				  lOutLen = 16;

			  // create a 64-character formatted output line:
			  sprintf(szBuf, "%c %08lX :                             "
							 "                      "
							 "   ", direction, pTmp-pAddress);
			  lOutLen2 = lOutLen;

			  for(lIndex = 1+lIndent, lIndex2 = 53-15+lIndent, lRelPos = 0;
				  lOutLen2;
				  lOutLen2--, lIndex += 2, lIndex2++
				 )
			  {
				 ucTmp = *pTmp++;

				 sprintf(szBuf + lIndex, "%02X ", (unsigned short)ucTmp);
				 if(!isprint(ucTmp))  ucTmp = '.'; // nonprintable char
				 szBuf[lIndex2] = ucTmp;

				 if (!(++lRelPos & 7))     // extra blank after 4 bytes
				 {  lIndex++; szBuf[lIndex+2] = ' '; }
			  }

			  if (!(lRelPos & 7)) lIndex--;

			  szBuf[lIndex  ]   = ' ';
			  szBuf[lIndex+1]   = ' ';

			  //file = fopen(dumpFileName, "a");
		   //   fprintf(file, "%s\n", szBuf);
			  //fclose(file);
			  Logger(this->m_dumpFileName, szBuf);

			  buf.pData   += lOutLen;
			  buf.lSize   -= lOutLen;
		   }

			  //file = fopen(dumpFileName, "a");
		   //   fprintf(file, "\n");
			  //fclose(file);
			Logger(this->m_dumpFileName, "");

			//mutex.MutexOff();
	}
}


int CJnior::Send(char* bytes, int size)
{
	char* sendBytes = new char[size + 5];
	int pos = 0;

	sendBytes[pos++] = 0x01;
	setshort(sendBytes, pos, size);

	short crc = 0xffff;
	if (USE_CRC) {
		crc = crc16_update( 0, bytes, size );
	}
	setshort(sendBytes, pos, crc);

	memcpy((char*)&sendBytes[pos], bytes, size);

	// initialize a socket set.
	fd_set fds;
	FD_ZERO(&fds);
	FD_SET(m_sckt, &fds);

	timeval timeout;
	timeout.tv_sec = 0;
	timeout.tv_usec = SEND_RECV_TIMEOUT;

	int isWritable = select(0, NULL, &fds, NULL, &timeout);
	//if (isWritable != 1) printf("write select: %d\r\n", isWritable);

	int bytesSent = 0;
	
	if (isWritable == SOCKET_ERROR || isWritable == 0 ) {
		return Error("CJnior::Send", WSAGetLastError());

		Status(STATUS_FAILED);

		// try to reconnect
		Reconnect();
	}
			
	// data is ready to be written to the socket
	else if (isWritable > 0) {
		bytesSent = send(m_sckt, sendBytes, size + 5, 0);

		if (bytesSent > 0) {
			//char timeStr [9];
			//_strtime( timeStr );
			//printf("%s  sent %d bytes\r\n", timeStr, bytesSent);

#if DEBUG
			if (m_dumpFileName != NULL) {
				hexdump(sendBytes, size + 5, '<');
			}
#endif

			if (this->m_communicationListeners.size() > 0 && bytesSent > 0) {
				COMMUNICATIONS_CALLBACK_ARGS* args = new COMMUNICATIONS_CALLBACK_ARGS;
				args->handle = this->m_handle;
				args->count = bytesSent;
				args->direction = 1;
				args->bytes = new char[bytesSent];
				memcpy(args->bytes, sendBytes, bytesSent);

				CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
				wrapper->listeners.assign(this->m_communicationListeners.begin(), this->m_communicationListeners.end());
				wrapper->args = args;

				////while (dwWrapperThreadId != -1);

				HANDLE hThread = CreateThread(
							NULL,										// default security attributes 
							0,											// use default stack size  
							(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
							wrapper,									// argument to thread function 
							0,											// use default creation flags 
							&m_dwCommunicationsWrapperThreadId);								// returns the thread identifier 
			}

			m_lastSentTime = time(0);
		} 

		// send failed
		else {
			Error("CJnior::Send", WSAGetLastError());

			Status(STATUS_FAILED);

			// try to reconnect
			Reconnect();

			// continute reading
			return STATUS_FAILED;
		}

		m_lastSentTime = time(0);
	}

	delete [] sendBytes;

	return (bytesSent > 0) ? STATUS_OK : STATUS_FAILED;
}


DWORD WINAPI CallbackWrapper ( LPVOID *lparam ) {
	CALLBACK_WRAPPER* wrapper = (CALLBACK_WRAPPER*)lparam;
	vector<CALLBACKNOTIFY> listeners = (vector<CALLBACKNOTIFY>)wrapper->listeners;

	for (int i=0; i < listeners.size(); i++) {	
		if (listeners[i] != NULL) {
			listeners[i]( wrapper->args );
		}
	}
	
	m_dwStatusWrapperThreadId = -1;

	return 0;
}

//DWORD WINAPI StatusCallbackWrapper ( LPVOID *lparam ) {
//	STATUS_CALLBACK_WRAPPER* wrapper = (STATUS_CALLBACK_WRAPPER*)lparam;
//	CJnior* jnior = (CJnior*)wrapper->jnior;
//
//	for (int i=0; i < jnior->m_statusListeners.size(); i++) {	
//		cout << jnior->m_statusListeners[i] << " " << wrapper->status << endl;
//		if (jnior->m_statusListeners[i] != NULL) {
//			jnior->m_statusListeners[i]( wrapper->status );
//		}
//	}
//	
//	m_dwStatusWrapperThreadId = -1;
//
//	return 0;
//}

int CJnior::ConnectionStatus(int status) {
	this->m_connectionStatus = Status(status);
	
	if (m_connectParams != NULL) {
		this->m_connectParams->status = m_connectionStatus;
		this->m_connectParams->message = GetStatusDescription(status);
	}

	char log[128];
	sprintf(log, "Connection Status - message: %03d %s\0", status, GetStatusDescription(status));
	Logger(this->m_dumpFileName, log);

	if (m_connectionListeners.size() > 0) {
		STATUS_CALLBACK_ARGS* args = new STATUS_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->status = status;
		args->message = GetStatusDescription(args->status);

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_connectionListeners.begin(), this->m_connectionListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper, //StatusCallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwStatusWrapperThreadId);								// returns the thread identifier 
	}

	return this->m_connectionStatus;
}

int CJnior::Status(int status) {
	//try {
		//char timeStr[9];
		//_strtime( timeStr );
		//char text[100];
		//sprintf(text, "%s  Status: %d %s", timeStr, status, GetStatusDescription(status));
		//printf("%s\r\n", text);
		//Log(text);

	//char log[128];
	//sprintf(log, "Status - message: %03d %s\0", status, GetStatusDescription(status));
	//Logger(this->m_dumpFileName, log);

	if (m_statusListeners.size() > 0) {
		STATUS_CALLBACK_ARGS* args = new STATUS_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->status = status;
		args->message = GetStatusDescription(args->status);

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_statusListeners.begin(), this->m_statusListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper, //StatusCallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwStatusWrapperThreadId);								// returns the thread identifier 
	}

	/*} catch (...) {
		Log("Exception in Status\r\n");
	}*/

	// this will be our callback wrapper soon
	return status;
}


void CJnior::AddStatusCallback(CALLBACKNOTIFY lProcAddress)
{
	// make sure the callback doesnt already exist
	if (m_statusListeners.size() > 0) {
		vector<CALLBACKNOTIFY>::iterator it = m_statusListeners.begin();
		while( it != m_statusListeners.end() ) {
			if (*it == lProcAddress) {
				return;
			}
			++it;
		}
	}	

	m_statusListeners.push_back(lProcAddress);
}

void CJnior::RemoveStatusCallback(CALLBACKNOTIFY lProcAddress)
{
	if (m_statusListeners.size() > 0) {
		vector<CALLBACKNOTIFY>::iterator it = m_statusListeners.begin();
		while( it != m_statusListeners.end() ) {
			if (*it == lProcAddress) {
				m_statusListeners.erase(it);
				break;
			}
			++it;
		}
	}
}

void CJnior::AddMonitorCallback(CALLBACKNOTIFY lProcAddress) 
{
		this->m_monitorListeners.push_back(lProcAddress);
}

void CJnior::AddConnectionCallback(CALLBACKNOTIFY lProcAddress) 
{
	int size = this->m_connectionListeners.size();

	this->m_connectionListeners.push_back(lProcAddress);

	// alert the new callbacks of the current state
	if (m_connectionListeners.size() > 0) {
		STATUS_CALLBACK_ARGS* args = new STATUS_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->status = this->m_connectionStatus;
		args->message = GetStatusDescription(args->status);

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_connectionListeners.begin() + size, this->m_connectionListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper, //StatusCallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwStatusWrapperThreadId);								// returns the thread identifier 
	}
}

void CJnior::AddLoginCallback(CALLBACKNOTIFY lProcAddress) 
{
	int size = this->m_loginListeners.size();

	this->m_loginListeners.push_back(lProcAddress);

	// alert the new callbacks of the current state
	if (m_loginListeners.size() > 0) {
		STATUS_CALLBACK_ARGS* args = new STATUS_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->status = this->m_loginStatus;
		args->message = GetStatusDescription(args->status);

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_loginListeners.begin() + size, this->m_loginListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper, //StatusCallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwStatusWrapperThreadId);								// returns the thread identifier 
	}
}

void CJnior::AddCustomCommandCallback(CALLBACKNOTIFY lProcAddress)
{
	this->m_customCommandListeners.push_back(lProcAddress);
}


//DWORD WINAPI RegistryCallbackWrapper ( LPVOID *lparam ) {
//	REGISTRY_CALLBACK_WRAPPER* wrapper = (REGISTRY_CALLBACK_WRAPPER*)lparam;
//	CJnior* jnior = (CJnior*)wrapper->jnior;
//	if (jnior->m_RegistryCallback != NULL) {
//		jnior->m_RegistryCallback( wrapper->keys, wrapper->count );
//	}
//	
//	m_dwRegistryWrapperThreadId = -1;
//
//	return 0;
//}

void CJnior::AddRegistryCallback(CALLBACKNOTIFY lProcAddress)
{
	this->m_registryListeners.push_back(lProcAddress);
}

void CJnior::AddRegistryListingCallback(CALLBACKNOTIFY lProcAddress) 
{
	this->m_registryListingListeners.push_back(lProcAddress);
}


//DWORD WINAPI CommunicationsCallbackWrapper ( LPVOID *lparam ) {
//	COMMUNICATIONS_CALLBACK_WRAPPER* wrapper = (COMMUNICATIONS_CALLBACK_WRAPPER*)lparam;
//	CJnior* jnior = (CJnior*)wrapper->jnior;
//	if (jnior->m_communicationsCallback != NULL) {
//		jnior->m_communicationsCallback( wrapper->bytes, wrapper->count, wrapper->direction );
//	}
//	
////	delete [] wrapper->bytes;
//
//	m_dwCommunicationsWrapperThreadId = -1;
//
//	return 0;
//}

void CJnior::AddCommunicationsCallback(CALLBACKNOTIFY lProcAddress)
{
	this->m_communicationListeners.push_back(lProcAddress);
}


//void CJnior::AddDebugCallback(CALLBACKNOTIFY lProcAddress)
//{
//	if (m_hPrintfThread == NULL) {
//		m_hPrintfThread = CreateThread(
//			NULL,										// default security attributes 
//			0,											// use default stack size  
//			(LPTHREAD_START_ROUTINE) this->PrintfRedirectThd,	// thread function 
//			this,										// argument to thread function 
//			0,											// use default creation flags 
//			&m_dwPrintfThreadId);								// returns the thread identifier 
//		SetStdHandle(STD_OUTPUT_HANDLE, m_hPrintfThread);
//		this->m_DebugCallback = lProcAddress;
//	}
//}

int CJnior::Error(char* source, int err)
{
	char log[128];
	sprintf(log, "ERR: %d %s\r\n", err, source);
	Logger(this->m_dumpFileName, log);

	Status(STATUS_FAILED);

	// this will be our callback wrapper soon
	return err;
}

int CJnior::SetDumpFile(char* filename) {
	m_dumpFileName = new char[strlen(filename) + 1];
	strcpy(m_dumpFileName, filename);

	Logger(filename, "**********************************************************************");

	return 0;
}

//////////////////////// DEBUG PRINTF /////////////////////////////////////////
DWORD WINAPI CJnior::PrintfRedirectThd ( LPVOID *lparam )
{
	// This is the owned of the thread
	CJnior* jnior = (CJnior*) lparam;

//	jnior->m_DebugCallback("hi\r\n");

	return 0;
}

bool CJnior::SendHeartbeat(CJnior* jnior) {
	Logger(jnior->m_dumpFileName, "Send Heartbeat");

	char ack = (char)0x06;

	fd_set fds;
	FD_ZERO(&fds);
	FD_SET(jnior->m_sckt, &fds);

	timeval timeout;
	timeout.tv_sec = 0;
	timeout.tv_usec = 100;

	if (time(0) - jnior->m_lastSentTime >= (SEND_RECV_TIMEOUT / 1000)) {

		FD_ZERO(&fds);
		FD_SET(jnior->m_sckt, &fds);

		timeout.tv_usec = 1000;

		int isWritable = select(0, NULL, &fds, NULL, &timeout);
		//if (isWritable != 1) printf("keep-alive write select: %d\r\n", isWritable);

		int bytesSent;
		
		if (isWritable == SOCKET_ERROR || isWritable == 0) {
			jnior->Error("CJnior::SendHeartbest", SOCKET_NOT_WRITABLE);

			jnior->Status(STATUS_FAILED);

			// try to reconnect
			jnior->Reconnect();
		}
				
		// data is ready to be writen to the socket
		else if (isWritable > 0) {
			int bytesSent = send(jnior->m_sckt, &ack, 1, 0);

			//char timeStr [9];
			//_strtime( timeStr );
			//printf("%s  sent %d bytes\r\n", timeStr, bytesSent);

			if (bytesSent > 0) {
#if DEBUG
				Logger(jnior->m_dumpFileName, "Sent Heartbeat");
#endif
				jnior->m_lastSentTime = time(0);
			} 
			
			// ack failed
			else {
				if (!jnior->m_rebooting) {
					jnior->Error("CJnior::SendHeartbeat", ACK_FAILED);
					jnior->Status(STATUS_FAILED);
				}

				// try to reconnect
				jnior->Reconnect();
			}
		}

	} // should we send the keep alive

	return true;
}





/******************************************************************************
************************ RECEIVE **********************************************
******************************************************************************/
void CJnior::DataReady() {
	char log[128];

	//char txt[100];
	//sprintf(txt, "PREREAD : nextReadPos=%d, m_pos=%d", m_nextReadPos, m_pos);
	//Log(txt);

#if DEBUG
	char s[100];
	sprintf(s, "Data Ready");
	Logger(this->m_dumpFileName, s);
#endif

	int bytesRecv = recv( m_sckt, &m_recvbuf[m_nextReadPos], 0xffff - m_nextReadPos, 0 );
	// nothing was read
	if (bytesRecv == SOCKET_ERROR) {
		int error = WSAGetLastError();
		return;
	}

	// call the communications callback wrapper incase someone is listening
	if (this->m_communicationListeners.size() > 0 && bytesRecv > 0) {
				COMMUNICATIONS_CALLBACK_ARGS* args = new COMMUNICATIONS_CALLBACK_ARGS;
				args->handle = this->m_handle;
				args->bytes = new char[bytesRecv];
				memcpy(args->bytes, &m_recvbuf[m_nextReadPos], bytesRecv);
				args->count = bytesRecv;
				args->direction = -1;

				CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
				wrapper->listeners.assign(this->m_communicationListeners.begin(), this->m_communicationListeners.end());
				wrapper->args = args;

				//while (dwWrapperThreadId != -1);

				//this->hexdump(&m_recvbuf[m_nextReadPos], bytesRecv, -1);

				HANDLE hThread = CreateThread(
							NULL,										// default security attributes 
							0,											// use default stack size  
							(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
							wrapper,									// argument to thread function 
							0,											// use default creation flags 
							&m_dwCommunicationsWrapperThreadId);								// returns the thread identifier 
	}


	if (bytesRecv > 0) {
		m_nextReadPos += bytesRecv;
	}

#if DEBUG
	sprintf(s, "read %d bytes\r\n", bytesRecv);
	Logger(this->m_dumpFileName, s);
	if (bytesRecv > 0) {
		if (m_dumpFileName != NULL) {
			hexdump(&m_recvbuf[0], m_nextReadPos, '>');
		}
	}
#endif

	// hmm if the WSAWaitForMultipleEvents passed through then 
	// there is either a read or close event.  If there is no data 
	// read then it must have been a close event?
	if ( bytesRecv <= 0 ) {
		Error("CJnior::DataReady", WSAGetLastError());

		// try to reconnect
		Reconnect();

		// continute reading
		return;
	} // bytesrecv = -1

	else if (m_nextReadPos > m_pos) {
		int available;
		while (m_nextReadPos > m_pos) {
			
			Sleep(10);

			if (this->m_quit) {
				m_nextReadPos = m_pos = 0;
				m_recvState = WAIT_SYNC_BYTE;
				break;
			}
		
#if DEBUG
			char txt[100];
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

			//if (m_dumpFileName != NULL) {
			//	hexdump(&m_recvbuf[0], m_nextReadPos, '>');
			//}

			// we only wait 15 seconds for the data payload to come in before we 
			// reset the receive state
		/////*	if (m_recvState != WAIT_SYNC_BYTE && m_recvHeader.SYNC_RECV_TIME + 15 < time(0)) {
		////		m_recvState = WAIT_SYNC_BYTE;
		////	}*/

			switch (m_recvState) {
				case WAIT_SYNC_BYTE:
					m_recvHeader.OFFSET = m_pos;
					if ( (m_recvHeader.SYNC_BYTE = m_recvbuf[m_pos++]) == 0x01 ) {
						m_recvState++;
						m_recvHeader.SYNC_RECV_TIME = time(0);
					}
					m_recvHeader.PAYLOAD_LENGTH = 0;

#if DEBUG
					sprintf(log, "SYNC BYTE? (%d)", m_recvHeader.SYNC_BYTE);
					Logger(this->m_dumpFileName, log);
#endif

					// if we never find the sync byte but weve read all of the 
					// bytes then we should reset the buffer array
					if (m_pos == m_nextReadPos) {
						m_nextReadPos = 0;
						m_pos = 0;
					}

					//printf("SYNC BYTE=%d\n", m_recvHeader.SYNC_BYTE);

					break;

				case WAIT_LENGTH_HI:
					m_recvHeader.LENGTH_HI = m_recvbuf[m_pos++] & 0xff;
					m_recvState++;

					//printf("LENGTH_HI=%d\n", m_recvHeader.LENGTH_HI);

					break;

				case WAIT_LENGTH_LO:
					m_recvHeader.LENGTH_LO = m_recvbuf[m_pos++] & 0xff;
					m_recvState++;

					//printf("LENGTH_LO=%d\n", m_recvHeader.LENGTH_LO);

					break;

				case WAIT_CRC_HI:
					m_recvHeader.CRC_HI = m_recvbuf[m_pos++] & 0xff;
					m_recvState++;

					//printf("CRC_HI=%d\n", m_recvHeader.CRC_HI);

					break;

				case WAIT_CRC_LO:
					m_recvHeader.CRC_LO = m_recvbuf[m_pos++] & 0xff;
					m_recvState++;

					//printf("CRC_LO=%d\n", m_recvHeader.CRC_LO);

					break;

				case WAIT_PAYLOAD:
					available = m_nextReadPos - m_pos;

					//char str[100];
					//sprintf(str, "offset=%d, payload length=%d, avail=%d, bytes recv=%d, m_pos=%d\n", 
					//	m_recvHeader.OFFSET, m_recvHeader.LENGTH_HI << 8 + m_recvHeader.LENGTH_LO, available, bytesRecv, m_pos);

					//Log("Wait Payload");
					//Log(str);
					//printf(str);

					//hexdump(&m_recvbuf[0], m_pos + m_recvHeader.LENGTH_HI << 8 + m_recvHeader.LENGTH_LO, '>');

					if (available >= (m_recvHeader.LENGTH_HI << 8 + m_recvHeader.LENGTH_LO) & 0xffff) {
						m_recvHeader.PAYLOAD_LENGTH = (m_recvHeader.LENGTH_HI << 8 + m_recvHeader.LENGTH_LO) & 0xffff;
						memcpy(&(m_recvHeader.PAYLOAD)[m_recvHeader.PAYLOAD_LENGTH], &m_recvbuf[m_pos], available);
						m_recvState++;
						break;
					}

					else {
						m_recvHeader.PAYLOAD_LENGTH += available;
					}

					break;

				case PAYLOAD_READY:
					{
						// here we would check the CRC and back the offset up to try again.
						int length = (m_recvHeader.LENGTH_HI << 8) + m_recvHeader.LENGTH_LO;
						unsigned short crc = crc16_update( 0, &m_recvbuf[m_pos], length );
						unsigned short jniorCrc = (m_recvHeader.CRC_HI << 8) + m_recvHeader.CRC_LO;

						if (crc != jniorCrc) {
							// INVALID CRC
							m_pos = m_recvHeader.OFFSET + 1;
							m_recvState = WAIT_SYNC_BYTE;

							sprintf(log, "Invalid CRC %d, should be %d", jniorCrc, crc);
							Logger(this->m_dumpFileName, log);

							continue;
						}

						//char str[100];
						//sprintf(str, "offset=%d, payload length=%d, avail=%d, bytes recv=%d, m_pos=%d\n", 
						//	m_recvHeader.OFFSET, m_recvHeader.LENGTH_HI << 8 + m_recvHeader.LENGTH_LO, available, bytesRecv, m_pos);

						//Log("Payload Ready");
						//Log(str);
						//printf(str);

						/*if (dumpFileName != NULL) {
							hexdump(&m_recvbuf[0], nextReadPos, '>');
						}*/

						int messageType = (int)(m_recvbuf[m_pos++] & 0xff);
						PacketReceived(messageType, m_recvHeader);
						Status(PACKET_RECEIVED_START + messageType);

						m_recvState = WAIT_SYNC_BYTE;
						
						if (m_pos == m_nextReadPos) {
							m_nextReadPos = 0;
							m_pos = 0;
						}

						break;
					}

			} // switch

		} // while m_pos < bytesRecv
	}

}


void CJnior::PacketReceived(int messageType, HEADER recvHeader) {
	int length = (recvHeader.LENGTH_HI << 8) + recvHeader.LENGTH_LO;

	char log[128];
	sprintf(log, "Message Type=%d Length=%d", messageType, length);
	Logger(this->m_dumpFileName, log);

	switch ((int)messageType) {
		case MONITOR_PACKET:
			ProcessMonitorPacket();
			break;

		case EXT_MONITOR_PACKET:
			ProcessExternalMonitorPacket();
			break;

		case DATE_TIME_PACKET:
			// Read the time
			time_t t;
			this->m_monitor.jniorTime = getlong(m_recvbuf, m_pos);
			this->m_timePacketRecvTime = clock();
			break;

		case USAGE_METER_PACKET:
			ProcessUsageMeterPacket();
			break;

		case READ_REG_KEYS_RESPONSE:
			ProcessReadRegistryKeysResponse();
			break;

		case WRITE_REG_KEYS_RESPONSE:
			{
				// get the number of keys returned
				int count = getshort(m_recvbuf, m_pos);

				m_writtenKeys -= count;

				printf("Sucessfully wrote %d key(s)\n", count);
			}

			break;

		case LIST_REG_KEYS_RESPONSE:
			{
				// get the number of keys returned
				int count = getshort(m_recvbuf, m_pos);

				// create a new array or strings to hold the listing
				char** keyNames = new char*[count];

				// get each key
				for (int i = 0; i < count; i++) {
					// get the string length
					int keyNameLength = m_recvbuf[m_pos++] & 0xff;
					// create a char array to hold the string
					keyNames[i] = new char[keyNameLength + 1];
					// copy the key over
					strncpy(keyNames[i], &m_recvbuf[m_pos], keyNameLength);
					keyNames[i][keyNameLength] = '\0';
					m_pos += keyNameLength;
				}

				if (this->m_registryListingListeners.size() > 0) {
					//m_RegistryCallback(regKeys, count);

					REGISTRY_LISTING_CALLBACK_ARGS* args = new REGISTRY_LISTING_CALLBACK_ARGS;
					args->handle = this->m_handle;
					args->count = count;
					args->path = this->m_currentListingRequest;
					args->keyNames = new char*[count];
					for (int i = 0; i < count; i++) {
						int keyNameLength = strlen(keyNames[i]);
						// create a char array to hold the string
						args->keyNames[i] = new char[keyNameLength + 1];
						// copy the key over
						strncpy(args->keyNames[i], keyNames[i], keyNameLength);
						args->keyNames[i][keyNameLength] = '\0';
					}

					CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
					wrapper->listeners.assign(this->m_registryListingListeners.begin(), this->m_registryListingListeners.end());
					wrapper->args = args;

					//while (dwWrapperThreadId != -1);

					HANDLE hThread = CreateThread(
								NULL,										// default security attributes 
								0,											// use default stack size  
								(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
								wrapper,									// argument to thread function 
								0,											// use default creation flags 
								&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
				}

				break;
			}

		case READ_DEVICE_RESPONSE:
			{
				int count = getshort(m_recvbuf, m_pos);

				for (int i = 0; i < count; i++) {
					long long deviceId = getlong(m_recvbuf, m_pos);
					int length = getshort(m_recvbuf, m_pos);


					CDevice* device = m_devices[deviceId];
					if (device == NULL) {
						if ((deviceId & 0xff) == DEVICE_TYPE_ENUM::FOUR_RELAY_OUT) {
							device = new CTypeFB();
						}
						if (device != NULL) {
							m_devices[deviceId] = device;
						}
					}

					device->Parse(m_recvbuf, m_pos);
				}

				break;
			}

		case GET_EXTERNAL_VALUE_RESPONSE:
			{
				char deviceType = m_recvbuf[m_pos++];
				char ioSelection = m_recvbuf[m_pos++];
				char channelNumber = m_recvbuf[m_pos++];
				double value = getdouble(m_recvbuf, m_pos);

				short externalModuleValueKey = (deviceType << 8) + (ioSelection << 4) + channelNumber;
				m_externalModuleValues[externalModuleValueKey] = value;

				break;
			}

		case LOGIN_ACK:
			ProcessLoginResponse();

			break;

		case CUSTOM_COMMAND_RESPONSE:
			{
				char returnStatus = m_recvbuf[m_pos++];
				short payloadSize = getshort(m_recvbuf, m_pos);
				if (payloadSize > 0) {
					char* payload = new char[payloadSize + 1];
					for (int i = 0; i < payloadSize; i++) {
						payload[i] = m_recvbuf[m_pos++];
					}

					if (this->m_customCommandListeners.size() > 0) {
						CUSTOM_COMMAND_CALLBACK_ARGS* args = new CUSTOM_COMMAND_CALLBACK_ARGS;
						args->handle = this->m_handle;
						args->returnStatus = returnStatus;
						args->size = payloadSize;
						args->payload = payload;

						CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
						wrapper->listeners.assign(this->m_customCommandListeners.begin(), this->m_customCommandListeners.end());
						wrapper->args = args;

						//while (dwWrapperThreadId != -1);

						HANDLE hThread = CreateThread(
									NULL,										// default security attributes 
									0,											// use default stack size  
									(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
									wrapper,									// argument to thread function 
									0,											// use default creation flags 
									&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
					}
					//memcpy(payload, (char*)m_recvbuf[m_pos], payloadSize);
				}

				break;
			}

		default:
			m_pos += length;

			break;
	}
}

void CJnior::ProcessMonitorPacket()
{
	// Read and assign the model and software version
	int valLength = m_recvbuf[m_pos++] & 0xff;
	char* regVal = new char[valLength + 1];
	strncpy(regVal, &m_recvbuf[m_pos], valLength);
	regVal[valLength] = '\0';
	m_pos += valLength;

	// find the space
	int space = 0;
	for (; space < valLength; space++) {
		if (regVal[space] == ' ') {
			regVal[space] = '\0';
			break;
		}
	}

	m_SoftwareVersion = &regVal[space + 2];
	m_Model = &regVal[2];
	m_Model[3] = '\0';

	char key[32];
	int keysCount = 48;
	RegistryKey** regKeys = new RegistryKey*[keysCount];
	int changedKeys = 0;

	// Read the Inputs
	for (int input = 0; input < 8; input++) {
		memcpy(&(m_monitor.inputs[input]), &m_recvbuf[m_pos], 8);
		ByteSwap(m_monitor.inputs[input].count);
		m_pos += 8;

		// set the state registry key.  could speed up later by checking 
		// if this is needed but the registry key set value functino 
		// performs a check so the user only gets real changes.
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/State");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* stateValue = new char[2];
		itoa(m_monitor.inputs[input].state, stateValue, 10);					
		if (regKeys[changedKeys]->SetValue(stateValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the alarm registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/Alarm");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* alarmValue = new char[2];
		itoa(m_monitor.inputs[input].alarm, alarmValue, 10);					
		if (regKeys[changedKeys]->SetValue(alarmValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the count registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/Count");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countValue = new char[13];
		itoa(m_monitor.inputs[input].count, countValue, 10);					
		if (regKeys[changedKeys]->SetValue(countValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the countAlarm1 registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/CountAlarm1");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countAlarm1Value = new char[2];
		itoa(m_monitor.inputs[input].countAlarm1, countAlarm1Value, 10);					
		if (regKeys[changedKeys]->SetValue(countAlarm1Value) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the countAlarm2 registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/CountAlarm2");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countAlarm2Value = new char[2];
		itoa(m_monitor.inputs[input].countAlarm2, countAlarm2Value, 10);					
		if (regKeys[changedKeys]->SetValue(countAlarm2Value) && regKeys[changedKeys]->subscribed) changedKeys++;
	}

	// Read the Outputs
	for (int output = 0; output < 8; output++) {
		m_monitor.outputs[output].state = m_recvbuf[m_pos++];

		// set the state registry key.  could speed up later by checking 
		// if this is needed but the registry key set value functino 
		// performs a check so the user only gets real changes.
		sprintf(key, "%s%d%s", "IO/Outputs/rout", output + 1, "/State");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* stateValue = new char[2];
		itoa(m_monitor.outputs[output].state, stateValue, 10);					
		if (regKeys[changedKeys]->SetValue(stateValue) && regKeys[changedKeys]->subscribed) changedKeys++;
	}

	// Read the time
	m_monitor.jniorTime = getlong(m_recvbuf, m_pos);

	m_monitorPacketRecvTime = clock();
	m_timePacketRecvTime = clock();

	if (strcmp(m_Model,"412") != 0 && strcmp(m_Model,"414") != 0 ) {
		if (this->m_monitorListeners.size() > 0) {
			MONITOR_CALLBACK_ARGS* args = new MONITOR_CALLBACK_ARGS;
			args->handle = this->m_handle;
			args->monitor = &m_monitor;

			CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
			wrapper->listeners.assign(this->m_monitorListeners.begin(), this->m_monitorListeners.end());
			wrapper->args = args;

			HANDLE hThread = CreateThread(
						NULL,										// default security attributes 
						0,											// use default stack size  
						(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
						wrapper,									// argument to thread function 
						0,											// use default creation flags 
						&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
		}
	}

	if (this->m_registryListeners.size() > 0 && changedKeys > 0) {
		REGISTRY_CALLBACK_ARGS* args = new REGISTRY_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->keys = new REGISTRY_KEY*[keysCount];
		for (int i = 0; i < keysCount; i++) {
			args->keys[i] = m_registry->ToStructure(regKeys[i]);
		}
		args->count = changedKeys;

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_registryListeners.begin(), this->m_registryListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
	}

}

void CJnior::ProcessExternalMonitorPacket()
{
	char key[32];
	int keysCount = 16;
	RegistryKey** regKeys = new RegistryKey*[keysCount];
	int changedKeys = 0;

	// get the number of digital inputs
	int inputCount = m_recvbuf[m_pos++];
#if DEBUG
			char txt[100];
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

	// Read the Inputs
	for (int input = 8; input < inputCount + 8; input++) {
		memcpy(&(m_monitor.inputs[input]), &m_recvbuf[m_pos], 8);
		ByteSwap(m_monitor.inputs[input].count);
		m_pos += 8;
#if DEBUG
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

		// set the state registry key.  could speed up later by checking 
		// if this is needed but the registry key set value functino 
		// performs a check so the user only gets real changes.
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/State");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* stateValue = new char[2];
		itoa(m_monitor.inputs[input].state, stateValue, 10);					
		if (regKeys[changedKeys]->SetValue(stateValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the alarm registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/Alarm");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* alarmValue = new char[2];
		itoa(m_monitor.inputs[input].alarm, alarmValue, 10);					
		if (regKeys[changedKeys]->SetValue(alarmValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the count registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/Count");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countValue = new char[13];
		itoa(m_monitor.inputs[input].count, countValue, 10);					
		if (regKeys[changedKeys]->SetValue(countValue) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the countAlarm1 registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/CountAlarm1");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countAlarm1Value = new char[2];
		itoa(m_monitor.inputs[input].countAlarm1, countAlarm1Value, 10);					
		if (regKeys[changedKeys]->SetValue(countAlarm1Value) && regKeys[changedKeys]->subscribed) changedKeys++;

		// set the countAlarm2 registry key
		sprintf(key, "%s%d%s", "IO/Inputs/din", input + 1, "/CountAlarm2");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* countAlarm2Value = new char[2];
		itoa(m_monitor.inputs[input].countAlarm2, countAlarm2Value, 10);					
		if (regKeys[changedKeys]->SetValue(countAlarm2Value) && regKeys[changedKeys]->subscribed) changedKeys++;
	}

	// get the number of outputs 
	int outputCount = m_recvbuf[m_pos++];
#if DEBUG
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

	// Read the Outputs
	for (int output = 0; output < outputCount; output++) {
		m_monitor.outputs[output + 8].state = m_recvbuf[m_pos++];
#if DEBUG
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

		// set the state registry key.  could speed up later by checking 
		// if this is needed but the registry key set value functino 
		// performs a check so the user only gets real changes.
		sprintf(key, "%s%d%s", "IO/Outputs/rout", output + 9, "/State");
		regKeys[changedKeys] = m_registry->GetKey(key);
		char* stateValue = new char[2];
		itoa(m_monitor.outputs[output + 8].state, stateValue, 10);					
		if (regKeys[changedKeys]->SetValue(stateValue) && regKeys[changedKeys]->subscribed) changedKeys++;
	}

	// Read the time
	m_monitor.jniorTime = getlong(m_recvbuf, m_pos);
#if DEBUG
			sprintf(txt, "recvState=%d, nextReadPos=%d, m_pos=%d", m_recvState, m_nextReadPos, m_pos);
			Logger(this->m_dumpFileName, txt);
#endif

	m_monitorPacketRecvTime = clock();
	m_timePacketRecvTime = clock();

	if (this->m_monitorListeners.size() > 0) {
		MONITOR_CALLBACK_ARGS* args = new MONITOR_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->monitor = &m_monitor;

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_monitorListeners.begin(), this->m_monitorListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
	}

	if (this->m_registryListeners.size() > 0 && changedKeys > 0) {
		REGISTRY_CALLBACK_ARGS* args = new REGISTRY_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->keys = new REGISTRY_KEY*[keysCount];
		for (int i = 0; i < keysCount; i++) {
			args->keys[i] = m_registry->ToStructure(regKeys[i]);
		}
		args->count = changedKeys;

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_registryListeners.begin(), this->m_registryListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
	}

}

void CJnior::ProcessUsageMeterPacket() 
{
	cout << "Process Usage Packet" << endl;

	// Read the Inputs
	for (int input = 0; input < 8; input++) {
		m_monitor.inputs[input].usage = getlong(m_recvbuf, m_pos);
	}

	// Read the Outputs
	for (int output = 0; output < 8; output++) {
		m_monitor.outputs[output].usage = getlong(m_recvbuf, m_pos);
	}

	// read the time
	m_monitor.jniorTime = getlong(m_recvbuf, m_pos);

	if (this->m_monitorListeners.size() > 0) {
		MONITOR_CALLBACK_ARGS* args = new MONITOR_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->monitor = &m_monitor;

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_monitorListeners.begin(), this->m_monitorListeners.end());
		wrapper->args = args;

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
	}
}

void CJnior::ProcessReadRegistryKeysResponse() 
{
	// get the number of keys returned
	short keysCount = getshort(m_recvbuf, m_pos);
	//cout << "Registry Key Read Response (" << count << ")\n";

	RegistryKey** regKeys = new RegistryKey*[keysCount];

	for (int i = 0; i < keysCount; i++) {
		short uniqueId = getshort(m_recvbuf, m_pos);

		//cout << "Registry Key Read Response Unique Id = " << uniqueId << "\n";

		RegistryKey* regKey = m_registry->GetKey(uniqueId);
		regKeys[i] = regKey;

		//cout << "Registry Key Read Response " << regKey->toString() << "\n";

		int valLength = m_recvbuf[m_pos++] & 0xff;
		char* regVal = new char[valLength + 1];
		strncpy(regVal, &m_recvbuf[m_pos], valLength);
		regVal[valLength] = '\0';

		//cout << "Registry Key Value = " << regVal << "\n";

		if (valLength > 0) {
			regKey->SetValue(regVal);
			m_pos += valLength;
		}

		regKey->readReceived = true;

		//char timeStr [9];
		//_strtime( timeStr );
		//cout << timeStr << "  " << uniqueId << " - (" << valLength << ") " << regVal << "\n";


		// perform the callback on the individual registry keys if there are 
		// callbacks assigned
		if (regKey->m_registryKeyListeners.size() > 0) {
			RegistryKey** regKeys = new RegistryKey*[1];
			regKeys[0] = regKey;

			REGISTRY_CALLBACK_ARGS* args = new REGISTRY_CALLBACK_ARGS;
			args->handle = this->m_handle;
			args->keys = new REGISTRY_KEY*[keysCount];
			//for (int i = 0; i < keysCount; i++) {
				args->keys[0] = m_registry->ToStructure(regKeys[0]);
			//}
			args->count = 1;

			CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
			wrapper->listeners.assign(regKey->m_registryKeyListeners.begin(), regKey->m_registryKeyListeners.end());
			wrapper->args = args;

			HANDLE hThread = CreateThread(
						NULL,										// default security attributes 
						0,											// use default stack size  
						(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
						wrapper,									// argument to thread function 
						0,											// use default creation flags 
						&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
		}
	}

	if (this->m_registryListeners.size() > 0) {
		//m_RegistryCallback(regKeys, count);

		REGISTRY_CALLBACK_ARGS* args = new REGISTRY_CALLBACK_ARGS;
		args->handle = this->m_handle;
		args->keys = new REGISTRY_KEY*[keysCount];
		for (int i = 0; i < keysCount; i++) {
			args->keys[i] = m_registry->ToStructure(regKeys[i]);
		}
		args->count = keysCount;

		CALLBACK_WRAPPER* wrapper = new CALLBACK_WRAPPER;
		wrapper->listeners.assign(this->m_registryListeners.begin(), this->m_registryListeners.end());
		wrapper->args = args;

		//while (dwWrapperThreadId != -1);

		HANDLE hThread = CreateThread(
					NULL,										// default security attributes 
					0,											// use default stack size  
					(LPTHREAD_START_ROUTINE) CallbackWrapper,	// thread function 
					wrapper,									// argument to thread function 
					0,											// use default creation flags 
					&m_dwRegistryWrapperThreadId);								// returns the thread identifier 
	}
}

void CJnior::ProcessLoginResponse()
{
	m_loginLevel = m_recvbuf[m_pos++] & 0xff;

	if (m_loginLevel == 0xff) {
		LoginStatus(STATUS_LOGIN_FAILED);
		m_loginLevel = -1;
	} else if (m_loginLevel >= 0x80) {
		LoginStatus(STATUS_LOGGED_IN_ADMIN);
	} else if (m_loginLevel >= 0x40) {
		LoginStatus(STATUS_LOGGED_IN_USER);
	} else if (m_loginLevel >= 0x00) {
		LoginStatus(STATUS_LOGGED_IN_GUEST);
	} else {
		LoginStatus(STATUS_LOGIN_FAILED);
		m_loginLevel = -1;
	}

}
