// JniorDll.cpp : Defines the entry point for the DLL application.
//

#pragma once

#include "stdafx.h"
#include "JniorConstants.h"

#include "JniorDll.h"
#include "AssemblyInfo.h"

#include "Jnior.h"

#include <map>
#include <iostream>
using namespace std;


#ifdef _MANAGED
#pragma managed(push, off)
#endif



#define INVALID_JNIOR_HANDLE		-1




static WSADATA wd;				// winsock data
bool initialized;				// wisock initialized sucessfully ?

bool QUIT = false;
int createJniorCount = 0;


ACCEPTEDCONNECTIONNOTIFY AcceptedConnectionCallback;


BOOL APIENTRY DllMain(HMODULE hModule,
	DWORD  ul_reason_for_call,
	LPVOID lpReserved
)
{

	// Startup Winsock
	int iResult = WSAStartup(MAKEWORD(2, 2), &wd);
	if (iResult != NO_ERROR)
	{
		initialized = FALSE;
		printf("Error at WSAStartup()\n");
		return FALSE;
	}


	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		break;
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	case DLL_PROCESS_DETACH:
		QUIT = true;
		break;
	}
	return TRUE;
}

#ifdef _MANAGED
#pragma managed(pop)
#endif


HANDLE hServerThread = NULL;
DWORD dwServerThreadId = 0;


///<summary>Gets the compiled DLL version</summary>
///<param name="version">A pointer to a char array that will hold the version string</param>
/// <returns> for success</returns>
JNIORDLL_API int GetDllVersion(char* version) {
	sprintf(version, "%d.%d.%d.%d", AssemblyInfo::getMajor(), AssemblyInfo::getMinor(), AssemblyInfo::getRevision(), AssemblyInfo::getBuild());
	return 0;
}

///<summary>Gets a string description for the status code</summary>
///<param name="status">an integer specifying the status code</param>
/// <returns>A string description</returns>
JNIORDLL_API char* GetStatusDescription(int status)
{
	switch (status) {
	case STATUS_COMMAND_TIMEOUT:						return "Timeout Occured!";
	case STATUS_FAILED:									return "Failed!";
	case STATUS_OK:										return "OK";
	case STATUS_NOT_CONNECTED:							return "Not Yet Connected";
	case STATUS_REBOOTING:								return "Rebooting...";
	case STATUS_DISCONNECTED:							return "Disconnected";
	case STATUS_CONNECTING:								return "Connecting...";
	case STATUS_RECONNECTING:							return "Reconnecting...";
	case STATUS_CONNECTED:								return "Connected";
	case STATUS_CONNECTION_FAILED:						return "Connection Failed";
	case STATUS_CANCELLED:								return "User Cancelled";
	case STATUS_WAIT_FOR_RECV_THREAD:					return "Waiting for Receiver Thread";
	case STATUS_RECV_THREAD_DONE:						return "Receiver Thread Done";

	case STATUS_NOT_LOGGED_IN:							return "Not Logged In";
	case STATUS_LOGGED_OUT:								return "Logged Out";
	case STATUS_LOGGING_IN:								return "Logging In...";
	case STATUS_LOGGED_IN_GUEST:						return "Logged In as Guest";
	case STATUS_LOGGED_IN_USER:							return "Logged In as User";
	case STATUS_LOGGED_IN_ADMIN:						return "Logged In as Admin";
	case STATUS_LOGIN_FAILED:							return "Login Failed";
	case STATUS_LOGIN_INCORRECT_LEVEL:					return "Incorrect Login Level";

	case STATUS_QUERY_JNIOR_PORT:						return "Querying HTTP for JNIOR Port number...";
	case STATUS_QUERY_JNIOR_PORT_SUCCESS:				return "HTTP returned JNIOR port number";

	case STATUS_REQUESTING_MONITOR:						return "Requesting Monitor Packet";
	case STATUS_REQUESTING_USAGE_METERS:				return "Requesting Usage Meters";
	case STATUS_REQUESTING_TIME:						return "Requesting Time Packet";

	case STATUS_MONITOR_PACKET_RECEIVED:				return "Monitor Packet Received";
	case STATUS_EXTERNAL_MONITOR_PACKET_RECEIVED:		return "External Monitor Packet Received";
	case STATUS_USAGE_METERS_RECEIVED:					return "Usage Meter Packet Received";
	case STATUS_TOGGLE_OUTPUT:							return "Toggled output";
	case STATUS_REGISTRY_READ_RECEIVED:					return "Registry Key Read";

	case STATUS_REGISTRY_WRITING:						return "Writing Registry Key";
	case STATUS_REGISTRY_WRITE_RECEIVED:				return "Registry Write Complete";
	case STATUS_LOGIN_ACK:								return "Login Ack Received";

	case SOCKET_NOT_WRITABLE:							return "Socket Not Writable";
	case SOCKET_NOT_READABLE:							return "Socket Not Readable";

	default:
		char* error = new char[32];
		sprintf(error, "Status (%d)", status);
		return error;
	}
}






std::map<int, CJnior*> connections;

//// SetUpListener /////////////////////////////////////////////////////
// Sets up a listener on the given interface and port, returning the
// listening socket if successful; if not, returns INVALID_SOCKET.

SOCKET SetUpListener(const char* pcAddress, int nPort)
{
	u_long nInterfaceAddr = inet_addr(pcAddress);
	if (nInterfaceAddr != INADDR_NONE) {
		SOCKET sd = socket(AF_INET, SOCK_STREAM, 0);
		if (sd != INVALID_SOCKET) {
			sockaddr_in sinInterface;
			sinInterface.sin_family = AF_INET;
			sinInterface.sin_addr.s_addr = nInterfaceAddr;
			sinInterface.sin_port = nPort;
			if (bind(sd, (sockaddr*)&sinInterface,
				sizeof(sockaddr_in)) != SOCKET_ERROR) {
				listen(sd, SOMAXCONN);
				return sd;
			}
			else {
				cout << WSAGetLastError() << " bind() failed" <<
					endl;
			}
		}
	}

	return INVALID_SOCKET;
}

//// AcceptConnections /////////////////////////////////////////////////
// Spins forever waiting for connections.  For each one that comes in, 
// we create a thread to handle it and go back to waiting for
// connections.  If an error occurs, we return.

DWORD WINAPI AcceptConnections(LPVOID lparam)
{
	CONNECT_PARAMS* cp = (CONNECT_PARAMS*)lparam;

	cout << "Establishing the listener..." << endl;
	SOCKET ListeningSocket = SetUpListener(cp->host, htons(cp->port));
	if (ListeningSocket == INVALID_SOCKET) {
		cout << endl << WSAGetLastError() << " establish listener" <<
			endl;
		return 3;
	}

	sockaddr_in sinRemote;
	int nAddrSize = sizeof(sinRemote);

	while (!QUIT) {
		cout << "Waiting for connections..." << flush;
		SOCKET sd = accept(ListeningSocket, (sockaddr*)&sinRemote,
			&nAddrSize);
		if (sd != INVALID_SOCKET) {
			cout << "Accepted connection from " <<
				inet_ntoa(sinRemote.sin_addr) << ":" <<
				ntohs(sinRemote.sin_port) << "." <<
				endl;

			CONNECT_PARAMS* newCp = new CONNECT_PARAMS();
			size_t len = strlen(inet_ntoa(sinRemote.sin_addr));
			newCp->host = new char[len + 1];
			newCp->host[len] = '\0';
			strncpy(newCp->host, inet_ntoa(sinRemote.sin_addr), len);
			newCp->port = ntohs(sinRemote.sin_port);
			newCp->retryCount = newCp->retriesRemaining = 0;
			newCp->retryInterval = 0;

			int handle = CreateJniorSession(newCp);
			CJnior* jnior = connections[handle];
			if (jnior == NULL) return INVALID_JNIOR_HANDLE;

			jnior->SetSocket(sd);

			if (AcceptedConnectionCallback != NULL) {
				AcceptedConnectionCallback(handle);
			}
		}
		else {
			cout << WSAGetLastError() << " accept() failed" <<
				endl;
			return 1;
		}
	}

	delete cp;

	return STATUS_OK;
}

///<summary>Starts a server that will listen for incomming JNIOR connections</summary>
///<param name="connectParams">The connect param structure that will specify the host adapter and the port to listen to</param>
/// <returns> for success</returns>
extern "C" JNIORDLL_API int StartServer(CONNECT_PARAMS* cp) {
	//CONNECT_PARAMS* cp = new CONNECT_PARAMS();
	//int len = strlen(host);
	//cp->host = new char[len + 1];
	//cp->host[len] = '\0';
	//strncpy(cp->host, host, len);
	//cp->port = port;
	//cp->retryCount = cp->retriesLeft = retries;
	//cp->retryInterval = retryInterval;

	if (hServerThread == NULL) {
		hServerThread = CreateThread(
			NULL,										// default security attributes 
			0,											// use default stack size  
			(LPTHREAD_START_ROUTINE)AcceptConnections,	// thread function 
			cp,											// argument to thread function 
			0,											// use default creation flags 
			&dwServerThreadId);							// returns the thread identifier 
	}

	return 0;
}

///<summary>Creates a new JNIOR connection object</summary>
///<param name="connectParams">the connection param structure</param>
/// <returns>The handle of the jnior object created</returns>
extern "C" JNIORDLL_API int CreateJniorSession(CONNECT_PARAMS* cp) {
	CJnior* jnior = new CJnior(cp);
	connections[jnior->m_handle] = jnior;

	createJniorCount++;

	return jnior->m_handle;
}

///<summary>Disables monitor packets for the specified jnior object</summary>
///<param name="handle">Handle of the jnior object</param>
/// <returns>0 for success</returns>
extern "C" JNIORDLL_API int DisableMonitorPackets(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->DisableMonitorPackets();
}

///<summary>Enables monitor packets for the specified jnior object</summary>
///<param name="handle"></param>
/// <returns>0 for success</returns>
extern "C" JNIORDLL_API int EnableMonitorPackets(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->EnableMonitorPackets();
}

extern "C" JNIORDLL_API int Reboot(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->Reboot();
}

extern "C" JNIORDLL_API int RequestMonitorPacket(int handle, int monitorInterval) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->RequestMonitorPacket(monitorInterval);
}

extern "C" JNIORDLL_API long long RequestClock(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->RequestClock();
}

extern "C" JNIORDLL_API int RequestUsageMeterPacket(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->RequestUsageMeterPacket();
}


extern "C" JNIORDLL_API CONNECT_PARAMS* GetConnectionProperties(int handle, CONNECT_PARAMS* connectParams) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return NULL;

	connectParams = jnior->GetConnectionProperties();
	cout << connectParams << endl;
	return jnior->GetConnectionProperties();
}

extern "C" JNIORDLL_API int ConnectAsync(int handle, CONNECT_PARAMS* connectParams) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	char filename[64];
	sprintf(filename, "%s.%d.log", connectParams->host, connectParams->port);
	jnior->SetDumpFile(filename);

	return jnior->ConnectAsync(connectParams);
}

extern "C" JNIORDLL_API int Connect(int handle, CONNECT_PARAMS* connectParams) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	char filename[64];
	sprintf(filename, "%s.%d.log", connectParams->host, connectParams->port);
	jnior->SetDumpFile(filename);

	return jnior->Connect(connectParams, false);
}

extern "C" JNIORDLL_API int Disconnect(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	jnior->Disconnect();

	return STATUS_OK;
}

extern "C" JNIORDLL_API int IsConnected(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	bool isConnected = jnior->IsConnected();
	return isConnected ? TRUE : FALSE;
}

extern "C" JNIORDLL_API int IsLoggedIn(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->IsLoggedIn() ? TRUE : FALSE;
}

extern "C" JNIORDLL_API int GetLoginStatus(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->GetLoginStatus();
}

extern "C" JNIORDLL_API int LoginAsync(int handle, CREDENTIALS* creds) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->Login(creds, false);
}

extern "C" JNIORDLL_API int Login(int handle, CREDENTIALS* creds) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->Login(creds, true);
}

extern "C" JNIORDLL_API int Cancel(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	jnior->Cancel();
	return 0;
}

extern "C" JNIORDLL_API int GetModel(int handle, char* model) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	strncpy(model, jnior->m_Model, strnlen(jnior->m_Model, 3));
	return 0;
}

extern "C" JNIORDLL_API int GetSoftwareVersion(int handle, char* softwareVersion) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	strncpy(softwareVersion, jnior->m_SoftwareVersion, strnlen(jnior->m_SoftwareVersion, 6));
	return 0;
}


extern "C" JNIORDLL_API long long GetMonitorFreshness(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->GetMonitorFreshness();
}


extern "C" JNIORDLL_API long long GetKnownJniorTime(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->GetKnownJniorTime();
}


extern "C" JNIORDLL_API int SetClock(int handle, long long milliseconds) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->SetClock(milliseconds);
}

extern "C" JNIORDLL_API int Command(int handle, char* commandString, char* returnString) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->Command(commandString, returnString);
}

extern "C" JNIORDLL_API int GetInput(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	JNIOR_MONITOR* monitor = jnior->GetMonitor();

	return monitor->inputs[channel].state;
}

extern "C" JNIORDLL_API int GetInputs(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	JNIOR_MONITOR* monitor = jnior->GetMonitor();
	int inputs = 0;
	for (int i = 0; i < 16; i++) {
		// if any input state is -1 then we know we havent received the first 
		// monitor packet.  return 0
		if (monitor->inputs[i].state == -1) return inputs;
		inputs |= (monitor->inputs[i].state << i);
	}

	return inputs;
}
extern "C" JNIORDLL_API int GetOutput(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	JNIOR_MONITOR* monitor = jnior->GetMonitor();

	return monitor->outputs[channel].state;
}

extern "C" JNIORDLL_API int GetOutputs(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	JNIOR_MONITOR* monitor = jnior->GetMonitor();
	int outputs = 0;
	for (int i = 0; i < 16; i++) {
		// if any output state is -1 then we know we havent received the first 
		// monitor packet.  return 0
		if (monitor->outputs[i].state == -1) return outputs;
		outputs |= (monitor->outputs[i].state << i);
	}

	return outputs;
}

extern "C" JNIORDLL_API int CloseOutput(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->CloseOutput(channel);
}

extern "C" JNIORDLL_API int OpenOutput(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->OpenOutput(channel);
}

extern "C" JNIORDLL_API int ToggleOutput(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->ToggleOutput(channel);
}

extern "C" JNIORDLL_API int ResetInputLatch(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->ResetInputLatch(channel);
}

extern "C" JNIORDLL_API int ClearInputCounter(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->ClearInputCounter(channel);
}

extern "C" JNIORDLL_API int ClearInputUsage(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->ClearInputUsage(channel);
}

extern "C" JNIORDLL_API int ClearOutputUsage(int handle, int channel) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->ClearOutputUsage(channel);
}

extern "C" JNIORDLL_API int PulseOutput(int handle, int channel, int duration) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->PulseOutput(channel, duration);
}

extern "C" JNIORDLL_API int SetOutput(int handle, int channel, int state) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->BlockSetRelays(1 << channel, state << channel);
}

extern "C" JNIORDLL_API int BlockPulseRelays(int handle, int channelMask, int stateMask, int duration) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->BlockPulseRelays(channelMask, stateMask, duration);
}

extern "C" JNIORDLL_API int BlockSetRelays(int handle, int channelMask, int stateMask) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->BlockSetRelays(channelMask, stateMask);
}

extern "C" JNIORDLL_API JNIOR_MONITOR* GetMonitor(int handle) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return NULL;

	return jnior->GetMonitor();
}

extern "C" JNIORDLL_API double GetExternalValue(int handle, char deviceType, char ioSelection, char channeNumber) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return INVALID_JNIOR_HANDLE;

	return jnior->GetExternalValue(deviceType, ioSelection, channeNumber);
}


extern "C" JNIORDLL_API REGISTRY_KEY* GetRegistryKeyHandle(int handle, char* key) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return NULL;

	RegistryKey* regkey = jnior->m_registry->GetKey(key);

	//printf("GetRegistryKey   %s\n", regkey);

	return (REGISTRY_KEY*)regkey;
}

extern "C" JNIORDLL_API int GetRegistryKeyId(int handle, REGISTRY_KEY* key) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//printf("GetRegistryKey   %s\n", jnior->m_registry->FromStructure(key)->toString());

	return key->uniqueId;
}

extern "C" JNIORDLL_API int GetRegistryKey(int handle, REGISTRY_KEY* key, char* value) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//printf("GetRegistryKey   %s\n", jnior->m_registry->FromStructure(key)->toString());
	strcpy(value, key->key);

	return 0;
}

extern "C" JNIORDLL_API int GetRegistryKeyValue(int handle, REGISTRY_KEY* key, char* value) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//printf("GetRegistryKeyValue   %s\n", jnior->m_registry->FromStructure(key)->toString());
	strcpy(value, key->value);

	return 0;
}

extern "C" JNIORDLL_API int SetRegistryKeyValue(int handle, REGISTRY_KEY* key, char* value) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->m_registry->FromStructure(key)->SetValue(value);

	//printf("SetRegistryKeyValue   %s\n", jnior->m_registry->FromStructure(key)->toString());

	return 0;
}

extern "C" JNIORDLL_API int ReadRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size, char* defaultValue) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//FILE* file = fopen("c:\debug.txt", "w");

	//for (int i = 0; i < size; i++) {
	//	fprintf(file, "Read key %s\n", keys[i]->toString());
	//}

	//fclose(file);

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->ReadRegistryKeys(regKeys, size, defaultValue, false);
}

extern "C" JNIORDLL_API int ReadRegistryKeys(int handle, REGISTRY_KEY** keys, int size, char* defaultValue) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//FILE* file = fopen("c:\debug.txt", "w");

	//for (int i = 0; i < size; i++) {
	//	fprintf(file, "Read key %s\n", keys[i]->toString());
	//}

	//fclose(file);

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->ReadRegistryKeys(regKeys, size, defaultValue, true);
}

extern "C" JNIORDLL_API int SubscribeRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size, char* defaultValue) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//FILE* file = fopen("c:\debug.txt", "w");

	//for (int i = 0; i < size; i++) {
	//	fprintf(file, "Read key %s\n", keys[i]->toString());
	//}

	//fclose(file);

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->SubscribeRegistryKeys(regKeys, size, defaultValue, false);
}

extern "C" JNIORDLL_API int SubscribeRegistryKeys(int handle, REGISTRY_KEY** keys, int size, char* defaultValue) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//FILE* file = fopen("c:\debug.txt", "w");

	//for (int i = 0; i < size; i++) {
	//	fprintf(file, "Read key %s\n", keys[i]->toString());
	//}

	//fclose(file);

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->SubscribeRegistryKeys(regKeys, size, defaultValue, true);
}

extern "C" JNIORDLL_API int WriteRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//for (int i = 0; i < size; i++) {
	//	printf("Write key %s\n", ((RegistryKey*)keys[i])->toString());
	//}

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->WriteRegistryKeys(regKeys, size, false);
}

extern "C" JNIORDLL_API int WriteRegistryKeys(int handle, REGISTRY_KEY** keys, int size) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	//for (int i = 0; i < size; i++) {
	//	printf("Write key %s\n", ((RegistryKey*)keys[i])->toString());
	//}

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->WriteRegistryKeys(regKeys, size, true);
}

extern "C" JNIORDLL_API int ListRegistryAsync(int handle, char* path) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	return jnior->ListRegistryAsync(path);
}

extern "C" JNIORDLL_API int AddRegistryKeyCallback(int handle, REGISTRY_KEY** keys, int size, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	RegistryKey** regKeys = new RegistryKey*[size];
	for (int i = 0; i < size; i++) {
		regKeys[i] = jnior->m_registry->FromStructure(keys[i]);
	}

	return jnior->AddRegistryKeyCallback(regKeys, size, lProcAddress);
}
/*********************** REGISTRY *********************************************/



extern "C" JNIORDLL_API int ReadDevices(int handle, long long deviceIds[], int size) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->ReadDevices(deviceIds, size, false);

	return 0;
}

extern "C" JNIORDLL_API int SubscribeDevices(int handle, long long deviceIds[], int size) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->SubscribeDevices(deviceIds, size);

	return 0;
}



extern "C" JNIORDLL_API int CustomCommand(int handle, char* commandName, char commandType, short payloadSize, char* payload) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->CustomCommand(commandName, commandType, payloadSize, payload);

	return 0;
}

extern "C" JNIORDLL_API int SendMacroName(int handle, char* macroName)
{
	size_t macroNameLength = strlen(macroName);
	char* payload = new char[macroNameLength];
	memcpy(payload, macroName, macroNameLength);

	// send it using the DLL
	return CustomCommand(handle, "macro", 1, (short)macroNameLength, payload);
}



extern "C" JNIORDLL_API int SetAcceptedConnectionCallback(ACCEPTEDCONNECTIONNOTIFY lProcAddress) {
	AcceptedConnectionCallback = lProcAddress;
	return 0;
}

extern "C" JNIORDLL_API int AddStatusCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddStatusCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int RemoveStatusCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->RemoveStatusCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddMonitorCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddMonitorCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddConnectionCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddConnectionCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddLoginCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddLoginCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddRegistryCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddRegistryCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddCommunicationsCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddCommunicationsCallback(lProcAddress);

	return 0;
}

extern "C" JNIORDLL_API int AddRegistryListingCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddRegistryListingCallback(lProcAddress);

	return 0;
}

//extern "C" JNIORDLL_API int AddSDebugCallback(int handle, CALLBACKNOTIFY lProcAddress) {
//	CJnior* jnior = connections[handle];
//	if (jnior == NULL) return -1;
//
//	jnior->AddDebugCallback(lProcAddress);
//
//	return 0;
//}

extern "C" JNIORDLL_API int AddCustomCommandCallback(int handle, CALLBACKNOTIFY lProcAddress) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->AddCustomCommandCallback(lProcAddress);

	return 0;
}



extern "C" JNIORDLL_API int SetDumpFile(int handle, char* filename) {
	CJnior* jnior = connections[handle];
	if (jnior == NULL) return -1;

	jnior->SetDumpFile(filename);

	return 0;

}