// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the JNIORDLL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// JNIORDLL_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef JNIORDLL_EXPORTS
#define JNIORDLL_API __declspec(dllexport)
#else
#define JNIORDLL_API __declspec(dllimport)
#endif

#pragma once

#include "JniorStructures.h"

#include <vector>
using namespace std;


extern "C" JNIORDLL_API int nJniorDll;

extern "C" JNIORDLL_API int GetDllVersion(char* version);

extern "C" JNIORDLL_API char* GetStatusDescription(int status);


#define CALLBACK    __stdcall

typedef void (CALLBACK* ACCEPTEDCONNECTIONNOTIFY)(int handle);


/*********************** CALLBACK ********************************************/
typedef void (CALLBACK* CALLBACKNOTIFY)(void* args);
#pragma pack(1)
struct CALLBACK_WRAPPER {
	vector<CALLBACKNOTIFY> listeners;
	void* args;
};
/*********************** CALLBACK ********************************************/





extern "C" JNIORDLL_API int StartServer(CONNECT_PARAMS* connectParams);

extern "C" JNIORDLL_API int CreateJniorSession(CONNECT_PARAMS*);

extern "C" JNIORDLL_API int DisableMonitorPackets(int handle);
extern "C" JNIORDLL_API int EnableMonitorPackets(int handle);

extern "C" JNIORDLL_API int Reboot(int handle);

extern "C" JNIORDLL_API int RequestMonitorPacket(int handle, int monitorInterval);
extern "C" JNIORDLL_API int RequestUsageMeterPacket(int handle);

extern "C" JNIORDLL_API CONNECT_PARAMS* GetConnectionProperties(int handle, CONNECT_PARAMS* connectParams);
///<summary>
///Performs the @see connect call asynchronously.  This means that the call returns 
///immediately with the work being done in another thread.  Validation to see 
///whether the necessary callbacks are defined is not performed
///<param name="handle">The handle of the jnior object to connect to.  This is 
///obtained as a result of calling the @see CreateJniorConnection() function
///</param>
///<param name="connectParams">A pointer to the @see connect_params stucture</param>
///</summary>
extern "C" JNIORDLL_API int ConnectAsync(int handle, CONNECT_PARAMS* connectParams);

///<summary>
///Connects to a given JNIOR as defined by the @see connect params.  If the 
///connection cannot be made the the connection is attempted again.  The number 
///of times the connection is attempted is also defined by @see connect params.
///If the port defined in the connect params structure is 0 then the web port is 
///used to try to determine the JNIOR protocol port.  In most OS versions the 
///method for this is using the query.cgi and the http get method.  In old JNIOR 
///operating systems like 2.12.227 and older there is a configure.htm file that 
///gets populated with the correct port.  Getting that file will reveal the 
///JNIOR protocol port.  If the port is specified but the connection fails atleast 
///once then the http port method is used under the assumption that the user may 
///have specified an incorrect port.
///<param name="handle">The handle of the jnior object to connect to.  This is 
///obtained as a result of calling the @see CreateJniorConnection() function
///</param>
///<param name="connectParams">A pointer to the @see connect_params stucture</param>
///</summary>
extern "C" JNIORDLL_API int Connect(int handle, CONNECT_PARAMS* connectParams);

/// <summary>
/// Disconnects from the JNIOR that belongs to the given session identified by the 
/// handle
/// </summary>
extern "C" JNIORDLL_API int Disconnect(int handle);

/// <summary>
/// returns whethere or not the given JNIOR that belongs to the session identified 
/// by the handle is connected
/// </summary>
extern "C" JNIORDLL_API int IsConnected(int handle);
extern "C" JNIORDLL_API int IsLoggedIn(int handle);
extern "C" JNIORDLL_API int GetLoginStatus(int handle);

extern "C" JNIORDLL_API int LoginAsync(int handle, CREDENTIALS* creds);
extern "C" JNIORDLL_API int Login(int handle, CREDENTIALS* creds);

extern "C" JNIORDLL_API int Cancel(int handle);

extern "C" JNIORDLL_API int GetModel(int handle, char* model);
extern "C" JNIORDLL_API int GetSoftwareVersion(int handle, char* softwareVersion);

extern "C" JNIORDLL_API long long GetMonitorFreshness(int handle);
extern "C" JNIORDLL_API long long GetKnownJniorTime(int handle);

extern "C" JNIORDLL_API long long RequestClock(int handle);
extern "C" JNIORDLL_API int SetClock(int handle, long long milliseconds);

extern "C" JNIORDLL_API int GetInput(int handle, int channel);
extern "C" JNIORDLL_API int GetInputs(int handle);
extern "C" JNIORDLL_API int GetOutput(int handle, int channel);
extern "C" JNIORDLL_API int GetOutputs(int handle);

extern "C" JNIORDLL_API int Command(int handle, char* commandString, char* returnString);
extern "C" JNIORDLL_API int CloseOutput(int handle, int channel);
extern "C" JNIORDLL_API int OpenOutput(int handle, int channel);
extern "C" JNIORDLL_API int ToggleOutput(int handle, int channel);
extern "C" JNIORDLL_API int ResetInputLatch(int handle, int channel);
extern "C" JNIORDLL_API int ClearInputCounter(int handle, int channel);
extern "C" JNIORDLL_API int ClearInputUsage(int handle, int channel);
extern "C" JNIORDLL_API int ClearOutputUsage(int handle, int channel);
extern "C" JNIORDLL_API int PulseOutput(int handle, int channel, int duration);
extern "C" JNIORDLL_API int SetOutput(int handle, int channel, int state);
extern "C" JNIORDLL_API int BlockPulseRelays(int handle, int channelMask, int stateMask, int duration);
extern "C" JNIORDLL_API int BlockSetRelays(int handle, int channelMask, int stateMask);

extern "C" JNIORDLL_API JNIOR_MONITOR* GetMonitor(int handle);
extern "C" JNIORDLL_API double GetExternalValue(int handle, char deviceType, char ioSelection, char channeNumber);


/*********************** REGISTRY *********************************************/
extern "C" JNIORDLL_API REGISTRY_KEY* GetRegistryKeyHandle(int handle, char* key);
extern "C" JNIORDLL_API int GetRegistryKeyId(int handle, REGISTRY_KEY* key);
extern "C" JNIORDLL_API int GetRegistryKey(int handle, REGISTRY_KEY* key, char* value);
extern "C" JNIORDLL_API int GetRegistryKeyValue(int handle, REGISTRY_KEY* key, char* value);
extern "C" JNIORDLL_API int SetRegistryKeyValue(int handle, REGISTRY_KEY* key, char* value);

extern "C" JNIORDLL_API int ReadRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size, char* defaultValue);
extern "C" JNIORDLL_API int ReadRegistryKeys(int handle, REGISTRY_KEY** keys, int size, char* defaultValue);
extern "C" JNIORDLL_API int SubscribeRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size, char* defaultValue);
extern "C" JNIORDLL_API int SubscribeRegistryKeys(int handle, REGISTRY_KEY** keys, int size, char* defaultValue);
extern "C" JNIORDLL_API int WriteRegistryKeysAsync(int handle, REGISTRY_KEY** keys, int size);
extern "C" JNIORDLL_API int WriteRegistryKeys(int handle, REGISTRY_KEY** keys, int size);
extern "C" JNIORDLL_API int ListRegistryAsync(int handle, char* path);
extern "C" JNIORDLL_API int AddRegistryListingCallback(int handle, CALLBACKNOTIFY lProcAddress);

extern "C" JNIORDLL_API int AddRegistryKeyCallback(int handle, REGISTRY_KEY** keys, int size, CALLBACKNOTIFY lProcAddress);
/*********************** REGISTRY *********************************************/


extern "C" JNIORDLL_API int ReadDevices(int, long long[], int);
extern "C" JNIORDLL_API int SubscribeDevices(int, long long[], int);


extern "C" JNIORDLL_API int CustomCommand(int handle, char* commandName, char commandType, short payloadSize, char* payload);
extern "C" JNIORDLL_API int SendMacroName(int handle, char* macroName);


extern "C" JNIORDLL_API int SetAcceptedConnectionCallback(ACCEPTEDCONNECTIONNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddStatusCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int RemoveStatusCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddMonitorCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddConnectionCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddLoginCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddRegistryCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddCommunicationsCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddRegistryListingCallback(int handle, CALLBACKNOTIFY lProcAddress);
extern "C" JNIORDLL_API int AddCustomCommandCallback(int handle, CALLBACKNOTIFY lProcAddress);
