/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter.reporting;

import com.integ.common.logging.BakFileLog;
import com.integ.common.logging.Logger;
import com.integ.common.system.Application;
import com.integ.common.utils.FileUtils;
import com.wedauto.cameracounter.Config;
import com.wedauto.cameracounter.reporting.ReportDeliveryTask;
import java.io.File;
import java.io.IOException;
import java.text.QuickDateFormat;

public class Report {
    protected static final Logger REPORT_LOG = BakFileLog.getLogger(Application.getAppName() + "_Report.log");
    public static final QuickDateFormat FILENAME_DATE_FORMAT = new QuickDateFormat("yyyyMMdd_HHmmss");
    public static final QuickDateFormat ENTRY_DATE_FORMAT = new QuickDateFormat("yyyy-MM-dd");
    public static final QuickDateFormat ENTRY_TIME_FORMAT = new QuickDateFormat("HH:mm:ss.fff");
    public static final File STORAGE_LOCATION = new File("flash/wedauto/" + Application.getAppName().toLowerCase());
    public static final Object REPORT_LOCK = new Object();
    private static File File = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeEntry(long timestamp, int count, int type, String returnCode) {
        STORAGE_LOCATION.mkdir();
        Object object = REPORT_LOCK;
        synchronized (object) {
            String entry = String.format("%s, %s, %s, %d, %d, %s\r\n", Config.getCameraId(), ENTRY_DATE_FORMAT.format(timestamp), ENTRY_TIME_FORMAT.format(timestamp), count, type, returnCode);
            try {
                if (null == File || !File.exists()) {
                    String filename = String.format("%s/report_%s_%s.csv", STORAGE_LOCATION.getPath(), Config.getCameraId(), FILENAME_DATE_FORMAT.format(timestamp));
                    File = new File(filename);
                    REPORT_LOG.info("create report file: " + File);
                    entry = String.format("CameraID, Date, Time, Quantity, Type, Return Code\r\n%s", entry);
                }
                if (null == File) {
                    throw new RuntimeException("report file is null");
                }
                FileUtils.appendAllBytes(File.getPath(), entry.getBytes());
            }
            catch (IOException ex) {
                REPORT_LOG.error("error making transmission log entry", ex);
            }
            if (0 == Config.getReportSendInterval()) {
                ReportDeliveryTask.emailEngineeringReport();
                ReportDeliveryTask.emailProductionReport();
                for (int attempt = 0; attempt < 2; ++attempt) {
                    if (0 != attempt) {
                        REPORT_LOG.warn("retrying report delivery");
                    }
                    if (!ReportDeliveryTask.ftpReport()) continue;
                    Report.removeFile();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilename() {
        Object object = REPORT_LOCK;
        synchronized (object) {
            REPORT_LOG.info("report file: " + File);
            if (null != File) {
                return File.getPath();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFile() {
        Object object = REPORT_LOCK;
        synchronized (object) {
            if (null != File) {
                REPORT_LOG.info("removing report file");
                File.delete();
                File = null;
            }
        }
    }
}

