/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter.reporting;

import com.integ.common.logging.BakFileLog;
import com.integ.common.logging.Logger;
import com.integ.common.system.Application;
import com.integ.common.utils.FileUtils;
import com.integpg.system.MailComposer;
import com.wedauto.cameracounter.Config;
import com.wedauto.cameracounter.FTPClient;
import com.wedauto.cameracounter.reporting.Report;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class ReportDeliveryTask
implements Runnable {
    private static final Logger REPORT_DELIVERY_TASK_LOG = BakFileLog.getLogger(Application.getAppName() + "_ReportDeliveryTask.log");
    private static final Logger FTP_LOG = BakFileLog.getLogger(Application.getAppName() + "_ftp.log");
    private static final String EOF_FILE_PATH = "/temp/EOF.TXT";
    private Thread _thread = null;

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.createEofTxtFile();
        int reportIntervalMillis = Config.getReportSendInterval();
        long previousReportSentTime = System.currentTimeMillis();
        if (0 != reportIntervalMillis) {
            reportIntervalMillis = (int)((long)reportIntervalMillis - System.currentTimeMillis() % (long)reportIntervalMillis);
        }
        REPORT_DELIVERY_TASK_LOG.info("report sent start time " + new Date(previousReportSentTime));
        try {
            while (true) {
                reportIntervalMillis = Config.getReportSendInterval();
                long nextReportSendTime = previousReportSentTime + (long)reportIntervalMillis;
                if (0 != reportIntervalMillis && System.currentTimeMillis() > nextReportSendTime) {
                    Object object = Report.REPORT_LOCK;
                    synchronized (object) {
                        String reportFilename = Report.getFilename();
                        REPORT_DELIVERY_TASK_LOG.info("report file: " + reportFilename);
                        ReportDeliveryTask.emailEngineeringReport();
                        ReportDeliveryTask.emailProductionReport();
                        for (int attempt = 0; attempt < 2; ++attempt) {
                            if (0 != attempt) {
                                REPORT_DELIVERY_TASK_LOG.warn("retrying report delivery");
                            }
                            if (!ReportDeliveryTask.ftpReport()) continue;
                            Report.removeFile();
                        }
                    }
                    previousReportSentTime = nextReportSendTime;
                    REPORT_DELIVERY_TASK_LOG.info("report sent at " + new Date(previousReportSentTime));
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            REPORT_DELIVERY_TASK_LOG.error("error in report delivery task", ex);
            return;
        }
    }

    public static void emailEngineeringReport() {
        ReportDeliveryTask.emailReport(true);
    }

    public static void emailProductionReport() {
        ReportDeliveryTask.emailReport(false);
    }

    private static void emailReport(boolean engineering) {
        String logType = engineering ? "Engineering" : "Production";
        String[] emailRecipients = engineering ? Config.getEngineeringEmailRecipients() : Config.getProductionEmailRecipients();
        System.out.println(logType + " email recipient count: " + emailRecipients.length);
        for (String emailRecipient : emailRecipients) {
            if (!"none".equalsIgnoreCase(emailRecipient) && !"".equalsIgnoreCase(emailRecipient)) {
                try {
                    REPORT_DELIVERY_TASK_LOG.info("   email recipient: " + emailRecipient);
                    MailComposer mailComposer = new MailComposer();
                    mailComposer.setToAddress(emailRecipients);
                    mailComposer.setSubject(String.format("%s Camera Counter Log Report", logType));
                    mailComposer.setMessage(String.format("Attached is the %s Camera Counter Log that has just been updated.", logType));
                    mailComposer.setAttachment(Report.getFilename());
                    mailComposer.send();
                }
                catch (Exception ex) {
                    REPORT_DELIVERY_TASK_LOG.error("Error emailing tranmission log", ex);
                }
                continue;
            }
            REPORT_DELIVERY_TASK_LOG.info("no " + logType.toLowerCase() + " email addresses configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean ftpReport() {
        boolean result = false;
        String ftpServer = Config.getFtpServer();
        String reportFilename = Report.getFilename();
        if (!"".equalsIgnoreCase(ftpServer) && null != reportFilename) {
            FTPClient ftpClient = new FTPClient();
            ftpClient.enableLog(true);
            try {
                FTP_LOG.info("connect to " + ftpServer);
                if (ftpClient.connect(ftpServer)) {
                    String username = Config.getFtpUsername();
                    String password = Config.getFtpPassword();
                    FTP_LOG.info("log in to " + ftpServer);
                    if (ftpClient.login(username, password)) {
                        String ftpRemoteDirectory = Config.getFtpRemoteDirectory();
                        if (!"none".equalsIgnoreCase(ftpRemoteDirectory) && !"".equalsIgnoreCase(ftpRemoteDirectory)) {
                            FTP_LOG.info("change working directory to " + ftpRemoteDirectory);
                            ftpClient.cwd(ftpRemoteDirectory);
                        }
                        if (null == reportFilename) throw new RuntimeException("Report filename is NULL");
                        File reportFile = new File(reportFilename);
                        FTP_LOG.info("send " + reportFile + " to " + ftpRemoteDirectory + " as " + reportFile.getName());
                        if (!ftpClient.store(reportFile.getPath(), reportFile.getName())) {
                            FTP_LOG.error("unable to send file to " + ftpServer);
                        } else {
                            result = true;
                        }
                        if (!ftpClient.store(EOF_FILE_PATH, "EOF.TXT")) {
                            FTP_LOG.error("unable to send EOF.TXT file to " + ftpServer);
                        }
                    } else {
                        FTP_LOG.error("unable to log in to " + ftpServer);
                    }
                } else {
                    FTP_LOG.error("unable to connect to " + ftpServer);
                }
                String ftpLog = ftpClient.getLog();
                FTP_LOG.info("ftpLog: " + ftpLog);
                return result;
            }
            catch (Exception ex) {
                FTP_LOG.error("error sending file via ftp", ex);
                return result;
            }
            finally {
                FTP_LOG.info("closing ftp client");
                ftpClient.close();
            }
        } else {
            if (!"".equalsIgnoreCase(ftpServer)) {
                FTP_LOG.info("ftpServer not set");
                return true;
            } else {
                if (null != reportFilename) return true;
                FTP_LOG.info("report file is null");
            }
            return true;
        }
    }

    private void createEofTxtFile() {
        try {
            FileUtils.writeAllBytes(EOF_FILE_PATH, new byte[]{48});
        }
        catch (IOException ex) {
            FTP_LOG.error("error creating EOF.TXT file", ex);
        }
    }
}

