/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import com.integ.common.logging.AppLog;
import com.integ.common.logging.BakFileLog;
import com.integ.common.logging.Logger;
import com.integ.common.messagepump.MessagePumpEngine;
import com.integ.common.system.Application;
import com.wedauto.cameracounter.Config;
import com.wedauto.cameracounter.JniorConnection;
import com.wedauto.cameracounter.JniorConnectionListener;
import com.wedauto.cameracounter.TypeChangedListener;
import com.wedauto.cameracounter.messagehandlers.CurrentStateMessage;
import java.util.Date;
import java.util.EventObject;

public class TypeMonitor
implements JniorConnectionListener {
    private final Logger _log = BakFileLog.getLogger(Application.getAppName() + "_typemonitor.log");
    private TypeChangedListener _typeChangedListener;
    private JniorConnection[] _jniorConnections;
    private TypeHostInfo[] _typeHostInfo;
    private long _inputStates = 0L;
    public static int CurrentSelectedType = -1;

    void init() {
        int typeHostCount = Config.getTypeHostCount();
        System.out.println("typeHostCount: " + typeHostCount);
        this._jniorConnections = new JniorConnection[typeHostCount];
        this._typeHostInfo = new TypeHostInfo[typeHostCount];
        int startingInput = 1;
        for (int i = 0; i < typeHostCount; ++i) {
            String typeHostIpAddress = Config.getTypeHostIpAddress(i);
            if (null == typeHostIpAddress) continue;
            this._typeHostInfo[i] = new TypeHostInfo();
            this._typeHostInfo[i].StartingInput = startingInput;
            this._typeHostInfo[i].TypeStartingInput = Config.getTypeStartingInput(i);
            this._typeHostInfo[i].TypeInputCount = Config.getTypeInputCount(i);
            int endingInput = this._typeHostInfo[i].TypeInputCount + this._typeHostInfo[i].TypeStartingInput - 1;
            int channelMask = 4095;
            channelMask >>= 12 - endingInput;
            this._typeHostInfo[i].ChannelMask = channelMask <<= this._typeHostInfo[i].TypeStartingInput - 1;
            this._log.info(String.format("overall input %d will be assigned from %s on inputs from %d to %d.  mask is %x", this._typeHostInfo[i].StartingInput, typeHostIpAddress, this._typeHostInfo[i].TypeStartingInput, endingInput, this._typeHostInfo[i].ChannelMask));
            this._jniorConnections[i] = new JniorConnection();
            this._jniorConnections[i].setName("typemonitor_" + (i + 1));
            this._jniorConnections[i].setLog(BakFileLog.getLogger(Application.getAppName() + "_" + this._jniorConnections[i].getName() + ".log"));
            this._jniorConnections[i].addConnectionListener(this);
            this._jniorConnections[i].start();
            startingInput += this._typeHostInfo[i].TypeInputCount;
        }
    }

    void typeChangedListener(TypeChangedListener listener) {
        this._typeChangedListener = listener;
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        JniorConnection jniorConnection = (JniorConnection)evt.getSource();
        int jniorConnectionIndex = this.getIndexForConnection(jniorConnection);
        System.out.println("jniorConnection: " + jniorConnection + ", index: " + jniorConnectionIndex);
        if (-1 != jniorConnectionIndex && this._jniorConnections[jniorConnectionIndex] == jniorConnection) {
            this._jniorConnections[jniorConnectionIndex].setIpAddress(Config.getTypeHostIpAddress(jniorConnectionIndex));
            this._jniorConnections[jniorConnectionIndex].setPort(9200);
        }
    }

    private int getIndexForConnection(JniorConnection jniorConnection) {
        for (int i = 0; i < this._jniorConnections.length; ++i) {
            System.out.println("jniorConnection[" + i + "]: " + this._jniorConnections[i] + ", jniorConnection: " + jniorConnection);
            if (this._jniorConnections[i] != jniorConnection) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        JniorConnection jniorConnection = (JniorConnection)evt.getSource();
        this._log.info(String.format("%s connected", jniorConnection.getName()));
        this.determineSelectedTank(jniorConnection);
    }

    @Override
    public void connectionLost(EventObject evt) {
        JniorConnection jniorConnection = (JniorConnection)evt.getSource();
        this._log.warn(String.format("%s disconnected", jniorConnection.getName()));
    }

    @Override
    public void monitorReceived(EventObject evt) {
        JniorConnection jniorConnection = (JniorConnection)evt.getSource();
        this._log.info(String.format("%s monitor received, time: %s, inputs: %d, outputs: %d", jniorConnection.getName(), new Date(jniorConnection.getTime()).toString(), jniorConnection.getInputStates(), jniorConnection.getOutputStates()));
        this.determineSelectedTank(jniorConnection);
    }

    private void determineSelectedTank(JniorConnection jniorConnection) {
        try {
            int jniorConnectionIndex = this.getIndexForConnection(jniorConnection);
            System.out.println("jniorConnection: " + jniorConnection + ", index: " + jniorConnectionIndex);
            if (-1 != jniorConnectionIndex) {
                TypeHostInfo typeHostInfo = this._typeHostInfo[jniorConnectionIndex];
                int endingInput = typeHostInfo.TypeInputCount + typeHostInfo.TypeStartingInput - 1;
                long inputStates = jniorConnection.getInputStates();
                this._log.info("Input states for " + jniorConnection.getIPAddress() + ": " + (inputStates &= typeHostInfo.ChannelMask));
                this._log.info(String.format("overall input %d will be assigned from %s on inputs from %d to %d", this._typeHostInfo[jniorConnectionIndex].StartingInput, jniorConnection.getIPAddress(), typeHostInfo.TypeStartingInput, endingInput));
                long mask = 0L;
                mask = typeHostInfo.StartingInput >= typeHostInfo.TypeStartingInput ? typeHostInfo.ChannelMask << typeHostInfo.StartingInput - typeHostInfo.TypeStartingInput : typeHostInfo.ChannelMask >> typeHostInfo.TypeStartingInput - typeHostInfo.StartingInput;
                this._log.info(String.format("mask: 0x%llx", mask));
                mask = 0xFFFFFFFFFFFFFFFFL ^ mask;
                this._log.info(String.format("inverted mask: 0x%llx", mask));
                long adjustedInputStates = 0L;
                adjustedInputStates = typeHostInfo.StartingInput >= typeHostInfo.TypeStartingInput ? inputStates << typeHostInfo.StartingInput - typeHostInfo.TypeStartingInput : inputStates >> typeHostInfo.TypeStartingInput - typeHostInfo.StartingInput;
                this._log.info(String.format("adjustedInputStates: 0x%llx", adjustedInputStates));
                this._inputStates &= mask;
                this._log.info(String.format("_inputStates: 0x%16llx", this._inputStates));
                this._inputStates |= adjustedInputStates;
                this._log.info(String.format("_inputStates: 0x%16llx", this._inputStates));
                int currentSelectedType = 0;
                int inputChannel = 1;
                for (inputStates = this._inputStates; 0L != inputStates; inputStates >>= 1) {
                    if (1L == (inputStates & 1L)) {
                        if (1L != inputStates) {
                            currentSelectedType = -1;
                            break;
                        }
                        currentSelectedType = inputChannel;
                    }
                    ++inputChannel;
                }
                CurrentSelectedType = currentSelectedType;
                if (null != this._typeChangedListener) {
                    this._typeChangedListener.onTypeChanged(CurrentSelectedType);
                }
                try {
                    CurrentStateMessage currentStateMessage = new CurrentStateMessage();
                    MessagePumpEngine.postMessage(currentStateMessage.build());
                }
                catch (Throwable ex) {
                    AppLog.error("error updating current selected type", ex);
                }
            }
        }
        catch (Exception ex) {
            this._log.error("error determining destination tank", ex);
        }
    }

    class TypeHostInfo {
        public int TypeStartingInput;
        public int TypeInputCount;
        public int StartingInput;
        public long ChannelMask;

        TypeHostInfo() {
        }
    }
}

