/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

class TextCollector
implements Runnable {
    private ServerSocket socket = null;
    private Socket data = null;
    private InetAddress address = null;
    private int port = 0;
    private String content = "";
    private boolean running = false;
    private int so_timeout;
    private String log = "";
    private boolean secure;

    TextCollector(ServerSocket port, int to, boolean sec) {
        this.socket = port;
        this.so_timeout = to;
        this.secure = sec;
    }

    TextCollector(InetAddress addr, int portnum, int to, boolean sec) {
        this.address = addr;
        this.port = portnum;
        this.so_timeout = to;
        this.secure = sec;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.data = this.socket == null ? new Socket(this.address, this.port) : this.socket.accept();
            if (this.secure) {
                this.data.setSecure(true);
            }
            this.data.setSoTimeout(this.so_timeout);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.data.getInputStream()));
            try {
                String str;
                while ((str = in.readLine()) != null) {
                    this.content = this.content + str + "\r\n";
                }
            }
            catch (SocketTimeoutException ste) {
                this.logprintln(ste);
            }
            this.data.close();
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        this.running = false;
    }

    String getContent() {
        return this.content;
    }

    boolean isRunning() {
        return this.running;
    }

    void resetLog() {
        this.log = "";
    }

    void disableLog() {
        this.log = null;
    }

    String getLog() {
        return this.log;
    }

    private void logprintln(Object obj) {
        this.logprint(obj);
        this.logprint("\r\n");
    }

    private void logprint(Object obj) {
        if (this.log == null) {
            System.out.print(obj);
        } else {
            this.log = this.log + obj.toString();
        }
    }
}

