/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integ.common.utils.HexUtils;
import com.integpg.system.JANOS;
import com.wedauto.cameracounter.JniorConnectionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.EventObject;
import java.util.Vector;

public class JniorConnection
implements Runnable {
    public Vector _listeners = new Vector();
    private String _ipAddress;
    private int _port = 9200;
    private String _username = "jnior";
    private String _password = "jnior";
    private boolean shutdown = false;
    private boolean _goodConnection = false;
    private boolean _hasExtendedMonitorPacket = false;
    private String _model;
    private String _version;
    private int _inputCount;
    private int _outputCount;
    private int _inputs;
    private int _outputs;
    private long _time;
    private String _name = "<unknown>";
    private Logger _log = SystemOutLog.getLogger();

    public void setIpAddress(String ipAddress) {
        this._ipAddress = ipAddress;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setUserName(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public boolean getConnectionState() {
        return this._goodConnection;
    }

    public void addConnectionListener(JniorConnectionListener listener) {
        this._listeners.addElement(listener);
    }

    public String getModel() {
        return this._model;
    }

    public String getVersion() {
        return this._version;
    }

    public int getInputCount() {
        return this._inputCount;
    }

    public int getOutputCount() {
        return this._outputCount;
    }

    private void alertConnectionAttempt() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.connectionAttempt(new EventObject(this));
        }
    }

    private void alertConnectionEstablished() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.connectionEstablished(new EventObject(this));
        }
    }

    private void alertConnectionLost() {
        System.out.println("alerting connection lost");
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.connectionLost(new EventObject(this));
        }
    }

    public int getInputStates() {
        return this._inputs;
    }

    public int getOutputStates() {
        return this._outputs;
    }

    public long getTime() {
        return this._time;
    }

    public void start() {
        Thread thd = new Thread(this);
        thd.setDaemon(true);
        thd.setName(String.format("%s:%s", this.getClass().getName(), this.getName()));
        thd.start();
    }

    @Override
    public void run() {
        FilterInputStream jIn = null;
        FilterOutputStream jOut = null;
        long nextKeepAlive = 0L;
        Socket jRemote = null;
        byte MsgType = 0;
        this.shutdown = false;
        block21: while (!this.shutdown) {
            try {
                this.alertConnectionAttempt();
                if (null != this._ipAddress && !"0.0.0.0".equals(this._ipAddress)) {
                    int port = 0 != this._port ? this._port : 9200;
                    System.out.println(String.format("%s trying to connect to %s:%s", this.getName(), this._ipAddress, port));
                    jRemote = new Socket(InetAddress.getByName(this._ipAddress), port);
                    jRemote.setSoTimeout(60000);
                    this.alertConnectionEstablished();
                    jIn = new DataInputStream(jRemote.getInputStream());
                    jOut = new DataOutputStream(new BufferedOutputStream(jRemote.getOutputStream(), 4096));
                    ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
                    DataOutputStream data = new DataOutputStream(dataBytes);
                    data.writeByte(126);
                    this.writeString(this._username, data);
                    this.writeString(this._password, data);
                    System.out.println(this._name + "   Remote UserName: " + this._username);
                    System.out.println(this._name + "   Remote Password: " + this._password);
                    data.flush();
                    this.sendMsg(dataBytes.toByteArray(), (DataOutputStream)jOut);
                    nextKeepAlive = System.currentTimeMillis() + 300000L;
                    this._log.info("send login");
                    while (!this.shutdown) {
                        while (!this.shutdown) {
                            try {
                                while (((DataInputStream)jIn).readByte() != 1) {
                                }
                                break;
                            }
                            catch (SocketTimeoutException ex) {
                                if (System.currentTimeMillis() < nextKeepAlive) continue;
                                nextKeepAlive = System.currentTimeMillis() + 300000L;
                                this._log.info("Send keep-alive");
                                ((DataOutputStream)jOut).writeByte(6);
                                ((DataOutputStream)jOut).flush();
                            }
                            catch (InterruptedIOException iioe) {
                                throw new EOFException();
                            }
                        }
                        if (this.shutdown) {
                            this._log.info("shutdown");
                            continue block21;
                        }
                        byte[] msg = this.getMsg((DataInputStream)jIn);
                        if (msg == null || msg.length == 0) {
                            this.close();
                            continue;
                        }
                        this._goodConnection = true;
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(msg));
                        MsgType = in.readByte();
                        this._log.info(this._name + "   MsgType: " + MsgType + "\r\n" + HexUtils.hexDump(msg, 0, msg.length));
                        switch (MsgType) {
                            case 1: {
                                this.parseMonitor(in);
                                break;
                            }
                            case 2: {
                                this.parseExtendedMonitor(in);
                                break;
                            }
                            case 125: {
                                this._log.info(this._name + " login " + this._ipAddress + ":" + this._port);
                                break;
                            }
                        }
                    }
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                }
            }
            catch (EOFException ex) {
                block34: {
                    ex.printStackTrace();
                    try {
                        if (!this._goodConnection) {
                            this.alertConnectionLost();
                        }
                        this._goodConnection = false;
                        if (jIn != null) {
                            jIn.close();
                        }
                        if (jOut != null) {
                            jOut.close();
                        }
                        if (jRemote == null) break block34;
                        jRemote.close();
                    }
                    catch (IOException ioe4) {
                        ioe4.printStackTrace();
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                }
            }
            catch (IOException ex) {
                block35: {
                    Throwable t = new Exception("unable to connect to " + this._ipAddress).initCause(ex);
                    t.printStackTrace();
                    try {
                        if (jIn != null) {
                            jIn.close();
                        }
                        if (jOut != null) {
                            jOut.close();
                        }
                        if (jRemote == null) break block35;
                        jRemote.close();
                    }
                    catch (IOException ioe3) {
                        ioe3.printStackTrace();
                        break;
                    }
                }
                if (!this._goodConnection) {
                    this.alertConnectionLost();
                }
                this._goodConnection = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        this._log.info(this._name + " connection ended");
    }

    private void parseMonitor(DataInputStream in) throws IOException {
        byte state;
        int n;
        int inputs = 0;
        int outputs = 0;
        String modelAndVersion = this.readString(in);
        if (null == this._model) {
            this._model = modelAndVersion.substring(0, modelAndVersion.indexOf(" "));
            System.out.println("model: " + this._model);
            int n2 = this._model.startsWith("412") ? 4 : (this._inputCount = this._model.startsWith("414") ? 12 : 8);
            this._outputCount = this._model.startsWith("412") ? 12 : (this._model.startsWith("414") ? 4 : 8);
            this._version = modelAndVersion.substring(modelAndVersion.indexOf(" ") + 1);
            this._hasExtendedMonitorPacket = 8 < this._inputCount || 8 < this._outputCount;
        }
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            inputs |= state << n;
            in.skip(7L);
        }
        this._inputs = inputs;
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            outputs |= state << n;
        }
        this._outputs = outputs & 0xFFFF;
        this._time = in.readLong();
        if (!this._hasExtendedMonitorPacket) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
                jcl.monitorReceived(new EventObject(this));
            }
        }
    }

    private void parseExtendedMonitor(DataInputStream in) throws IOException {
        byte state;
        int inputs = this._inputs;
        int outputs = this._outputs;
        int inputCount = in.readByte();
        for (int n = 0; n < inputCount; ++n) {
            int channel = n + 8;
            state = in.readByte();
            inputs |= state << channel;
            in.skipBytes(7);
        }
        this._inputs = inputs;
        int outputCount = in.readByte();
        for (int n = 0; n < outputCount; ++n) {
            state = in.readByte();
            outputs |= state << n + 8;
        }
        this._outputs = outputs & 0xFFFF;
        long time = in.readLong();
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorConnectionListener jcl = (JniorConnectionListener)this._listeners.elementAt(i);
            jcl.monitorReceived(new EventObject(this));
        }
    }

    private String readString(DataInputStream in) throws IOException {
        byte[] bData = new byte[in.readByte() & 0xFF];
        in.read(bData);
        return new String(bData);
    }

    private void writeString(String str, DataOutputStream out) throws IOException {
        if (str.length() < 255) {
            out.writeByte(str.length());
            out.writeBytes(str);
        } else {
            out.writeByte(255);
            out.writeBytes(str.substring(0, 255));
        }
    }

    private byte[] getMsg(DataInputStream in) throws IOException {
        short len = in.readShort();
        int crc = in.readShort() & 0xFFFF;
        if (0 < len && 1024 > len) {
            byte[] data = new byte[len];
            in.read(data);
            if (crc != JANOS.CRC16((byte[])data, (int)0, (int)len, (int)0)) {
                return null;
            }
            return data;
        }
        return null;
    }

    private void sendMsg(byte[] message, DataOutputStream out) throws IOException {
        if (message == null) {
            return;
        }
        out.writeByte(1);
        out.writeShort(message.length);
        out.writeShort(JANOS.CRC16((byte[])message, (int)0, (int)message.length, (int)0));
        out.write(message);
        out.flush();
    }

    public void close() {
        System.out.println("Close");
        this.shutdown = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }
}

