/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

class FileRetrieve
implements Runnable {
    private ServerSocket socket = null;
    private Socket data = null;
    private InetAddress address = null;
    private int port = 0;
    private boolean running = false;
    private String log = "";
    private String filename;
    private boolean secure;

    FileRetrieve(String file, ServerSocket port, boolean sec) {
        this.filename = file;
        this.socket = port;
        this.secure = sec;
    }

    FileRetrieve(String file, InetAddress addr, int portnum, boolean sec) {
        this.filename = file;
        this.address = addr;
        this.port = portnum;
        this.secure = sec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        char[] bufr = new char[8192];
        OutputStreamWriter file = null;
        BufferedReader in = null;
        try {
            file = new FileWriter(this.filename);
            this.data = this.socket == null ? new Socket(this.address, this.port) : this.socket.accept();
            if (this.secure) {
                this.data.setSecure(true);
            }
            in = new BufferedReader(new InputStreamReader(this.data.getInputStream()));
            try {
                int nread;
                while ((nread = in.read(bufr)) > 0) {
                    file.write(bufr, 0, nread);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        finally {
            try {
                file.close();
                in.close();
                this.data.close();
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.running = false;
    }

    boolean isRunning() {
        return this.running;
    }

    void resetLog() {
        this.log = "";
    }

    void disableLog() {
        this.log = null;
    }

    String getLog() {
        return this.log;
    }

    private void logprintln(Object obj) {
        this.logprint(obj);
        this.logprint("\r\n");
    }

    private void logprint(Object obj) {
        if (this.log == null) {
            System.out.print(obj);
        } else {
            this.log = this.log + obj.toString();
        }
    }
}

