/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import com.integ.common.logging.AppLog;
import com.integ.common.messagepump.MessagePumpAppHandler;
import com.integ.common.messagepump.MessagePumpEngine;
import com.integ.common.system.Application;
import com.integ.common.utils.StringUtils;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.PortInUseException;
import com.integpg.comm.SerialPort;
import com.integpg.comm.UnsupportedCommOperationException;
import com.wedauto.cameracounter.AssemblyInfo;
import com.wedauto.cameracounter.Config;
import com.wedauto.cameracounter.TypeChangedListener;
import com.wedauto.cameracounter.TypeMonitor;
import com.wedauto.cameracounter.messagehandlers.ConfigUpdatedEventHandler;
import com.wedauto.cameracounter.messagehandlers.CurrentStateMessage;
import com.wedauto.cameracounter.messagehandlers.GetStateEventHandler;
import com.wedauto.cameracounter.messagehandlers.RebootEventHandler;
import com.wedauto.cameracounter.reporting.Report;
import com.wedauto.cameracounter.reporting.ReportDeliveryTask;
import java.io.IOException;
import java.io.InputStream;

public class CameraCounterMain
implements TypeChangedListener {
    public static final AssemblyInfo AssemblyInfo = new AssemblyInfo();
    private static final CameraCounterMain INSTANCE = new CameraCounterMain();
    private SerialPort _serialPort;
    private InputStream _inputStream;
    private String _cameraType;
    private int _loafType;

    public static void main(String[] args) {
        Application.init(AssemblyInfo);
        try {
            INSTANCE.init(args);
            INSTANCE.run();
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            try {
                AppLog.info("Sleeping forever.  The JNIOR must be rebooted");
                CurrentStateMessage.setRebootNeeded(true);
                CurrentStateMessage currentStateMessage = new CurrentStateMessage();
                MessagePumpEngine.postMessage(currentStateMessage.build());
                Thread.sleep(Integer.MAX_VALUE);
            }
            catch (Exception ex1) {
                AppLog.error(ex1);
            }
        }
    }

    public void init(String[] args) throws Throwable {
        AppLog.info("add web page listeners");
        MessagePumpAppHandler snapAppListener = new MessagePumpAppHandler(10510).addCommandListener("config.updated", new ConfigUpdatedEventHandler()).addCommandListener("state.get", new GetStateEventHandler()).addCommandListener("reboot.execute", new RebootEventHandler());
        MessagePumpEngine.addListener(snapAppListener);
        AppLog.info("start message pump engine");
        MessagePumpEngine.start();
        AppLog.info("initialize configuration");
        Config.init();
        this._cameraType = Config.getCameraType();
        System.out.println("cameraType " + this._cameraType);
        if (!"A".equalsIgnoreCase(this._cameraType) && !"B".equalsIgnoreCase(this._cameraType)) {
            throw new RuntimeException("Camera Type must be A or B.  Please set the Type and reboot.");
        }
        AppLog.info("acquire serial port");
        this.openSerialPort();
        AppLog.info("start type monitors");
        TypeMonitor typeMonitor = new TypeMonitor();
        typeMonitor.typeChangedListener(this);
        typeMonitor.init();
        AppLog.info("start report delivery task");
        ReportDeliveryTask reportDeliveryTask = new ReportDeliveryTask();
        reportDeliveryTask.start();
    }

    @Override
    public void onTypeChanged(int newType) {
        this._loafType = newType;
    }

    private void openSerialPort() throws Throwable {
        try {
            this._serialPort = new AUXSerialPort();
            this._serialPort.open();
            this._serialPort.setSerialPortParams(115200, 8, 1, 0);
            this._inputStream = this._serialPort.getInputStream();
        }
        catch (PortInUseException | UnsupportedCommOperationException | IOException ex) {
            Throwable throwable = new Exception("There was an error gaining access to the AUX Serial Port.  This application cannot function and will be shut down.").initCause(ex);
            throw throwable;
        }
    }

    public void run() throws Throwable {
        AppLog.info("start reading from serial port");
        StringBuilder sb = new StringBuilder();
        while (true) {
            String terminationString = Config.getTerminationString();
            try {
                int b;
                sb.setLength(0);
                while (-1 != (b = this._inputStream.read())) {
                    sb.append((char)b);
                    int terminationPos = sb.indexOf(terminationString);
                    if (-1 == terminationPos) continue;
                    break;
                }
            }
            catch (IOException ex) {
                AppLog.error("error getting message from the serial port");
                break;
            }
            if (0 == sb.length()) continue;
            try {
                int terminationPos = sb.indexOf(terminationString);
                sb.setLength(terminationPos);
                long timestamp = System.currentTimeMillis();
                String s = sb.toString();
                System.out.println(String.format("read %s from serial port", s));
                String[] parts = StringUtils.split(s, ",");
                int quantity = Integer.parseInt(parts[0]);
                String returnCode = "";
                if (1 < parts.length) {
                    returnCode = parts[1];
                }
                Report.makeEntry(timestamp, quantity, this._loafType, returnCode);
            }
            catch (Exception ex) {
                AppLog.error("error parsing serial data: :" + sb.toString(), ex);
            }
        }
        AppLog.error("main loop done");
    }
}

