App.controller('Controller', function ($scope, $location) {
    var _this = this;
    _this.SerialNumber = '#########';
    _this.Connected = false;
    _this.Config = { TerminationString: "\\r\\n", ReportSendIntervalInMinutes: 60 };
    _this.SavedConfig = angular.copy(_this.Config);
    _this.SelectedType = -1;
    _this.RebootNeeded = false;


    // instantiate our JniorConfigStorage class and pass in our websocket object
    var jniorConfigStorage = new JniorConfigStorage(jnrWebsocket, '/flash/wedauto/cameracounter/config.json');

    // onLoggedIn callback.  this is where we will read the config file
    jnrWebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log('onLoggedIn');
        _this.readConfig();

        jnrWebsocket.mkDir("/flash/wedauto", function (json) {
            if ("Succeed" == json.Result) {
                jnrWebsocket.mkDir("/flash/wedauto/cameracounter", function (json) {
                });
            }
        });

        jnrWebsocket.postMessage(APP_ID, { Message: 'state.get' });

        jnrWebsocket.readRegistryKeys(
            ["$serialnumber", "ipconfig/hostname"],
            function (key, value) {
                if (key.endsWith('serialnumber')) _this.SerialNumber = value;
                else if (key.endsWith('hostname')) _this.HostName = value;

                $scope.$apply();
            }
        );

        jnrWebsocket.addEventListener('onMessage', _this.onMessage);

        $scope.$apply();
    });



    jnrWebsocket.onClosed = function () {
        _this.Connected = false;

        $scope.$apply();
    };



    _this.hasChanged = function (config, savedConfig) {
        var changed = !angular.equals(config, savedConfig);
        return changed;
    };



    _this.readConfig = function () {
        jniorConfigStorage.readConfig(function (result, config) {
            if ('Fail' !== result) {
                _this.Config = config;

                _this.SavedConfig = angular.copy(_this.Config);
                console.log('Config: ' + _this.Config);

                $scope.$apply();
            }
        });
    };


    _this.validate = function () {
        //
        // go through each type host.  make sure that the model has enough inputs for the
        // configured starting input + input count

        if (!$scope.Form.$valid) {
            bootbox.alert({
                className: 'bb-danger',
                title: 'Errors detected',
                message: 'There are errors.  Please fix the errors and try again.'
            });
            return false;
        }
        return true;
    };


    _this.saveChangesRequest = function () {
        if (!_this.validate()) return;

        _this.SaveDialog = bootbox.confirm({
            className: "bb-primary",
            title: "Are you sure you want to save your changes?",
            message: "You will need to reboot for the changes to take affect.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-primary'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.saveChanges();
                    return false;
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });

    };


    _this.saveChanges = function () {
        jniorConfigStorage.Config = _this.Config;
        jniorConfigStorage.saveConfig(function (status) {
            if ('Fail' !== status) {
                _this.SavedConfig = angular.copy(_this.Config);
                $scope.$apply();

                jnrWebsocket.postMessage(APP_ID, { Message: 'config.updated' });

                _this.SaveDialog.modal('hide');
            } else {
                alert('error saving the file');
            }
        });
    };


    _this.cancelChangesRequest = function () {
        _this.CancelDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            buttons: {
                cancel: {
                    label: 'Keep Changes',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Cancel Changes',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.cancelChanges();
                    return false;
                }
            }
        });
        _this.CancelDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.cancelChanges = function () {
        _this.Config = angular.copy(_this.SavedConfig);
        $scope.$apply();

        _this.CancelDialog.modal('hide');
    };



    _this.sendReboot = function () {
        jnrWebsocket.postMessage(APP_ID, { Message: 'reboot.execute' });
    };



    _this.onMessage = function (json) {
        var message = json.Message;

        if ('state.update' === message) {
            _this.Connected = true;

            _this.SelectedType = json.SelectedType;
            _this.RebootNeeded = json.RebootNeeded;

            $scope.$apply();
        }
    };



    _this.getTypesMonitored = function (index) {
        var startingTypeIndex = 1;
        for (var i = 0; i <= index; i++) {
            //
            // get the type host by index
            var typeHost = _this.Config.TypeHosts[i];
            if (typeHost) {
                if (i == index) {
                    var endingTypeIndex = startingTypeIndex + typeHost.InputCount - 1;
                    return startingTypeIndex + " - " + endingTypeIndex;
                }

                startingTypeIndex += typeHost.InputCount;
            }
        }
    };



    _this.addTypeHost = function () {
        if (!_this.Config.TypeHosts) _this.Config.TypeHosts = [];
        _this.Config.TypeHosts.push({});
    };



    _this.moveTypeHostUp = function (typeHost) {
        var typeHostIndex = _this.Config.TypeHosts.indexOf(typeHost);
        if (-1 != typeHostIndex) {
            array_move(_this.Config.TypeHosts, typeHostIndex, typeHostIndex - 1);
        }
    };



    _this.moveTypeHostDown = function (typeHost) {
        var typeHostIndex = _this.Config.TypeHosts.indexOf(typeHost);
        if (-1 != typeHostIndex) {
            array_move(_this.Config.TypeHosts, typeHostIndex, typeHostIndex + 1);
        }
    };



    function array_move(arr, old_index, new_index) {
        if (new_index >= arr.length) {
            var k = new_index - arr.length + 1;
            while (k--) {
                arr.push(undefined);
            }
        }
        arr.splice(new_index, 0, arr.splice(old_index, 1)[0]);
        return arr; // for testing
    };



    _this.removeTypeHost = function (typeHost) {
        var typeHostIndex = _this.Config.TypeHosts.indexOf(typeHost);
        if (-1 != typeHostIndex) {
            _this.Config.TypeHosts.splice(typeHostIndex, 1)
        }
    };
});