/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

class FileStore
implements Runnable {
    private ServerSocket socket = null;
    private Socket data = null;
    private InetAddress address = null;
    private int port = 0;
    private boolean running = false;
    private String log = "";
    private String filename;
    private boolean secure;

    FileStore(String file, ServerSocket port, boolean sec) {
        this.filename = file;
        this.socket = port;
        this.secure = sec;
    }

    FileStore(String file, InetAddress addr, int portnum, boolean sec) {
        this.filename = file;
        this.address = addr;
        this.port = portnum;
        this.secure = sec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        char[] bufr = new char[1400];
        FileReader file = null;
        BufferedWriter out = null;
        try {
            int nread;
            file = new FileReader(this.filename);
            this.data = this.socket == null ? new Socket(this.address, this.port) : this.socket.accept();
            if (this.secure) {
                this.data.setSecure(true);
            }
            out = new BufferedWriter(new OutputStreamWriter(this.data.getOutputStream()));
            while ((nread = file.read(bufr)) > 0) {
                out.write(bufr, 0, nread);
                out.flush();
            }
            out.close();
            file.close();
            this.data.close();
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (out != null) {
                    out.close();
                }
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (IOException ex) {
                this.logprintln(ex);
            }
        }
        this.running = false;
    }

    boolean isRunning() {
        return this.running;
    }

    void resetLog() {
        this.log = "";
    }

    void disableLog() {
        this.log = null;
    }

    String getLog() {
        return this.log;
    }

    private void logprintln(Object obj) {
        this.logprint(obj);
        this.logprint("\r\n");
    }

    private void logprint(Object obj) {
        if (this.log == null) {
            System.out.print(obj);
        } else {
            this.log = this.log + obj.toString();
        }
    }
}

