/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import com.integpg.net.FileEntry;
import com.wedauto.cameracounter.FileRetrieve;
import com.wedauto.cameracounter.FileStore;
import com.wedauto.cameracounter.TextCollector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.QuickDateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FTPClient {
    private static final QuickDateFormat DATE_FORMAT = QuickDateFormat.getDefault();
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private int so_timeout = 10000;
    private StringBuffer logb = null;
    private boolean passive = false;
    private boolean secure = false;

    public boolean connect(String server) {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = new Socket(server, 21);
            this.out = new PrintWriter(this.socket.getOutputStream());
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.secure = false;
            String resp = this.getresponse();
            if (this.responseStatus(resp) == 2) {
                return true;
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        return false;
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    public void setSoTimeout(int to) {
        this.so_timeout = to;
    }

    public void setPassive(boolean mode) {
        this.passive = mode;
    }

    public void resetLog() {
        this.logb = new StringBuffer(2048);
    }

    public void enableLog(boolean enable) {
        this.logb = enable ? new StringBuffer(2048) : null;
    }

    public String getLog() {
        return this.logb.toString();
    }

    public boolean login(String user, String pass) {
        try {
            if (this.socket == null) {
                return false;
            }
            String resp = this.command("USER " + user);
            if (this.responseCode(resp) != 331) {
                return false;
            }
            this.logprintln("PASS *****");
            this.out.println("PASS " + pass);
            this.out.flush();
            resp = this.getresponse();
            if (this.responseStatus(resp) == 2) {
                return true;
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        return false;
    }

    public boolean auth() {
        try {
            String resp = this.command("AUTH TLS");
            if (this.responseStatus(resp) == 2) {
                this.socket.setSecure(true);
                this.secure = true;
                this.command("PBSZ 0");
                this.command("PROT P");
                return true;
            }
        }
        catch (Exception ex) {
            this.logprintln(ex);
        }
        return false;
    }

    public String cdup() {
        return this.command("CDUP");
    }

    public String cwd(String dir) {
        return this.command("CWD " + dir);
    }

    public boolean delete(String file) {
        if (this.socket == null) {
            return false;
        }
        String resp = this.command("DELE " + file);
        return this.responseCode(resp) == 250;
    }

    public String feat() {
        return this.command("FEAT");
    }

    public String list(boolean nlst) {
        return this.command(nlst ? "NLST" : "LIST");
    }

    public String mdtm(String file) {
        if (this.socket == null) {
            return null;
        }
        return this.command("MDTM " + file);
    }

    public String mfmt(String file, String filedate) {
        if (this.socket == null) {
            return null;
        }
        return this.command("MFMT " + filedate + " " + file);
    }

    public boolean mkdir(String dir) {
        if (this.socket == null) {
            return false;
        }
        String resp = this.command("MKD " + dir);
        return this.responseCode(resp) == 250;
    }

    public String mlsd(String dir) {
        if (this.socket == null) {
            return null;
        }
        return this.command(dir == null ? "MLSD" : "MLSD " + dir);
    }

    public String mlst(String file) {
        if (this.socket == null) {
            return null;
        }
        return this.command(file == null ? "MLST" : "MLST " + file);
    }

    public String noop() {
        return this.command("NOOP");
    }

    public String pwd() {
        if (this.socket == null) {
            return null;
        }
        String resp = this.command("PWD");
        int pos1 = resp.indexOf(34);
        int pos2 = resp.lastIndexOf(34);
        if (pos1 > 3 && pos2 > pos1 + 1) {
            return resp.substring(pos1 + 1, pos2);
        }
        return "";
    }

    public String port(InetAddress addr, int portnum) {
        byte[] ip = addr.getAddress();
        return this.command("PORT " + Integer.toString(ip[0] & 0xFF) + "," + Integer.toString(ip[1] & 0xFF) + "," + Integer.toString(ip[2] & 0xFF) + "," + Integer.toString(ip[3] & 0xFF) + "," + Integer.toString(portnum / 256) + "," + Integer.toString(portnum & 0xFF));
    }

    public String quit() {
        return this.command("QUIT");
    }

    public boolean rename(String from, String to) {
        if (this.socket == null) {
            return false;
        }
        String resp = this.command("RNFR " + from);
        if (this.responseCode(resp) != 350) {
            return false;
        }
        resp = this.command("RNTO " + to);
        return this.responseCode(resp) == 250;
    }

    public boolean rmdir(String dir) {
        if (this.socket == null) {
            return false;
        }
        String resp = this.command("RMD " + dir);
        return this.responseCode(resp) == 250;
    }

    public int size(String file) {
        if (this.socket == null) {
            return 0;
        }
        String resp = this.command("SIZE " + file);
        if (this.responseCode(resp) == 213) {
            return Integer.parseInt(resp.substring(4));
        }
        return 0;
    }

    public String syst() {
        return this.command("SYST");
    }

    public String type(String stype) {
        if (this.socket == null) {
            return null;
        }
        return this.command("TYPE " + stype);
    }

    public int[] pasv() {
        int[] params = new int[6];
        if (this.socket == null) {
            return null;
        }
        String resp = this.command("PASV");
        if (this.responseCode(resp) != 227) {
            return null;
        }
        int n = 0;
        int p = 4;
        while (n < 6 && p < resp.length()) {
            char ch;
            if (!Character.isDigit(resp.charAt(p))) {
                ++p;
                continue;
            }
            int b = 0;
            while (Character.isDigit(ch = resp.charAt(p++))) {
                if ((b = 10 * b + (ch - 48)) < 256) continue;
                return null;
            }
            params[n++] = b;
        }
        return params;
    }

    public String dir(boolean nlst) {
        String content = "";
        ServerSocket port = null;
        try {
            TextCollector dc;
            if (this.passive) {
                int[] params = this.pasv();
                if (params == null) {
                    return content;
                }
                int address = params[0] << 24 | params[1] << 16 | params[2] << 8 | params[3];
                InetAddress addr = new InetAddress(address);
                int portnum = params[4] << 8 | params[5];
                dc = new TextCollector(addr, portnum, this.so_timeout, this.secure);
            } else {
                port = new ServerSocket(0);
                InetAddress address = InetAddress.getLocalHost();
                int portnum = port.getLocalPort();
                this.port(address, portnum);
                dc = new TextCollector(port, this.so_timeout, this.secure);
            }
            new Thread(dc).start();
            String resp = this.list(nlst);
            while (this.responseStatus(resp) == 1) {
                resp = this.getresponse();
            }
            if (this.responseStatus(resp) == 2) {
                while (dc.isRunning()) {
                    this.sleep(50);
                }
            }
            if (dc.getLog() != null) {
                this.logprint(dc.getLog());
            }
            if (port != null) {
                port.close();
            }
            content = dc.getContent();
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        return content;
    }

    public FileEntry[] parseDir(String listing) {
        int format = -1;
        int year = -1;
        FileEntry[] list = new FileEntry[]{};
        BufferedReader str = new BufferedReader(new StringReader(listing));
        try {
            String line;
            while ((line = str.readLine()) != null) {
                int n;
                line = line.trim();
                int len = this.tokenlen(line, 0);
                if (format == -1) {
                    for (n = 0; n < len && "-drwx".indexOfChar((int)line.charAt(n), 0) != -1; ++n) {
                    }
                    if (n == len) {
                        format = 1;
                        Date dt = new Date();
                        year = dt.getYear() + 1900;
                    } else {
                        for (n = 0; n < len && "-/0123456789".indexOfChar((int)line.charAt(n), 0) != -1; ++n) {
                        }
                        if (n != len) continue;
                        format = 2;
                    }
                }
                FileEntry fe = new FileEntry();
                if (format == 1) {
                    if (line.charAt(0) == 'd') {
                        fe.directory = true;
                    }
                    n = this.nexttoken(line, 0);
                    n = this.nexttoken(line, n);
                    n = this.nexttoken(line, n);
                    n = this.nexttoken(line, n);
                    fe.size = Integer.parseInt(line.substring(n, n + this.tokenlen(line, n)));
                    n = this.nexttoken(line, n);
                    len = this.nexttoken(line, n);
                    len = this.nexttoken(line, len);
                    len += this.tokenlen(line, len);
                    fe.modified = Date.parse(line.substring(n, len));
                    n = this.nexttoken(line, len);
                    fe.name = line.substring(n);
                } else {
                    len = this.nexttoken(line, 0);
                    len += this.tokenlen(line, len);
                    fe.modified = Date.parse(line.substring(0, len));
                    n = this.nexttoken(line, len);
                    String ssize = line.substring(n, n + this.tokenlen(line, n));
                    if (ssize.toLowerCase().indexOf("dir") >= 0) {
                        fe.directory = true;
                    } else {
                        fe.size = Integer.parseInt(ssize);
                    }
                    n = this.nexttoken(line, n);
                    fe.name = line.substring(n);
                }
                FileEntry[] copy = list;
                list = new FileEntry[copy.length + 1];
                for (n = 0; n < copy.length; ++n) {
                    list[n] = copy[n];
                }
                list[n] = fe;
            }
        }
        catch (IOException ex) {
            this.logprintln(ex);
        }
        return list;
    }

    private int nexttoken(String str, int pos) {
        int end = str.length();
        while (pos < end && str.charAt(pos) != ' ') {
            ++pos;
        }
        while (pos < end && str.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos == end) {
            pos = -1;
        }
        return pos;
    }

    private int tokenlen(String str, int pos) {
        int end = str.length();
        int ptr = pos;
        while (pos < end && str.charAt(ptr) != ' ') {
            ++ptr;
        }
        return ptr - pos;
    }

    public boolean retrieve(String dstfile, String remotefile) {
        ServerSocket port = null;
        try {
            FileRetrieve fr;
            if (this.passive) {
                int[] params = this.pasv();
                if (params == null) {
                    return false;
                }
                int address = params[0] << 24 | params[1] << 16 | params[2] << 8 | params[3];
                InetAddress addr = new InetAddress(address);
                int portnum = params[4] << 8 | params[5];
                fr = new FileRetrieve(dstfile, addr, portnum, this.secure);
            } else {
                port = new ServerSocket(0);
                InetAddress address = InetAddress.getLocalHost();
                int portnum = port.getLocalPort();
                this.port(address, portnum);
                fr = new FileRetrieve(dstfile, port, this.secure);
            }
            new Thread(fr).start();
            String resp = this.command("RETR " + remotefile);
            if (this.responseStatus(resp) == 5) {
                return false;
            }
            while (this.responseStatus(resp) == 1) {
                resp = this.getresponse();
            }
            while (fr.isRunning()) {
                this.sleep(50);
            }
            if (fr.getLog() != null) {
                this.logprint(fr.getLog());
            }
            if (port != null) {
                port.close();
            }
            if (this.responseCode(resp = this.command("MDTM " + remotefile)) == 213 && resp.length() >= 18) {
                int yr = Integer.parseInt(resp.substring(4, 8)) - 1900;
                int mon = Integer.parseInt(resp.substring(8, 10)) - 1;
                int day = Integer.parseInt(resp.substring(10, 12));
                int hr = Integer.parseInt(resp.substring(12, 14));
                int min = Integer.parseInt(resp.substring(14, 16));
                int sec = Integer.parseInt(resp.substring(16, 18));
                Date dt = new Date(yr, mon, day, hr, min, sec);
                File file = new File(dstfile);
                file.setLastModified(dt.getTime());
            }
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(String srcfile, String remotefile) {
        ServerSocket port = null;
        try {
            FileStore fs;
            if (this.passive) {
                int[] params = this.pasv();
                if (params == null) {
                    boolean bl = false;
                    return bl;
                }
                int n = params[0] << 24 | params[1] << 16 | params[2] << 8 | params[3];
                InetAddress addr = new InetAddress(n);
                int portnum2 = params[4] << 8 | params[5];
                fs = new FileStore(srcfile, addr, portnum2, this.secure);
            } else {
                port = new ServerSocket(0);
                InetAddress address = InetAddress.getLocalHost();
                int n = port.getLocalPort();
                this.port(address, n);
                fs = new FileStore(srcfile, port, this.secure);
            }
            String resp = this.command("STOR " + remotefile);
            if (this.responseStatus(resp) == 5) {
                boolean bl = false;
                return bl;
            }
            new Thread(fs).start();
            while (this.responseStatus(resp) == 1) {
                resp = this.getresponse();
            }
            while (fs.isRunning()) {
                this.sleep(50);
            }
            if (fs.getLog() != null) {
                this.logprint(fs.getLog());
            }
            File file = new File(srcfile);
            long timestamp = file.lastModified();
            Date dt = new Date(timestamp);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            this.command("MFMT " + format.format(dt) + " " + remotefile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
            this.logprintln(ioe);
        }
        finally {
            if (port != null) {
                try {
                    port.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        return true;
    }

    public String command(String cmd) {
        try {
            if (this.socket == null) {
                return "";
            }
            this.logprintln(cmd);
            this.out.println(cmd);
            this.out.flush();
            return this.getresponse();
        }
        catch (IOException ioe) {
            this.logprintln(ioe);
            return "";
        }
    }

    private String getresponse() throws IOException {
        String str;
        String response = this.in.readLine();
        if (response == null) {
            throw new IOException("no response");
        }
        if (response.length() < 4 || response.charAt(3) == ' ') {
            this.logprintln(response);
            return response;
        }
        while ((str = this.in.readLine()) != null) {
            response = response + "\r\n" + str;
            if (str.length() < 4 || str.substring(0, 3).compareTo(response.substring(0, 3)) != 0 || str.charAt(3) != ' ') continue;
        }
        this.logprintln(response);
        return response;
    }

    public int responseCode(String response) {
        return Integer.parseInt(response.substring(0, 3));
    }

    public int responseStatus(String response) {
        return Integer.parseInt(response.substring(0, 1));
    }

    public int responsePurpose(String response) {
        return Integer.parseInt(response.substring(1, 2));
    }

    private void logprintln(Object obj) {
        this.logprint(String.format("%s, %s\r\n", DATE_FORMAT.format(), obj.toString()));
    }

    private void logprint(Object obj) {
        if (this.logb != null) {
            this.logb.append(obj.toString());
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.socket != null;
    }
}

