/*
 * Decompiled with CFR 0.152.
 */
package com.wedauto.cameracounter;

import com.integ.common.logging.AppLog;
import com.integ.common.system.Application;
import com.integ.common.utils.FileUtils;
import com.integ.common.utils.StringUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class Config {
    private static final String APPDATA_ROOT = "AppData/" + Application.getAppName();
    private static final String WEDAUTO_PATH = "/flash/wedauto";
    private static final String APPLICATION_PATH = String.format("%s/%s", "/flash/wedauto", Application.getAppName().toLowerCase());
    private static final String JSON_CONFIG_PATH = String.format("%s/%s", APPLICATION_PATH, "config.json");
    private static Json JSON_CONFIG = new Json();

    static void init() {
        new File(WEDAUTO_PATH).mkdir();
        new File(APPLICATION_PATH).mkdir();
        if (new File(JSON_CONFIG_PATH).exists()) {
            try {
                String jsonConfigFileContents = FileUtils.readAllText(JSON_CONFIG_PATH);
                JSON_CONFIG = new Json(jsonConfigFileContents);
                System.out.println("JSON_CONFIG: " + JSON_CONFIG);
            }
            catch (IOException ex) {
                AppLog.error("error reading configuration json file", ex);
            }
        } else {
            Json hostJson;
            JSON_CONFIG.put("CameraType", (Object)Config.getAndEraseRegistryString(String.format("%s/CameraType", APPDATA_ROOT), "A/B"));
            JSON_CONFIG.put("CameraId", (Object)Config.getAndEraseRegistryString(String.format("%s/CameraId", APPDATA_ROOT), "ID"));
            JSON_CONFIG.put("TerminationString", (Object)Config.getAndEraseRegistryString(String.format("%s/TerminationString", APPDATA_ROOT), "\n"));
            JSON_CONFIG.put("ReportSendIntervalInMinutes", Config.getAndEraseRegistryInt(String.format("%s/ReportSendIntervalInMinutes", APPDATA_ROOT), 60));
            JSON_CONFIG.put("EngineeringEmailRecipients", (Object)Config.getAndEraseRegistryString(String.format("%s/EngineeringEmailRecipients", APPDATA_ROOT), ""));
            JSON_CONFIG.put("ProductionEmailRecipients", (Object)Config.getAndEraseRegistryString(String.format("%s/ProductionEmailRecipients", APPDATA_ROOT), ""));
            JSON_CONFIG.put("FtpServer", (Object)Config.getAndEraseRegistryString(String.format("%s/FtpServer", APPDATA_ROOT), ""));
            JSON_CONFIG.put("FtpRemoteDirectory", (Object)Config.getAndEraseRegistryString(String.format("%s/FtpRemoteDirectory", APPDATA_ROOT), ""));
            JSON_CONFIG.put("FtpUsername", (Object)Config.getAndEraseRegistryString(String.format("%s/FtpUsername", APPDATA_ROOT), ""));
            JSON_CONFIG.put("FtpPassword", (Object)Config.getAndEraseRegistryString(String.format("%s/FtpPassword", APPDATA_ROOT), ""));
            ArrayList<Json> typeHostsList = new ArrayList<Json>();
            String hostIpAddress = Config.getAndEraseRegistryString(String.format("%s/TypeHost1", APPDATA_ROOT), "");
            if (!"none".equalsIgnoreCase(hostIpAddress)) {
                hostJson = new Json();
                hostJson.put("IpAddress", (Object)hostIpAddress);
                hostJson.put("StartingInput", Config.getAndEraseRegistryInt(String.format("%s/TypeStartingInput1", APPDATA_ROOT), 1));
                hostJson.put("InputCount", Config.getAndEraseRegistryInt(String.format("%s/TypeInputCount1", APPDATA_ROOT), 1));
                typeHostsList.add(hostJson);
            }
            if (!"none".equalsIgnoreCase(hostIpAddress = Config.getAndEraseRegistryString(String.format("%s/TypeHost2", APPDATA_ROOT), ""))) {
                hostJson = new Json();
                hostJson.put("IpAddress", (Object)hostIpAddress);
                hostJson.put("StartingInput", Config.getAndEraseRegistryInt(String.format("%s/TypeStartingInput2", APPDATA_ROOT), 1));
                hostJson.put("InputCount", Config.getAndEraseRegistryInt(String.format("%s/TypeInputCount2", APPDATA_ROOT), 1));
                typeHostsList.add(hostJson);
            }
            if (!"none".equalsIgnoreCase(hostIpAddress = Config.getAndEraseRegistryString(String.format("%s/TypeHost3", APPDATA_ROOT), ""))) {
                hostJson = new Json();
                hostJson.put("IpAddress", (Object)hostIpAddress);
                hostJson.put("StartingInput", Config.getAndEraseRegistryInt(String.format("%s/TypeStartingInput3", APPDATA_ROOT), 1));
                hostJson.put("InputCount", Config.getAndEraseRegistryInt(String.format("%s/TypeInputCount3", APPDATA_ROOT), 1));
                typeHostsList.add(hostJson);
            }
            JSON_CONFIG.put("TypeHosts", (Object)typeHostsList.toArray());
            JSON_CONFIG.save(JSON_CONFIG_PATH);
        }
    }

    public static String getAndEraseRegistryString(String keyName, String defaultValue) {
        String value = JANOS.getRegistryString((String)keyName, (String)defaultValue);
        JANOS.setRegistryString((String)keyName, (String)"");
        return value;
    }

    public static int getAndEraseRegistryInt(String keyName, int defaultValue) {
        int value = JANOS.getRegistryInt((String)keyName, (int)defaultValue);
        JANOS.setRegistryString((String)keyName, (String)"");
        return value;
    }

    public static String getCameraType() {
        return JSON_CONFIG.getString("CameraType");
    }

    public static String getCameraId() {
        return JSON_CONFIG.getString("CameraId");
    }

    public static String getTerminationString() {
        String terminationString = JSON_CONFIG.getString("TerminationString");
        return Config.getTerminationString(terminationString);
    }

    private static String getTerminationString(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString;
    }

    public static int getReportSendInterval() {
        int minutes = JSON_CONFIG.getInt("ReportSendIntervalInMinutes");
        int millis = minutes * 60000;
        return millis;
    }

    public static String[] getEngineeringEmailRecipients() {
        String emailRecipients = JSON_CONFIG.getString("EngineeringEmailRecipients");
        return StringUtils.split(emailRecipients, ",");
    }

    public static String[] getProductionEmailRecipients() {
        String emailRecipients = JSON_CONFIG.getString("ProductionEmailRecipients");
        return StringUtils.split(emailRecipients, ",");
    }

    public static String getFtpServer() {
        return JSON_CONFIG.getString("FtpServer");
    }

    public static String getFtpRemoteDirectory() {
        return JSON_CONFIG.getString("FtpRemoteDirectory");
    }

    public static String getFtpUsername() {
        return JSON_CONFIG.getString("FtpUsername");
    }

    public static String getFtpPassword() {
        return JSON_CONFIG.getString("FtpPassword");
    }

    public static int getTypeHostCount() {
        Json[] typeHostJsonArray = (Json[])JSON_CONFIG.get("TypeHosts");
        return typeHostJsonArray.length;
    }

    public static String getTypeHostIpAddress(int index) {
        Json[] typeHostJsonArray = (Json[])JSON_CONFIG.get("TypeHosts");
        if (index < typeHostJsonArray.length) {
            Json typeHostJson = typeHostJsonArray[index];
            return typeHostJson.getString("IpAddress");
        }
        return null;
    }

    public static int getTypeStartingInput(int index) {
        Json[] typeHostJsonArray = (Json[])JSON_CONFIG.get("TypeHosts");
        if (index < typeHostJsonArray.length) {
            Json typeHostJson = typeHostJsonArray[index];
            return typeHostJson.getInt("StartingInput");
        }
        return -1;
    }

    public static int getTypeInputCount(int index) {
        Json[] typeHostJsonArray = (Json[])JSON_CONFIG.get("TypeHosts");
        if (index < typeHostJsonArray.length) {
            Json typeHostJson = typeHostJsonArray[index];
            return typeHostJson.getInt("InputCount");
        }
        return -1;
    }
}

