function MonthByDaysChart() {
    var _this = this;
    _this.initialized = false;
    _this.downloadedFiles = [];
    _this.Title = 'Rolling Month by Days';
    _this.loading = true;
    _this.dataRecords = new DataRecords();


    var _pendingFiles = [];
    var _filesInProgress = [];

    var fileRequestTimes = [];
    JnrWebsocket.addEventListener('onLoggedIn', function () {

        // if we have pending files that were requested before the login then we
        // must request them now
        if (0 < _pendingFiles.length) {
            _pendingFiles.forEach(function (filename) {
                if (!_this.downloadedFiles[filename]) {
                    _this.downloadedFiles[filename] = true;
                    console.log('month by days get ' + filename);
                    // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                    fileRequestTimes[filename] = new Date();
                    _filesInProgress.push(filename);
                    console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                    JnrWebsocket.readFile(filename, fileReceived);
                }
            });
        }
    });


    function fileReceived(result) {
        var filename = result.File;
        var elapsed = new Date() - fileRequestTimes[filename];
        console.log(filename + ': ' + elapsed);

        if ('Fail' !== result.Status) {
            var fileContents = Base64.decode(result.Data);
            _this.hourlyFileCallback(fileContents);
        }

        var indexOf = _filesInProgress.indexOf(filename);
        _filesInProgress.splice(indexOf, 1);
        console.log('remove ' + filename + ' from files in progress.  ' + _filesInProgress.length + ' files remaining');
        if (0 === _filesInProgress.length) {
            _this.loading = false;
            JnrWebsocket.readRegistryKey('AppData/Utility/Din' + _input + '/$RollingMetrics', function (key, value) {
                var json = JSON.parse(value);
                _this.updateRollingMetrics(json);
            });
        }
    }


    _this.shown = function () {
        if (!_this.initialized) {
            var ctx = document.getElementById('canvas-month-by-days')
            ctx.height = 500;
            _this.Chart = new Chart(ctx.getContext('2d'), _this.config);

            _this.loadFileForDate(new Date());

            setTimeout(function () {
                _this.initialized = true;
            }, 15000);
        }

        _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = getYAxisTitle();
        _this.Chart.update();
    };


    _this.getData = function () {
        return _this.hourlyDataSet.data;
    };


    _this.loadFileForDate = function (date) {
        var fileDateString = moment(date).format('YYYYMMM');
        var filename = "/flash/utility/storage/by-months/din" + _input + "_" + fileDateString + ".dat";

        var loggedIn = JnrWebsocket.isLoggedIn();
        if (!loggedIn) {
            _pendingFiles.push(filename);
        } else {
            if (!_this.downloadedFiles[filename]) {
                _this.downloadedFiles[filename] = true;
                console.log('month by days ' + filename);
                // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                fileRequestTimes[filename] = new Date();
                _filesInProgress.push(filename);
                console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                JnrWebsocket.readFile(filename, fileReceived);
            }
        }
    };


    _this.updateRollingMetrics = function (rollingMetricsJson) {
        // make sure we have loaded some data for this chart already
        if (_this.loading) return;

        var hourlyJson = rollingMetricsJson.RollingHourlyAverage;
        var startOfDay = new Date(rollingMetricsJson.Timestamp * 1000);
        startOfDay.setHours(0, 0, 0, 0);

        var newData = { x: startOfDay.getTime(), y: hourlyJson[_metric], tag: hourlyJson };
        // console.log(newData);

        // push or replace?
        if (0 === _this.hourlyDataSet.data.length ||
            _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1].x !== newData.x) {
            _this.hourlyDataSet.data.push(newData);
        } else {
            var data = _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1];

            if (!data.oldY) {
                data.oldY = data.y
            }
            if ('Counts' === _metric) {
                data.y = data.oldY + newData.y;
            } else {
                var totalCounts = data.tag.Counts + newData.tag.Counts;
                var totalized = data.oldY * data.tag.Counts + newData.y * newData.tag.Counts;
                data.y = totalized / totalCounts;
            }
        }

        if (_this.Chart) {
            var axis = _this.Chart.scales['x-axis-0'];
            var shouldBeMin = getMinTime();
            var isRealTime = shouldBeMin === axis.options.time.min;
            if (isRealTime) {
                var duration = axis.max - axis.min;
                axis.options.time.max = getMaxTime(); //mostRecentTime + (30 * 60000);
                axis.options.time.min = axis.options.time.max - duration;
            }

            _this.Chart.update();
        }
    };


    _this.chartDataFileCallback = function (fileContents) {
        var lines = fileContents.match(/[^\r\n]+/g);
        for (var lineIndex in lines) {
            var line = lines[lineIndex];
            var json = JSON.parse(line);
            _this.dataRecords.allRecords.push(json);
        }

        var jsonArray = _this.dataRecords.aggregate('day');
        var newData = jsonArray.map(function (e) {
            return { x: e.Timestamp * 1000, y: e[_metric], tag: e };
        });
        return newData;
    };


    _this.hourlyFileCallback = function (fileContents) {
        if (-1 !== fileContents.indexOf('does not exist')) {
            console.log('   ' + fileContents);
            _this.initialized = true;
            return;
        }

        var newData = _this.chartDataFileCallback(fileContents);
        _this.hourlyDataSet.data = newData; //_this.hourlyDataSet.data.concat(newData);
        _this.hourlyDataSet.data.sort(function (a, b) {
            return a.x - b.x;
        });
        _this.Chart.update();
    };


    _this.hourlyDataSet = {
        type: ('Counts' === _metric) ? 'bar' : 'line',
        fill: ('Counts' === _metric) ? true : false,
        label: 'Daily Averages',
        data: [],
        backgroundColor: Color(window.chartColors.blue).alpha(0.5).rgbString(),
        borderColor: window.chartColors.blue,
        borderWidth: 2,
        pointRadius: 1,
        lineTension: 0
    };


    function getMaxTime() {
        return moment().startOf('day').add(12, 'hours').valueOf();
    }


    function getMinTime() {
        return moment().startOf('day').subtract(1, 'months').subtract(12, 'hours').valueOf();
    }


    _this.config = {
        type: 'bar',
        data: {
            datasets: [_this.hourlyDataSet]
        },
        options: {
            maintainAspectRatio: false,
            animation: {
                duration: 0
            },
            responsive: true,
            tooltips: {
                // enabled: false
                mode: 'x-axis',
                intersect: false,
                callbacks: {
                    title: function (tooltipItem, data) {
                        var x = data.datasets[0].data[tooltipItem[0].index].x;
                        var date = moment(x);
                        return date.format('ll');
                    },
                    label: function (tooltipItem, data) {
                        if ('Counts' === _metric) {
                            return 'Daily Total: ' + tooltipItem.yLabel;
                        } else {
                            return 'Daily Average: ' + tooltipItem.yLabel.toFixed(2);
                        }
                    }
                }
            },
            scales: {
                xAxes: [{
                    type: 'time',
                    time: {
                        max: getMaxTime(), // now
                        min: getMinTime(),
                        unit: 'day',
                        unitStepSize: 1
                    },
                    gridLines: {
                        borderDash: [6, 2],
                        offsetGridLines: true
                    },
                    ticks: {
                        callback: function (label, index, ticks) {
                            if (0 != ticks.length) {
                                var tickDate = new Date(ticks[index].value);
                                if (new Date() > tickDate) {
                                    _this.loadFileForDate(tickDate);
                                }

                                var date = moment(tickDate);
                                return date.format('ddd MMM DD');
                            }
                        }
                    }
                }],
                yAxes: [{
                    display: true,
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    scaleLabel: {
                        display: true,
                        labelString: 'Seconds'
                    },
                    ticks: {
                        suggestedMin: 0
                    }
                }]
            },
            legend: {
                display: false
            },
            pan: {
                enabled: true,
                mode: 'x',
                speed: 10,
                threshold: 10
            },
            zoom: {
                enabled: true,
                mode: 'x',
                limits: {
                    max: 10,
                    min: 0.5
                }
            }
        }
    };
};
