function DataRecords() {
    var _this = this;
    _this.allRecords = [];



    _this.aggregate = function (timePeriod) {
        _this.allRecords.sort(function (a, b) {
            return a.Timestamp - b.Timestamp;
        });

        var lastTimePeriod = null;
        var totalizedJson = null;
        var records = 0;
        var jsonArray = [];
        _this.allRecords.forEach(function (element) {
            var json = element;

            // // since this data is coming from a file containing records that are one hour we 
            // // need to subtract the hour to get the time period that this record represents.
            // json.Timestamp -= (json.Minutes * 60);

            // get start of week since this chart is by weeks
            var hourAgo = moment((json.Timestamp - 3600) * 1000);
            var now = moment(json.Timestamp * 1000);
            var nowStartOf = hourAgo.startOf(timePeriod);
            // console.log('now: ' + now.format('MM-DD-YYYY HH:mm') + ', nowStartOf: ' + nowStartOf.format('MM-DD-YYYY HH:mm') + ','
            //     + (null != totalizedJson ? (', count: ' + json.Counts + ', totalizedJson.Counts: ' + totalizedJson.Counts) : ''));

            var newTimePeriod = null == lastTimePeriod;
            if (!newTimePeriod) {
                var lastTimePeriodStartOf = lastTimePeriod.startOf(timePeriod);
                // console.log('lastTimePeriodStartOf: ' + lastTimePeriodStartOf.format('MM-DD-YYYY HH:mm'));
                newTimePeriod = newTimePeriod || !(nowStartOf.isSame(lastTimePeriodStartOf));
            }
            if (newTimePeriod) {
                if (null != totalizedJson) {
                    // console.log('lastTimePeriodStartOf: ' + lastTimePeriodStartOf.format('MM-DD-YYYY HH:mm') + ' = ' + JSON.stringify(totalizedJson));

                    totalizedJson.AvgHigh /= totalizedJson.Counts;
                    totalizedJson.AvgLow /= totalizedJson.Counts;
                    totalizedJson.AvgCycle /= totalizedJson.Counts;
                    totalizedJson.AvailablePercent /= records;
                    records = 0;
                    jsonArray.push(totalizedJson);
                }

                lastTimePeriod = hourAgo;

                totalizedJson = angular.copy(json);
                totalizedJson.AvgHigh = json.AvgHigh * json.Counts;
                totalizedJson.AvgLow = json.AvgLow * json.Counts;
                totalizedJson.AvgCycle = json.AvgCycle * json.Counts;
                totalizedJson.AvailablePercent = json.AvailablePercent;
                totalizedJson.Timestamp = lastTimePeriod.valueOf() / 1000;
                totalizedJson.Timestring = lastTimePeriod.format("MM/DD/YYYY HH:mm");
                records++;
            } else {
                totalizedJson.Counts = (isNaN(totalizedJson.Counts)) ? json.Counts : totalizedJson.Counts + json.Counts;
                totalizedJson.AvgHigh = (isNaN(totalizedJson.AvgHigh)) ? json.AvgHigh * json.Counts : totalizedJson.AvgHigh + json.AvgHigh * json.Counts;
                totalizedJson.AvgLow = (isNaN(totalizedJson.AvgLow)) ? json.AvgLow * json.Counts : totalizedJson.AvgLow + json.AvgLow * json.Counts;
                totalizedJson.AvgCycle = (isNaN(totalizedJson.AvgCycle)) ? json.AvgCycle * json.Counts : totalizedJson.AvgCycle + json.AvgCycle * json.Counts;
                totalizedJson.AvailablePercent = (isNaN(totalizedJson.AvailablePercent)) ? json.AvailablePercent : totalizedJson.AvailablePercent + json.AvailablePercent;
                records++;
            }
        });
        if (null != totalizedJson) {
            totalizedJson.AvgHigh /= totalizedJson.Counts;
            totalizedJson.AvgLow /= totalizedJson.Counts;
            totalizedJson.AvgCycle /= totalizedJson.Counts;
            jsonArray.push(totalizedJson);
            totalizedJson.AvailablePercent /= records;
            records = 0;
        }

        return jsonArray;
    };
};


