<html ng-app="App">

<head>
    <title>Utility - Configuration</title>

    <!-- <base href="/utility/"> -->

    <script type="text/javascript" src="jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="angular-1.3.15.min.js"></script>
    <script type="text/javascript" src="bootstrap-3.3.0.min.js"></script>
    <link rel="stylesheet" href="bootstrap-3.3.0.min.css">
    <script type="text/javascript" src="bootbox_4.4.0.js"></script>

    <script type="text/javascript" src="prototype-functions.js"></script>

    <script type="text/javascript" src="base64.js"></script>
    <script type="text/javascript" src="md5.js"></script>
    <script type="text/javascript" src="comm.js"></script>
    <script type="text/javascript" src="jnrWebsocket.js"></script>

    <script type="text/javascript" src="app.js"></script>
    <script>
            var Config = {};
            
            <?php 
                $filename = '/flash/utility/config.json';
                if (file_exists($filename)) {
                    $fp = fopen($filename, 'rb');
                    if ($fp) {
                        $size = filesize($filename);
                        
                        echo 'Config = ';
                        print(fread($fp, $size));
                        fclose($fp);
                        echo ';';
                    }
                }
            ?>
    </script>
    
    
    <script type="text/javascript" src="configure.js"></script>


    <style>
        .config-item {
            margin-bottom: 24px;
        }

        input {
            width: 75px;
        }

        .config-item input[type=checkbox] {
            margin-left: 25px;
            width: 25px;
        }

        .bootbox .modal-content {
            border-radius: 0;
        }

        .bb-primary .modal-header {
            background-color: #428bca;
            color: #fff;
        }

        .bb-success .modal-header {
            background-color: #5cb85c;
            color: #fff;
        }

        .bb-warning .modal-header {
            background-color: #f0ad4e;
            color: #fff;
        }

        .bb-danger .modal-header {
            background-color: #c9302c;
            color: #fff;
        }
    </style>
</head>


<body ng-controller="Controller as ctrl">
    <nav id="navbar" class="navbar navbar-inverse navbar-fixed-top" role="navigation">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false"
                    aria-controls="navbar">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a id="page-title" class="navbar-brand" href="javascript: void(0)" style="color: white;">Utility</a>
            </div>

            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <!-- <ul class="nav navbar-nav">
                    <li role="presentation">
                        <a href="/utility/?SelectedChart=real-time">Real-Time Analog</a>
                    </li>
                    <li role="presentation">
                        <a href="/utility/?SelectedChart=real-time-digital">Real-Time Digital</a>
                    </li>
                    <li role="presentation">
                        <a href="/utility/?SelectedChart=six-minute">By Minutes</a>
                    </li>
                    <li role=" presentation ">
                        <a href="/utility/?SelectedChart=day-by-hours">Day by Hours</a>
                    </li>
                    <li role="presentation ">
                        <a href="/utility/?SelectedChart=month-by-days">Month By Days</a>
                    </li>
                    <li role="presentation ">
                        <a href="/utility/?SelectedChart=year-by-weeks">Year By Weeks</a>
                    </li>
                    <li role="presentation ">
                        <a href="/utility/?SelectedChart=year-by-months">Year By Months</a>
                    </li>
                </ul> -->

                <div class="nav navbar-nav navbar-right" style="padding: 10px;">
                    <button class="btn btn-success btn-sm" ng-disabled="!ctrl.hasChanged(ctrl.Config, ctrl.SavedConfig)" ng-click="ctrl.saveChangesRequest()">Save
                        Changes
                    </button>
                    <button class="btn btn-warning btn-sm" ng-disabled="!ctrl.hasChanged(ctrl.Config, ctrl.SavedConfig)" ng-click="ctrl.cancelChangesRequest()">Cancel
                        Changes
                    </button>
                </div>

            </div>
            <!-- /.navbar-collapse -->

        </div>
    </nav>

    <div class="container-fluid" style="padding-top: 70px;">
        <h2>Configuration</h2>
        <!-- {{ctrl.Config}} -->


        <div class="config-item">
        <h4>Visible Tabs</h4>
        <p style="margin-left:24px;">
            <label><span style="width:135px; display:inline-block;">Real-Time Analog?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.RealTimeAnalog"></label><br>
            <label><span style="width:135px; display:inline-block;">Real-Time Digital?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.RealTimeDigital"></label><br>
            <label><span style="width:135px; display:inline-block;">By Minutes?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.ByMinutes"></label><br>
            <label><span style="width:135px; display:inline-block;">Day by Hours?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.DayByHours"></label><br>
            <label><span style="width:135px; display:inline-block;">Month by Days?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.MonthByDays"></label><br>
            <label><span style="width:135px; display:inline-block;">Year by Weeks?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.YearByWeeks"></label><br>
            <label><span style="width:135px; display:inline-block;">Year by Months?</span> <input type="checkbox" ng-model="ctrl.Config.VisibleTabs.YearByMonths"></label><br>
        </p>
        </div>

        
        <!-- <div class="config-item">
            <h4>The default Metric is
                <select ng-model="ctrl.Config.DefaultMetric">
                    <option value="Counts">Counts</option>
                    <option value="AvgCycle">Cycle Time</option>
                    <option value="AvgHigh">High Time</option>
                    <option value="AvgLow">Low Time</option>
                </select>
            </h4>
        </div> -->

        <div class="config-item">
            <h4>The initial Chart is
                <select ng-model="ctrl.Config.InitialChart">
                    <option value="real-time">Real-Time Analog</option>
                    <option value="real-time-digital">Real-Time Digital</option>
                    <option value="six-minute">By Minutes</option>
                    <option value="day-by-hours">Day by Hours</option>
                    <option value="month-by-days">Month by Days</option>
                    <option value="year-by-weeks">Year by Weeks</option>
                    <option value="year-by-months">Year by Months</option>
                </select>
            </h4>
        </div>

        <div class="config-item">
            <h4>The initial Input is
            <select ng-model="ctrl.Config.InitialInput">
                <option ng-repeat="input in ctrl.inputArray">{{ input }}</option>
            </select>
            </h4>
        </div>


        <!-- <div class="config-item">
            <h4>Y-Axis minimum is
                <select ng-model="ctrl.Config.YAxis.Minimum.Type">
                    <option value="dynamic">dynamic</option>
                    <option value="set-value">set value</option>
                </select>
                <input ng-show="'set-value' === ctrl.Config.YAxis.Minimum.Type" ng-model="ctrl.Config.YAxis.Minimum.Value" />                and
                the maximum is
                <select ng-model="ctrl.Config.YAxis.Maximum.Type">
                    <option value="dynamic">dynamic</option>
                    <option value="set-value">set value</option>
                </select>
                <input ng-show="'set-value' === ctrl.Config.YAxis.Maximum.Type" ng-model="ctrl.Config.YAxis.Maximum.Value" />
            </h4>
        </div> -->

      

        <!-- <div class="config-item">
            <h4>The time periods should show
                <select ng-model="ctrl.Config.CurrentPeriod">
                    <option value="accumulating">accumulating</option>
                    <option value="rolling">rolling</option>
                </select>
                data
            </h4>
        </div> -->

        <div class="config-item">
            <h4>The real-time table should show <input ng-model="ctrl.Config.RealTimeRecordCount" /> rows</h4>
        </div>


        <div class="config-item">
            <h4>The Minute Chart chart should show values in
                <select ng-model="ctrl.Config.MinuteBlockDuration">
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                    <option value="5">5</option>
                    <option value="6">6</option>
                    <option value="10">10</option>
                    <option value="12">12</option>
                    <option value="15">15</option>
                    <option value="20">20</option>
                    <option value="30">30</option>
                </select>
                minute blocks</h4>
        </div>


        <div class="config-item">
            <h4>Select the Inputs to be Logged</h4>
            <table>
                <tr>
                <th style="padding-right:12px;">Input #</th>
                <th style="padding-right:12px;">Counts</th>
                <th style="padding-right:12px;">Multiplier</th>
                <th style="padding-right:12px;">Avg Cycle Time</th>
                <th style="padding-right:12px;">Avg High Time</th>
                <th style="padding-right:12px;">Avg Low Time</th>
                <th style="padding-right:12px;">Available Percentage</th>
                <th style="padding-right:12px;">Default Metric</th>
                </tr>
                <tr ng-repeat="inputChannel in ctrl.inputArray">
                    <td style="font-size:18px;">Input {{inputChannel}}</td>
                    <td style="font-size:14px;"><input type="checkbox" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].Counts" /></td>
                    <td style="font-size:14px;"><input type="text" ng-disabled="!ctrl.Config.InputsEnabled[inputChannel - 1].Counts" placeholder="1" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].CountMultiplier" /></td>
                    <td style="font-size:14px;"><input type="checkbox" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].AvgCycle" /></td>
                    <td style="font-size:14px;"><input type="checkbox" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].AvgHigh" /></td>
                    <td style="font-size:14px;"><input type="checkbox" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].AvgLow" /></td>
                    <td style="font-size:14px;"><input type="checkbox" ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].AvailablePercent" /></td>
                    <td style="font-size:14px; font-weight:700;">
                        <select ng-model="ctrl.Config.InputsEnabled[inputChannel - 1].DefaultMetric">
                            <option value="Counts">Counts</option>
                            <option value="AvgCycle">Cycle Time</option>
                            <option value="AvgHigh">High Time</option>
                            <option value="AvgLow">Low Time</option>
                            <option value="AvailablePercent">Available Percentage</option>
                        </select>
                    </td>
                </tr>
            </table>
        </div>
        

        <div class="config-item">
            <h4>Select the Analog Inputs to be Logged</h4>
            <div ng-repeat="inputChannel in ctrl.inputArray">
                <label ng-show="ctrl.Config.AnalogModulesAvailable[Math.floor((inputChannel - 1) / 4)] === true"><input ng-disabled="!ctrl.Config.InputsEnabled[inputChannel - 1]"
                        ng-model="ctrl.Config.RealTimeInputsEnabled[inputChannel - 1]" type="checkbox" /> Real-Time Flow Analog
                    Input {{inputChannel}}</label>
            </div>
        </div>

    </div>
</body>

</html>