/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.text;

import com.integpg.system.ArrayUtils;
import com.integpg.system.Timebase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class QuickDateFormat {
    private static final QuickDateFormat DEFAULT = new QuickDateFormat();
    private static final SimpleDateFormat TIMEZONE_DATE_FORMAT = new SimpleDateFormat("z");
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final String[] MONTH_NAME_STRINGS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final byte[][] AM_PM_STRING_BYTES = new byte[][]{"am".getBytes(), "pm".getBytes()};
    private final Calendar _calendar = Calendar.getInstance();
    private final byte[] _dateStampBytes;
    public final int DATE_STAMP_LENGTH;
    public final int DATE_STAMP_LENGTH_WITH_COMMA;
    private final String _pattern;
    int _weekOfYearPos = -1;
    int _monthPos = -1;
    int _monthNamePos = -1;
    int _dayPos = -1;
    int _2yearPos = -1;
    int _4yearPos = -1;
    int _hourPos = -1;
    int _hourOfDayPos = -1;
    int _minutePos = -1;
    int _secondPos = -1;
    int _millisPos = -1;
    int _timezonePos = -1;
    int _ampmPos = -1;
    private final byte[] _buf = new byte[8];
    private long _lastTimeRef = 0L;
    private long _nextHour = System.currentTimeMillis() - System.currentTimeMillis() % 3600000L;
    private long _nextMinute = 0L;

    public static QuickDateFormat getDefault() {
        return DEFAULT;
    }

    public QuickDateFormat() {
        this("MM-dd-yyyy HH:mm:ss.fff zzz");
    }

    public QuickDateFormat(String pattern) {
        this._pattern = pattern;
        this._dateStampBytes = new byte[pattern.length() + 2];
        ArrayUtils.arraycopy((Object)pattern.getBytes(), (int)0, (Object)this._dateStampBytes, (int)0, (int)pattern.length());
        this._dateStampBytes[this._dateStampBytes.length - 2] = 44;
        this._dateStampBytes[this._dateStampBytes.length - 1] = 32;
        this.DATE_STAMP_LENGTH = this._dateStampBytes.length - 2;
        this.DATE_STAMP_LENGTH_WITH_COMMA = this._dateStampBytes.length;
        this._weekOfYearPos = pattern.indexOf("WY");
        this._monthNamePos = pattern.indexOf("MMM");
        if (-1 == this._monthNamePos) {
            this._monthPos = pattern.indexOf("MM");
        }
        this._dayPos = pattern.indexOf("dd");
        if (-1 == this._dayPos) {
            this._dayPos = pattern.indexOf("DD");
        }
        this._2yearPos = pattern.indexOf("yy");
        if (-1 == this._2yearPos) {
            this._2yearPos = pattern.indexOf("YY");
        }
        this._4yearPos = pattern.indexOf("yyyy");
        if (-1 == this._4yearPos) {
            this._4yearPos = pattern.indexOf("YYYY");
        }
        this._hourPos = pattern.indexOf("hh");
        this._hourOfDayPos = pattern.indexOf("HH");
        this._minutePos = pattern.indexOf("mm");
        this._secondPos = pattern.indexOf("ss");
        this._millisPos = pattern.indexOf("fff");
        if (-1 == this._millisPos) {
            this._millisPos = pattern.indexOf("SSS");
        }
        this._timezonePos = pattern.indexOf("zzz");
        this._ampmPos = pattern.indexOf("aa");
        this.updateTimezone();
    }

    public String getDateFormatString() {
        return this._pattern;
    }

    public Date parse(String dateString) {
        Calendar cal = Calendar.getInstance();
        try {
            int month = -1;
            if (-1 != this._monthNamePos) {
                String monthString = dateString.substring(this._monthNamePos, this._monthNamePos + 3).toLowerCase();
                int monthIndex = "janfebmaraprmayjunjulaugsepoctnovdec".indexOf(monthString);
                month = monthIndex / 3;
            } else if (-1 != this._monthPos) {
                month = Integer.parseInt(dateString.substring(this._monthPos, this._monthPos + 2)) - 1;
            }
            int dayOfMonth = Integer.parseInt(dateString.substring(this._dayPos, this._dayPos + 2));
            int year = 0;
            if (-1 != this._4yearPos) {
                year = Integer.parseInt(dateString.substring(this._4yearPos, this._4yearPos + 4));
            } else if (-1 != this._2yearPos) {
                year = Integer.parseInt(dateString.substring(this._2yearPos, this._2yearPos + 2));
                year += 2000;
            }
            int hour = 0;
            if (-1 != this._hourOfDayPos) {
                hour = Integer.parseInt(dateString.substring(this._hourOfDayPos, this._hourOfDayPos + 2));
            } else if (-1 != this._hourPos) {
                hour = Integer.parseInt(dateString.substring(this._hourPos, this._hourPos + 2));
            }
            int minute = Integer.parseInt(dateString.substring(this._minutePos, this._minutePos + 2));
            int second = 0;
            if (-1 != this._secondPos) {
                second = Integer.parseInt(dateString.substring(this._secondPos, this._secondPos + 2));
            }
            cal.set(year, month, dayOfMonth, hour, minute, second);
            if (-1 != this._millisPos) {
                int millis = Integer.parseInt(dateString.substring(this._millisPos, this._millisPos + 3));
                cal.set(14, millis);
            }
        }
        catch (Exception ex) {
            System.err.println(String.format("error parsing date %s", dateString));
        }
        return cal.getTime();
    }

    private void updateTimezone() {
        if (-1 != this._timezonePos) {
            String dstString;
            String timezoneString = Timebase.getTimeZone();
            if (Timebase.isDST((long)System.currentTimeMillis(), (String)timezoneString) && null != (dstString = Timebase.getDSTTimeZone((String)timezoneString))) {
                timezoneString = dstString;
            }
            ArrayUtils.arraycopy((Object)timezoneString.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._timezonePos, (int)timezoneString.length());
        }
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    public String format() {
        return this.format(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long time) {
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            if (time <= 0L) {
                time = System.currentTimeMillis();
            }
            if (this._nextHour <= time) {
                this._nextHour += 3600000L;
                this.updateTimezone();
            }
            if (this._lastTimeRef > time || time >= this._nextMinute) {
                this.initRefBytes(time);
            }
            int delta = (int)(time - this._lastTimeRef);
            int rSecond = delta / 1000;
            if (-1 != this._secondPos) {
                this.stuffInt(this._buf, rSecond + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._secondPos, (int)2);
            }
            if (-1 != this._millisPos) {
                int rMillis = delta - 1000 * rSecond;
                this.stuffInt(this._buf, rMillis + 1000, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._millisPos, (int)3);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return new String(this._dateStampBytes, 0, this.DATE_STAMP_LENGTH);
        }
    }

    public byte[] toByteArray() {
        return this._dateStampBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRefBytes(long time) {
        this._calendar.setTimeInMillis(time);
        int second = this._calendar.get(13);
        int millis = this._calendar.get(14);
        this._lastTimeRef = time - (long)(1000 * second + millis);
        this._nextMinute = time + 60000L - time % 60000L;
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            int rHour;
            int month;
            if (-1 != this._weekOfYearPos) {
                int weekOfYear = this._calendar.get(3);
                this.stuffInt(this._buf, weekOfYear + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._weekOfYearPos, (int)2);
            }
            if (-1 != this._monthPos) {
                month = this._calendar.get(2);
                this.stuffInt(this._buf, month + 101, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._monthPos, (int)2);
            }
            if (-1 != this._monthNamePos) {
                month = this._calendar.get(2);
                String monthName = MONTH_NAME_STRINGS[month];
                ArrayUtils.arraycopy((Object)monthName.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._monthNamePos, (int)3);
            }
            if (-1 != this._dayPos) {
                int day = this._calendar.get(5);
                this.stuffInt(this._buf, day + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._dayPos, (int)2);
            }
            if (-1 != this._2yearPos || -1 != this._4yearPos) {
                int year = this._calendar.get(1);
                this.stuffInt(this._buf, year, 0, false);
                if (-1 != this._2yearPos) {
                    ArrayUtils.arraycopy((Object)this._buf, (int)2, (Object)this._dateStampBytes, (int)this._2yearPos, (int)2);
                }
                if (-1 != this._4yearPos) {
                    ArrayUtils.arraycopy((Object)this._buf, (int)0, (Object)this._dateStampBytes, (int)this._4yearPos, (int)4);
                }
            }
            if (-1 != this._hourPos) {
                rHour = this._calendar.get(10);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourPos, (int)2);
            }
            if (-1 != this._hourOfDayPos) {
                rHour = this._calendar.get(11);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourOfDayPos, (int)2);
            }
            if (-1 != this._minutePos) {
                int minute = this._calendar.get(12);
                this.stuffInt(this._buf, minute + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._minutePos, (int)2);
            }
            if (-1 != this._ampmPos) {
                byte[] amPmBytes = AM_PM_STRING_BYTES[this._calendar.get(9)];
                ArrayUtils.arraycopy((Object)amPmBytes, (int)0, (Object)this._dateStampBytes, (int)this._ampmPos, (int)2);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    private void stuffInt(byte[] array, int value, int dec, boolean rjustified) {
        int dig;
        ArrayUtils.arrayFill((byte[])array, (int)0, (int)array.length, (byte)32);
        if (value == 0) {
            array[0] = 48;
            return;
        }
        int offset = 0;
        boolean leading = true;
        if (value < 0) {
            array[offset++] = 45;
            value = -value;
            rjustified = false;
        }
        for (dig = 1000000; dig >= 1; dig /= 10) {
            if (leading && value < dig) {
                if (!rjustified) continue;
                ++offset;
                continue;
            }
            array[offset] = 48;
            while (value >= dig) {
                int n = offset;
                array[n] = (byte)(array[n] + 1);
                value -= dig;
            }
            ++offset;
            leading = false;
        }
        for (dig = dec; dig > 0; --dig) {
            array[offset] = array[offset - 1];
            if (array[offset] == 32) {
                array[offset] = 48;
            }
            --offset;
            if (dig != 1) continue;
            array[offset] = 46;
            if (array[offset - 1] != 32) continue;
            array[offset - 1] = 48;
        }
    }
}

