function YearByWeeksChart() {
    var _this = this;
    _this.initialized = false;
    _this.downloadedFiles = [];
    _this.Title = 'Rolling Year by Weeks';
    _this.loading = true;
    _this.dataRecords = new DataRecords();


    var _pendingFiles = [];
    var _filesInProgress = [];

    var fileRequestTimes = [];
    JnrWebsocket.addEventListener('onLoggedIn', function () {

        // if we have pending files that were requested before the login then we
        // must request them now
        if (0 < _pendingFiles.length) {
            _pendingFiles.forEach(function (filename) {
                if (!_this.downloadedFiles[filename]) {
                    _this.downloadedFiles[filename] = true;
                    console.log('year by weeks get ' + filename);
                    // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                    fileRequestTimes[filename] = new Date();
                    _filesInProgress.push(filename);
                    console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                    JnrWebsocket.readFile(filename, fileReceived);
                }
            });
        }
    });


    function fileReceived(result) {
        var filename = result.File;
        var elapsed = new Date() - fileRequestTimes[filename];
        console.log(filename + ': ' + elapsed);

        if ('Fail' !== result.Status) {
            var fileContents = Base64.decode(result.Data);
            _this.hourlyFileCallback(fileContents);
        }

        var indexOf = _filesInProgress.indexOf(filename);
        _filesInProgress.splice(indexOf, 1);
        console.log('remove ' + filename + ' from files in progress.  ' + _filesInProgress.length + ' files remaining');
        if (0 === _filesInProgress.length) {
            _this.loading = false;
            JnrWebsocket.readRegistryKey('AppData/Utility/Din' + _input + '/$RollingMetrics', function (key, value) {
                var json = JSON.parse(value);
                _this.updateRollingMetrics(json);
            });
        }
    }


    _this.shown = function () {
        if (!_this.initialized) {
            var ctx = document.getElementById('canvas-year-by-weeks')
            ctx.height = 500;
            _this.Chart = new Chart(ctx.getContext('2d'), _this.config);

            _this.loadFileForDate(new Date().getStartOfWeek());
            setTimeout(function () {
                _this.initialized = true;
            }, 15000);
        }

        _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = getYAxisTitle();
        _this.Chart.update();
    };


    _this.getData = function () {
        return _this.dataSet.data;
    };


    _this.updateRollingMetrics = function (rollingMetricsJson) {
        if (_this.loading) return;

        // make sure we have loaded some data for this chart already
        if (!_this.initialized) return;

        var hourlyJson = rollingMetricsJson.RollingHourlyAverage;
        var startOfWeek = new Date(rollingMetricsJson.Timestamp * 1000);
        startOfWeek.setDate(startOfWeek.getDate() - startOfWeek.getDay());
        startOfWeek.setHours(0, 0, 0, 0);

        var newData = { x: startOfWeek.getTime(), y: hourlyJson[_metric], tag: hourlyJson };
        console.log(newData);

        var isRealTime = false;
        if (0 !== _this.dataSet.data.length) {
            var axis = _this.Chart.scales['x-axis-0'];
            var mostRecentTime = _this.dataSet.data[_this.dataSet.data.length - 1].x;
            isRealTime = (axis.max >= mostRecentTime);
        }

        // push or replace?
        if (0 === _this.dataSet.data.length ||
            _this.dataSet.data[_this.dataSet.data.length - 1].x !== newData.x) {
            _this.dataSet.data.push(newData);
        } else {
            var data = _this.dataSet.data[_this.dataSet.data.length - 1];

            if (!data.oldY) {
                data.oldY = data.y
            }
            if ('Counts' === _metric) {
                data.y = data.oldY + newData.y;
            } else {
                var totalCounts = data.tag.Counts + newData.tag.Counts;
                var totalized = data.oldY * data.tag.Counts + newData.y * newData.tag.Counts;
                data.y = totalized / totalCounts;
            }
        }

        if (_this.Chart) {
            var axis = _this.Chart.scales['x-axis-0'];
            var shouldBeMin = getMinTime();
            var isRealTime = shouldBeMin === axis.options.time.min;
            if (isRealTime) {
                var mostRecentTime = _this.dataSet.data[_this.dataSet.data.length - 1].x;
                var duration = axis.max - axis.min;
                axis.options.time.max = getMaxTime(); //mostRecentTime + (30 * 60000);
                axis.options.time.min = axis.options.time.max - duration;
            }

            _this.Chart.update();
        }
    };


    Date.prototype.getStartOfWeek = function () {
        var target = new Date(this.valueOf());
        console.log('target: ' + target);
        var dayNr = this.getDay();
        // console.log('  dayNr: ' + dayNr);
        target.setDate(target.getDate() - dayNr);
        // console.log('  target: ' + target);
        return target;
    }


    _this.loadFileForDate = function (date) {
        var weekOfYear = moment(date).week();
        var year = date.getFullYear();
        var weekOfYearString = ("0" + weekOfYear).slice(-2);
        var fileDateString = year + 'wk' + weekOfYearString;
        var filename = "/flash/utility/storage/by-weeks/din" + _input + "_" + fileDateString + ".dat";

        // if date given is the fisrt week of the year but is the 12th month then get the 53rd week of the year.
        var month = date.getMonth();
        if (1 === weekOfYear && 11 === month) {
            // add 1 to year
            year++;

            console.log('should be 53rd week: ' + date);

            var endOfYearFileDateString = moment(date).format('YYYY') + 'wk53';
            var endOfYearFilename = "/flash/utility/storage/by-weeks/din" + _input + "_" + endOfYearFileDateString + ".dat";

            fileDateString = year + 'wk' + weekOfYearString;
            filename = "/flash/utility/storage/by-weeks/din" + _input + "_" + fileDateString + ".dat";

            var loggedIn = JnrWebsocket.isLoggedIn();
            if (!loggedIn) {
                _pendingFiles.push(filename);
                _pendingFiles.push(endOfYearFilename);
            } else {
                if (!_this.downloadedFiles[filename]) {
                    _this.downloadedFiles[filename] = true;
                    console.log('year by weeks get ' + filename);
                    fileRequestTimes[filename] = new Date();
                    _filesInProgress.push(filename);
                    console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                    JnrWebsocket.readFile(filename, fileReceived);
                }
                if (!_this.downloadedFiles[endOfYearFilename]) {
                    _this.downloadedFiles[endOfYearFilename] = true;
                    console.log('year by weeks get ' + endOfYearFilename);
                    fileRequestTimes[endOfYearFilename] = new Date();
                    _filesInProgress.push(endOfYearFilename);
                    console.log('add ' + endOfYearFilename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                    JnrWebsocket.readFile(endOfYearFilename, fileReceived);
                }
            }
        }

        var loggedIn = JnrWebsocket.isLoggedIn();
        if (!loggedIn) {
            _pendingFiles.push(filename);
        } else {
            if (!_this.downloadedFiles[filename]) {
                _this.downloadedFiles[filename] = true;
                console.log('year by weeks get ' + filename);
                fileRequestTimes[filename] = new Date();
                JnrWebsocket.readFile(filename, fileReceived);
            }
        }
    };


    _this.JsonArray = [];
    _this.chartDataFileCallback = function (fileContents) {
        var lines = fileContents.match(/[^\r\n]+/g);
        for (var lineIndex in lines) {
            var line = lines[lineIndex];
            var json = JSON.parse(line);
            _this.dataRecords.allRecords.push(json);
        }

        var jsonArray = _this.dataRecords.aggregate('week');
        var newData = jsonArray.map(function (e) {
            return { x: e.Timestamp * 1000, y: e[_metric], tag: e };
        });
        return newData;
    };


    _this.hourlyFileCallback = function (fileContents) {
        if (-1 !== fileContents.indexOf('does not exist')) {
            console.log('   ' + fileContents);
            _this.initialized = true;
            return;
        }

        var newData = _this.chartDataFileCallback(fileContents);
        _this.dataSet.data = newData;
        _this.dataSet.data.sort(function (a, b) {
            return a.x - b.x;
        });
        _this.Chart.update();
        _this.initialized = true;
    };


    _this.dataSet = {
        type: ('Counts' === _metric) ? 'bar' : 'line',
        fill: ('Counts' === _metric) ? true : false,
        label: 'Weekly Averages',
        data: [],
        backgroundColor: Color(window.chartColors.blue).alpha(0.5).rgbString(),
        borderColor: window.chartColors.blue,
        borderWidth: 2,
        pointRadius: 1,
        lineTension: 0
    };


    function getMaxTime() {
        return moment().startOf('week').add(4, 'days').valueOf();
    }


    function getMinTime() {
        return moment().startOf('week').subtract(53, 'weeks').add(4, 'days').valueOf();
    }


    _this.config = {
        type: 'bar',
        data: {
            datasets: [_this.dataSet]
        },
        options: {
            maintainAspectRatio: false,
            animation: {
                duration: 0
            },
            responsive: true,
            tooltips: {
                // enabled: false
                mode: 'x-axis',
                intersect: false,
                callbacks: {
                    title: function (tooltipItem, data) {
                        var x = data.datasets[0].data[tooltipItem[0].index].x;
                        var date = moment(x);
                        var weekOfYear = date.week();
                        var weekOfYearString = ("0" + weekOfYear).slice(-2);
                        return 'Week ' + weekOfYearString + ' - ' + date.format('ll');
                    },
                    label: function (tooltipItem, data) {
                        if ('Counts' === _metric) {
                            return 'Weekly Total: ' + tooltipItem.yLabel;
                        } else {
                            return 'Weekly Average: ' + tooltipItem.yLabel.toFixed(2);
                        }
                    }
                }
            },
            scales: {
                xAxes: [{
                    type: 'time',
                    time: {
                        max: getMaxTime(),
                        min: getMinTime(), // 53 weeks
                        unit: 'week',
                        unitStepSize: 1
                    },
                    gridLines: {
                        borderDash: [6, 2],
                        offsetGridLines: true
                    },
                    ticks: {
                        callback: function (label, index, ticks) {
                            if (0 != ticks.length) {
                                var tickDate = new Date(ticks[index].value);
                                if (new Date() > tickDate) {
                                    _this.loadFileForDate(tickDate);
                                }

                                var date = moment(tickDate);
                                var weekOfYear = date.week();
                                var weekOfYearString = ("0" + weekOfYear).slice(-2);
                                // return 'Week ' + weekOfYearString + ' - ' + date.format('ll');
                                return date.format('ww - ddd MMM DD');
                            }
                        }
                    }
                }],
                yAxes: [{
                    display: true,
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    scaleLabel: {
                        display: true,
                        labelString: 'Seconds'
                    },
                    ticks: {
                        suggestedMin: 0
                    }
                }]
            },
            legend: {
                display: false
            },
            pan: {
                enabled: true,
                mode: 'x',
                speed: 10,
                threshold: 10
            },
            zoom: {
                enabled: true,
                mode: 'x',
                limits: {
                    max: 10,
                    min: 0.5
                }
            }
        }
    };
};
