/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.utility.Config;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.DateUtils;

public class ImportantTimes {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff");
    public long RollingDayStart;
    public long RollingHourStart;
    public long StartOfHour;
    public long NextHour;
    public long RollingSixMinutesStart;
    public long StartOfByMinutes;
    public long NextByMinutes;

    public void updateTimes() {
        long now = System.currentTimeMillis();
        this.StartOfHour = DateUtils.getStartOfHour();
        this.NextHour = this.StartOfHour + 3600000L;
        int minuteBlockDuration = Config.getMinuteBlockDuration();
        this.StartOfByMinutes = now - now % (60000L * (long)minuteBlockDuration);
        this.NextByMinutes = this.StartOfByMinutes + 60000L * (long)minuteBlockDuration;
    }

    public String printTimes() {
        String result = "StartOfHour: " + QUICK_DATE_FORMAT.format(this.StartOfHour);
        result = result + ", NextHour: " + QUICK_DATE_FORMAT.format(this.NextHour);
        result = result + ", StartOfByMinutes: " + QUICK_DATE_FORMAT.format(this.StartOfByMinutes);
        result = result + ", NextByMinutes: " + QUICK_DATE_FORMAT.format(this.NextByMinutes);
        return result;
    }

    public void updateRollingTimes() {
        long now = System.currentTimeMillis();
        this.RollingDayStart = now - 86400000L;
        this.RollingHourStart = now - 3600000L;
        int minuteBlockDuration = Config.getMinuteBlockDuration();
        this.RollingSixMinutesStart = now - 60000L * (long)minuteBlockDuration;
    }

    public String printRollingTimes() {
        String result = "RollingDayStart: " + QUICK_DATE_FORMAT.format(this.RollingDayStart);
        result = result + ", RollingHourStart: " + QUICK_DATE_FORMAT.format(this.RollingHourStart);
        result = result + ", RollingSixMinutes: " + QUICK_DATE_FORMAT.format(this.RollingSixMinutesStart);
        return result;
    }
}

