/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.utility.Config;
import com.integ.utility.UtilityMain;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.DateUtils;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class InstantaneousLogger
implements Runnable {
    private Thread _thd;
    private boolean _initialized = false;

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName());
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        System.out.println("intstantaneous logger not initialized");
        while (!this._initialized) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        while (true) {
            try {
                while (true) {
                    int sleepDuration = (int)(System.currentTimeMillis() % 10000L);
                    Thread.sleep(sleepDuration);
                    this.getInstantaneous();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInstantaneous() {
        RandomAccessFile raf = null;
        TypeFE lastFe = null;
        byte[] timeBytes = new byte[4];
        for (int i = 0; i < UnitConfig.getInputCount(); ++i) {
            boolean inputEnabled = Config.getAnalogInputEnabled(i + 1);
            if (!inputEnabled) continue;
            try {
                TypeFE typeFe = TypeFE.getByIndex(i / 4);
                if (null == typeFe || null != lastFe && lastFe == typeFe) continue;
                lastFe = typeFe;
                typeFe.read();
                int time = (int)(System.currentTimeMillis() / 1000L);
                ArrayUtils.setInt((byte[])timeBytes, (int)0, (int)time);
                String filename = UtilityMain.UTILITY_STORAGE.getPath() + "typeFE_" + (i / 4 + 1) + ".dat";
                System.out.println("typeFe.getDataBlock().length: " + typeFe.getDataBlock().length);
                raf = null;
                try {
                    int secondsIntoDay = (int)(DateUtils.getMillisIntoDay() / 1000L);
                    System.out.println("secondsIntoDay: " + secondsIntoDay);
                    int index = secondsIntoDay / 10;
                    raf = new RandomAccessFile(filename, "rw");
                    raf.seek(index * 12);
                    raf.write(timeBytes, 0, 4);
                    raf.write(typeFe.getDataBlock(), 0, 8);
                    raf.close();
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    if (null != raf) {
                        raf.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setInitialized() {
        this._initialized = true;
    }
}

