/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogOutputStream
extends OutputStream {
    protected final LogOptions _logOptions;
    protected final File _file;
    protected final File _bakFile;
    protected final File _tmpFile;
    protected final int _clusterSize = 4096;

    public LogOutputStream(LogOptions logOptions) throws FileNotFoundException {
        this._logOptions = logOptions;
        this._file = new File(this._logOptions.getFilePath());
        this._bakFile = new File(this._file.getPath() + ".bak");
        this._tmpFile = new File(this._file.getPath() + ".tmp");
    }

    @Override
    public void write(int b) throws IOException {
        throw new RuntimeException("should not call this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        File file = this._file;
        synchronized (file) {
            if (0 != len) {
                int numberOfBytesConsumedInPreWrite = this.preWrite(b, off, len);
                if (0 < numberOfBytesConsumedInPreWrite) {
                    off += numberOfBytesConsumedInPreWrite;
                    len -= numberOfBytesConsumedInPreWrite;
                }
                FileUtils.appendBytes(this._file.getPath(), b, off, len);
                this.postWrite(len);
            }
        }
    }

    protected abstract int preWrite(byte[] var1, int var2, int var3) throws IOException;

    protected void postWrite(int len) throws IOException {
    }

    @Override
    public void flush() {
    }
}

