/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.filesystem.FileModifiedEvent;
import com.integ.filesystem.FileModifiedListener;
import com.integ.filesystem.FileSystemMonitor;
import com.integ.utility.DigitalInputConfig;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.util.Json;

public class Config {
    public static final File FLASH_UTILITY = new File("/flash/utility/");
    public static final File UTILITY_STORAGE = new File("/flash/utility/storage/");
    private static final File CONFIG_FILE = new File(FLASH_UTILITY.getPath() + "config.json");
    private static Json _json = null;
    private static DigitalInputConfig[] _digitalInputConfig = null;

    public static void load() {
        FileSystemMonitor.addFile(CONFIG_FILE, new FileModifiedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileModified(FileModifiedEvent fileModifiedEvent) {
                long start;
                block10: {
                    start = System.currentTimeMillis();
                    try {
                        if (!CONFIG_FILE.exists()) break block10;
                        File file = CONFIG_FILE;
                        synchronized (file) {
                            String fileContents = FileUtils.readAllText(CONFIG_FILE.getPath());
                            _json = new Json(fileContents);
                            Config.access$202(new DigitalInputConfig[UnitConfig.getInputCount()]);
                            if (null == _digitalInputConfig || null != _json && null != _json.get("InputsEnabled")) {
                                if (null == _digitalInputConfig) {
                                    Config.access$202(new DigitalInputConfig[UnitConfig.getInputCount()]);
                                }
                                try {
                                    String[] inputsEnabled = (String[])_json.get("InputsEnabled");
                                    for (int i = 0; i < UnitConfig.getInputCount(); ++i) {
                                        System.out.println("channelNumber: " + (i + 1) + ", inputsEnabled: " + inputsEnabled.length);
                                        if (i >= inputsEnabled.length || null == inputsEnabled[i]) continue;
                                        System.out.println("inputsEnabled[" + i + "]: " + inputsEnabled[i]);
                                        _digitalInputConfig[i] = new DigitalInputConfig((Json)inputsEnabled[i]);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                long elapsed = System.currentTimeMillis() - start;
                AppLog.info("Loaded configuration in " + (double)elapsed / 1000.0 + " seconds");
            }
        });
        FileSystemMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getInputEnabled(int channelNumber) {
        File file = CONFIG_FILE;
        synchronized (file) {
            boolean b = null != _digitalInputConfig && null != _digitalInputConfig[channelNumber - 1] && (Config._digitalInputConfig[channelNumber - 1].Counts || Config._digitalInputConfig[channelNumber - 1].AvgCycle || Config._digitalInputConfig[channelNumber - 1].AvgHigh || Config._digitalInputConfig[channelNumber - 1].AvgLow || Config._digitalInputConfig[channelNumber - 1].AvailablePercent);
            return b;
        }
    }

    public static DigitalInputConfig getInputConfig(int channelNumber) {
        if (null != _digitalInputConfig && null != _digitalInputConfig[channelNumber - 1]) {
            return _digitalInputConfig[channelNumber - 1];
        }
        return DigitalInputConfig.Empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAnalogInputEnabled(int channelNumber) {
        File file = CONFIG_FILE;
        synchronized (file) {
            if (null != _json && null != _json.get("RealTimeInputsEnabled")) {
                try {
                    String[] realTimeInputsEnabled = (String[])_json.get("RealTimeInputsEnabled");
                    if (channelNumber <= realTimeInputsEnabled.length && null != realTimeInputsEnabled[channelNumber - 1]) {
                        return (Boolean)((Object)realTimeInputsEnabled[channelNumber - 1]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    public static int getMinuteBlockDuration() {
        if (null != _json && null != _json.get("MinuteBlockDuration")) {
            try {
                int minuteBlockDuration = _json.getInt("MinuteBlockDuration");
                return minuteBlockDuration;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 6;
    }

    public static int getRealTimeRecordCount() {
        if (null != _json && null != _json.get("RealTimeRecordCount")) {
            try {
                int realTimeRecordCount = _json.getInt("RealTimeRecordCount");
                return realTimeRecordCount;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 10;
    }

    public static void setLastSixMinuteWriteTime(int inputNumber) {
        String keyName = "AppData/DigitalInputTracker/Din" + inputNumber + "/$LastSixMinuteWrite";
        JANOS.setRegistryString((String)keyName, (String)String.valueOf(System.currentTimeMillis()));
    }

    public static long getLastSixMinuteWriteTime(int inputNumber) {
        String keyName = "AppData/DigitalInputTracker/Din" + inputNumber + "/$LastSixMinuteWrite";
        return (long)JANOS.getRegistryDouble((String)keyName, (double)0.0);
    }

    public static boolean getCycleTimeLogEnabled() {
        String keyName = "AppData/utility/CycleTimeLogEnabled";
        return JANOS.getRegistryBoolean((String)keyName, (boolean)false);
    }

    static /* synthetic */ DigitalInputConfig[] access$202(DigitalInputConfig[] x0) {
        _digitalInputConfig = x0;
        return x0;
    }

    static {
        if (!FLASH_UTILITY.exists()) {
            System.out.println("make directory: " + FLASH_UTILITY.getPath());
            FLASH_UTILITY.mkdir();
        }
        if (!UTILITY_STORAGE.exists()) {
            System.out.println("make directory: " + UTILITY_STORAGE.getPath());
            UTILITY_STORAGE.mkdir();
        }
        Config.getCycleTimeLogEnabled();
    }
}

