function RealTimeDigitalChart() {
    var scope = undefined;

    var _this = this;
    _this.initialized = false;

    _this.Title = 'Real-Time Digital';


    // ugh.  passing the $scope variable outside of Angular!  So bad!
    _this.setScope = function ($scope) {
        scope = $scope;
    };


    JnrWebsocket.addEventListener('onLoggedIn', function () {
        // add a listener for the response
        JnrWebsocket.addEventListener('onMessage', _this.onMessage);
        JnrWebsocket.postMessage(1500, { Command: 'get-realtime-records', Input: _input });
    });


    _this.shown = function () {
        if (!_this.initialized) {
        }
    };


    _this.onMessage = function (json) {
        var message = json.Message;
        if ('realtime-records' === message) {
            // make sure this is for the selected input
            if (_input == json.Input) {
                var records = json.Records;
                if (scope) {
                    records = records.reverse();

                    scope.Records = records.map(function (e) {
                        var record = {};
                        record.Timestamp = e.Timestamp;
                        var cycleStart = e.Timestamp - e.CycleTime * 1000;
                        record.CycleStart = moment(cycleStart).format('MM/DD/YYYY h:mm:ss.SS a');
                        var cycleEnd = e.Timestamp;
                        record.CycleEnd = moment(cycleEnd).format('h:mm:ss.SS a');
                        record.CycleTime = e.CycleTime.toFixed(2);
                        record.HighTime = e.HighTime.toFixed(2);
                        record.LowTime = e.LowTime.toFixed(2);
                        return record;
                    });

                    scope.averages = records.reduce(function (accumulator, e) {
                        accumulator.CycleTime += parseFloat(e.CycleTime);
                        accumulator.HighTime += parseFloat(e.HighTime);
                        accumulator.LowTime += parseFloat(e.LowTime);
                        return accumulator;
                    }, { CycleTime: 0, HighTime: 0, LowTime: 0 });
                    scope.averages.CycleTime = (scope.averages.CycleTime / scope.Records.length).toFixed(2);
                    scope.averages.HighTime = (scope.averages.HighTime / scope.Records.length).toFixed(2);
                    scope.averages.LowTime = (scope.averages.LowTime / scope.Records.length).toFixed(2);

                    scope.$apply();
                }
            }
        }
    };


    _this.getRecords = function () {
        return _this.Records;
    };

};
