/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.sorting.FileDateComparer;
import com.integ.sorting.QuickSort;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.io.File;
import java.util.ArrayList;

public class DirectoryCleanupServiceBySize
implements Runnable {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy");
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    protected final Log _cleanupLog = FileLog.getLog(new LogOptions("/" + Application.getAppName() + "_cleanup.log").setMaxFileSizeInKb(64));
    private Thread _thd = null;
    private String _path;
    private int _maxDirectorySize;

    public DirectoryCleanupServiceBySize(String path, int maxDirectorySizeInKb) {
        this._path = path;
        if (!this._path.endsWith("/")) {
            this._path = this._path + "/";
        }
        this._maxDirectorySize = maxDirectorySizeInKb * 1024;
        this._cleanupLog.info(String.format("Max Directory Size for %s: %.2f MB", this._path, (double)this._maxDirectorySize / 1048576.0));
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName());
            this._thd.start();
        }
    }

    @Override
    public void run() {
        AppLog.info(this._thd.getName() + " started");
        while (true) {
            long start = System.currentTimeMillis();
            double initialAvailableFlashRemainingInMb = (double)JANOS.getFreeFlash() / 1048576.0;
            AppLog.info(String.format("%.2f MB remaining in flash", initialAvailableFlashRemainingInMb));
            int maxDirectorySize = this._maxDirectorySize;
            if (8.0 > initialAvailableFlashRemainingInMb) {
                maxDirectorySize = (int)((double)maxDirectorySize - (8.0 - initialAvailableFlashRemainingInMb) * 1048576.0);
                this._cleanupLog.info(String.format("Max Directory Size for %s changed to %.2f MB", this._path, (double)maxDirectorySize / 1048576.0));
            }
            try {
                this._cleanupLog.info("get directory listing for " + this._path);
                File logPathDirectory = new File(this._path);
                String[] fileNames = logPathDirectory.list();
                ArrayList<File> files = new ArrayList<File>();
                for (String fileName : fileNames) {
                    files.add(new File(this._path + fileName));
                }
                File[] filesArray = (File[])files.toArray();
                QuickSort<File> quickSort = new QuickSort<File>();
                quickSort.sort(filesArray, new FileDateComparer());
                long sortElapsed = System.currentTimeMillis() - start;
                this._cleanupLog.info("took " + sortElapsed + " to sort the file array");
                long totalSize = 0L;
                boolean deleteRemainingFiles = false;
                long deletedSize = 0L;
                for (int i = 0; i < filesArray.length; ++i) {
                    File file = filesArray[i];
                    try {
                        this._cleanupLog.info(String.format("%s modified: %s, size: %.2f KB, %.2f MB", file.getName(), QUICK_DATE_FORMAT.format(file.lastModified()), (double)file.length() / 1024.0, (double)(totalSize += file.length()) / 1048576.0));
                        if ((long)maxDirectorySize < totalSize) {
                            if (!deleteRemainingFiles) {
                                this._cleanupLog.info("remove remaining files");
                            }
                            deleteRemainingFiles = true;
                        }
                        if (!deleteRemainingFiles) continue;
                        this._cleanupLog.info("remove " + file.getPath());
                        AppLog.info("remove " + file.getPath());
                        deletedSize += file.length();
                        file.delete();
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this._cleanupLog.info(String.format("removed %,lld bytes", deletedSize));
                if (0L < deletedSize) {
                    AppLog.info(String.format("removed %,lld bytes", deletedSize));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            long elapsed = System.currentTimeMillis() - start;
            this._cleanupLog.info(String.format("cleanup %s took %.1f seconds", this._path, (double)elapsed / 1000.0));
            double availableFlashRemainingInMb = (double)JANOS.getFreeFlash() / 1024.0 / 1024.0;
            if (availableFlashRemainingInMb != initialAvailableFlashRemainingInMb) {
                AppLog.info(String.format("%.2f MB remaining in flash", availableFlashRemainingInMb));
            }
            try {
                Thread.sleep(14400000L);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

