/*
 * Decompiled with CFR 0.152.
 */
package com.integ.filesystem;

import com.integ.filesystem.FileModifiedEvent;
import com.integ.filesystem.FileModifiedListener;
import com.integpg.janoslib.io.AppLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileSystemMonitor
implements Runnable {
    private static final FileSystemMonitor INSTANCE = new FileSystemMonitor();
    private static final Hashtable<File, FileModifiedListener> LISTENER_BY_FILE = new Hashtable();
    private static final Hashtable<File, Long> LAST_MODIFIED_TIME_BY_FILE = new Hashtable();
    private static Thread Thread = null;

    public static void addFile(File file, FileModifiedListener fileModifiedListener) {
        LISTENER_BY_FILE.put(file, fileModifiedListener);
        LAST_MODIFIED_TIME_BY_FILE.put(file, 0L);
    }

    public static void start() {
        if (null == Thread) {
            Thread = new Thread(INSTANCE);
            Thread.setName(INSTANCE.getClass().getName());
            Thread.setDaemon(true);
            Thread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                ArrayList<File> files = this.getFiles();
                for (File file : files) {
                    if (!file.exists()) continue;
                    long lastModifiedTime = LAST_MODIFIED_TIME_BY_FILE.get(file);
                    if (file.lastModified() == lastModifiedTime) continue;
                    AppLog.info(file.getPath() + " has been modified");
                    LAST_MODIFIED_TIME_BY_FILE.put(file, file.lastModified());
                    FileModifiedListener fileModifiedListener = LISTENER_BY_FILE.get(file);
                    if (null == fileModifiedListener) continue;
                    fileModifiedListener.fileModified(new FileModifiedEvent(this, file));
                }
                java.lang.Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ex) {
            AppLog.info(this.getClass().getName() + " has finished");
            return;
        }
    }

    private ArrayList<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Enumeration<File> filesEnum = LAST_MODIFIED_TIME_BY_FILE.keys();
        while (filesEnum.hasMoreElements()) {
            files.add(filesEnum.nextElement());
        }
        return files;
    }
}

