function SixMinuteChart() {
    var _this = this;
    _this.initialized = false;
    _this.downloadedFiles = [];
    _this.Title = 'Every ';
    if (1 == Config.MinuteBlockDuration) _this.Title += 'Minute';
    else _this.Title += Config.MinuteBlockDuration + ' Minutes';

    var _pendingFiles = [];

    var fileRequestTimes = [];
    JnrWebsocket.addEventListener('onLoggedIn', function () {

        // if we have pending files that were requested before the login then we
        // must request them now
        if (0 < _pendingFiles.length) {
            _pendingFiles.forEach(function (filename) {
                if (!_this.downloadedFiles[filename]) {
                    _this.downloadedFiles[filename] = true;
                    console.log('six minutes get ' + filename);
                    // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                    fileRequestTimes[filename] = new Date();
                    JnrWebsocket.readFile(filename, fileReceived);
                }
            });
        }
    });


    function fileReceived(result) {
        var filename = result.File;
        var elapsed = new Date() - fileRequestTimes[filename];
        console.log(filename + ': ' + elapsed);

        if ('Fail' !== result.Status) {
            var fileContents = Base64.decode(result.Data);
            _this.sixMinuteFileCallback(fileContents);
        }
    }


    _this.shown = function () {
        if (!_this.initialized) {
            var ctx = document.getElementById('canvas-six-minute')
            // ctx.height = '100%';
            _this.Chart = new Chart(ctx.getContext('2d'), _this.config);

            _this.loadFileForDate(new Date());
            setTimeout(function () {
                _this.initialized = true;
            }, 5000);
        }

        _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = getYAxisTitle();
        _this.Chart.update();
    };


    _this.getData = function () {
        return _this.sixMinuteDataSet.data;
    };


    _this.loadFileForDate = function (date) {
        var hourlyFileDateString = moment(date).format('YYYYMMMDD');
        var filename = "/flash/utility/storage/by-days/din" + _input + "_" + hourlyFileDateString + ".dat";

        var loggedIn = JnrWebsocket.isLoggedIn();
        if (!loggedIn) {
            _pendingFiles.push(filename);
        } else {
            if (!_this.downloadedFiles[filename]) {
                _this.downloadedFiles[filename] = true;
                console.log('six minute ' + filename);
                // $.get("/utility/download.php?filename=" + filename, _this.sixMinuteFileCallback);
                fileRequestTimes[filename] = new Date();
                JnrWebsocket.readFile(filename, fileReceived);
            }
        }
    };


    _this.updateRollingMetrics = function (rollingMetricsJson) {
        if (!_this.Chart) return;

        var sixMinuteJson = rollingMetricsJson.RollingSixMinuteAverage;
        if (sixMinuteJson) {
            var newData = { x: sixMinuteJson.NextLogTime * 1000, y: sixMinuteJson[_metric], data: sixMinuteJson };
            // console.log(newData);

            var isRealTime = false;
            if (0 !== _this.sixMinuteDataSet.data.length) {
                var axis = _this.Chart.scales['x-axis-0'];
                var mostRecentTime = _this.sixMinuteDataSet.data[_this.sixMinuteDataSet.data.length - 1].x;
                isRealTime = (axis.max >= mostRecentTime);
            }

            // push or replace?
            if (0 === _this.sixMinuteDataSet.data.length ||
                _this.sixMinuteDataSet.data[_this.sixMinuteDataSet.data.length - 1].x !== newData.x) {
                _this.sixMinuteDataSet.data.push(newData);
            } else {
                _this.sixMinuteDataSet.data[_this.sixMinuteDataSet.data.length - 1] = newData;
            }

            if (_this.Chart) {
                var axis = _this.Chart.scales['x-axis-0'];
                var shouldBeMin = getMinTime();
                var isRealTime = shouldBeMin === axis.options.time.min;
                if (isRealTime) {
                    var mostRecentTime = _this.sixMinuteDataSet.data[_this.hourlyDataSet.data.length - 1].x;
                    var duration = axis.max - axis.min;
                    axis.options.time.max = mostRecentTime + (30 * 60000);
                    axis.options.time.min = axis.options.time.max - duration;
                }

                _this.Chart.update();
            }
        }
    };


    _this.chartDataFileCallback = function (fileContents) {
        var lines = fileContents.match(/[^\r\n]+/g);
        var jsonArray = [];
        for (var lineIndex in lines) {
            var line = lines[lineIndex];
            var json = JSON.parse(line);
            jsonArray.push(json);
        }

        var newData = jsonArray.map(function (e) {
            return { x: e.Timestamp * 1000, y: e[_metric], data: e };
        });
        return newData;
    };


    _this.sixMinuteFileCallback = function (fileContents) {
        if (-1 !== fileContents.indexOf('does not exist')) {
            console.log('   ' + fileContents);
            return;
        }

        var newData = _this.chartDataFileCallback(fileContents);
        _this.sixMinuteDataSet.data = _this.sixMinuteDataSet.data.concat(newData);
        _this.sixMinuteDataSet.data.sort(function (a, b) {
            return a.x - b.x;
        });
        _this.Chart.update();
    };


    _this.sixMinuteDataSet = {
        type: 'LineWithLine',
        label: 'Six Minute ' + getDataSetLabel(),
        data: [],
        backgroundColor: Color(window.chartColors.blue).alpha(0.5).rgbString(),
        borderColor: window.chartColors.blue,
        borderWidth: 2,
        fill: false,
        pointRadius: 1,
        lineTension: 0
    };


    function getMinTime() {
        return moment().subtract(4, 'hours').valueOf();
    }


    _this.config = {
        type: 'line',
        data: {
            datasets: [_this.sixMinuteDataSet]
        },
        options: {
            maintainAspectRatio: false,
            animation: {
                duration: 0
            },
            responsive: true,
            tooltips: {
                // enabled: false,
                mode: 'x-axis',
                intersect: false,
                callbacks: {
                    label: function (tooltipItem, data) {
                        var dataPoint = data.datasets[0].data[tooltipItem.index];
                        if (dataPoint.data) {
                            var minutes = dataPoint.data.Minutes;

                            var title = '';
                            if (1 == minutes) title = '1 Minute';
                            else title += minutes + ' Minutes';

                            if ('Counts' === _metric) {
                                return title + ' Total: ' + tooltipItem.yLabel;
                            } else {
                                return title + ' Average: ' + tooltipItem.yLabel.toFixed(2);
                            }
                        }
                    }
                }
            },
            scales: {
                xAxes: [{
                    type: 'time',
                    time: {
                        max: moment().valueOf(), // now
                        min: getMinTime(),
                        unit: 'hour'
                    },
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    ticks: {
                        callback: function (label, index, ticks) {
                            if (0 != ticks.length) {
                                var prevDate = (0 !== index) ? new Date(ticks[index - 1].value) : null;
                                var tickDate = new Date(ticks[index].value);
                                if (prevDate == null || prevDate.getDate() !== tickDate.getDate()) {
                                    label = moment(tickDate).format('ll') + ' ' + label;

                                    if (new Date() > tickDate) {
                                        _this.loadFileForDate(tickDate);
                                    }
                                }
                                return label;
                            }
                        }
                    },
                    beforeBuildTicks: beforeBuildTicks
                }],
                yAxes: [{
                    afterDataLimits: function (axis) {
                        if ('Counts' !== _metric && 360 < axis.max) axis.max = 360;
                    },
                    display: true,
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    scaleLabel: {
                        display: true,
                        labelString: getYAxisTitle()
                    },
                    ticks: {
                        suggestedMin: 0,
                        userCallback: yAxisTicks
                    }
                }]
            },
            legend: {
                display: false
            },
            pan: {
                enabled: true,
                mode: 'x',
                speed: 10,
                threshold: 10
            },
            zoom: {
                enabled: true,
                mode: 'x',
                limits: {
                    max: 10,
                    min: 0.5
                }
            }
        }
    };
};