/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.sorting.FileDateComparer;
import com.integ.sorting.QuickSort;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class DirectoryCleanupService
implements Runnable {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy");
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    protected final Logger _cleanupLog = FileLog.getLog(new LogOptions("/" + Application.getAppName() + "_cleanup.log").setMaxFileSizeInKb(64));
    private Thread _thd = null;
    private String _path;

    public DirectoryCleanupService(String path) {
        this._path = path;
        if (!this._path.endsWith("/")) {
            this._path = this._path + "/";
        }
        this.getMaxDirectorySize();
        this.getMaxAgeInWeeks();
    }

    public void setMaxDirectorySizeInKb(int maxDirectorySizeInKb) {
        String keyName = "AppData/DigitalInputTracker/MaxDirectorySizeInKb";
        JANOS.setRegistryString((String)keyName, (String)String.valueOf(maxDirectorySizeInKb));
    }

    public int getMaxDirectorySize() {
        String keyName = "AppData/DigitalInputTracker/Cleanup/MaxDirectorySizeInKb";
        int maxDirectorySizeInKb = RegistryHelper.getRegistryKey(keyName, 16384);
        int maxDirectorySize = maxDirectorySizeInKb * 1024;
        this._cleanupLog.info(String.format("Max Directory Size for %s: %.2f MB", this._path, (double)maxDirectorySize / 1048576.0));
        return maxDirectorySize;
    }

    public void setMaxAgeInWeeks(int maxAgeInWeeks) {
        String keyName = "AppData/DigitalInputTracker/Cleanup/MaxAgeInWeeks";
        JANOS.setRegistryString((String)keyName, (String)String.valueOf(maxAgeInWeeks));
    }

    public int getMaxAgeInWeeks() {
        String keyName = "AppData/DigitalInputTracker/Cleanup/MaxAgeInWeeks";
        int maxAgeInWeeks = RegistryHelper.getRegistryKey(keyName, 26);
        this._cleanupLog.info(String.format("Max File Age in months Size for %s: %d months", this._path, maxAgeInWeeks));
        return maxAgeInWeeks;
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName(this.getClass().getName());
            this._thd.start();
        }
    }

    @Override
    public void run() {
        AppLog.info(this._thd.getName() + " started");
        while (true) {
            long start = System.currentTimeMillis();
            double initialAvailableFlashRemainingInMb = (double)JANOS.getFreeFlash() / 1048576.0;
            AppLog.info(String.format("%.2f MB remaining in flash", initialAvailableFlashRemainingInMb));
            int maxDirectorySize = this.getMaxDirectorySize();
            if (8.0 > initialAvailableFlashRemainingInMb) {
                maxDirectorySize = (int)((double)maxDirectorySize - (8.0 - initialAvailableFlashRemainingInMb) * 1048576.0);
                this._cleanupLog.info(String.format("Max Directory Size for %s changed to %.2f MB", this._path, (double)maxDirectorySize / 1048576.0));
            }
            long oldestDateTimestamp = System.currentTimeMillis();
            Date oldestDate = new Date(oldestDateTimestamp -= 604800000L * (long)this.getMaxAgeInWeeks());
            this._cleanupLog.info(String.format("Oldest file expiration date for %s is %s", this._path, QUICK_DATE_FORMAT.format(oldestDate)));
            try {
                this._cleanupLog.info("get directory listing for " + this._path);
                ArrayList<File> files = this.getFiles(this._path);
                this._cleanupLog.info(String.format("%d files found in %s", files.size(), this._path));
                this._cleanupLog.info("sorting files by date.  newest to oldest");
                File[] filesArray = (File[])files.toArray();
                QuickSort<File> quickSort = new QuickSort<File>();
                quickSort.sort(filesArray, new FileDateComparer());
                long sortElapsed = System.currentTimeMillis() - start;
                this._cleanupLog.info("took " + sortElapsed + " to sort the file array");
                long totalSize = 0L;
                boolean deleteRemainingFiles = false;
                long deletedSize = 0L;
                for (int i = 0; i < filesArray.length; ++i) {
                    File file = filesArray[i];
                    try {
                        if (deleteRemainingFiles) {
                            this._cleanupLog.info("remove " + file.getPath());
                            AppLog.info("remove " + file.getPath());
                            deletedSize += file.length();
                            file.delete();
                            Thread.sleep(100L);
                            continue;
                        }
                        this._cleanupLog.info(String.format("%s modified: %s, size: %.2f KB, %.2f MB", file.getPath(), QUICK_DATE_FORMAT.format(file.lastModified()), (double)file.length() / 1024.0, (double)(totalSize += file.length()) / 1048576.0));
                        if ((long)maxDirectorySize < totalSize) {
                            if (!deleteRemainingFiles) {
                                this._cleanupLog.info("max file size limit reached.  remove remaining files");
                            }
                            deleteRemainingFiles = true;
                            continue;
                        }
                        if (file.lastModified() >= oldestDate.getTime()) continue;
                        if (!deleteRemainingFiles) {
                            this._cleanupLog.info("max file age limit reached.  remove remaining files");
                        }
                        deleteRemainingFiles = true;
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (0L < deletedSize) {
                    this._cleanupLog.info(String.format("removed %,lld bytes", deletedSize));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            long elapsed = System.currentTimeMillis() - start;
            this._cleanupLog.info(String.format("cleanup %s took %.1f seconds", this._path, (double)elapsed / 1000.0));
            double availableFlashRemainingInMb = (double)JANOS.getFreeFlash() / 1024.0 / 1024.0;
            if (availableFlashRemainingInMb != initialAvailableFlashRemainingInMb) {
                AppLog.info(String.format("%.2f MB remaining in flash", availableFlashRemainingInMb));
            }
            try {
                Thread.sleep(14400000L);
            }
            catch (InterruptedException ex) {
            }
        }
    }

    private ArrayList<File> getFiles(String _path) {
        ArrayList<File> directoriesToList = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        directoriesToList.add(new File(_path));
        while (0 < directoriesToList.size()) {
            String[] fileNames;
            File directory = (File)directoriesToList.remove(0);
            System.out.println("list directory = " + directory);
            for (String fileName : fileNames = directory.list()) {
                File file;
                String directoryPath = directory.getPath();
                if (!directoryPath.endsWith("/")) {
                    directoryPath = directoryPath + "/";
                }
                if ((file = new File(directoryPath + fileName)).isDirectory()) {
                    directoriesToList.add(file);
                    continue;
                }
                files.add(file);
            }
        }
        return files;
    }
}

