function RealTimeChart() {
    var _this = this;
    _this.initialized = false;

    _this.Desc = '';
    _this.Units = '';
    _this.min = 4;
    _this.max = 20;
    _this.DeviceIds = null;
    _this.nextRealTimeReading = new Date().getTime();
    _this.Title = 'Real-Time Analog';


    JnrWebsocket.addEventListener('onLoggedIn', function () {

    });


    _this.shown = function () {
        if (!_this.initialized) {
            var ctx = document.getElementById('canvas-realtime-analog')
            ctx.height = 500;
            _this.Chart = new Chart(ctx.getContext('2d'), _this.config);

            if (JnrWebsocket.isLoggedIn) {
                if (!_this.DeviceIds || null === _this.DeviceIds) {
                    var input = parseInt(_input);
                    var moduleIndex = Math.floor((input - 1) / 4) + 1;

                    JnrWebsocket.readRegistryKey("Externals/DeviceOrder/TypeFE_" + moduleIndex, function (key, value) {
                        if (null !== value) {
                            if (null == _this.DeviceIds) _this.DeviceIds = [];
                            _this.DeviceIds.push(value);

                            var channelIndex = (input - 1) % 4 + 1;
                            JnrWebsocket.readRegistryKeys(
                                ["Externals/" + value + "/Ain" + channelIndex + "/Units",
                                "Externals/" + value + "/Ain" + channelIndex + "/Min",
                                "Externals/" + value + "/Ain" + channelIndex + "/Max"],
                                function (key, value) {
                                    if (key.endsWith('Units')) {
                                        if (null === value) value = 'Value';
                                        _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = value;
                                    }
                                    else if (key.endsWith('Min') && null !== value) {
                                        _this.min = parseFloat(value);
                                        _this.Chart.config.options.scales.yAxes[0].ticks.min = _this.min;
                                    }
                                    else if (key.endsWith('Max') && null !== value) {
                                        _this.max = parseFloat(value);
                                        _this.Chart.config.options.scales.yAxes[0].ticks.max = _this.max;
                                    }

                                    Scope.$apply();
                                    _this.Chart.update();
                                }
                            );
                        }
                    });
                }
            }
            
            _this.loadFile();
            window.setInterval(_this.getCurrentValue, 5000);
        }

        _this.Chart.update();
    };


    _this.getData = function () {
        return _this.dataSet.data;
    };


    _this.getCurrentValue = function () {
        if (JnrWebsocket.isLoggedIn) {
            // if (!_this.DeviceIds || null === _this.DeviceIds) {
            // var input = parseInt(_input);
            // var moduleIndex = Math.floor((input - 1) / 4) + 1;

            // JnrWebsocket.readRegistryKey("Externals/DeviceOrder/TypeFE_" + moduleIndex, function (key, value) {
            //     if (null !== value) {
            //         if (null == _this.DeviceIds) _this.DeviceIds = [];
            //         _this.DeviceIds.push(value);

            //         var channelIndex = (input - 1) % 4 + 1;
            //         JnrWebsocket.readRegistryKeys(
            //             ["Externals/" + value + "/Ain" + channelIndex + "/Units",
            //             "Externals/" + value + "/Ain" + channelIndex + "/Min",
            //             "Externals/" + value + "/Ain" + channelIndex + "/Max"],
            //             function (key, value) {
            //                 if (key.endsWith('Units')) {
            //                     if (null === value) value = 'Value';
            //                     _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = value;
            //                 }
            //                 else if (key.endsWith('Min') && null !== value) {
            //                     _this.min = parseFloat(value);
            //                     _this.Chart.config.options.scales.yAxes[0].ticks.min = _this.min;
            //                 }
            //                 else if (key.endsWith('Max') && null !== value) {
            //                     _this.max = parseFloat(value);
            //                     _this.Chart.config.options.scales.yAxes[0].ticks.max = _this.max;
            //                 }

            //                 Scope.$apply();
            //             }
            //         );
            //     }
            // });
            // }

            if (_this.initialized && null != _this.DeviceIds && new Date().getTime() > _this.nextRealTimeReading) {
                JnrWebsocket.readDevices(_this.DeviceIds, function (device) {
                    _this.nextRealTimeReading = new Date().getTime() + 10000;

                    var input = parseInt(_input);
                    var moduleChannel = (input - 1) % 4;
                    console.log(device);

                    var deviceData = device.Hex;
                    var value = parseInt(deviceData.substring(moduleChannel * 4, moduleChannel * 4 + 4), 16);
                    console.log(device.Address + '.' + moduleChannel + ' = ' + value);

                    var newData = { x: new Date().getTime(), y: _this.getScaledValue(value) };
                    _this.dataSet.data.push(newData);
                    _this.dataSet.data.sort(function (a, b) {
                        return a.x - b.x;
                    });

                    if (_this.Chart) _this.Chart.update();
                });
            }
        }
    };


    _this.getScaledValue = function (rawValue) {
        var percentage = rawValue / 65520.0;
        var scaledValue = (_this.max - _this.min) * percentage + _this.min;
        scaledValue = Math.round(scaledValue * 100) / 100;
        return scaledValue;
    };


    _this.loadFile = function (dte) {
        var input = parseInt(_input);
        var moduleIndex = Math.floor((input - 1) / 4) + 1;

        $.get("/utility/download.php?filename=/flash/utility/storage/typefe_" + moduleIndex + ".dat&binary=true", function (contents) {
            var pos = 0;
            var fileSize = contents.length;
            var currentTime = new Date().getTime();
            while (pos < fileSize) {
                var timestamp = parseInt(contents.substring(pos, pos + 8), 16) * 1000;
                pos += 8;
                if (currentTime >= timestamp && (currentTime - 86400000) < timestamp) {
                    var time = new Date(timestamp);
                    // var line = time + ' ';

                    var input = parseInt(_input);

                    var values = [];
                    for (var i = 0; i < 4; i++) {
                        values[i] = parseInt(contents.substring(pos, pos + 4), 16);
                        pos += 4;
                        // line += values[i] + ' ';

                        if (input === i + 1) {
                            var newData = { x: timestamp, y: _this.getScaledValue(values[i]), time: time };
                            _this.dataSet.data.push(newData);
                        }
                    }
                    // console.log(line);
                } else {
                    pos += 16;
                }
            }

            _this.dataSet.data.sort(function (a, b) {
                return a.x - b.x;
            });

            if (_this.Chart) _this.Chart.update();

            _this.initialized = true;
        });
    };


    _this.dataSet = {
        type: 'LineWithLine',
        label: 'Real-Time Anaglog Signal',
        data: [],
        backgroundColor: Color(window.chartColors.blue).alpha(0.5).rgbString(),
        borderColor: window.chartColors.blue,
        borderWidth: 2,
        lineTension: 0,
        fill: false,
        pointRadius: 0
    };


    _this.config = {
        type: 'LineWithLine',
        data: {
            datasets: [_this.dataSet]
        },
        options: {
            maintainAspectRatio: false,
            animation: {
                duration: 0
            },
            responsive: true,
            tooltips: {
                mode: 'nearest',
                intersect: false,
                callbacks: {
                    title: function (tooltipItem, data) {
                        var x = data.datasets[0].data[tooltipItem[0].index].x;
                        var date = moment(x);
                        return date.format('ll') + ' ' + date.format('h:mm:ss A');
                    }
                }
            },
            scales: {
                xAxes: [{
                    type: 'time',
                    time: {
                        min: new Date() - (3600000 * 2), // 2 hours
                        unit: 'hour',
                        unitStepSize: 1
                    },
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    ticks: {
                        callback: function (label, index, ticks) {
                            if (0 != ticks.length) {
                                var prevDate = (0 !== index) ? new Date(ticks[index - 1].value) : null;
                                var tickDate = new Date(ticks[index].value);
                                if (prevDate == null || prevDate.getDate() !== tickDate.getDate()) {
                                    label = moment(tickDate).format('ll') + ' ' + label;
                                }
                                return label;
                            }
                        }
                    },
                    beforeBuildTicks: beforeBuildTicks
                }],
                yAxes: [{
                    display: true,
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    scaleLabel: {
                        display: true,
                        labelString: 'Value'
                    },
                    ticks: {
                        min: 4,
                        max: 20,
                    }
                }]
            },
            legend: {
                display: false
            },
            pan: {
                enabled: true,
                mode: 'x',
                speed: 10,
                threshold: 10
            },
            zoom: {
                enabled: true,
                mode: 'x',
                limits: {
                    max: 10,
                    min: 0.5
                }
            }
        }
    };
};
