window.chartColors = {
    red: 'rgb(255, 99, 132)',
    orange: 'rgb(255, 159, 64)',
    yellow: 'rgb(255, 205, 86)',
    green: 'rgb(75, 192, 192)',
    blue: 'rgb(54, 162, 235)',
    purple: 'rgb(153, 102, 255)',
    grey: 'rgb(201, 203, 207)'
};


var SelectedChart;
var SavedChartOptions = {};
var _yAxisLabel = "blank";

var Scope;


// our charts
var RealTimeChart = new RealTimeChart();
var RealTimeDigitalChart = new RealTimeDigitalChart();
var SixMinuteChart = new SixMinuteChart();
var DayByHoursChart = new DayByHoursChart();
var MonthByDaysChart = new MonthByDaysChart();
var YearByWeeksChart = new YearByWeeksChart();
var YearByMonthsChart = new YearByMonthsChart();


function getYAxisTitle() {
    if ('Counts' === _metric) return 'Counts';
    if ('AvailablePercent' === _metric) return 'Percent';
    return 'Seconds';
};


function getDataSetLabel() {
    if ('Counts' === _metric) return 'Counts';
    if ('AvgCycle' === _metric) return 'Average Cycle Times';
    if ('AvgHigh' === _metric) return 'Average High Times';
    if ('AvgLow' === _metric) return 'Average Low Times';
    if ('AvailablePercent' === _metric) return 'Available Percentage';
    return 'Unknown';
};


function yAxisTicks(label, index, labels) {
    if (null !== _metric && 'Counts' === _metric) {
        if (Math.floor(label) === label) {
            return Math.floor(label);
        }
    } else return label.toFixed(3);
};


Chart.defaults.LineWithLine = Chart.defaults.line;
Chart.controllers.LineWithLine = Chart.controllers.line.extend({
    // draw: function (ease) {
    //     Chart.controllers.line.prototype.draw.call(this, ease);
    // }
});


Number.prototype.countDecimals = function () {
    if (Math.floor(this.valueOf()) === this.valueOf()) return 0;
    return this.toString().split(".")[1].length || 0;
}


function getChartOptions(chart) {
    var configFileName = '/flash/utility/chart-options.json';
    JnrWebsocket.readFile(configFileName, function (response) {
        if ('Fail' !== response.Status) {
            var fileContents = Base64.decode(response.Data);
            SavedChartOptions = JSON.parse(fileContents);
            var chartOptionsForChart = SavedChartOptions[SelectedChart.toLowerCase()];
            if (chartOptionsForChart && null != chartOptionsForChart) {
                var chartOptions = chartOptionsForChart[_metric.toLowerCase() + '-' + _input];

                if (null != chartOptions) {
                    if (chartOptions.yMin && '' !== chartOptions.yMin) {
                        chart.options.scales.yAxes[0].ticks.min = chartOptions.yMin;
                    }

                    if (chartOptions.yMax && '' !== chartOptions.yMax) {
                        chart.options.scales.yAxes[0].ticks.max = chartOptions.yMax;
                    }

                    if (chartOptions.highWater && '' !== chartOptions.highWater) {
                        chart.options.scales.yAxes[0].ticks.highWater = chartOptions.highWater;
                    }

                    if (chartOptions.lowWater && '' !== chartOptions.lowWater) {
                        chart.options.scales.yAxes[0].ticks.lowWater = chartOptions.lowWater;
                    }

                    chart.update();
                }
            }
        }
    });

    // if this is a percentage chart make sure the range does not exceed 0 - 100%
    if ('AvailablePercent' === _metric) {
        chart.options.scales.yAxes[0].ticks.min = 0;
        chart.options.scales.yAxes[0].ticks.max = 100;
    }
}


function beforeBuildTicks(axis) {
    var duration = axis.max - axis.min;
    duration /= 1000;
    if ((3600 * 24 * 7) < duration) {
        axis.options.time.unit = 'day';
        axis.options.time.stepSize = 1;
    } else if ((3600 * 24) < duration) {
        axis.options.time.unit = 'hour';
        axis.options.time.stepSize = 6;
    } else if ((3600 * 4) < duration) {
        axis.options.time.unit = 'hour';
        axis.options.time.stepSize = 1;
    } else if ((60 * 60) < duration) {
        axis.options.time.unit = 'minute';
        axis.options.time.stepSize = 15
    } else if ((60 * 15) < duration) {
        axis.options.time.unit = 'minute';
        axis.options.time.stepSize = 5
    } else {
        axis.options.time.unit = 'minute';
        axis.options.time.stepSize = 1
    }
}


Chart.pluginService.register({
    afterInit: function (chart) {
        // I was loading the chart options here.  There was a race condition between the chart
        // being initialized and the websocket authenticating.  I will now check to see if the 
        // websocket is logged in.  if it is then i will call the getChartOptions function.  if
        // it is not then we shall register a callback to get alerted when the connection is 
        // logged in.  We will then call the getChartOptions function.
        if (!JnrWebsocket.isLoggedIn()) {
            JnrWebsocket.addOnLoggedInListener(function () {
                getChartOptions(chart);
            });
        } else {
            getChartOptions(chart);
        }

    },
    beforeDraw: function (chart) {
        var ctx = chart.ctx;
        ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
        ctx.textAlign = 'center';
        ctx.textBaseline = 'bottom';

        var scalesX = chart.scales['x-axis-0'];
        var scalesY = chart.scales['y-axis-0'];

        // draw high water
        if (chart.options.scales.yAxes[0].ticks.highWater) {
            var topY = scalesY.top;
            var bottomY = scalesY.bottom;
            var heightY = bottomY - topY;
            var startY = scalesY.start;
            var endY = scalesY.end;
            var pixelsPerTick = heightY / (endY - startY);

            var highWater = chart.options.scales.yAxes[0].ticks.highWater;
            if (highWater >= startY && highWater <= endY) {
                chart.ctx.beginPath();
                chart.ctx.strokeStyle = '#ff0000';
                chart.ctx.moveTo(scalesX.left, (endY - highWater) * pixelsPerTick + topY);
                chart.ctx.lineTo(chart.width, (endY - highWater) * pixelsPerTick + topY);
                chart.ctx.stroke();
            }
        }

        // draw low water
        if (chart.options.scales.yAxes[0].ticks.lowWater) {
            var topY = scalesY.top;
            var bottomY = scalesY.bottom;
            var heightY = bottomY - topY;
            var startY = scalesY.start;
            var endY = scalesY.end;
            var pixelsPerTick = heightY / (endY - startY);

            var lowWater = chart.options.scales.yAxes[0].ticks.lowWater;
            if (lowWater >= startY && highWater <= endY) {
                chart.ctx.beginPath();
                chart.ctx.strokeStyle = '#ff0000';
                chart.ctx.moveTo(scalesX.left, (endY - lowWater) * pixelsPerTick + topY);
                chart.ctx.lineTo(chart.width, (endY - lowWater) * pixelsPerTick + topY);
                chart.ctx.stroke();
            }
        }
    },
    afterDraw: function (chart) {
        // if (chart.chart === RealTimeChart.Chart) updateThumbnail('canvas-realtime-analog', 'real-time-thumbnail');
        // else if (chart.chart === SixMinuteChart.Chart) updateThumbnail('canvas-six-minute', 'six-minute-thumbnail');
        // else if (chart.chart === DayByHoursChart.Chart) updateThumbnail('canvas-day-by-hours', 'day-by-hours-thumbnail');
        // else if (chart.chart === MonthByDaysChart.Chart) updateThumbnail('canvas-month-by-days', 'month-by-days-thumbnail');
        // else if (chart.chart === YearByWeeksChart.Chart) updateThumbnail('canvas-year-by-weeks', 'year-by-weeks-thumbnail');
        // else if (chart.chart === YearByMonthsChart.Chart) updateThumbnail('canvas-year-by-months', 'year-by-months-thumbnail');

        var ctx = chart.ctx;
        ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
        ctx.textAlign = 'center';
        ctx.textBaseline = 'bottom';

        var scalesX = chart.scales['x-axis-0'];
        var scalesY = chart.scales['y-axis-0'];

        // // draw high water
        // if (chart.options.scales.yAxes[0].ticks.highWater) {
        //     var topY = scalesY.top;
        //     var bottomY = scalesY.bottom;
        //     var heightY = bottomY - topY;
        //     var startY = scalesY.start;
        //     var endY = scalesY.end;
        //     var pixelsPerTick = heightY / (endY - startY);

        //     var highWater = chart.options.scales.yAxes[0].ticks.highWater;
        //     if (highWater >= startY && highWater <= endY) {
        //         chart.ctx.beginPath();
        //         chart.ctx.strokeStyle = '#ff0000';
        //         chart.ctx.moveTo(scalesX.left, (endY - highWater) * pixelsPerTick + topY);
        //         chart.ctx.lineTo(chart.width, (endY - highWater) * pixelsPerTick + topY);
        //         chart.ctx.stroke();
        //     }
        // }

        // // draw low water
        // if (chart.options.scales.yAxes[0].ticks.lowWater) {
        //     var topY = scalesY.top;
        //     var bottomY = scalesY.bottom;
        //     var heightY = bottomY - topY;
        //     var startY = scalesY.start;
        //     var endY = scalesY.end;
        //     var pixelsPerTick = heightY / (endY - startY);

        //     var lowWater = chart.options.scales.yAxes[0].ticks.lowWater;
        //     if (lowWater >= startY && highWater <= endY) {
        //         chart.ctx.beginPath();
        //         chart.ctx.strokeStyle = '#ff0000';
        //         chart.ctx.moveTo(scalesX.left, (endY - lowWater) * pixelsPerTick + topY);
        //         chart.ctx.lineTo(chart.width, (endY - lowWater) * pixelsPerTick + topY);
        //         chart.ctx.stroke();
        //     }
        // }

        // if (chart.tooltip._active && chart.tooltip._active.length) {
        //     var activePoint = chart.tooltip._active[0],
        //         x = activePoint.tooltipPosition().x,
        //         topY = scalesY.top,
        //         bottomY = scalesY.bottom;

        //     // draw line
        //     ctx.save();
        //     ctx.beginPath();
        //     ctx.moveTo(x, topY);
        //     ctx.lineTo(x, bottomY);
        //     ctx.lineWidth = 2;
        //     ctx.strokeStyle = '#07C';
        //     ctx.stroke();
        //     ctx.restore();
        // }

        if ('canvas-realtime-analog' != chart.canvas.id) {
            var durationShown = scalesX.max - scalesX.min;
            var dataLabelsShown = 1 * 3600000 >= durationShown || ('bar' === chart.config.type);

            // only show labels if we are looking at an hour or less
            if (dataLabelsShown) {
                chart.config.data.datasets.forEach(function (dataset, i) {
                    var meta = chart.controller.getDatasetMeta(i);
                    meta.data.forEach(function (bar, index) {
                        var data = dataset.data[index];
                        if (undefined !== data.y && !isNaN(data.y)) {
                            var value = data.y;
                            var decimalCount = value.countDecimals();
                            if (0 !== decimalCount) {
                                value = value.toFixed(2);
                            }
                            if (scalesX.left <= bar._model.x && scalesY.bottom >= bar._model.y) {
                                ctx.fillStyle = '#000';
                                ctx.fillText(value, bar._model.x, bar._model.y - 5);
                            }
                        }
                    });
                });
            }

            // show the tooltips if we are not showing data labels
            chart.config.options.tooltips.enabled = !dataLabelsShown;
        }
    }
});


var updateThumbnail = function (chart, thumb) {
    // get six minute chart canvas
    var chartCanvas = document.getElementById(chart)
    var ctx = chartCanvas.getContext('2d');

    // get thumbnail canvas
    var backCanvas = document.getElementById(thumb)
    var backCtx = backCanvas.getContext('2d');

    // save main canvas contents
    backCtx.clearRect(0, 0, backCanvas.width, backCanvas.height);
    backCtx.drawImage(chartCanvas, 0, 0, backCanvas.width, backCanvas.height);
}


App.controller('Controller', function ($scope, $location) {
    var _this = this;
    _this.WebVersion = "2.5";
    _this.Version = "--";

    _this.Config = Config;


    _this.HostName = '';

    _this.SelectedChart = ''; //'six-minute';
    _this.pageName = $location.path();

    _this.analogInputName = '';
    _this.digitalInputName = '';

    Scope = $scope;

    RealTimeDigitalChart.setScope($scope);


    _this.isConfigEmpty = function () {
        return isEmpty(_this.Config);
    };


    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            // // if the path is differnt then let the page redirect
            // if ($location.path() !== _this.pageName) {
            //     window.location = $location.absUrl();
            //     return;
            // }

            if ('/' === $location.path() || 'index.php' === $location.path()) {
                SelectedChart = $location.search().SelectedChart || 'six-minute';
                _input = _this.SelectedInput = $location.search().SelectedInput || '1';

                // here we get the selected metric from the location bar.  we then make sure 
                // that it is one of the metrics available for the selected input.  if it not 
                // then we must change to the defualt metric for the selected input.
                _this.SelectedMetric = $location.search().SelectedMetric || Config.DefaultMetric || 'Counts';

                // get the input config for the selected input
                var inputConfig = Config.InputsEnabled[_input - 1];
                if (!inputConfig || true !== inputConfig[_this.SelectedMetric]) {
                    $location.search('SelectedMetric', inputConfig.DefaultMetric);
                    // force page reload
                    window.location = $location.absUrl();
                }

                if (_this.SelectedChart !== SelectedChart) {
                    _this.setSelectedChart(SelectedChart);
                }
            } else {
                window.location = $location.absUrl();
            }
        }
    });


    _this.getDataFiles = function () {
        JnrWebsocket.postMessage(1500, { Command: 'get-data-files', SelectedChart: _this.SelectedChart, Input: _input });
    };


    _this.getSelectedChart = function () {
        if (_this.SelectedChart === 'real-time') return RealTimeChart;
        else if (_this.SelectedChart === 'six-minute') return SixMinuteChart;
        else if (_this.SelectedChart === 'day-by-hours') return DayByHoursChart;
        else if (_this.SelectedChart === 'month-by-days') return MonthByDaysChart;
        else if (_this.SelectedChart === 'year-by-weeks') return YearByWeeksChart;
        else if (_this.SelectedChart === 'year-by-months') return YearByMonthsChart;
    };


    _this.setSelectedChart = function (selectedChart) {
        _this.SelectedChart = selectedChart;
        $location.search('SelectedChart', selectedChart);

        var chart = _this.getSelectedChart();
        if (null != chart) {
            chart.shown();
        } else {
            console.log('unknown chart selected');
        }
    };


    _this.getChartTitle = function () {
        var chart = null;
        if (_this.SelectedChart === 'real-time') return RealTimeChart.Title;
        else if (_this.SelectedChart === 'real-time-digital') chart = RealTimeDigitalChart;
        else if (_this.SelectedChart === 'six-minute') chart = SixMinuteChart;
        else if (_this.SelectedChart === 'day-by-hours') chart = DayByHoursChart;
        else if (_this.SelectedChart === 'month-by-days') chart = MonthByDaysChart;
        else if (_this.SelectedChart === 'year-by-weeks') chart = YearByWeeksChart;
        else if (_this.SelectedChart === 'year-by-months') chart = YearByMonthsChart;

        if (null != chart) {
            if ('Counts' === _this.SelectedMetric) return 'Counts for ' + chart.Title;
            if ('AvgCycle' === _this.SelectedMetric) return 'Average Cycle Time for ' + chart.Title;
            if ('AvgHigh' === _this.SelectedMetric) return 'Average High Time for ' + chart.Title;
            if ('AvgLow' === _this.SelectedMetric) return 'Average Low Time for ' + chart.Title;
            if ('AvailablePercent' === _this.SelectedMetric) return 'Available Percentage for ' + chart.Title;
        } else {
            return "Unknown";
        }
    };


    _this.chartOptions = function () {
        var yMin, yMax, lowWater, highWater;

        var chartOptionsForChart = SavedChartOptions[_this.SelectedChart.toLowerCase()];
        if (chartOptionsForChart && null != chartOptionsForChart) {
            var chartOptions = chartOptionsForChart[_metric.toLowerCase() + '-' + _input];

            if (null != chartOptions) {
                yMin = chartOptions.yMin;
                yMax = chartOptions.yMax;
                lowWater = chartOptions.lowWater;
                highWater = chartOptions.highWater;
            }
        }
        if (!yMin || null == yMin || isNaN(yMin)) yMin = '';
        if (!yMax || null == yMax || isNaN(yMax)) yMax = '';
        if (!highWater || null == highWater || isNaN(highWater)) highWater = '';
        if (!lowWater || null == lowWater || isNaN(lowWater)) lowWater = '';

        var body = '<a href="#" style="float:right" onclick="$(\'#yMin\').val(\'\'); $(\'#yMax\').val(\'\');">clear</a><h4>Y-Axis</h4>\r\n' +
            'Min: <input type="text" id="yMin" class="form-control" value="' + yMin + '" />\r\n' +
            'Max: <input type="text" id="yMax" class="form-control" value="' + yMax + '" /><br>\r\n' +
            '<a href="#" style="float:right" onclick="$(\'#lowWater\').val(\'\'); $(\'#highWater\').val(\'\');">clear</a><h4>Targets</h4>\r\n' +
            'High: <input type="text" id="highWater" class="form-control" value="' + highWater + '" />\r\n' +
            'Low: <input type="text" id="lowWater" class="form-control" value="' + lowWater + '" /><br>\r\n';

        _this.DataFileDialog = bootbox.dialog({
            className: 'bb-primary',
            title: 'Chart Options',
            message: body,
            // size: 'large',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-success',
                    callback: function () {
                        var selectedChart = _this.getSelectedChart();

                        var yMin = $("#yMin").val();
                        if (yMin && '' !== yMin) {
                            yMin = parseFloat(yMin);
                            selectedChart.Chart.options.scales.yAxes[0].ticks.min = yMin;
                        } else {
                            delete selectedChart.Chart.options.scales.yAxes[0].ticks.min;
                        }

                        var yMax = $("#yMax").val();
                        if (yMax && '' !== yMax) {
                            yMax = parseFloat(yMax);
                            selectedChart.Chart.options.scales.yAxes[0].ticks.max = yMax;
                        } else {
                            delete selectedChart.Chart.options.scales.yAxes[0].ticks.max;
                        }

                        var highWater = $("#highWater").val();
                        if (highWater && '' !== highWater) {
                            highWater = parseFloat(highWater);
                            selectedChart.Chart.options.scales.yAxes[0].ticks.highWater = highWater;
                        } else {
                            delete selectedChart.Chart.options.scales.yAxes[0].ticks.highWater;
                        }

                        var lowWater = $("#lowWater").val();
                        if (lowWater && '' !== lowWater) {
                            lowWater = parseFloat(lowWater);
                            selectedChart.Chart.options.scales.yAxes[0].ticks.lowWater = lowWater;
                        } else {
                            delete selectedChart.Chart.options.scales.yAxes[0].ticks.lowWater;
                        }

                        selectedChart.Chart.update();


                        // lets save this in a chart options file
                        var configFileName = '/flash/utility/chart-options.json';
                        JnrWebsocket.readFile(configFileName, function (response) {
                            var chartOptions = {};

                            if ('Fail' !== response.Status) {
                                var fileContents = Base64.decode(response.Data);
                                chartOptions = JSON.parse(fileContents);
                            }

                            var chartOptionsForChart = chartOptions[_this.SelectedChart.toLowerCase()] || {};
                            chartOptionsForChart[_metric.toLowerCase() + '-' + _input] = {
                                yMin: yMin, yMax: yMax, highWater: highWater, lowWater: lowWater
                            };
                            chartOptions[_this.SelectedChart.toLowerCase()] = chartOptionsForChart;

                            var chartOptionsJsonString = JSON.stringify(chartOptions, null, 2);
                            JnrWebsocket.writeFile(configFileName, chartOptionsJsonString).then(function (result) {
                                if (result.Status) {
                                    bootbox.alert({
                                        className: 'bb-success',
                                        title: 'Success',
                                        message: '<p class="lead">Chart Options Saved</p>'
                                    });

                                    SavedChartOptions = chartOptions;
                                }
                            });
                        });
                    }
                }
            }
        });
    };


    _this.inputChanged = function () {
        $location.search('SelectedInput', _this.SelectedInput);
        // force page reload
        window.location = $location.absUrl();
    };


    _this.metricChanged = function () {
        $location.search('SelectedMetric', _this.SelectedMetric);
        // force page reload
        window.location = $location.absUrl();
    };


    _this.availableMetricArray;


    JnrWebsocket.connect();
    JnrWebsocket.enableCommLogging();

    JnrWebsocket.onLoggedIn = function () {
        JnrWebsocket.readRegistryKeys(
            ["$model", "appdata/utility/$version", "ipconfig/hostname"],
            function (key, value) {
                if (key.endsWith("$version")) {
                    _this.Version = value;
                } else if (key.endsWith("$model")) {
                    _this.analogInputArray = [];
                    _this.digitalInputArray = [];
                    if (!isEmpty(Config)) {
                        for (var i = 0; i <= 4; i++) {
                            if (Config.RealTimeInputsEnabled[i] && true === Config.RealTimeInputsEnabled[i]) _this.analogInputArray.push(i + 1);
                            if (Config.InputsEnabled[i] && objectHasTrueProperty(Config.InputsEnabled[i])) _this.digitalInputArray.push(i + 1);
                        }

                        if (!value.startsWith('412')) {
                            for (var i = 5; i <= 8; i++) {
                                if (Config.RealTimeInputsEnabled[i] && true === Config.RealTimeInputsEnabled[i]) _this.analogInputArray.push(i + 1);
                                if (Config.InputsEnabled[i] && objectHasTrueProperty(Config.InputsEnabled[i])) _this.digitalInputArray.push(i + 1);
                            }

                            if (!value.startsWith('410')) {
                                for (var i = 9; i <= 12; i++) {
                                    if (Config.RealTimeInputsEnabled[i] && true === Config.RealTimeInputsEnabled[i]) _this.analogInputArray.push(i + 1);
                                    if (Config.InputsEnabled[i] && objectHasTrueProperty(Config.InputsEnabled[i])) _this.digitalInputArray.push(i + 1);
                                }

                            }
                        }
                    }
                } else if (key.endsWith("hostname")) {
                    _this.HostName = value;
                }

                $scope.$apply();
            }
        );


        JnrWebsocket.registrySubscription('AppData/Utility/Din' + _this.SelectedInput + '/$RollingMetrics', function (key, value) {
            var json = JSON.parse(value);
            SixMinuteChart.updateRollingMetrics(json);
            DayByHoursChart.updateRollingMetrics(json);
            MonthByDaysChart.updateRollingMetrics(json);
            YearByWeeksChart.updateRollingMetrics(json);
            YearByMonthsChart.updateRollingMetrics(json);
        });


        var input = parseInt(_input);
        var moduleIndex = Math.floor((input - 1) / 4) + 1;


        // $$$$ clean this up later.  i didnt know where to put it but i wanted to get it
        // implemented to see if it would work.

        // get our input config object
        var inputConfig = Config.InputsEnabled[_input - 1];
        _this.availableMetricArray = [];
        if (inputConfig.Counts) _this.availableMetricArray.push({ value: 'Counts', name: 'Counts' });
        if (inputConfig.AvgCycleTime || inputConfig.AvgCycle) _this.availableMetricArray.push({ value: 'AvgCycle', name: 'Average Cycle Time' });
        if (inputConfig.AvgHighTime || inputConfig.AvgHigh) _this.availableMetricArray.push({ value: 'AvgHigh', name: 'Average High Time' });
        if (inputConfig.AvgLowTime || inputConfig.AvgLow) _this.availableMetricArray.push({ value: 'AvgLow', name: 'Average Low Time' });
        if (inputConfig.AvailablePercent) _this.availableMetricArray.push({ value: 'AvailablePercent', name: 'Available Percent' });


        JnrWebsocket.readRegistryKey("Externals/DeviceOrder/TypeFE_" + moduleIndex, function (key, value) {
            if (null !== value) {
                if (null == _this.DeviceIds) _this.DeviceIds = [];
                _this.DeviceIds.push(value);

                var channelIndex = (input - 1) % 4 + 1;
                JnrWebsocket.readRegistryKey("Externals/" + value + "/Ain" + channelIndex + "/Desc",
                    function (key, value) {
                        if (null === value) value = 'Analog Input ' + _input;
                        _this.analogInputName = ' [' + value + ']';

                        $scope.$apply();
                    }
                );
            }
        });


        JnrWebsocket.readRegistryKeys(
            ["IO/Inputs/din" + _input + "/Desc"],
            function (key, value) {
                if (key.endsWith('Desc')) {
                    if (null === value) value = 'Digital Input ' + _input;
                    _this.digitalInputName = ' [' + value + ']';
                }

                $scope.$apply();
            }
        );
    };


    _this.timeRangeChanged = function () {
        if ('original' === _this.SelectedTimRange) location.reload();
        else if ('yesterday' === _this.SelectedTimRange) _this.showYesterday();
        else if ('prev-week' === _this.SelectedTimRange) _this.showPreviousWeek();
        else if ('last-7-days' === _this.SelectedTimRange) _this.showLastWeek();
        else if ('prev-month' === _this.SelectedTimRange) _this.showLastWeek();
        else if ('last-30-days' === _this.SelectedTimRange) _this.showLastMonth();
        else if ('last-90-days' === _this.SelectedTimRange) _this.showLast3Months();
        else if ('last-6-months' === _this.SelectedTimRange) _this.showLast6Months();
        else if ('last-12-months' === _this.SelectedTimRange) _this.showLast12Months();
        else if ('this-year' === _this.SelectedTimRange) _this.showThisYear();
    };


    _this.saveChartData = function (event) {
        if (isIE()) {
            alert('Sorry.  To Save the data you must be using a modern browser like Google Chrome, Mozilla Firefox or Microsoft Edge');

        } else {
            var selectedChart = _this.getSelectedChart();
            var data = selectedChart.getData();
            var axisTime = selectedChart.Chart.config.options.scales.xAxes[0].time;
            var chartMinTime = axisTime.min;
            if (typeof (chartMinTime) === 'object') chartMinTime = chartMinTime._d.valueOf();
            var chartMaxTime = axisTime.max || new Date().getTime();
            if (typeof (chartMaxTime) === 'object') chartMaxTime = chartMaxTime._d.valueOf();

            var outputArray = data.filter(function (e) {
                if (e.x >= chartMinTime && e.x <= chartMaxTime) {
                    return (e.x / 1000) + ', ' + moment(e.x).format('MM-DD-YYYY h:mm a') + ', ' + e.y;
                }
            });

            var outputArray = outputArray.map(function (e) {
                return (e.x / 1000) + ', ' + moment(e.x).format('MM-DD-YYYY h:mm a') + ', ' + e.y;
            });

            if (0 === outputArray.length) {
                bootbox.alert({
                    className: 'bb-danger',
                    title: 'Ooops!',
                    message: '<p class="lead">There is not any data to save.  This shouldn\'t happen!</p>'
                });
                return;
            }

            var output = 'Millseconds, Date Stamp, ' + _metric + '\n' + outputArray.join('\n');

            var filename = _this.HostName;
            if (_this.SelectedChart === 'real-time') filename += _this.analogInputName;
            else filename += _this.digitalInputName;
            filename += '_' + _this.getChartTitle();
            filename = filename.replaceAll(' ', '_');
            filename += '-' + moment().format('YYYYMMDD') + '.csv';
            var $link = $(event.target);
            $link.attr('download', filename)
                .attr('href', "data:application/octet-stream;base64," + Base64.encode(output));
        }
    };


    function isIE() {
        var ua = window.navigator.userAgent;
        var msie = ua.indexOf("MSIE ");
        return msie > 0;
    }


    _this.showYesterday = function () {
        _this.showRange(moment().startOf('day').subtract(1, 'days').valueOf(), moment().startOf('day').valueOf());
    };


    _this.showPreviousWeek = function () {
        _this.showRange(moment().startOf('week').subtract(1, 'weeks').valueOf(), moment().startOf('week').valueOf());
    };


    _this.showLastWeek = function () {
        _this.showRange(moment().startOf('day').subtract(1, 'weeks').valueOf(), moment().valueOf());
    };


    _this.showPreviousMonth = function () {
        _this.showRange(moment().startOf('month').subtract(1, 'months').valueOf(), moment().startOf('month').valueOf());
    };


    _this.showLastMonth = function () {
        _this.showRange(moment().startOf('day').subtract(1, 'months').valueOf(), moment().valueOf());
    };


    _this.showLast3Months = function () {
        _this.showRange(moment().startOf('day').subtract(3, 'months').valueOf(), moment().valueOf());
    };


    _this.showLast6Months = function () {
        _this.showRange(moment().startOf('day').subtract(6, 'months').valueOf(), moment().valueOf());
    };


    _this.showLast12Months = function () {
        _this.showRange(moment().startOf('day').subtract(12, 'months').valueOf(), moment().valueOf());
    };


    _this.showThisYear = function () {
        _this.showRange(moment().startOf('year').valueOf(), moment().valueOf());
    };


    _this.showRange = function (start, end) {
        var selectedChart = _this.getSelectedChart();
        selectedChart.Chart.config.options.scales.xAxes[0].time.min = start;
        selectedChart.Chart.config.options.scales.xAxes[0].time.max = end;
        selectedChart.Chart.update();
    };


    _this.showCustomRange = function () {
        var body = '' +
            '<p>Select the start date: <input type="text" class="form-control" data-date-format="mm/dd/yy" data-date-autoclose="true" id="cust-start-date"></p>\r\n' +
            '<p>Select the end date:  <input type="text" class="form-control" data-date-format="mm/dd/yy" data-date-autoclose="true" id="cust-end-date"></p>\r\n' +
            // '<p>Select the time resolution: <select class="form-control">\r\n' +
            // '<option>Every six Minutes</option>\r\n' +
            // '<option>Rolling Day by Hours</option>\r\n' +
            // '<option>Rolling Month by Days</option>\r\n' +
            // '<option>Rolling Year by Weeks</option>\r\n' +
            // '<option>Rolling Year by Months</option>\r\n' +
            // '</select>\r\n';
            '';

        _this.DataFileDialog = bootbox.dialog({
            className: 'bb-primary',
            title: 'Set Custom Date Range',
            message: body,
            // size: 'large',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-success',
                    callback: function () {
                        var startDate = $("#cust-start-date").val();
                        var endDate = $("#cust-end-date").val();

                        var selectedChart = _this.getSelectedChart();
                        selectedChart.Chart.config.options.scales.xAxes[0].time.min = moment(startDate).valueOf();
                        selectedChart.Chart.config.options.scales.xAxes[0].time.max = moment(endDate).valueOf();
                        selectedChart.Chart.update();
                    }
                }
            }
        });
        _this.DataFileDialog.init(function () {
            var selectedChart = _this.getSelectedChart();

            var minDate = moment(selectedChart.Chart.config.options.scales.xAxes[0].time.min);
            var maxDate = moment(selectedChart.Chart.config.options.scales.xAxes[0].time.max);

            if (_this.SelectedChart.startsWith('year')) {
                $("#cust-start-date").datepicker({ startView: 'year', minViewMode: 'month', format: "MM yyyy" });
                $("#cust-end-date").datepicker({ startView: 'year', minViewMode: 'month', format: "MM yyyy" });

                $("#cust-start-date").datepicker().on('changeMonth', function (ev) {
                    $("#cust-start-date").datepicker('hide');
                });

                $("#cust-end-date").datepicker().on('changeMonth', function (ev) {
                    $("#cust-end-date").datepicker('hide');
                });
            }

            $("#cust-start-date").datepicker('update', minDate.format('MM-DD-YYYY'));
            $("#cust-end-date").datepicker('update', maxDate.format('MM-DD-YYYY'));

            $('#cust-start-date').datepicker().on('changeDate', function (ev) {
                $("#cust-end-date").datepicker('setStartDate', $("#cust-start-date").val());
            });

            $('#cust-end-date').datepicker().on('changeDate', function (ev) {
                $("#cust-start-date").datepicker('setEndDate', $("#cust-end-date").val());
            });

            _this.DataFileDialog.draggable({
                handle: ".modal-header"
            });
        });
    };
});