function DayByHoursChart() {
    var _this = this;
    _this.initialized = false;
    _this.downloadedFiles = [];
    _this.Title = 'Rolling Day by Hours';
    _this.realtime = true;
    _this.loading = true;

    var _pendingFiles = [];
    var _filesInProgress = [];

    var fileRequestTimes = [];
    JnrWebsocket.addEventListener('onLoggedIn', function () {

        // if we have pending files that were requested before the login then we
        // must request them now
        if (0 < _pendingFiles.length) {
            _pendingFiles.forEach(function (filename) {
                if (!_this.downloadedFiles[filename]) {
                    _this.downloadedFiles[filename] = true;
                    console.log('day by hours get ' + filename);
                    // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                    fileRequestTimes[filename] = new Date();
                    _filesInProgress.push(filename);
                    console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                    JnrWebsocket.readFile(filename, fileReceived);
                }
            });
        }
    });


    function fileReceived(result) {
        var filename = result.File;
        var elapsed = new Date() - fileRequestTimes[filename];
        console.log(filename + ': ' + elapsed);

        if ('Fail' !== result.Status) {
            var fileContents = Base64.decode(result.Data);
            _this.hourlyFileCallback(fileContents);
        }

        var indexOf = _filesInProgress.indexOf(filename);
        _filesInProgress.splice(indexOf, 1);
        console.log('remove ' + filename + ' from files in progress.  ' + _filesInProgress.length + ' files remaining');
        if (0 === _filesInProgress.length) {
            _this.loading = false;
            JnrWebsocket.readRegistryKey('AppData/Utility/Din' + _input + '/$RollingMetrics', function (key, value) {
                var json = JSON.parse(value);
                _this.updateRollingMetrics(json);
            });
        }
    }


    _this.shown = function () {
        if (!_this.initialized) {
            var ctx = document.getElementById('canvas-day-by-hours')
            ctx.height = 500;
            _this.Chart = new Chart(ctx.getContext('2d'), _this.config);

            _this.loadFileForDate(new Date());
            setTimeout(function () {
                _this.initialized = true;
            }, 5000);
        }

        _this.Chart.config.options.scales.yAxes[0].scaleLabel.labelString = getYAxisTitle();
        _this.Chart.update();
    };


    _this.getData = function () {
        return _this.hourlyDataSet.data;
    };


    _this.loadFileForDate = function (date) {
        // var weekOfYear = date.getWeek(); 
        var weekOfYear = moment(date).week();
        var weekOfYearString = ("0" + weekOfYear).slice(-2);
        var fileDateString = moment(date).format('YYYY') + 'wk' + weekOfYearString;
        var filename = "/flash/utility/storage/by-weeks/din" + _input + "_" + fileDateString + ".dat";

        var loggedIn = JnrWebsocket.isLoggedIn();
        if (!loggedIn) {
            _pendingFiles.push(filename);
        } else {
            if (!_this.downloadedFiles[filename]) {
                _this.downloadedFiles[filename] = true;
                console.log('day by hours ' + filename);
                // $.get("/utility/download.php?filename=" + filename, _this.hourlyFileCallback);
                fileRequestTimes[filename] = new Date();
                _filesInProgress.push(filename);
                console.log('add ' + filename + ' to files in progress.  ' + _filesInProgress.length + ' files in progress');
                JnrWebsocket.readFile(filename, fileReceived);
            }
        }
    };


    _this.updateRollingMetrics = function (rollingMetricsJson) {
        // make sure we have loaded some data for this chart already
        if (_this.loading) return;

        var hourlyJson = rollingMetricsJson.RollingHourlyAverage;
        var startOfHour = new Date(rollingMetricsJson.Timestamp * 1000);
        startOfHour.setMinutes(0, 0, 0);

        var newData = { x: startOfHour.getTime(), y: hourlyJson[_metric] };

        console.log(newData);

        // var isRealTime = false;
        // if (0 !== _this.hourlyDataSet.data.length) {
        //     var axis = _this.Chart.scales['x-axis-0'];
        //     var mostRecentTime = _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1].x;
        //     isRealTime = (axis.max >= mostRecentTime);
        // }

        // push or replace?
        if (0 === _this.hourlyDataSet.data.length ||
            _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1].x !== newData.x) {
            _this.hourlyDataSet.data.push(newData);
        } else {
            _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1] = newData;
        }

        if (_this.Chart) {
            var axis = _this.Chart.scales['x-axis-0'];
            var shouldBeMin = getMinTime();
            var isRealTime = shouldBeMin === axis.options.time.min;
            if (isRealTime) {
                var mostRecentTime = _this.hourlyDataSet.data[_this.hourlyDataSet.data.length - 1].x;
                var duration = axis.max - axis.min;
                axis.options.time.max = mostRecentTime + (30 * 60000);
                axis.options.time.min = axis.options.time.max - duration;
            }

            _this.Chart.update();
        }
    };


    _this.chartDataFileCallback = function (fileContents) {
        var lines = fileContents.match(/[^\r\n]+/g);
        var jsonArray = [];
        for (var lineIndex in lines) {
            var line = lines[lineIndex];
            var json = JSON.parse(line);
            jsonArray.push(json);
        }

        var newData = jsonArray.map(function (e) {
            return { x: e.Timestamp * 1000 - (e.Minutes * 60000), y: e[_metric] };
        });
        return newData;
    };


    _this.hourlyFileCallback = function (fileContents) {
        if (-1 !== fileContents.indexOf('does not exist')) {
            console.log('   ' + fileContents);
            _this.initialized = true;
            return;
        }

        var newData = _this.chartDataFileCallback(fileContents);
        _this.hourlyDataSet.data = _this.hourlyDataSet.data.concat(newData);
        _this.hourlyDataSet.data.sort(function (a, b) {
            return a.x - b.x;
        });
        _this.Chart.update();
    };


    _this.hourlyDataSet = {
        type: ('Counts' === _metric) ? 'bar' : 'line',
        fill: ('Counts' === _metric) ? true : false,
        label: 'Hourly Averages',
        data: [],
        backgroundColor: Color(window.chartColors.blue).alpha(0.5).rgbString(),
        borderColor: window.chartColors.blue,
        borderWidth: 2,
        pointRadius: 1,
        lineTension: 0
    };


    function getMinTime() {
        return moment().startOf('hour').subtract(25, 'hours').add(30, 'minute').valueOf();
    }


    _this.config = {
        type: 'bar',
        data: {
            datasets: [_this.hourlyDataSet]
        },
        options: {
            maintainAspectRatio: false,
            animation: {
                duration: 0
            },
            responsive: true,
            showTooltips: true,
            tooltips: {
                // enabled: false,
                mode: 'x-axis',
                intersect: false,
                callbacks: {
                    title: function (tooltipItem, data) {
                        var x = data.datasets[0].data[tooltipItem[0].index].x;
                        var date = moment(x);
                        return date.format('ll') + ' ' + date.format('h A');
                    },
                    label: function (tooltipItem, data) {
                        if ('Counts' === _metric) {
                            return 'Hourly Total: ' + tooltipItem.yLabel;
                        } else {
                            return 'Hourly Average: ' + tooltipItem.yLabel.toFixed(2);
                        }
                    }
                }
            },
            scales: {
                xAxes: [{
                    type: 'time',
                    time: {
                        max: moment().startOf('hour').add(30, 'minute').valueOf(), // now
                        min: getMinTime(),
                        unit: 'hour',
                        unitStepSize: 1
                    },
                    gridLines: {
                        borderDash: [6, 2],
                        offsetGridLines: true
                    },
                    ticks: {
                        callback: function (label, index, ticks) {
                            if (0 != ticks.length) {
                                var prevDate = (0 !== index) ? new Date(ticks[index - 1].value) : null;
                                var tickDate = new Date(ticks[index].value);
                                if (prevDate == null || prevDate.getDate() !== tickDate.getDate()) {
                                    label = moment(tickDate).format('ll') + ' ' + label;

                                    if (new Date() > tickDate) {
                                        _this.loadFileForDate(tickDate);
                                    }
                                }
                                return label;
                            }
                        }
                    }
                }],
                yAxes: [{
                    display: true,
                    gridLines: {
                        borderDash: [6, 2]
                    },
                    scaleLabel: {
                        display: true,
                        labelString: 'Seconds'
                    },
                    ticks: {
                        suggestedMin: 0,
                        userCallback: yAxisTicks
                    }
                }]
            },
            legend: {
                display: false
            },
            pan: {
                enabled: true,
                mode: 'x',
                speed: 10,
                threshold: 10
            },
            zoom: {
                enabled: true,
                mode: 'x',
                limits: {
                    max: 10,
                    min: 0.5
                }
            }
        }
    };



    // Date.prototype.getWeek = function () {
    //     var target  = new Date(this.valueOf());
    //     var dayNr   = (this.getDay() + 6) % 7;
    //     target.setDate(target.getDate() - dayNr + 3);
    //     var firstThursday = target.valueOf();
    //     target.setMonth(0, 1);
    //     if (target.getDay() != 4) {
    //         target.setMonth(0, 1 + ((4 - target.getDay()) + 7) % 7);
    //     }
    //     return 1 + Math.ceil((firstThursday - target) / 604800000);
    // }


    Date.prototype.getWeek = function () {
        var target = new Date(this.valueOf());
        console.log('target: ' + target);
        var dayNr = this.getDay();
        // console.log('  dayNr: ' + dayNr);
        target.setDate(target.getDate() - dayNr); // + 3);
        // console.log('  target: ' + target);

        if (this.getFullYear() !== target.getFullYear()) {
            return 1;
        }

        var firstSunday = target.valueOf();
        // console.log('  firstSunday: ' + firstSunday);
        target.setMonth(0, 1);
        // console.log('  target: ' + target);
        if (target.getDay() != 0) {
            target.setMonth(0, 1 + (target.getDay() + 7) % 7);
            // console.log('  not sunday, target: ' + target);
        }
        var result = 1 + Math.ceil((firstSunday - target) / 604800000);
        console.log('  result: ' + result);
        return result;
    }


    // var d = new Date();
    // console.log('week of year: ' + d.getWeek());
    // d.setDate(d.getDate()-1);
    // console.log('week of year: ' + d.getWeek());
    // d.setDate(d.getDate()-1);
    // console.log('week of year: ' + d.getWeek());
    // d.setDate(d.getDate()-1);
    // console.log('week of year: ' + d.getWeek());
    // d.setDate(d.getDate()-1);
    // console.log('week of year: ' + d.getWeek());
    // d.setDate(d.getDate()-1);
    // console.log('week of year: ' + d.getWeek());    
};
