/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.utility.Config;
import com.integ.utility.CycleTime;
import com.integ.utility.DigitalInputConfig;
import com.integ.utility.DigitalInputRecord;
import com.integ.utility.InputDuration;
import com.integ.utility.TransitionEvent;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Json;

public class TimePeriodTracker {
    private static final String DEBUG_TIMEPERIODLOG = "digitallog";
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    private final Log _log;
    private final int _inputNumber;
    private final String _timePeriodString;
    private final ArrayList<CycleTime> _cycleTimeArrayList;
    private int _cycleTimeIndex = 0;
    private final ArrayList<TransitionEvent> _ioEventArrayList;
    private int _ioEventIndex = 0;
    private double _totalizedCycleTime = 0.0;
    private double _totalizedHighTime = 0.0;
    private double _totalizedLowTime = 0.0;
    private DigitalInputRecord _record = new DigitalInputRecord();
    private long _boundaryStartTime;
    private final InputDuration _inputDuration;

    public TimePeriodTracker(int inputNumber, String timePeriodString, ArrayList<CycleTime> cycleTimeArrayList, ArrayList<TransitionEvent> ioEventArrayList, long boundaryStartTime, InputDuration inputDuration) {
        this._inputNumber = inputNumber;
        this._timePeriodString = timePeriodString;
        this._cycleTimeArrayList = cycleTimeArrayList;
        this._ioEventArrayList = ioEventArrayList;
        this._boundaryStartTime = boundaryStartTime;
        this._inputDuration = inputDuration;
        this._log = FileLog.getLog(new LogOptions("/temp/" + Application.getAppName() + "_din" + inputNumber + "_" + StringUtils.replaceAll(timePeriodString, "-", "_") + ".log").setMaxFileSizeInKb(128));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCycleTime(CycleTime cycleTime) {
        ArrayList<CycleTime> arrayList = this._cycleTimeArrayList;
        synchronized (arrayList) {
            if (this._boundaryStartTime > cycleTime.InitialTransitionHighTime) {
                ++this._cycleTimeIndex;
                return;
            }
            this._totalizedCycleTime += cycleTime.getCycleDuration();
            this._totalizedHighTime += cycleTime.getHighDuration();
            this._totalizedLowTime += cycleTime.getLowDuration();
        }
    }

    public void addTransitionEvent(TransitionEvent transitionEvent) {
        if (this._boundaryStartTime > transitionEvent.Timestamp) {
            ++this._ioEventIndex;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        ArrayList<CycleTime> arrayList = this._cycleTimeArrayList;
        synchronized (arrayList) {
            if (0 < this._cycleTimeIndex) {
                --this._cycleTimeIndex;
                CycleTime cycleTime = this._cycleTimeArrayList.get(this._cycleTimeIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementIoEvent() {
        ArrayList<TransitionEvent> arrayList = this._ioEventArrayList;
        synchronized (arrayList) {
            if (0 < this._ioEventIndex) {
                --this._ioEventIndex;
                TransitionEvent transitionEvent = this._ioEventArrayList.get(this._ioEventIndex);
                if (DEBUG.is(DEBUG_TIMEPERIODLOG)) {
                    this._log.info("decremented " + this._timePeriodString + " ioEventIndex to [" + this._ioEventIndex + "] " + QUICK_DATE_FORMAT.format(transitionEvent.Timestamp));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long boundaryStartTime) {
        try {
            int lastIndex;
            ArrayList<Object> arrayList = this._cycleTimeArrayList;
            synchronized (arrayList) {
                if (0 < this._cycleTimeArrayList.size() && this._cycleTimeArrayList.size() > this._cycleTimeIndex) {
                    CycleTime cycleTime = this._cycleTimeArrayList.get(this._cycleTimeIndex);
                    lastIndex = this._cycleTimeIndex;
                    while (cycleTime.InitialTransitionHighTime < boundaryStartTime) {
                        this._log.info(String.format("remove index %d/%d, %lld, %.2f, %.2f, %.2f, %d, %.2f, %.2f, %.2f", this._cycleTimeIndex, this._cycleTimeArrayList.size(), cycleTime.CompletionTime, cycleTime.getCycleDuration(), cycleTime.getHighDuration(), cycleTime.getLowDuration(), this._record.Counts - 1, this._totalizedCycleTime, this._totalizedHighTime, this._totalizedLowTime));
                        this._totalizedCycleTime -= cycleTime.getCycleDuration();
                        this._totalizedHighTime -= cycleTime.getHighDuration();
                        this._totalizedLowTime -= cycleTime.getLowDuration();
                        ++this._cycleTimeIndex;
                        this._log.info(String.format("%d/%d, %lld, %d, %.2f, %.2f, %.2f", this._cycleTimeIndex, this._cycleTimeArrayList.size(), cycleTime.CompletionTime, this._record.Counts - 1, this._totalizedCycleTime, this._totalizedHighTime, this._totalizedLowTime));
                        if (this._cycleTimeArrayList.size() <= this._cycleTimeIndex) break;
                        cycleTime = this._cycleTimeArrayList.get(this._cycleTimeIndex);
                    }
                    if (lastIndex != this._cycleTimeIndex) {
                        if (0.0 != this._totalizedCycleTime) {
                            this._log.warn(String.format("totalized cycle time is not zero! %d, %.3f, %.3f, %.3f", this._record.Counts - 1, this._totalizedCycleTime, this._totalizedHighTime, this._totalizedLowTime));
                        }
                        this._log.info("updated " + this._timePeriodString + " cycleTimeIndex since " + QUICK_DATE_FORMAT.format(boundaryStartTime) + " to [" + this._cycleTimeIndex + "] " + QUICK_DATE_FORMAT.format(cycleTime.CompletionTime));
                    }
                }
            }
            arrayList = this._ioEventArrayList;
            synchronized (arrayList) {
                if (0 < this._ioEventArrayList.size() && this._ioEventArrayList.size() > this._ioEventIndex) {
                    TransitionEvent transitionEvent = this._ioEventArrayList.get(this._ioEventIndex);
                    lastIndex = this._ioEventIndex;
                    while (transitionEvent.Timestamp < boundaryStartTime) {
                        ++this._ioEventIndex;
                        if (this._ioEventArrayList.size() <= this._ioEventIndex) break;
                        transitionEvent = this._ioEventArrayList.get(this._ioEventIndex);
                    }
                    if (lastIndex != this._ioEventIndex && DEBUG.is(DEBUG_TIMEPERIODLOG)) {
                        this._log.info("updated " + this._timePeriodString + " ioEventIndex since " + QUICK_DATE_FORMAT.format(boundaryStartTime) + " to [" + this._cycleTimeIndex + "] " + QUICK_DATE_FORMAT.format(transitionEvent.Timestamp));
                    }
                }
            }
            long start = System.currentTimeMillis();
            double counts = 0.0;
            for (int i = this._ioEventIndex; i < this._ioEventArrayList.size(); ++i) {
                counts += this._ioEventArrayList.get((int)i).CountMultiplier;
            }
            this._record.Counts = (int)counts;
            long elapsed = System.currentTimeMillis() - start;
            if (0 < this._record.Counts - 1) {
                this._log.info(String.format("_totalizedCycleTime: %.2f, _totalizedHighTime: %.2f, _totalizedLowTime: %.2f, _record.Counts: %d", this._totalizedCycleTime, this._totalizedHighTime, this._totalizedLowTime, this._record.Counts - 1));
                this._record.AvgCycleTime = this._totalizedCycleTime / (double)(this._record.Counts - 1);
                this._record.AvgHighTime = this._totalizedHighTime / (double)(this._record.Counts - 1);
                this._record.AvgLowTime = this._totalizedLowTime / (double)(this._record.Counts - 1);
            } else {
                this._record.AvgCycleTime = 0.0;
                this._record.AvgHighTime = 0.0;
                this._record.AvgLowTime = 0.0;
            }
            if (DEBUG.is(DEBUG_TIMEPERIODLOG)) {
                DigitalInputConfig digitalInputConfig = Config.getInputConfig(this._inputNumber);
                this._log.info("TimePeriod: " + this._timePeriodString + ": " + this._record.getJson(digitalInputConfig));
            }
        }
        catch (Exception ex) {
            this._log.error("_arrayList.size(): " + this._cycleTimeArrayList.size() + ", _index: " + this._cycleTimeIndex, ex);
            throw ex;
        }
        this._boundaryStartTime = boundaryStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldestCycleTime() {
        ArrayList<CycleTime> arrayList = this._cycleTimeArrayList;
        synchronized (arrayList) {
            this._log.info("getOldestCycleTime:: _arrayList.size(): " + this._cycleTimeArrayList.size() + ", _index: " + this._cycleTimeIndex);
            if (0 < this._cycleTimeArrayList.size() && this._cycleTimeIndex < this._cycleTimeArrayList.size()) {
                CycleTime cycleTime = this._cycleTimeArrayList.get(this._cycleTimeIndex);
                return cycleTime.CompletionTime;
            }
        }
        return -1L;
    }

    public Json getJson() {
        return this.getJson(false);
    }

    public Json getJson(boolean getAll) {
        this._record.AvailablePercent = this._inputDuration.getPercentage() * 100.0;
        DigitalInputConfig digitalInputConfig = null;
        if (!getAll) {
            digitalInputConfig = Config.getInputConfig(this._inputNumber);
        }
        return this._record.getJson(digitalInputConfig);
    }
}

