/*
 * Decompiled with CFR 0.152.
 */
package com.integ.sorting;

import com.integ.sorting.Comparator;

public class QuickSort<T> {
    private T[] array;
    private int length;
    private Comparator _comparator;

    public void sort(T[] inputArr, Comparator comparator) {
        if (inputArr == null || inputArr.length == 0) {
            return;
        }
        this.array = inputArr;
        this.length = inputArr.length;
        this._comparator = comparator;
        this.quickSort(0, this.length - 1);
    }

    private void quickSort(int lowerIndex, int higherIndex) {
        int i = lowerIndex;
        int j = higherIndex;
        int pivotIndex = lowerIndex + (higherIndex - lowerIndex) / 2;
        T pivot = this.array[pivotIndex];
        while (i <= j) {
            while (i < pivotIndex && this._comparator.compare(this.array[i], pivot) < 0) {
                ++i;
            }
            while (j > pivotIndex && this._comparator.compare(this.array[j], pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            this.swap(i, j);
            ++i;
            --j;
        }
        if (lowerIndex < j) {
            this.quickSort(lowerIndex, j);
        }
        if (i < higherIndex) {
            this.quickSort(i, higherIndex);
        }
    }

    private void swap(int i, int j) {
        T temp = this.array[i];
        this.array[i] = this.array[j];
        this.array[j] = temp;
    }
}

