/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogOutputStream;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BakLogOutputStream
extends LogOutputStream {
    public BakLogOutputStream(LogOptions logOptions) throws FileNotFoundException {
        super(logOptions);
    }

    @Override
    protected int preWrite(byte[] b, int off, int len) throws IOException {
        if ((long)this._logOptions.getMaxFileSize() < this._file.length() + (long)len) {
            return this.bakFile(b, off, len);
        }
        return 0;
    }

    private int bakFile(byte[] b, int off, int len) throws IOException {
        File bakFile;
        long start = System.currentTimeMillis();
        int remainingSpace = this._logOptions.getMaxFileSize() - (int)this._file.length();
        while (0 < remainingSpace--) {
            if (10 != b[remainingSpace]) continue;
            FileUtils.appendBytes(this._file.getPath(), b, off, remainingSpace++);
            break;
        }
        if ((bakFile = new File(this._logOptions.getFilePath() + ".bak")).exists()) {
            bakFile.delete();
        }
        this._file.renameTo(bakFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to create bak file for %s", elapsed, this._file.getPath()));
        return remainingSpace;
    }
}

