/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.text.DecimalFormat;
import java.util.Json;

public class InputDuration {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final Log _log;
    private final int _inputNumber;
    private final String _timePeriodString;
    private final Json _json = new Json();
    private long _boundaryTime = -1L;
    private long _lastTransitionTime = -1L;
    private int _lastState = -1;
    private long _totalizedDuration = 0L;
    private double _lastPercentage;

    public InputDuration(int inputNumber, String timePeriodString) {
        this._log = FileLog.getLog(new LogOptions(String.format("/temp/%s_din%d_inputduration_%s.log", Application.getAppName(), inputNumber, timePeriodString)).setMaxFileSizeInKb(32));
        this._log.vital("application startup - " + timePeriodString);
        this._inputNumber = inputNumber;
        this._timePeriodString = timePeriodString;
        this._json.put("TimePeriodString", (Object)timePeriodString);
        this._lastState = JANOS.getInputStates() >> this._inputNumber - 1 & 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(long transitionTime, int state) {
        InputDuration inputDuration = this;
        synchronized (inputDuration) {
            this._json.put("State", state);
            if (-1L != this._boundaryTime) {
                if (0 == state) {
                    if (-1L != this._lastTransitionTime) {
                        long highTime = transitionTime - this._lastTransitionTime;
                        this._totalizedDuration += highTime;
                    }
                } else {
                    this._lastTransitionTime = transitionTime;
                }
            }
            this._lastState = state;
            this.updateJson(transitionTime);
        }
    }

    private void updateJson(long transitionTime) {
        this._json.put("Timestamp", (Object)QUICK_DATE_FORMAT.format(transitionTime));
        this._json.put("Duration", this._totalizedDuration);
        double percent = 0.0;
        if (-1L != this._boundaryTime) {
            this._log.info(String.format("transitionTime: %s - _boundaryTime: %s", QUICK_DATE_FORMAT.format(transitionTime), QUICK_DATE_FORMAT.format(this._boundaryTime)));
            long timePeriodDuration = transitionTime - this._boundaryTime;
            if (0L < timePeriodDuration) {
                percent = (double)this._totalizedDuration / (double)timePeriodDuration;
            }
            this._lastPercentage = percent;
            this._log.info(String.format("_totalizedDuration: %lld / timePeriodDuration: %lld = %.2f", this._totalizedDuration, timePeriodDuration, this._lastPercentage));
        }
        this._json.put("Percent", (Object)DECIMAL_FORMAT.format(percent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoundaryTime(long newBoundaryTime) {
        InputDuration inputDuration = this;
        synchronized (inputDuration) {
            this._log.info("updating " + this._timePeriodString + " boundary time to " + QUICK_DATE_FORMAT.format(newBoundaryTime));
            if (newBoundaryTime > this._lastTransitionTime) {
                this._log.info(String.format("last state: %d", this._lastState));
                if (1 == this._lastState) {
                    long highTime = newBoundaryTime - this._lastTransitionTime;
                    this._totalizedDuration += highTime;
                }
                this.updateJson(newBoundaryTime);
                this._lastTransitionTime = newBoundaryTime;
                this._totalizedDuration = 0L;
            }
            this._boundaryTime = newBoundaryTime;
            this._log.info("updated " + this._timePeriodString + " boundary time to " + QUICK_DATE_FORMAT.format(newBoundaryTime));
            this._json.put("BoundaryStartTime", this._boundaryTime);
            this._json.put("BoundaryStartTimestamp", (Object)QUICK_DATE_FORMAT.format(this._boundaryTime));
        }
    }

    double getPercentage() {
        return this._lastPercentage;
    }
}

