/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.BakLogOutputStream;
import com.integpg.janoslib.logger.BufferedLineOutputStream;
import com.integpg.janoslib.logger.FileLogService;
import com.integpg.janoslib.logger.HalfBakLogOutputStream;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogOutputStream;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.RollingLogOutputStream;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Hashtable;

public class FileLog
extends Logger {
    public static final QuickDateFormat LogDateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final LogOptions _logOptions;
    private final String _firstEntry = String.format("%s, %s", LogDateFormat.format(System.currentTimeMillis()), "--------------------------------------------------");
    private boolean _firstWrite = true;
    private boolean _isBackground;

    public static Logger getRollingLog(LogOptions logOptions) {
        logOptions.setLogType(LogTypes.Rolling);
        return FileLog.getLog(logOptions);
    }

    public static Logger getBackupLog(LogOptions logOptions) {
        logOptions.setLogType(LogTypes.SingleBak);
        return FileLog.getLog(logOptions);
    }

    public static Logger getFlashBackupLog(LogOptions logOptions) {
        logOptions.setLogType(LogTypes.FlashBakDate);
        return FileLog.getLog(logOptions);
    }

    public static Logger getHalfBackupLog(LogOptions logOptions) {
        logOptions.setLogType(LogTypes.HalfBak);
        return FileLog.getLog(logOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLog(LogOptions logOptions) {
        try {
            Hashtable<String, Logger> hashtable = FileLogService.LOGS_CACHE;
            synchronized (hashtable) {
                String filename = logOptions.getFilePath().toLowerCase();
                if (!FileLogService.LOGS_CACHE.containsKey(filename)) {
                    System.out.println((Object)((Object)logOptions.getLogType()) + " log file: " + filename + " with max size of " + logOptions.getMaxFileSize());
                    FileLog fileLog = new FileLog(logOptions);
                    FileLogService.LOGS_CACHE.put(filename, fileLog);
                }
                return FileLogService.LOGS_CACHE.get(filename);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return SystemOutLog.getLogger();
        }
    }

    private FileLog(LogOptions logOptions) throws FileNotFoundException {
        this._logOptions = logOptions;
        LogOutputStream logOutputStream = null;
        if (null != this._logOptions.getLogType()) {
            switch (this._logOptions.getLogType()) {
                case Rolling: {
                    logOutputStream = new RollingLogOutputStream(logOptions);
                    break;
                }
                case SingleBak: {
                    logOutputStream = new BakLogOutputStream(logOptions);
                    break;
                }
                case HalfBak: {
                    logOutputStream = new HalfBakLogOutputStream(logOptions);
                    break;
                }
            }
        }
        if (null != logOutputStream) {
            super.setPrintStream(new PrintStream(new BufferedLineOutputStream(logOutputStream, 1024)));
        }
        this._isBackground = Application.isBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void println(String s) {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (this._firstWrite) {
                super.println(this._firstEntry);
                this._firstWrite = false;
            }
            if (!this._isBackground) {
                System.out.println(s);
            }
            super.print(String.format("%s, %s\r\n", LogDateFormat.format(System.currentTimeMillis()), s));
            this._nextFlushTime = System.currentTimeMillis() + 5000L;
            if (this._finalized) {
                this._nextFlushTime = System.currentTimeMillis();
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FileLog fileLog = this;
        synchronized (fileLog) {
            if (System.currentTimeMillis() >= this._nextFlushTime) {
                if (null != this._printStream) {
                    this._printStream.flush();
                }
                this._nextFlushTime = Long.MAX_VALUE;
            }
        }
    }
}

