/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.Logger;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileLogService
implements Runnable {
    private static final FileLogService THIS = new FileLogService();
    protected static final Hashtable<String, Logger> LOGS_CACHE = new Hashtable();
    private Thread _thread = null;

    public static void start() {
        if (null == FileLogService.THIS._thread) {
            FileLogService.THIS._thread = new Thread(THIS);
            FileLogService.THIS._thread.setName(THIS.getClass().getName());
            FileLogService.THIS._thread.setDaemon(true);
            FileLogService.THIS._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            System.out.println("FileLogService started.");
            while (true) {
                Thread.sleep(1000L);
                Hashtable<String, Logger> hashtable = LOGS_CACHE;
                synchronized (hashtable) {
                    Enumeration<Logger> e = LOGS_CACHE.elements();
                    while (e.hasMoreElements()) {
                        Logger log = e.nextElement();
                        if (Long.MAX_VALUE == log.getNextFlushTime()) continue;
                        log.flush();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("FileLogService done.");
            return;
        }
    }
}

