/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.utility.Config;
import com.integ.utility.CycleTime;
import com.integ.utility.DigitalInputConfig;
import com.integ.utility.ImportantTimes;
import com.integ.utility.InputDuration;
import com.integ.utility.TimePeriodTracker;
import com.integ.utility.TransitionEvent;
import com.integ.utility.UtilityMain;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class DigitalInputMonitor
implements Runnable {
    private static final String DEBUG_DIGITALLOG = "digitallog";
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    private static final QuickDateFormat CYCLEEVENTS_DATE_FORMAT = new QuickDateFormat("yyyyMMddHH00");
    private static final QuickDateFormat SIX_MINUTE_FILE_DATE_FORMAT = new QuickDateFormat("yyyyMMMdd");
    private static final QuickDateFormat HOURLY_FILE_DATE_FORMAT = new QuickDateFormat("yyyywkWY");
    private static final QuickDateFormat MONTHLY_FILE_DATE_FORMAT = new QuickDateFormat("yyyyMMM");
    private static final QuickDateFormat JSON_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm");
    public static final File BY_HOURS_STORAGE = new File(UtilityMain.UTILITY_STORAGE + "by-hours/");
    public static final File BY_DAYS_STORAGE = new File(UtilityMain.UTILITY_STORAGE + "by-days/");
    public static final File BY_WEEKS_STORAGE = new File(UtilityMain.UTILITY_STORAGE + "by-weeks/");
    public static final File BY_MONTHS_STORAGE = new File(UtilityMain.UTILITY_STORAGE + "by-months/");
    private final Log _log;
    private final Log _ioEventLog;
    private final int _inputNumber;
    private final ArrayList<IoEvent> _ioEventsToProcess = new ArrayList();
    private final ArrayList<CycleTime> _cycleTimes;
    private final ArrayList<TransitionEvent> _ioEvents;
    private final TimePeriodTracker _hourlyTracker;
    private final TimePeriodTracker _sixMinuteTracker;
    private final InputDuration _byMinutesInputDuration;
    private final InputDuration _hourlyInputDuration;
    private CycleTime _cycleTime;
    private boolean _newCycleTimesToProcess = false;
    private long _nextProcessTime = -1L;
    private boolean _initialized = false;
    private final ArrayList<Json> _realTimeRecords = new ArrayList();
    private final ImportantTimes _importantTimes = new ImportantTimes();
    private long _startTime = System.currentTimeMillis();
    private final Thread _thread;

    public DigitalInputMonitor(int inputNumber) {
        this._log = FileLog.getLog(new LogOptions("/temp/" + Application.getAppName() + "_din" + inputNumber + ".log").setMaxFileSizeInKb(64));
        this._ioEventLog = FileLog.getLog(new LogOptions("/temp/" + Application.getAppName() + "_din" + inputNumber + "_ioevent.log").setMaxFileSizeInKb(64));
        this._importantTimes.updateTimes();
        this._cycleTimes = new ArrayList(32);
        this._ioEvents = new ArrayList(32);
        this._inputNumber = inputNumber;
        this._byMinutesInputDuration = new InputDuration(this._inputNumber, "by-minutes");
        this._hourlyInputDuration = new InputDuration(this._inputNumber, "hourly");
        this._hourlyTracker = new TimePeriodTracker(inputNumber, "Hourly", this._cycleTimes, this._ioEvents, this._importantTimes.StartOfHour, this._hourlyInputDuration);
        this._sixMinuteTracker = new TimePeriodTracker(inputNumber, "By-Minute", this._cycleTimes, this._ioEvents, this._importantTimes.StartOfByMinutes, this._byMinutesInputDuration);
        long timestamp = System.currentTimeMillis();
        Json json = new Json();
        json.put("Timestamp", timestamp / 1000L);
        json.put("Timestring", (Object)JSON_DATE_FORMAT.format(timestamp));
        Json sixMinuteJson = this._sixMinuteTracker.getJson(true);
        sixMinuteJson.put("NextLogTime", this._importantTimes.NextByMinutes / 1000L);
        json.put("RollingSixMinuteAverage", (Object)sixMinuteJson);
        Json hourlyJson = this._hourlyTracker.getJson(true);
        hourlyJson.put("NextLogTime", this._importantTimes.NextHour / 1000L);
        json.put("RollingHourlyAverage", (Object)hourlyJson);
        JANOS.setRegistryString((String)("AppData/Utility/Din" + this._inputNumber + "/$RollingMetrics"), (String)json.toString());
        this._thread = new Thread(this);
        this._thread.setName(this.getClass().getName() + ":" + inputNumber);
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public Json[] getRealTimeCycleTimesJsonArray() {
        try {
            return (Json[])this._realTimeRecords.toArray();
        }
        catch (Exception ex) {
            AppLog.error("Error getting real-time array", ex);
            return new Json[0];
        }
    }

    public void processTimePeriod(long now) {
        if (this._initialized && this._importantTimes.NextByMinutes < now) {
            this.processUpdates(true);
            UtilityMain.BOUNDARY_LOG.info(String.format("Input %d _importantTimes.NextByMinutes: %s", this._inputNumber, QUICK_DATE_FORMAT.format(this._importantTimes.NextByMinutes)));
            UtilityMain.BOUNDARY_LOG.info("Input " + this._inputNumber + " Now: " + QUICK_DATE_FORMAT.format(now));
            this._byMinutesInputDuration.updateBoundaryTime(this._importantTimes.NextByMinutes);
            UtilityMain.BOUNDARY_LOG.info("Input " + this._inputNumber + " Crossed by-minute boundary");
            this.logSixMinuteRecord(this._importantTimes.NextByMinutes, false);
            this.sendBoundaryNotification("by-minute");
            if (this._importantTimes.NextHour <= now) {
                UtilityMain.BOUNDARY_LOG.info("\"Input \" + _inputNumber + \" Crossed hourly boundary");
                this._hourlyInputDuration.updateBoundaryTime(this._importantTimes.NextHour);
                this.logHourlyRecord(this._importantTimes.NextHour);
                this.logHourlyRecordInMonthlyFile(this._importantTimes.NextHour);
                this.sendBoundaryNotification("hourly");
            }
            this._importantTimes.updateTimes();
            UtilityMain.BOUNDARY_LOG.info(this._importantTimes.printTimes());
        }
    }

    private void sendBoundaryNotification(String boundaryName) {
        Json json = new Json();
        json.put("Message", (Object)"boundary-crossed");
        json.put("Input", this._inputNumber);
        json.put("BoundaryName", (Object)boundaryName);
        json.put("Timestamp", System.currentTimeMillis());
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = 1500;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IoEvent ioEvent) {
        ArrayList<IoEvent> arrayList = this._ioEventsToProcess;
        synchronized (arrayList) {
            this._ioEventsToProcess.add(ioEvent);
            this._ioEventLog.info(String.format("Input %d added ioevent, %d events to process", this._inputNumber, this._ioEventsToProcess.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIoEvent(IoEvent ioEvent) {
        int state = ioEvent.states >> this._inputNumber - 1 & 1;
        if (this._startTime < ioEvent.timestamp) {
            this._ioEventLog.info(String.format("@ %s channel %d is now %s", QUICK_DATE_FORMAT.format(ioEvent.timestamp), this._inputNumber, 1 == state ? "HIGH" : "LOW"));
        }
        if (this._importantTimes.NextByMinutes < ioEvent.timestamp) {
            System.out.println(String.format("Input %d ioevent timestamp exceeded next by-minutes: %lld < %lld", this._inputNumber, this._importantTimes.NextByMinutes, ioEvent.timestamp));
            this.processTimePeriod(ioEvent.timestamp);
        }
        if (this._initialized) {
            this._byMinutesInputDuration.updateState(ioEvent.timestamp, state);
            this._hourlyInputDuration.updateState(ioEvent.timestamp, state);
        }
        if (1 == state) {
            DigitalInputConfig digitalInputConfig = Config.getInputConfig(this._inputNumber);
            TransitionEvent transitionEvent = new TransitionEvent(ioEvent, digitalInputConfig.CountMultiplier);
            this._ioEvents.add(transitionEvent);
            this._sixMinuteTracker.addTransitionEvent(transitionEvent);
            this._hourlyTracker.addTransitionEvent(transitionEvent);
            if (null != this._cycleTime) {
                if (DEBUG.is(DEBUG_DIGITALLOG)) {
                    this._log.info(String.format("Input %d has completed a cycle.", this._inputNumber));
                }
                this._cycleTime.CompletionTime = ioEvent.timestamp;
                double cycleDuration = this._cycleTime.getCycleDuration();
                if (0.0 != cycleDuration) {
                    try {
                        if (this._startTime < this._cycleTime.CompletionTime) {
                            String filename = String.format("%sdin%d_%s_cycleevents.dat", BY_HOURS_STORAGE.getPath(), this._inputNumber, CYCLEEVENTS_DATE_FORMAT.format(this._cycleTime.CompletionTime));
                            System.out.println("cycleevents filename: " + filename);
                            String line = String.format("%s, %.3f, %.3f, %.3f\r\n", QUICK_DATE_FORMAT.format(this._cycleTime.CompletionTime), cycleDuration, this._cycleTime.getHighDuration(), this._cycleTime.getLowDuration());
                            FileUtils.appendAllBytes(filename, line.getBytes());
                        }
                    }
                    catch (IOException ex) {
                        AppLog.error("error writing to cycle events log", ex);
                    }
                    ArrayList<CycleTime> arrayList = this._cycleTimes;
                    synchronized (arrayList) {
                        this._cycleTimes.add(this._cycleTime);
                        this._sixMinuteTracker.addCycleTime(this._cycleTime);
                        this._hourlyTracker.addCycleTime(this._cycleTime);
                        if (DEBUG.is(DEBUG_DIGITALLOG)) {
                            this._log.info(String.format("Input %d %d cycle times in list", this._inputNumber, this._cycleTimes.size()));
                        }
                        this._newCycleTimesToProcess = true;
                        this._realTimeRecords.add(this._cycleTime.getJson());
                        while (Config.getRealTimeRecordCount() < this._realTimeRecords.size()) {
                            this._realTimeRecords.remove(0);
                        }
                        if (DEBUG.is(DEBUG_DIGITALLOG)) {
                            this._log.info("input " + this._inputNumber + " " + this._realTimeRecords.size() + " realtime digital records in list");
                        }
                        if (this._startTime < this._cycleTime.CompletionTime) {
                            Json json = new Json();
                            json.put("Message", (Object)"realtime-records");
                            json.put("Input", this._inputNumber);
                            json.put("Records", (Object)this.getRealTimeCycleTimesJsonArray());
                            json.put("Timestamp", System.currentTimeMillis());
                            SystemMsg responseMsg = new SystemMsg();
                            responseMsg.type = 1500;
                            responseMsg.msg = json.toString().getBytes();
                            MessagePumpEngine.postMessage(responseMsg);
                        }
                        if (this._initialized) {
                            this._thread.interrupt();
                        }
                    }
                    this._cycleTime = null;
                }
            }
            if (DEBUG.is(DEBUG_DIGITALLOG)) {
                this._log.info("Input " + this._inputNumber + " is starting a new cycle.");
            }
            this._cycleTime = new CycleTime();
            this._cycleTime.InitialTransitionHighTime = ioEvent.timestamp;
        } else if (null != this._cycleTime) {
            this._cycleTime.TransitionLowTime = ioEvent.timestamp;
        }
    }

    public void processUpdates() {
        this.processUpdates(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(boolean force) {
        UtilityMain.BOUNDARY_LOG.info("input " + this._inputNumber + " process updates " + Thread.currentThread().getName());
        long start = System.currentTimeMillis();
        int realTimeRecordCount = Config.getRealTimeRecordCount();
        if (1 > realTimeRecordCount) {
            realTimeRecordCount = 1;
        }
        ArrayList<CycleTime> arrayList = this._cycleTimes;
        synchronized (arrayList) {
            if (force || this._newCycleTimesToProcess) {
                this._newCycleTimesToProcess = false;
                System.out.println("input " + this._inputNumber + " process updates");
                this._log.info("input " + this._inputNumber + " has " + this._cycleTimes.size() + " cycle times in list.");
                ArrayList<Object> arrayList2 = this._cycleTimes;
                synchronized (arrayList2) {
                    if (0 < this._cycleTimes.size()) {
                        this._importantTimes.updateRollingTimes();
                        while (realTimeRecordCount < this._cycleTimes.size() && this._cycleTimes.get((int)0).CompletionTime < this._importantTimes.RollingHourStart - 14400000L) {
                            this._sixMinuteTracker.decrement();
                            this._hourlyTracker.decrement();
                            this._cycleTimes.remove(0);
                            System.out.println("input " + this._inputNumber + " removed cycle time from list");
                        }
                        this._log.info("input " + this._inputNumber + " has " + this._cycleTimes.size() + " cycle times in list.");
                    }
                }
                this._log.info("input " + this._inputNumber + " has " + this._ioEvents.size() + " io events in list");
                arrayList2 = this._ioEvents;
                synchronized (arrayList2) {
                    if (0 < this._ioEvents.size()) {
                        while (0 < this._ioEvents.size() && this._ioEvents.get((int)0).Timestamp < this._importantTimes.RollingHourStart - 14400000L) {
                            this._sixMinuteTracker.decrementIoEvent();
                            this._hourlyTracker.decrementIoEvent();
                            this._ioEvents.remove(0);
                        }
                        this._log.info("input " + this._inputNumber + " has " + this._ioEvents.size() + " io events in list");
                        this._sixMinuteTracker.update(this._importantTimes.StartOfByMinutes);
                        this._hourlyTracker.update(this._importantTimes.StartOfHour);
                    }
                }
                this.updateRollingMetrics();
                long elapsed = System.currentTimeMillis() - start;
                if (50L < elapsed) {
                    System.out.println("input " + this._inputNumber + " event processing took " + elapsed);
                }
            }
        }
        this._initialized = true;
    }

    private void updateRollingMetrics() {
        long timestamp = System.currentTimeMillis();
        Json json = new Json();
        json.put("Timestamp", timestamp / 1000L);
        json.put("Timestring", (Object)JSON_DATE_FORMAT.format(timestamp));
        Json sixMinuteJson = this._sixMinuteTracker.getJson();
        sixMinuteJson.put("Minutes", Config.getMinuteBlockDuration());
        sixMinuteJson.put("NextLogTime", this._importantTimes.NextByMinutes / 1000L);
        json.put("RollingSixMinuteAverage", (Object)sixMinuteJson);
        Json hourlyJson = this._hourlyTracker.getJson();
        hourlyJson.put("NextLogTime", this._importantTimes.NextHour / 1000L);
        json.put("RollingHourlyAverage", (Object)hourlyJson);
        JANOS.setRegistryString((String)("AppData/Utility/Din" + this._inputNumber + "/$RollingMetrics"), (String)json.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSixMinuteRecord(long timestamp, boolean createNull) {
        try {
            if (!createNull) {
                long lastSixMinuteWriteTime = Config.getLastSixMinuteWriteTime(this._inputNumber);
                System.out.println("last by-minute write time: " + lastSixMinuteWriteTime);
                if (this._importantTimes.StartOfByMinutes > lastSixMinuteWriteTime) {
                    System.out.println("Last by-minute write is too old.  Create null entry.");
                    long now = System.currentTimeMillis();
                    this.logSixMinuteRecord(now, true);
                }
            }
            ArrayList<CycleTime> lastSixMinuteWriteTime = this._cycleTimes;
            synchronized (lastSixMinuteWriteTime) {
                long start = System.currentTimeMillis();
                if (this._initialized && null != this._sixMinuteTracker) {
                    Json json = this._sixMinuteTracker.getJson();
                    json.put("Timestamp", timestamp / 1000L);
                    json.put("Timestring", (Object)JSON_DATE_FORMAT.format(timestamp));
                    json.put("Minutes", Config.getMinuteBlockDuration());
                    String line = json.toString() + "\r\n";
                    String filename = UtilityMain.UTILITY_STORAGE.getPath() + "by-days/" + "din" + this._inputNumber + "_" + SIX_MINUTE_FILE_DATE_FORMAT.format(timestamp) + ".dat";
                    FileUtils.appendAllBytes(filename, line.getBytes());
                }
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("six-minute entry took " + elapsed);
                this.updateRollingMetrics();
            }
            Config.setLastSixMinuteWriteTime(this._inputNumber);
            long lastSixMinuteWriteTime2 = Config.getLastSixMinuteWriteTime(this._inputNumber);
            System.out.println("last by-minute write time: " + lastSixMinuteWriteTime2);
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHourlyRecord(long timestamp) {
        try {
            ArrayList<CycleTime> arrayList = this._cycleTimes;
            synchronized (arrayList) {
                long start = System.currentTimeMillis();
                if (this._initialized && null != this._hourlyTracker) {
                    Json json = this._hourlyTracker.getJson();
                    json.put("Timestamp", timestamp / 1000L);
                    json.put("Timestring", (Object)JSON_DATE_FORMAT.format(timestamp));
                    json.put("Minutes", 60);
                    String line = json.toString() + "\r\n";
                    String filename = UtilityMain.UTILITY_STORAGE.getPath() + "by-weeks/" + "din" + this._inputNumber + "_" + HOURLY_FILE_DATE_FORMAT.format(timestamp) + ".dat";
                    FileUtils.appendAllBytes(filename, line.getBytes());
                }
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("hourly entry took " + elapsed);
            }
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHourlyRecordInMonthlyFile(long timestamp) {
        try {
            ArrayList<CycleTime> arrayList = this._cycleTimes;
            synchronized (arrayList) {
                long start = System.currentTimeMillis();
                if (null != this._hourlyTracker) {
                    Json json = this._hourlyTracker.getJson();
                    json.put("Timestamp", timestamp / 1000L);
                    json.put("Timestring", (Object)JSON_DATE_FORMAT.format(timestamp));
                    json.put("Minutes", 60);
                    String line = json.toString() + "\r\n";
                    String filename = UtilityMain.UTILITY_STORAGE.getPath() + "by-months/" + "din" + this._inputNumber + "_" + MONTHLY_FILE_DATE_FORMAT.format(timestamp) + ".dat";
                    FileUtils.appendAllBytes(filename, line.getBytes());
                    System.out.println("appended to " + filename);
                }
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("hourly entry took " + elapsed);
            }
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    private void waitForInitializationComplete() {
        System.out.println("input " + this._inputNumber + " not initialized");
        while (!this._initialized) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.waitForInitializationComplete();
        System.out.println("input " + this._inputNumber + " initialized");
        while (true) {
            try {
                while (true) {
                    long sleepDuration;
                    long now;
                    if (0 < this._ioEventsToProcess.size()) {
                        while (0 < this._ioEventsToProcess.size()) {
                            ArrayList<IoEvent> arrayList = this._ioEventsToProcess;
                            synchronized (arrayList) {
                                IoEvent ioEvent = this._ioEventsToProcess.remove(0);
                                this.processIoEvent(ioEvent);
                            }
                        }
                        this._ioEventLog.info(String.format("Input %d processed all ioevents, %d ioevents remain", this._inputNumber, this._ioEventsToProcess.size()));
                    }
                    if (this._importantTimes.NextByMinutes < (now = System.currentTimeMillis())) {
                        this._ioEventLog.info(String.format(Thread.currentThread().getName() + "crossed by-minutes boundary: %s < %s", QUICK_DATE_FORMAT.format(this._importantTimes.NextByMinutes), QUICK_DATE_FORMAT.format(now)));
                        this.processTimePeriod(now);
                    }
                    if (2000L < (sleepDuration = this._importantTimes.NextByMinutes - System.currentTimeMillis())) {
                        sleepDuration = 2000L;
                    }
                    if (0L >= sleepDuration) continue;
                    Thread.sleep(sleepDuration);
                }
            }
            catch (InterruptedException ex) {
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        if (!BY_HOURS_STORAGE.exists()) {
            BY_HOURS_STORAGE.mkdir();
        }
        if (!BY_DAYS_STORAGE.exists()) {
            BY_DAYS_STORAGE.mkdir();
        }
        if (!BY_WEEKS_STORAGE.exists()) {
            BY_WEEKS_STORAGE.mkdir();
        }
        if (!BY_MONTHS_STORAGE.exists()) {
            BY_MONTHS_STORAGE.mkdir();
        }
    }
}

