/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integ.utility.DigitalInputMonitor;
import com.integ.utility.UtilityMain;
import com.integpg.system.SystemMsg;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Json;

public class WebPageListener
implements MessagePumpListener {
    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _commandString;

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (1500 == systemMsg.type) {
            this._systemMsg = systemMsg;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MessagePumpEngine.LOG.info(Thread.currentThread().getName() + " started");
                    long start = System.currentTimeMillis();
                    WebPageListener.this.processMessage();
                    long elapsed = System.currentTimeMillis() - start;
                    MessagePumpEngine.LOG.info(WebPageListener.this._commandString + " processed in " + elapsed);
                }
            }).start();
        }
    }

    private void processMessage() {
        String contentJsonString = new String(this._systemMsg.msg);
        this._receivedJson = new Json(contentJsonString);
        this._commandString = this._receivedJson.getString("Command");
        System.out.println("commandString: " + this._commandString);
        if ("get-data-files".equalsIgnoreCase(this._commandString)) {
            this.getDataFiles();
        } else if ("get-realtime-records".equalsIgnoreCase(this._commandString)) {
            this.getRealtimeRecords();
        }
    }

    private void sendReponse(Json json) {
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = this._systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }

    private void getDataFiles() {
        final String inputString = "din" + this._receivedJson.getString("Input");
        System.out.println("inputString: " + inputString);
        String selectedChartString = this._receivedJson.getString("SelectedChart");
        System.out.println("selectedChartString: " + selectedChartString);
        if (null == inputString || null == selectedChartString) {
            return;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.startsWith(inputString);
            }
        };
        Json json = new Json();
        json.put("Message", (Object)"data-files");
        File storageLocation = null;
        if ("six-minute".equalsIgnoreCase(selectedChartString)) {
            storageLocation = DigitalInputMonitor.BY_DAYS_STORAGE;
        } else if ("day-by-hours".equalsIgnoreCase(selectedChartString) || "year-by-weeks".equalsIgnoreCase(selectedChartString)) {
            storageLocation = DigitalInputMonitor.BY_WEEKS_STORAGE;
        } else if ("month-by-days".equalsIgnoreCase(selectedChartString) || "year-by-months".equalsIgnoreCase(selectedChartString)) {
            storageLocation = DigitalInputMonitor.BY_MONTHS_STORAGE;
        }
        System.out.println("storageLocation: " + storageLocation);
        if (null != storageLocation) {
            String[] files = storageLocation.list(filenameFilter);
            json.put("Files", (Object)files);
            this.sendReponse(json);
        }
    }

    private void getRealtimeRecords() {
        String inputString = this._receivedJson.getString("Input");
        System.out.println("inputString: " + inputString);
        if (null == inputString) {
            return;
        }
        int input = Integer.parseInt(inputString);
        if (0 == input) {
            return;
        }
        System.out.println("get realtime records for input " + input);
        DigitalInputMonitor digitalInputMonitor = UtilityMain.getDigitalInputMonitor(input);
        Json[] realTimeCycleTimesJsonArray = digitalInputMonitor.getRealTimeCycleTimesJsonArray();
        Json json = new Json();
        json.put("Message", (Object)"realtime-records");
        json.put("Timestamp", System.currentTimeMillis());
        json.put("Input", input);
        json.put("Records", (Object)realTimeCycleTimesJsonArray);
        this.sendReponse(json);
    }
}

