<html lang="en" ng-app="App">

<head>
    <title>Utility</title>

    <base href="/utility/">

    <script type="text/javascript" src="jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="jquery-ui-1.11.1.min.js"></script>
    <script type="text/javascript" src="angular-1.3.15.min.js"></script>
    <script type="text/javascript" src="bootstrap-3.3.0.min.js"></script>
    <!-- <script type="text/javascript" src="transition.js"></script>
    <script type="text/javascript" src="collapse.js"></script> -->
    <link href="bootstrap-3.3.0.min.css" rel="stylesheet">
    <script type="text/javascript" src="bootbox_4.4.0.js"></script>

    <script type="text/javascript" src="Chart.bundle.min.js"></script>
    <script type="text/javascript" src="hammer.min.js"></script>
    <script type="text/javascript" src="chartjs-plugin-zoom.min.js"></script>

    <script type="text/javascript" src="moment.min.2.5.0.js"></script>
    <script type="text/javascript" src="bootstrap-datepicker.js"></script>
    <link href="datepicker.css" rel="stylesheet">

    <script type="text/javascript" src="prototype-functions.js"></script>
    <script type="text/javascript" src="base64.js"></script>
    <script type="text/javascript" src="md5.js"></script>
    <script type="text/javascript" src="comm.js"></script>
    <script type="text/javascript" src="jnrWebsocket.js"></script>


    <script type="text/javascript" src="app.js"></script>
    <script>
            var Config = {};
            
            <?php 
                $filename = '/flash/utility/config.json';
                if (file_exists($filename)) {
                    $fp = fopen($filename, 'rb');
                    if ($fp) {
                        $size = filesize($filename);
                        
                        echo 'Config = ';
                        print(fread($fp, $size));
                        fclose($fp);
                        echo ';';
                    }
                }
            ?>
    </script>


    <style>
        canvas {
            -moz-user-select: none;
            -webkit-user-select: none;
            -ms-user-select: none;
        }

        .navbar-nav>.active>a {
            color: #fff !important;
            background: #444 !important;
        }

                .bootbox .modal-content {
            border-radius: 0;
        }

        .bb-primary .modal-header {
            background-color: #428bca;
            color: #fff;
        }

        .bb-success .modal-header {
            background-color: #5cb85c;
            color: #fff;
        }

        .bb-warning .modal-header {
            background-color: #f0ad4e;
            color: #fff;
        }

        .bb-danger .modal-header {
            background-color: #c9302c;
            color: #fff;
        }
    </style>


    <script>
        var _metric = getParameterByName('SelectedMetric') || 'Counts';

        // $().ready(function() {
        //     setChartHeight();
        // });

        // $(window).resize(function () {
        //     setChartHeight();
        // });

        // function setChartHeight() {
        //     var canvasElements = $('[id^=canvas]');
        //     var h = Math.min(document.documentElement.clientHeight, window.innerHeight || 0);
        //     for (var i = 0; i < canvasElements.length; i++) {
        //         var canvasElement = canvasElements[i];
        //         var position = getOffset(canvasElement);
        //         canvasElement.setAttribute("style", "height:" + (h - position.top - 50) + "px;");
        //     }
        // }


        function getOffset( el ) {
            var _x = 0;
            var _y = 0;
            while( el && !isNaN( el.offsetLeft ) && !isNaN( el.offsetTop ) ) {
                var computedStyle = window.getComputedStyle(el, null);
                var paddingLeft = parseInt(computedStyle.getPropertyValue('padding-left')) || 0;
                var paddingTop = parseInt(computedStyle.getPropertyValue('padding-top')) || 0;
                var marginLeft = parseInt(computedStyle.getPropertyValue('margin-left')) || 0;
                var marginTop = parseInt(computedStyle.getPropertyValue('margin-top')) || 0;

                _x += el.offsetLeft + paddingLeft + marginLeft;
                _y += el.offsetTop + paddingTop + marginTop;
                el = el.parentNode;
            }
            return { top: _y, left: _x };
        }
    </script>


    <script type="text/javascript" src="aggregate-records.js"></script>
    <script src="realtime-analog.js"></script>
    <script src="realtime-digital.js"></script>
    <script src="six-minute.js"></script>
    <script src="day-by-hours.js"></script>
    <script src="month-by-days.js"></script>
    <script src="year-by-weeks.js"></script>
    <script src="year-by-months.js"></script>
    <script type="text/javascript" src="utility.js"></script>

</head>


<body ng-controller="Controller as ctrl">
    <nav id="navbar" class="navbar navbar-inverse navbar-fixed-top" role="navigation">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false"
                    aria-controls="navbar">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a id="page-title" class="navbar-brand" href="javascript: void(0)" style="color: white;">Utility</a>
            </div>

            <!-- Collect the nav links, forms, and other content for toggling -->
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <ul class="nav navbar-nav">
                <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.RealTimeAnalog" ng-class="(ctrl.SelectedChart === 'real-time') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('real-time')">Real-Time Analog</a>
                    </li>
                    <li role="presentation" ng-show="ctrl.Config.VisibleTabs.RealTimeDigital" ng-class="(ctrl.SelectedChart === 'real-time-digital') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('real-time-digital')">Real-Time Digital</a>
                    </li>
                    <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.ByMinutes" ng-class="(ctrl.SelectedChart === 'six-minute') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('six-minute')">By Minutes</a>
                    </li>
                    <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.DayByHours" ng-class="(ctrl.SelectedChart === 'day-by-hours') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('day-by-hours')">Day by Hours</a>
                    </li>
                    <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.MonthByDays" ng-class="(ctrl.SelectedChart === 'month-by-days') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('month-by-days')">Month By
                            Days
                        </a>
                    </li>
                    <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.YearByWeeks" ng-class="(ctrl.SelectedChart === 'year-by-weeks') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('year-by-weeks')">Year By Weeks</a>
                    </li>
                    <li role="presentation" ng-hide="false === ctrl.Config.VisibleTabs.YearByMonths" ng-class="(ctrl.SelectedChart === 'year-by-months') ? 'active' : ''">
                        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('year-by-months')">Year By Months
                        </a>
                    </li>

                     <li role="presentation "><a href="configure.php?" target="utility-config">Configuration</a></li>
                     <!-- <li id="about-menu" class="dropdown">
                        <a href="javascript: void(0)" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                            <span>Tools</span>
                            <span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu" role="menu">
                            <li role="presentation "><a href="configure.php?" target="utility-config">Configuration</a></li>
                        </ul>
                    </li> -->
                </ul>

                <ul class="nav navbar-nav navbar-right">
                    <li id="about-menu" class="dropdown">
                        <a href="javascript: void(0)" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                            <span>About</span>
                            <span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu" role="menu">
                        <li>
                                <a href="javascript: void(0)">Application v
                                    <span ng-bind="ctrl.Version">...</span>
                                </a>
                            </li>
                            <li>
                                <a href="javascript: void(0)">Web v
                                    <span ng-bind="ctrl.WebVersion">...</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>

            </div>
            <!-- /.navbar-collapse -->

        </div>
    </nav>


    <div ng-show="!(ctrl.isConfigEmpty() || 0 === ctrl.Config.InputsEnabled.length)" class="container-fluid " style="padding-top: 75px;">

        <div style="text-align:center; width:100%; line-height:1.5">
            <div style="float: right"><a href="javascript: void(0)" ng-click="ctrl.chartOptions()">Chart Options</a></div>
            <h4>
                <span ng-bind="ctrl.HostName"></span> - 
                <span ng-show="ctrl.SelectedChart === 'real-time'" ng-bind="ctrl.analogInputName"></span>
                <span ng-show="ctrl.SelectedChart !== 'real-time'" ng-bind="ctrl.digitalInputName"></span>
                <br>
                <span ng-bind="ctrl.getChartTitle()"></span>
            </h4>
        </div>
    
        <div id="date-range " style="text-align:center; width:100%; "></div>

            <canvas id="canvas-realtime-analog" ng-show="ctrl.SelectedChart === 'real-time'" style="height: 500px; max-height:500px;"></canvas>

            <div ng-show="ctrl.SelectedChart === 'real-time-digital'">
            <table class="table table-striped table-condensed" style="width: 0;margin:auto;">
                <tr>
                    <th>Cycle Start</th>
                    <th>Cycle End</th>
                    <th style="white-space:nowrap;">Cycle Time</th>
                    <th style="white-space:nowrap;">High Time</th>
                    <th style="white-space:nowrap;">Low Time</th>
                </tr>
                <tr ng-repeat="record in Records">
                    <td ng-bind="record.CycleStart" style="padding-right:32px; white-space:nowrap;"></td>
                    <td ng-bind="record.CycleEnd" style="padding-right:32px; white-space:nowrap;"></td>
                    <td style="text-align:right;"><span ng-bind="record.CycleTime"></span>s</td>
                    <td style="text-align:right;"><span ng-bind="record.HighTime"></span>s</td>
                    <td style="text-align:right;"><span ng-bind="record.LowTime"></span>s</td>
                </tr>
                <tr>
                    <td colspan="2" style="font-weight:bold;">Average over last {{Records.length}} records</td>
                    <td style="text-align:right; font-weight:bold;"><span ng-bind="averages.CycleTime"></span>s</td>
                    <td style="text-align:right; font-weight:bold;"><span ng-bind="averages.HighTime"></span>s</td>
                    <td style="text-align:right; font-weight:bold;"><span ng-bind="averages.LowTime"></span>s</td>
                </tr>
            </table>
        </div>

        <canvas id="canvas-six-minute" ng-show="ctrl.SelectedChart==='six-minute'" style="height: 500px; max-height:500px;"></canvas>
        <canvas id="canvas-day-by-hours" ng-show="ctrl.SelectedChart==='day-by-hours'" style="height: 500px; max-height:500px;"></canvas>
        <canvas id="canvas-week-by-days" ng-show="ctrl.SelectedChart==='week-by-days'" style="height: 500px; max-height:500px;"></canvas>
        <canvas id="canvas-month-by-days" ng-show="ctrl.SelectedChart==='month-by-days'" style="height: 500px; max-height:500px;"></canvas>
        <canvas id="canvas-year-by-weeks" ng-show="ctrl.SelectedChart==='year-by-weeks'" style="height: 500px; max-height:500px;"></canvas>
        <canvas id="canvas-year-by-months" ng-show="ctrl.SelectedChart==='year-by-months'" style="height: 500px; max-height:500px;"></canvas>

        <div style="float:left; margin-top:12px;">
            <div ng-hide="ctrl.SelectedChart.startsWith('real-time')" style="display:inline;">
                <select ng-model="ctrl.SelectedTimRange" ng-change="ctrl.timeRangeChanged()">
                <option selected="selected" disabled="disabled">Drop down to select another time range</option>
                <option value="original">Show Original</option>
                <option ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours'" value="yesterday">Show Yesterday</option>
                <option ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" value="prev-week">Show Previous Week</option>
                <option ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" value="last-7-days">Show Last 7 Days</option>
                <option ng-show="ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" value="prev-month">Show Previous Month</option>
                <option ng-show="ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" value="last-30-days">Show Last 30 Days</option>
                <option ng-show="ctrl.SelectedChart==='month-by-days' || ctrl.SelectedChart==='year-by-weeks'" value="last-90-days">Show Last 90 Days</option>
                <option ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" value="last-6-months">Show Last 6 Months</option>
                <option ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" value="last-12-months">Show Last 12 Months</option>
                <option ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" value="this-year">Show This Year</option>
                </select>

                <!-- <button class="btn btn-link" ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours'" ng-click="ctrl.showYesterday()">Show Yesterday</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" ng-click="ctrl.showPreviousWeek()">Show Previous Week</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='six-minute' || ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" ng-click="ctrl.showLastWeek()">Show Last 7 Days</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" ng-click="ctrl.showPreviousMonth()">Show Previous Month</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='day-by-hours' || ctrl.SelectedChart==='month-by-days'" ng-click="ctrl.showLastMonth()">Show Last 30 Days</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='month-by-days' || ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" ng-click="ctrl.showLast3Months()">Show Last 90 Days</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" ng-click="ctrl.showLast6Months()">Show Last 6 Months</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" ng-click="ctrl.showLast12Months()">Show Last 12 Months</button>
                <button class="btn btn-link" ng-show="ctrl.SelectedChart==='year-by-weeks' || ctrl.SelectedChart==='year-by-months'" ng-click="ctrl.showThisYear()">Show This Year</button> -->
                <button class="btn btn-link" ng-click="ctrl.showCustomRange()">Show Custom Range</button>
            </div>

            <a href="javascript://save-chart-data" class="btn btn-link" id="save-chart-data" ng-click="ctrl.saveChartData($event)" style="font-weight: bold">Save Chart Data</a>
        </div>

        <h4 style="float:right;">
            <span ng-hide="ctrl.SelectedChart.startsWith('real-time')">
                Plot
                <select ng-model="ctrl.SelectedMetric" ng-change="ctrl.metricChanged()" 
                ng-options="metric.value as metric.value for metric in ctrl.availableMetricArray track by metric.value">
                </select>
                for 
            </span>

            <span ng-show="ctrl.SelectedChart === 'real-time'">
                Analog Input
                <select ng-model="ctrl.SelectedInput" ng-change="ctrl.inputChanged()">
                    <option ng-repeat="input in ctrl.analogInputArray">{{ input }}</option>
                </select>
            </span>

            <span ng-hide="ctrl.SelectedChart === 'real-time'">
                Digital Input
                <select ng-model="ctrl.SelectedInput" ng-change="ctrl.inputChanged()">
                    <option ng-repeat="input in ctrl.digitalInputArray">{{ input }}</option>
                </select>
            </span>
        </h4>

        <!-- <br><br>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('real-time')">
            <canvas id="real-time-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('six-minute')">
            <canvas id="six-minute-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('day-by-hours')">
            <canvas id="day-by-hours-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('month-by-days')">
            <canvas id="month-by-days-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('year-by-weeks')">
            <canvas id="year-by-weeks-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a>
        <a href="javascript: void(0)" ng-click="ctrl.setSelectedChart('year-by-months')">
            <canvas id="year-by-months-thumbnail" style="width:200px; hight:50px;"></canvas>
        </a> -->
    </div>


    <div ng-show="ctrl.isConfigEmpty() || 0 === ctrl.Config.InputsEnabled.length" class="container">
        <br><br><br><br><br>
        <h1 style="text-align:center; line-height:1.5;">The are not any inputs configured to be logged.  Please go to the bottom of the 
            <a href="configure.php?" target="utility-config">Configuration</a> page and select the inputs that should be logged.
        </h1>
    </div>

</body>

</html>