/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utility;

import com.integ.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integ.janoslib.iolog.IoLogListener;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.utility.AssemblyInfo;
import com.integ.utility.Config;
import com.integ.utility.DigitalInputMonitor;
import com.integ.utility.DirectoryCleanupService;
import com.integ.utility.ImportantTimes;
import com.integ.utility.InstantaneousLogger;
import com.integ.utility.WebPageListener;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;

public class UtilityMain
implements IoLogListener {
    public static final Logger BOUNDARY_LOG = FileLog.getLog(new LogOptions("/temp/utility_boundary.log").setMaxFileSizeInKb(64));
    private static final DigitalInputsIoLogMonitor INPUT_IO_LOG_MONITOR = new DigitalInputsIoLogMonitor();
    public static UtilityMain INSTANCE;
    private DigitalInputMonitor[] _digitalInputMonitors;
    private final ImportantTimes _importantTimes = new ImportantTimes();
    private boolean _initialized = false;
    private InstantaneousLogger _instantaneousLogger;

    public static void main(String[] args) throws InterruptedException {
        Application.init(new AssemblyInfo());
        Application.enableApplicationWatchdog(0);
        INSTANCE = new UtilityMain();
        INSTANCE.init();
        INSTANCE.loop();
    }

    public static DigitalInputMonitor getDigitalInputMonitor(int channel) {
        try {
            if (0 < channel && UnitConfig.getInputCount() >= channel) {
                return UtilityMain.INSTANCE._digitalInputMonitors[channel - 1];
            }
        }
        catch (Exception ex) {
            AppLog.error("error getting digital input monitor for " + channel, ex);
        }
        return null;
    }

    public void init() {
        Config.load();
        this._digitalInputMonitors = new DigitalInputMonitor[UnitConfig.getInputCount()];
        for (int i = 0; i < UnitConfig.getInputCount(); ++i) {
            this._digitalInputMonitors[i] = new DigitalInputMonitor(i + 1);
        }
        System.out.println("created digital input monitor array [" + this._digitalInputMonitors.length + ")]");
        AppLog.info("start io log monitor");
        INPUT_IO_LOG_MONITOR.setRefreshTimestamp(System.currentTimeMillis() - 3600000L);
        INPUT_IO_LOG_MONITOR.addIoLogEventListener(this);
        INPUT_IO_LOG_MONITOR.start();
        AppLog.info("start instatntaneous logger");
        this._instantaneousLogger = new InstantaneousLogger();
        this._instantaneousLogger.start();
        AppLog.info("add web page listener");
        MessagePumpEngine.addListener(new WebPageListener());
        AppLog.info("start message pump engine");
        MessagePumpEngine.start();
    }

    public void loop() throws InterruptedException {
        if (!this._initialized) {
            System.out.println("main not initialized");
            while (!this._initialized) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        DirectoryCleanupService storageDirectoryCleanupService = new DirectoryCleanupService(Config.UTILITY_STORAGE.getPath());
        storageDirectoryCleanupService.start();
        this._importantTimes.updateTimes();
        System.out.println(this._importantTimes.printTimes());
        Thread.sleep(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIoEvent(IoEvent ioEvent) {
        UtilityMain utilityMain = this;
        synchronized (utilityMain) {
            for (int chan = 0; chan < 8; ++chan) {
                boolean inputEnabled;
                if (1 != (ioEvent.mask >> chan & 1) || !(inputEnabled = Config.getInputEnabled(chan + 1))) continue;
                DigitalInputMonitor digitalInputMonitor = this._digitalInputMonitors[chan];
                digitalInputMonitor.addEvent(ioEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIoEventsProcessed() {
        if (!this._initialized) {
            AppLog.info("Inputs Inititalized");
            this._initialized = true;
            this._instantaneousLogger.setInitialized();
        }
        UtilityMain utilityMain = this;
        synchronized (utilityMain) {
            for (int chan = 0; chan < this._digitalInputMonitors.length; ++chan) {
                boolean inputEnabled = Config.getInputEnabled(chan + 1);
                if (!inputEnabled) continue;
                this._digitalInputMonitors[chan].processUpdates();
            }
        }
    }
}

