App.controller('Controller', function ($scope) {
    $scope.Math = window.Math;

    var _this = this;
    _this.Config = Config;
    if (isEmpty(_this.Config)) {
        _this.Config = { YAxis: { Minimum: {}, Maximum: {} }, VisibleTabs: {}, AnalogModulesAvailable: [false, false, false], InputsEnabled: [], RealTimeInputsEnabled: [] };

        _this.Config.VisibleTabs.RealTimeAnalog = true;
        _this.Config.VisibleTabs.RealTimeDigital = false;
        _this.Config.VisibleTabs.ByMinutes = true;
        _this.Config.VisibleTabs.DayByHours = true;
        _this.Config.VisibleTabs.MonthByDays = true;
        _this.Config.VisibleTabs.YearByWeeks = true;
        _this.Config.VisibleTabs.YearByMonths = true;

        _this.Config.YAxis.Minimum.Type = _this.Config.YAxis.Minimum.Type || 'set-value';
        _this.Config.YAxis.Minimum.Value = _this.Config.YAxis.Minimum.Value || 0;
        _this.Config.YAxis.Maximum.Type = _this.Config.YAxis.Maximum.Type || 'dynamic';
        _this.Config.YAxis.Maximum.Value = _this.Config.YAxis.Maximum.Value || 0;

        _this.Config.DefaultMetric = _this.Config.DefaultMetric || 'Counts';
        _this.Config.InitialChart = 'six-minute';
        _this.Config.InitialInput = '1';

        _this.Config.MinuteBlockDuration = _this.Config.MinuteBlockDuration || 6;
        _this.Config.CurrentPeriod = _this.Config.CurrentPeriod || 'rolling';
        _this.Config.RealTimeRecordCount = 10;
    }

    _this.SavedConfig = angular.copy(_this.Config);


    _this.hasChanged = function (config, savedConfig) {
        var changed = !angular.equals(config, savedConfig);
        return changed;
    };


    _this.saveChangesRequest = function () {
        _this.SaveDialog = bootbox.confirm({
            className: "bb-primary",
            title: "Are you sure you want to save your changes?",
            message: "Your changes will take affect without needing to reboot.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-primary'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.saveChanges();
                    return false;
                }
            }
        });
        _this.SaveDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });

    };


    _this.saveChanges = function () {
        $("#bootbox-confirm-btn").html("Saving...");
        $("#bootbox-confirm-btn").prop('disabled', true);
        $("#bootbox-cancel-btn").prop('disabled', true);

        setTimeout(function () {
            var filename = "/flash/utility/config.json";
            var jsonString = JSON.stringify(_this.Config, null, 2);
            JnrWebsocket.writeFile(filename, jsonString).then(function (result) {
                if (result.Status) {
                    bootbox.alert({
                        className: 'bb-success',
                        title: 'Success',
                        message: 'Configuration has been successfully saved'
                    });
                } else {
                    bootbox.alert({
                        className: 'bb-danger',
                        title: 'Error',
                        message: 'Unable to save configuration'
                    });
                }

                _this.SavedConfig = angular.copy(_this.Config);
                $scope.$apply();

                _this.SaveDialog.modal('hide');
            });
        });
    };


    _this.cancelChangesRequest = function () {
        _this.CancelDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            buttons: {
                cancel: {
                    label: 'Keep Changes',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Cancel Changes',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.cancelChanges();
                    return false;
                }
            }
        });
        _this.CancelDialog.init(function () {
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.cancelChanges = function () {
        $("#bootbox-confirm-btn").html("Reverting...");
        $("#bootbox-confirm-btn").prop('disabled', true);
        $("#bootbox-cancel-btn").prop('disabled', true);

        setTimeout(function () {
            _this.Config = angular.copy(_this.SavedConfig);
            $scope.$apply();

            _this.CancelDialog.modal('hide');
        }, 1000);
    };


    JnrWebsocket.connect();
    JnrWebsocket.onLoggedIn = function () {
        JnrWebsocket.readRegistryKeys(["$model"],
            function (key, value) {
                if (key.endsWith("$model")) {
                    _this.inputArray = [1, 2, 3, 4];
                    if (!value.startsWith('412')) {
                        _this.inputArray = _this.inputArray.concat([5, 6, 7, 8]);
                        if (!value.startsWith('410')) {
                            _this.inputArray = _this.inputArray.concat([9, 10, 11, 12]);
                        }
                    }
                }

                $scope.$apply();
            }
        );

        JnrWebsocket.readFile("/flash/utility/config.json", function (result) {
            if ('Fail' !== result.Status) {
                var fileContents = Base64.decode(result.Data);
                var json = JSON.parse(fileContents);
                // _this.Config = json;

                for (var prop in json) {
                    if (json.hasOwnProperty(prop)) {
                        _this.Config[prop] = json[prop];
                    }
                }
                _this.SavedConfig = angular.copy(_this.Config);

                $scope.$apply();
            }
        });


        JnrWebsocket.getRegistryListing('Externals/DeviceOrder', function (node, keys) {
            console.log(node + ': ' + keys);
            for (var keyIndex in keys) {
                var key = keys[keyIndex];
                if (-1 !== key.indexOf('FE_1')) _this.Config.AnalogModulesAvailable[0] = true;
                else if (-1 !== key.indexOf('FE_2')) _this.Config.AnalogModulesAvailable[1] = true;
                else if (-1 !== key.indexOf('FE_3')) _this.Config.AnalogModulesAvailable[2] = true;
            }
            $scope.$apply();
        });
    };
});