/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.PlotSeries;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class PlotData
implements Cloneable {
    public PlotSeries owner;
    public Object data;
    protected double time;
    private Rectangle m_rect = null;

    public PlotData() {
    }

    public PlotData(double data, double time) {
        this.data = new Double(data);
        this.time = time;
    }

    public PlotData(String data, double time) {
        this.data = data;
        this.time = time;
    }

    public double getRelativeTime() {
        int numElements;
        if (this.owner != null && this.owner.xAxis != null && (numElements = this.owner.xAxis.getNumberOfElements()) > 0 && this.owner.xAxis.isAdjusted()) {
            return this.time + this.owner.xAxis.getMin();
        }
        return this.time;
    }

    public double getTime() {
        return this.time;
    }

    public String getTimeString() {
        return String.valueOf(this.time);
    }

    public double getDouble() {
        return (Double)this.data;
    }

    public String getDoubleString() {
        return String.valueOf(this.data);
    }

    public double getX() {
        if (this.m_rect != null) {
            return (double)this.m_rect.x + (double)this.m_rect.width / 2.0;
        }
        return -1.0;
    }

    public double getY() {
        if (this.m_rect != null) {
            return (double)this.m_rect.y + (double)this.m_rect.y / 2.0;
        }
        return -1.0;
    }

    public int calculateX(double startTime, double totalTime, double pixelsPerX, int width) {
        double ellapsed = (int)(this.getTime() + (double)this.owner.xAxis.getNumberOfElements() - startTime);
        if (this.owner.xAxis.getNumberOfElements() > 0) {
            ellapsed %= (double)this.owner.xAxis.getNumberOfElements();
        }
        return (int)(ellapsed / totalTime * (double)width);
    }

    public int calculateY(double min, double pixelsPerY) {
        double val = this.getDouble() / (double)this.owner.getFactor();
        int y = (int)((val - min) * pixelsPerY);
        return y;
    }

    public boolean isOver(int x, int y) {
        if (this.m_rect == null) {
            return false;
        }
        return this.m_rect.contains(x, y);
    }

    public boolean setHighlighted() {
        if (this.owner.getHighlighted() != this) {
            this.owner.setHighlighted(this);
            return true;
        }
        return false;
    }

    public void draw(Graphics g, int left, int bottom, int itemOffset, int chartWidth, int chartHeight, double pixelsPerX, double pixelsPerY, int xOffset, double startTime, double totalTime, int min, int width, PlotData prevPd) {
        if (this.owner == null) {
            return;
        }
        if (g == null) {
            return;
        }
        startTime = this.owner.xAxis.getMin();
        totalTime = this.owner.xAxis.getAdjustedMax() - this.owner.xAxis.getMin();
        int x = this.calculateX(startTime, totalTime, pixelsPerX, chartWidth) + xOffset;
        int y = bottom - this.calculateY(min, pixelsPerY);
        int px = 0;
        int py = 0;
        if (prevPd != null) {
            px = prevPd.calculateX(startTime, totalTime, pixelsPerX, chartWidth) + xOffset;
            py = bottom - prevPd.calculateY(min, pixelsPerY);
        }
        if (this.owner.getHighlighted() == this) {
            g.setColor(Color.RED);
            g.drawLine(x + left + itemOffset + width / 2, bottom - chartHeight, x + left + itemOffset + width / 2, bottom);
        }
        g.setColor(this.owner.color);
        switch (this.owner.type) {
            case 3: {
                if (y == bottom) {
                    y = bottom - 1;
                }
                this.m_rect = new Rectangle(x + left + itemOffset, y, width, bottom - y);
                g.fillRect(x + left + itemOffset, y, width, bottom - y);
                break;
            }
            case 1: {
                if (prevPd == null) break;
                Graphics2D g2d = (Graphics2D)g;
                this.m_rect = new Rectangle(x + left, y, x - px, 1);
                g2d.draw(new Line2D.Double(px + left, py, x + left, y));
            }
        }
    }

    public Object clone() {
        PlotData pd = new PlotData();
        pd.time = this.time;
        pd.data = this.data;
        pd.owner = this.owner;
        if (this.m_rect != null) {
            pd.m_rect = (Rectangle)this.m_rect.clone();
        }
        return pd;
    }

    public String toString() {
        return this.getTimeString() + " : " + this.getDoubleString();
    }

    void invalidate() {
        this.m_rect = null;
    }
}

