/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Plot.PlotData;
import Plot.PlotSeries;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Axis
implements Cloneable {
    public static final int VALUE_SCALE = -1;
    private static final long SECOND_MILLIS = 1000L;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long DAY_MILLIS = 86400000L;
    private static final String[] daysOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private PlotSeries m_labels = new PlotSeries();
    private int m_offset = 0;
    private double m_min;
    private double m_max;
    private double m_major;
    private boolean m_autoScale = false;
    private boolean m_dirtyLabels = false;
    private int m_scaleType = -1;
    private Rectangle rect = null;
    private boolean m_adjusted = false;
    private Rectangle chartArea;

    public Axis(double min, double max, double major) {
        this.setMin(min);
        this.setMax(max);
        this.setMajor(major);
    }

    public void setRect(Rectangle r) {
        this.rect = r;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public void setChartArea(Rectangle ga) {
        this.chartArea = ga;
    }

    public Rectangle getChartArea() {
        return this.chartArea;
    }

    public void draw(Graphics g) {
        int xLabelWidth;
        double min = this.getMin();
        double max = this.getAdjustedMax();
        long size = (long)(max - min);
        int labelsLength = this.getLabels().size();
        int chartWidth = this.rect.width;
        FontMetrics fm = g.getFontMetrics();
        if (min >= max) {
            size = (long)(max + (double)this.getNumberOfElements() - min);
        }
        g.setColor(Color.BLACK);
        for (int j = 0; j < labelsLength; ++j) {
            int dx;
            int width = (int)((long)chartWidth / size);
            PlotData sc = new PlotData();
            Object io = this.m_labels.get(j);
            sc.data = ((PlotData)io).data;
            sc.time = ((PlotData)io).time;
            int ellapsed = (int)(sc.time - min);
            if (!(sc.time >= min)) continue;
            xLabelWidth = fm.stringWidth(sc.data.toString());
            if (j == 0 && this.getScaleType() == 0) {
                dx = this.rect.x;
            } else if (j == labelsLength - 1 && this.getScaleType() == 0) {
                dx = this.rect.x + this.rect.width - xLabelWidth;
            } else {
                dx = (int)((double)ellapsed / (max - min) * (double)chartWidth);
                dx += this.rect.x + width / 2;
                Color c = g.getColor();
                g.setColor(Color.LIGHT_GRAY);
                if (this.chartArea != null) {
                    g.drawLine(dx, this.chartArea.y, dx, this.chartArea.height);
                }
                g.setColor(c);
                if (((dx -= xLabelWidth / 2) < this.rect.x + xLabelWidth || dx > this.rect.x + this.rect.width - xLabelWidth * 2) && this.getScaleType() == 0) continue;
            }
            g.drawString(sc.data.toString(), dx, this.rect.y + fm.getHeight());
        }
        if (this.getScaleType() == 0) {
            int seconds = (int)Math.round((max - min) / 1000.0);
            String xTitle = seconds < 60 ? "Time - " + seconds + " seconds" : "Time - " + Math.round((double)seconds / 60.0) + " minutes";
            xLabelWidth = fm.stringWidth(xTitle);
            g.drawString(xTitle, this.rect.x + this.rect.width / 2 - xLabelWidth / 2, this.rect.y + fm.getHeight() * 2);
        }
    }

    public synchronized void setAutoScale(boolean b) {
        this.m_dirtyLabels = true;
        this.m_autoScale = b;
    }

    public synchronized void setScaleType(int type) {
        this.m_dirtyLabels = true;
        this.m_scaleType = type;
    }

    public synchronized int getScaleType() {
        return this.m_scaleType;
    }

    private void scaleIt() {
        double ellapsed = this.m_max - this.m_min;
        if (this.m_scaleType == 0) {
            if (ellapsed > 8.64E7) {
                this.setMajor(8.64E7);
            } else if (ellapsed > 3600000.0) {
                this.setMajor(3600000.0);
            } else if (ellapsed > 900000.0) {
                this.setMajor(900000.0);
            } else if (ellapsed > 300000.0) {
                this.setMajor(300000.0);
            } else {
                this.setMajor(60000.0);
            }
        }
    }

    public int getNumberOfElements() {
        switch (this.getScaleType()) {
            case 11: {
                return 24;
            }
            case 5: {
                return 31;
            }
            case 7: {
                return 7;
            }
            case 3: {
                return 53;
            }
        }
        return 0;
    }

    private void fillLabels() {
        double min = this.getMin();
        double max = this.getAdjustedMax();
        double d = min;
        Date date = new Date();
        SimpleDateFormat dFormat = new SimpleDateFormat("HH:mm");
        int numberOfElements = this.getNumberOfElements();
        if (this.m_autoScale) {
            this.scaleIt();
        }
        if (this.m_scaleType == 0) {
            // empty if block
        }
        if ((max - min) / 100.0 < this.m_major) {
            this.m_labels.removeAllElements();
            while (d < max) {
                double index = d;
                if (this.m_scaleType == 0 || d % this.m_major == 0.0) {
                    String label;
                    if (numberOfElements > 0) {
                        index %= (double)(numberOfElements + this.m_offset);
                    }
                    if (this.m_scaleType == 0) {
                        date.setTime((long)index);
                        label = dFormat.format(date);
                    } else {
                        label = this.m_scaleType == 7 ? daysOfWeek[(int)index] : String.valueOf((long)index);
                    }
                    this.m_labels.addElement(new PlotData(label, d));
                }
                d = d - d % this.m_major + this.m_major;
            }
            if (this.m_scaleType == 0) {
                date.setTime((long)max);
                String dateString = dFormat.format(date);
                this.m_labels.addElement(new PlotData(dateString, max));
            }
        }
        this.m_dirtyLabels = false;
    }

    public synchronized void setOffset(int offset) {
        this.m_offset = offset;
    }

    public synchronized void setLabels(PlotSeries ps) {
        this.setAutoScale(false);
        this.m_labels = ps;
    }

    public synchronized double setMax(double val) {
        this.m_dirtyLabels = true;
        this.m_max = val + 1.0;
        return this.m_max;
    }

    public synchronized double setMin(double val) {
        this.m_dirtyLabels = true;
        this.m_min = val;
        return this.m_min;
    }

    public synchronized double setMajor(double val) {
        this.m_dirtyLabels = true;
        this.m_major = val;
        return this.m_major;
    }

    public synchronized PlotSeries getLabels() {
        if (this.m_dirtyLabels) {
            this.fillLabels();
        }
        return this.m_labels;
    }

    public synchronized double getMax() {
        return this.m_max;
    }

    public synchronized double getAdjustedMax() {
        if (this.getNumberOfElements() > 0 && this.m_max <= this.m_min) {
            this.m_adjusted = true;
            return this.m_max + (double)this.getNumberOfElements();
        }
        return this.m_max;
    }

    public boolean isAdjusted() {
        return this.m_adjusted;
    }

    public synchronized double getMin() {
        return this.m_min;
    }

    public synchronized double getMajor() {
        return this.m_major;
    }

    public Object clone() {
        Axis retValue = new Axis(this.m_min, this.m_max, this.m_major);
        retValue.m_major = this.m_major;
        retValue.m_labels = this.m_labels;
        retValue.m_autoScale = this.m_autoScale;
        retValue.m_dirtyLabels = this.m_dirtyLabels;
        retValue.m_scaleType = this.m_scaleType;
        retValue.rect = this.rect;
        retValue.chartArea = this.chartArea;
        return retValue;
    }
}

